/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.internal;

import com.atomikos.icatch.CompositeTransaction;
import java.util.HashSet;
import java.util.Stack;

class JdbcNonXAConnectionHandleState {
    private CompositeTransaction currentTransaction;
    private boolean readOnly;
    private HashSet<CompositeTransaction> history;

    public JdbcNonXAConnectionHandleState() {
        this(false);
    }

    public JdbcNonXAConnectionHandleState(boolean readOnly) {
        this.readOnly = readOnly;
        this.history = new HashSet();
    }

    private void registerTransaction(CompositeTransaction ct) {
        this.currentTransaction = ct;
        this.history.add(ct);
    }

    private boolean registeredBefore(CompositeTransaction ct) {
        return ct != null && this.history.contains(ct);
    }

    public void notifyBeforeUse(CompositeTransaction ct) throws TransactionContextException {
        if (ct.isSameTransaction(this.currentTransaction)) {
            if (this.registeredBefore(ct)) {
                return;
            }
            CompositeTransaction localRoot = this.findLocalRoot(ct);
            if (localRoot != ct) {
                this.registerTransaction(ct);
                throw new SubTxAwareParticipantRegistrationRequiredException();
            }
        } else {
            if (ct.isDescendantOf(this.currentTransaction)) {
                this.currentTransaction = ct;
                this.registerTransaction(ct);
                throw new SubTxAwareParticipantRegistrationRequiredException();
            }
            if (this.currentTransaction == null) {
                this.currentTransaction = ct;
                this.registerTransaction(ct);
                if (this.readOnly) {
                    throw new ReadOnlyParticipantRegistrationRequiredException();
                }
                throw new ParticipantRegistrationRequiredException();
            }
            throw new InvalidTransactionContextException("Connection accessed by transaction " + ct.getTid() + "is already in use by another transaction: " + this.currentTransaction.getTid());
        }
    }

    public void subTransactionTerminated() {
        Stack parentTransactions = this.currentTransaction.getLineage();
        this.currentTransaction = null;
        if (parentTransactions != null && !parentTransactions.isEmpty()) {
            CompositeTransaction parent;
            this.currentTransaction = parent = (CompositeTransaction)parentTransactions.peek();
        }
    }

    public boolean isEnlistedInGlobalTransaction() {
        return this.currentTransaction != null;
    }

    public boolean isEnlistedInGlobalTransaction(CompositeTransaction ct) {
        boolean ret = false;
        CompositeTransaction tx = this.currentTransaction;
        if (tx != null && ct != null) {
            ret = tx.isSameTransaction(ct);
        }
        return ret;
    }

    public void reset() {
        this.currentTransaction = null;
        this.history.clear();
    }

    public CompositeTransaction findLocalRoot(CompositeTransaction ct) {
        CompositeTransaction ret = ct;
        Stack parents = ct.getLineage();
        if (parents != null) {
            Stack parentsClone = (Stack)parents.clone();
            while (!parentsClone.isEmpty()) {
                CompositeTransaction parent = (CompositeTransaction)parentsClone.pop();
                if (!parent.isLocal()) continue;
                ret = parent;
            }
        }
        return ret;
    }

    static class InvalidTransactionContextException
    extends TransactionContextException {
        private static final long serialVersionUID = 1L;

        public InvalidTransactionContextException(String msg) {
            super(msg);
        }
    }

    static class SubTxAwareParticipantRegistrationRequiredException
    extends TransactionContextException {
        private static final long serialVersionUID = 1L;

        SubTxAwareParticipantRegistrationRequiredException() {
        }
    }

    static class ReadOnlyParticipantRegistrationRequiredException
    extends TransactionContextException {
        private static final long serialVersionUID = 1L;

        ReadOnlyParticipantRegistrationRequiredException() {
        }
    }

    static class ParticipantRegistrationRequiredException
    extends TransactionContextException {
        private static final long serialVersionUID = 1L;

        ParticipantRegistrationRequiredException() {
        }
    }

    static class TransactionContextException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TransactionContextException() {
        }

        public TransactionContextException(String msg) {
            super(msg);
        }
    }
}

