/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.lock.holder;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.infra.props.TypedProperties;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.repository.cluster.lock.DistributedLock;
import org.apache.shardingsphere.mode.repository.cluster.lock.creator.DistributedLockCreator;

public final class DistributedLockHolder {
    private final DistributedLockCreator<Object, TypedProperties<?>> creator;
    private final Object client;
    private final TypedProperties<?> props;
    private final Map<String, DistributedLock> locks = new ConcurrentHashMap<String, DistributedLock>();

    public DistributedLockHolder(String type, Object client, TypedProperties<?> props) {
        this.creator = (DistributedLockCreator)TypedSPILoader.getService(DistributedLockCreator.class, (Object)type);
        this.client = client;
        this.props = props;
    }

    public DistributedLock getDistributedLock(String lockKey) {
        return this.locks.computeIfAbsent(lockKey, key -> this.creator.create((String)key, this.client, this.props));
    }
}

