/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.core.importer.sink;

import com.google.protobuf.Message;
import io.netty.channel.Channel;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.cdc.generator.CDCResponseUtils;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.response.CDCResponse;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.response.DataRecordResult;
import org.apache.shardingsphere.data.pipeline.cdc.util.DataRecordResultConvertUtils;
import org.apache.shardingsphere.data.pipeline.core.importer.sink.PipelineSink;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.PipelineJobUpdateProgress;
import org.apache.shardingsphere.infra.exception.core.external.sql.sqlstate.XOpenSQLState;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class PipelineCDCSocketSink
implements PipelineSink {
    private static final long DEFAULT_TIMEOUT_MILLISECONDS = 100L;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Channel channel;
    private final ShardingSphereDatabase database;
    private final Map<String, String> tableSchemaNameMap;

    public PipelineCDCSocketSink(Channel channel, ShardingSphereDatabase database, Collection<String> schemaTableNames) {
        this.channel = channel;
        this.database = database;
        this.tableSchemaNameMap = new HashMap<String, String>(schemaTableNames.size(), 1.0f);
        schemaTableNames.stream().filter(each -> each.contains(".")).forEach(each -> {
            String[] split = each.split("\\.");
            this.tableSchemaNameMap.put(split[1], split[0]);
        });
    }

    public PipelineJobUpdateProgress write(String ackId, Collection<Record> records) {
        if (records.isEmpty()) {
            return new PipelineJobUpdateProgress(0);
        }
        while (!this.channel.isWritable() && this.channel.isActive()) {
            this.doAwait();
        }
        if (!this.channel.isActive()) {
            return new PipelineJobUpdateProgress(0);
        }
        Collection<DataRecordResult.Record> resultRecords = this.getResultRecords(records);
        DataRecordResult dataRecordResult = DataRecordResult.newBuilder().addAllRecord(resultRecords).setAckId(ackId).build();
        this.channel.writeAndFlush((Object)CDCResponseUtils.succeed("", CDCResponse.ResponseCase.DATA_RECORD_RESULT, (Message)dataRecordResult));
        return new PipelineJobUpdateProgress(resultRecords.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAwait() {
        long startMillis;
        this.lock.lock();
        long endMillis = startMillis = System.currentTimeMillis();
        try {
            boolean awaitResult;
            do {
                awaitResult = this.condition.await(100L - (endMillis - startMillis), TimeUnit.MILLISECONDS);
                endMillis = System.currentTimeMillis();
            } while (!awaitResult && 100L > endMillis - startMillis);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Collection<DataRecordResult.Record> getResultRecords(Collection<Record> records) {
        LinkedList<DataRecordResult.Record> result = new LinkedList<DataRecordResult.Record>();
        for (Record each : records) {
            if (!(each instanceof DataRecord)) continue;
            DataRecord dataRecord = (DataRecord)each;
            result.add(DataRecordResultConvertUtils.convertDataRecordToRecord(this.database.getName(), this.tableSchemaNameMap.get(dataRecord.getTableName()), dataRecord));
        }
        return result;
    }

    public void close() throws IOException {
        this.channel.writeAndFlush((Object)CDCResponseUtils.failed("", XOpenSQLState.GENERAL_ERROR.getValue(), "The socket channel is closed."));
    }

    @Generated
    public Channel getChannel() {
        return this.channel;
    }
}

