/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.checker.ShadowRuleStatementChecker;
import org.apache.shardingsphere.shadow.distsql.handler.update.UnusedAlgorithmFinder;
import org.apache.shardingsphere.shadow.distsql.statement.DropShadowRuleStatement;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

@DistSQLExecutorCurrentRuleRequired(value=ShadowRule.class)
public final class DropShadowRuleExecutor
implements DatabaseRuleDropExecutor<DropShadowRuleStatement, ShadowRule, ShadowRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShadowRule rule;

    public void checkBeforeUpdate(DropShadowRuleStatement sqlStatement) {
        if (!sqlStatement.isIfExists()) {
            this.checkRuleExisted(sqlStatement);
        }
    }

    private void checkRuleExisted(DropShadowRuleStatement sqlStatement) {
        ShadowRuleStatementChecker.checkExisted(sqlStatement.getNames(), this.getDataSourceNames(), notExistedRuleNames -> new MissingRequiredRuleException("Shadow", this.database.getName(), notExistedRuleNames));
    }

    private Collection<String> getDataSourceNames() {
        return this.rule.getConfiguration().getDataSources().stream().map(ShadowDataSourceConfiguration::getName).collect(Collectors.toList());
    }

    public boolean hasAnyOneToBeDropped(DropShadowRuleStatement sqlStatement) {
        return !Collections.disjoint(sqlStatement.getNames(), this.getDataSourceNames());
    }

    public ShadowRuleConfiguration buildToBeDroppedRuleConfiguration(DropShadowRuleStatement sqlStatement) {
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        for (String string : sqlStatement.getNames()) {
            result.getDataSources().add(new ShadowDataSourceConfiguration(string, null, null));
            this.dropRule(string);
        }
        this.rule.getConfiguration().getTables().forEach((key, value) -> value.getDataSourceNames().removeIf(sqlStatement.getNames()::contains));
        for (Map.Entry entry : this.rule.getConfiguration().getTables().entrySet()) {
            if (!((ShadowTableConfiguration)entry.getValue()).getDataSourceNames().isEmpty()) continue;
            result.getTables().put((String)entry.getKey(), (ShadowTableConfiguration)entry.getValue());
        }
        this.rule.getConfiguration().getTables().entrySet().removeIf(each -> ((ShadowTableConfiguration)each.getValue()).getDataSourceNames().isEmpty());
        UnusedAlgorithmFinder.findUnusedShadowAlgorithm(this.rule.getConfiguration()).forEach(each -> result.getShadowAlgorithms().put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getShadowAlgorithms().get(each)));
        return result;
    }

    public ShadowRuleConfiguration buildToBeAlteredRuleConfiguration(DropShadowRuleStatement sqlStatement) {
        LinkedHashMap<String, ShadowTableConfiguration> tables = new LinkedHashMap<String, ShadowTableConfiguration>();
        Collection toBeDroppedDataSourceNames = sqlStatement.getNames();
        for (Map.Entry each : this.rule.getConfiguration().getTables().entrySet()) {
            if (toBeDroppedDataSourceNames.containsAll(((ShadowTableConfiguration)each.getValue()).getDataSourceNames())) continue;
            LinkedList currentDataSources = new LinkedList(((ShadowTableConfiguration)each.getValue()).getDataSourceNames());
            currentDataSources.removeAll(toBeDroppedDataSourceNames);
            tables.put((String)each.getKey(), new ShadowTableConfiguration(currentDataSources, ((ShadowTableConfiguration)each.getValue()).getShadowAlgorithmNames()));
        }
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        result.setTables(tables);
        return result;
    }

    private void dropRule(String ruleName) {
        Optional<ShadowDataSourceConfiguration> dataSourceRuleConfig = this.rule.getConfiguration().getDataSources().stream().filter(each -> ruleName.equals(each.getName())).findAny();
        dataSourceRuleConfig.ifPresent(optional -> this.rule.getConfiguration().getDataSources().remove(optional));
    }

    public Class<ShadowRule> getRuleClass() {
        return ShadowRule.class;
    }

    public Class<DropShadowRuleStatement> getType() {
        return DropShadowRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShadowRule rule) {
        this.rule = rule;
    }
}

