/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image.internal.shared;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.DataType;
import org.apache.sis.image.internal.shared.ColorModelFactory;
import org.apache.sis.image.internal.shared.ColorsForRange;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.image.internal.shared.ScaledColorSpace;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.InternationalString;

public final class ColorScaleBuilder {
    public static final ColorModel NULL_COLOR_MODEL = null;
    private static final InternationalString TRANSPARENT = Vocabulary.formatInternational((short)249);
    private static final InternationalString COLOR_INDEX = Vocabulary.formatInternational((short)30);
    private static final InternationalString VISUAL = Vocabulary.formatInternational((short)221);
    private static final int MAX_VALUE = 255;
    public static final int TYPE_COMPACT = 0;
    private final boolean compact;
    public static final Function<Category, Color[]> GRAYSCALE = category -> {
        Color[] colorArray;
        if (category.isQuantitative()) {
            Color[] colorArray2 = new Color[2];
            colorArray2[0] = Color.BLACK;
            colorArray = colorArray2;
            colorArray2[1] = Color.WHITE;
        } else {
            colorArray = null;
        }
        return colorArray;
    };
    private final Function<Category, Color[]> colors;
    private ColorsForRange[] entries;
    private SampleDimension source;
    private SampleDimension target;
    private NumberRange<?> defaultRange;
    private final ColorModel inheritedColors;

    public ColorScaleBuilder(Collection<Map.Entry<NumberRange<?>, Color[]>> colors, ColorModel inherited) {
        this.entries = ColorsForRange.list(colors, inherited);
        this.inheritedColors = inherited;
        this.colors = GRAYSCALE;
        for (Map.Entry<NumberRange<?>, Color[]> entry : colors) {
            NumberRange<?> range = entry.getKey();
            if (!(range.getMinDouble() < 0.0) && !(range.getMaxDouble() >= 256.0)) continue;
            this.compact = true;
            return;
        }
        this.compact = false;
    }

    public ColorScaleBuilder(Function<Category, Color[]> colors, ColorModel inherited, boolean compact) {
        this.colors = colors != null ? colors : GRAYSCALE;
        this.inheritedColors = inherited;
        this.compact = compact;
    }

    private void checkInitializationStatus(boolean initialized) {
        if (this.entries != null != initialized) {
            throw new IllegalStateException(Errors.format((short)(initialized ? (short)177 : 1), this.getClass()));
        }
    }

    private static boolean isAlreadyScaled(NumberRange<?> range) {
        return range.getMinDouble(true) == 0.0 && range.getMaxDouble(true) == 255.0;
    }

    public boolean initialize(SampleModel model, SampleDimension source) {
        this.checkInitializationStatus(false);
        if (source == null) {
            return false;
        }
        this.source = source;
        List<Category> categories = source.getCategories();
        if (categories.isEmpty()) {
            return false;
        }
        boolean isUndefined = true;
        boolean missingNodata = true;
        ColorsForRange[] ranges = new ColorsForRange[categories.size()];
        for (int i = 0; i < ranges.length; ++i) {
            ColorsForRange range = new ColorsForRange(categories.get(i), this.colors, this.inheritedColors);
            isUndefined &= range.isUndefined();
            missingNodata &= range.isData;
            ranges[i] = range;
        }
        if (isUndefined || !missingNodata && ranges.length <= 1) {
            return false;
        }
        if (missingNodata && (model == null || !DataType.isInteger(model))) {
            int count = ranges.length;
            ranges = Arrays.copyOf(ranges, count + 1);
            ranges[count] = new ColorsForRange((CharSequence)TRANSPARENT, NumberRange.create(Float.class, (Number)Float.valueOf(Float.NaN)), null, false, this.inheritedColors);
        }
        this.entries = ranges;
        return true;
    }

    public boolean initialize(SampleModel source, int band) {
        this.checkInitializationStatus(false);
        if (DataType.isInteger(source)) {
            long minimum = 0L;
            long maximum = Numerics.bitmask((int)source.getSampleSize(band)) - 1L;
            if (!DataType.isUnsigned(source)) {
                minimum = (maximum >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            this.initialize(minimum, maximum);
            return true;
        }
        return false;
    }

    public boolean initialize(ColorModel source) {
        this.checkInitializationStatus(false);
        if (source != null) {
            ColorSpace cs = source.getColorSpace();
            if (cs instanceof ScaledColorSpace) {
                ScaledColorSpace scs = (ScaledColorSpace)cs;
                this.initialize(scs.offset, scs.maximum, source.getTransferType());
                return true;
            }
            if (ImageUtilities.isIntegerType(source.getTransferType())) {
                long maximum = Numerics.bitmask((int)source.getPixelSize()) - 1L;
                long minimum = 0L;
                if (source instanceof IndexColorModel) {
                    IndexColorModel indexed = (IndexColorModel)source;
                    int t = indexed.getMapSize();
                    if ((long)t <= maximum) {
                        maximum = (long)t - 1L;
                    }
                    if ((t = indexed.getTransparentPixel()) == 0) {
                        minimum = 1L;
                    }
                }
                if (minimum < maximum) {
                    this.initialize(minimum, maximum);
                    return true;
                }
            }
        }
        return false;
    }

    public void initialize(double minimum, double maximum, int dataType) {
        this.checkInitializationStatus(false);
        ArgumentChecks.ensureFinite((String)"minimum", (double)minimum);
        ArgumentChecks.ensureFinite((String)"maximum", (double)maximum);
        this.defaultRange = ImageUtilities.isIntegerType(dataType) ? NumberRange.create((long)Math.round(minimum), (boolean)true, (long)Math.round(maximum), (boolean)true) : NumberRange.create((double)minimum, (boolean)true, (double)maximum, (boolean)true);
        this.applyDefaultRange();
    }

    public void initialize(long minimum, long maximum) {
        this.checkInitializationStatus(false);
        this.defaultRange = NumberRange.create((long)minimum, (boolean)true, (long)maximum, (boolean)true);
        this.applyDefaultRange();
    }

    private void applyDefaultRange() {
        SampleDimension.Builder builder = new SampleDimension.Builder().setName((CharSequence)VISUAL);
        if (this.compact) {
            NumberRange samples = NumberRange.create((int)1, (boolean)true, (int)255, (boolean)true);
            builder.setBackground((CharSequence)TRANSPARENT, 0).addQuantitative((CharSequence)COLOR_INDEX, samples, this.defaultRange);
        } else {
            builder.addQuantitative((CharSequence)COLOR_INDEX, this.defaultRange, null, null);
        }
        this.target = builder.build();
        this.source = this.target.forConvertedValues(true);
        List<Category> categories = this.target.getCategories();
        ColorsForRange[] entries = new ColorsForRange[categories.size()];
        for (int i = 0; i < entries.length; ++i) {
            Category category = categories.get(i);
            ColorsForRange range = new ColorsForRange(category.forConvertedValues(true), this.colors, this.inheritedColors);
            range.sampleRange = category.getSampleRange();
            entries[i] = range;
        }
        this.entries = entries;
    }

    public void rescaleMainRange(ColorModel original) {
        ColorSpace cs;
        this.checkInitializationStatus(true);
        if (original != null && (cs = original.getColorSpace()) instanceof ScaledColorSpace) {
            ScaledColorSpace scs = (ScaledColorSpace)cs;
            double minimum = scs.offset;
            double maximum = scs.maximum;
            ColorsForRange widest = null;
            double widestSpan = 0.0;
            for (ColorsForRange entry : this.entries) {
                double span = Math.min(entry.sampleRange.getMaxDouble(), maximum) - Math.max(entry.sampleRange.getMinDouble(), minimum);
                if (!(span > widestSpan)) continue;
                widestSpan = span;
                widest = entry;
            }
            this.defaultRange = NumberRange.create((double)minimum, (boolean)true, (double)maximum, (boolean)false);
            if (widest != null && widestSpan != widest.sampleRange.getSpan()) {
                widest.sampleRange = this.defaultRange;
                this.target = null;
            }
        }
    }

    private void compact() {
        Object[] entries;
        block23: {
            if (this.target != null) {
                return;
            }
            entries = this.entries;
            if (this.source != null) {
                this.target = this.source.forConvertedValues(false);
                if (this.target.getSampleRange().filter(ColorScaleBuilder::isAlreadyScaled).isPresent()) {
                    int i;
                    if (this.target == this.source) {
                        return;
                    }
                    HashMap mapper = new HashMap();
                    for (Category category : this.target.getCategories()) {
                        if (mapper.put(category.forConvertedValues(true).getSampleRange(), category.getSampleRange()) == null) continue;
                        break block23;
                    }
                    NumberRange[] ranges = new NumberRange[entries.length];
                    for (i = 0; i < entries.length; ++i) {
                        ranges[i] = (NumberRange)mapper.remove(((ColorsForRange)entries[i]).sampleRange);
                        if (ranges[i] != null) {
                            continue;
                        }
                        break block23;
                    }
                    for (i = 0; i < entries.length; ++i) {
                        ((ColorsForRange)entries[i]).sampleRange = ranges[i];
                    }
                    return;
                }
            }
        }
        Arrays.sort(entries);
        double span = 0.0;
        int lower = 0;
        int deferred = 0;
        int count = entries.length;
        NumberRange themes = null;
        HashMap<NumberRange, Object> mapper = new HashMap<NumberRange, Object>();
        SampleDimension.Builder builder = new SampleDimension.Builder();
        for (int i = 0; i < count; ++i) {
            Object entry = entries[i];
            NumberRange sourceRange = ((ColorsForRange)entry).sampleRange;
            if (!((ColorsForRange)entry).isData) {
                NumberRange targetRange;
                if (lower >= 255) {
                    throw new IllegalArgumentException(Resources.format((short)62));
                }
                if (mapper.put(targetRange = NumberRange.create((int)lower++, (boolean)true, (int)lower, (boolean)false), entry) != null) continue;
                double value = sourceRange.getMinDouble();
                if (Double.isNaN(value)) {
                    builder.mapQualitative(((ColorsForRange)entry).name(), targetRange, (float)value);
                    continue;
                }
                if (value == ((ColorsForRange)entry).sampleRange.getMaxDouble()) {
                    sourceRange = NumberRange.create((double)Math.min(value - 0.5, Math.nextDown(value)), (boolean)true, (double)Math.max(value + 0.5, Math.nextUp(value)), (boolean)false);
                }
                builder.addQuantitative(((ColorsForRange)entry).name(), targetRange, sourceRange);
                themes = themes != null ? themes.unionAny(sourceRange) : sourceRange;
                continue;
            }
            double s = sourceRange.getSpan();
            if (s > 0.0) {
                span += s;
                System.arraycopy(entries, deferred, entries, deferred + 1, i - deferred);
                entries[deferred++] = entry;
                continue;
            }
            System.arraycopy(entries, i + 1, entries, i, --count - i);
            entries[count] = null;
        }
        if (deferred == 0 && themes != null) {
            if (this.defaultRange == null) {
                this.defaultRange = NumberRange.create((int)0, (boolean)true, (int)32768, (boolean)false);
            }
            for (NumberRange sourceRange : this.defaultRange.subtractAny(themes)) {
                span += sourceRange.getSpan();
                ColorsForRange[] tmp = (ColorsForRange[])Arrays.copyOf(entries, ++count);
                System.arraycopy(entries, deferred++, tmp, deferred, count - deferred);
                tmp[deferred - 1] = new ColorsForRange(null, sourceRange, null, true, null);
                entries = tmp;
            }
        }
        entries = (ColorsForRange[])ArraysExt.resize((Object[])entries, (int)count);
        this.entries = entries;
        int base = lower;
        double toIndexRange = (double)(256 - base) / span;
        span = 0.0;
        for (int i = 0; i < deferred; ++i) {
            Object entry = entries[i];
            int upper = Math.toIntExact(Math.round((span += ((ColorsForRange)entry).sampleRange.getSpan()) * toIndexRange) + (long)base);
            if (upper <= lower) {
                throw new IllegalArgumentException(Resources.format((short)62));
            }
            NumberRange samples = NumberRange.create((int)lower, (boolean)true, (int)upper, (boolean)false);
            if (mapper.put(samples, entry) == null) {
                builder.addQuantitative(((ColorsForRange)entry).name(), samples, ((ColorsForRange)entry).sampleRange);
            }
            lower = upper;
        }
        if (this.source != null) {
            builder.setName(this.source.getName());
        } else {
            builder.setName((CharSequence)VISUAL);
        }
        this.target = builder.build();
        for (Category category : this.target.getCategories()) {
            NumberRange<?> packed = category.getSampleRange();
            ((ColorsForRange)mapper.get(packed)).sampleRange = packed;
        }
    }

    public ColorModel createColorModel(DataType dataType, int numBands, int visibleBand) {
        this.checkInitializationStatus(true);
        int typeCode = dataType.toDataBufferType();
        ArgumentChecks.ensureStrictlyPositive((String)"numBands", (int)numBands);
        ArgumentChecks.ensureBetween((String)"visibleBand", (int)0, (int)(numBands - 1), (int)visibleBand);
        if (this.compact) {
            this.compact();
            typeCode = 0;
        }
        return ColorModelFactory.createPiecewise(typeCode, numBands, visibleBand, this.entries);
    }

    public ColorModel createColorModel(SampleModel target, int numBands, int visibleBand) {
        return this.createColorModel(DataType.forBands(target), numBands, visibleBand);
    }

    public MathTransform1D getSampleToIndexValues() throws NoninvertibleTransformException {
        MathTransform1D toTarget;
        this.checkInitializationStatus(true);
        if (this.target != null && (toTarget = (MathTransform1D)this.target.getTransferFunction().orElse(null)) != null) {
            return toTarget.inverse();
        }
        return (MathTransform1D)MathTransforms.identity((int)1);
    }
}

