/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.spark.sql

import org.apache.spark.sql.catalyst.catalog.{CatalogColumnStat, CatalogStatistics}

object TPCDSTableStats {

  // These data statistics are extracted from generated TPCDS data with SF=100

  // scalastyle:off line.size.limit
  val sf100TableStats = Map(
    "customer" -> CatalogStatistics(500000000L, Some(2000000L), Map(
      "c_birth_country" -> CatalogColumnStat(Some(196L), None, None, Some(69626), Some(9), Some(20), None, CatalogColumnStat.VERSION),
      "c_current_cdemo_sk" -> CatalogColumnStat(Some(1184426L), Some("1"), Some("1920798"), Some(69943), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "c_customer_id" -> CatalogColumnStat(Some(2000000L), None, None, Some(0), Some(16), Some(16), None, CatalogColumnStat.VERSION),
      "c_birth_day" -> CatalogColumnStat(Some(32L), Some("1"), Some("31"), Some(70166), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "c_last_name" -> CatalogColumnStat(Some(5250L), None, None, Some(70098), Some(7), Some(13), None, CatalogColumnStat.VERSION),
      "c_login" -> CatalogColumnStat(Some(0L), None, None, Some(2000000), Some(20), Some(20), None, CatalogColumnStat.VERSION),
      "c_first_shipto_date_sk" -> CatalogColumnStat(Some(3755L), Some("2449028"), Some("2452678"), Some(70080), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "c_first_name" -> CatalogColumnStat(Some(5146L), None, None, Some(69769), Some(6), Some(11), None, CatalogColumnStat.VERSION),
      "c_birth_month" -> CatalogColumnStat(Some(12L), Some("1"), Some("12"), Some(69896), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "c_email_address" -> CatalogColumnStat(Some(1929800L), None, None, Some(70200), Some(28), Some(47), None, CatalogColumnStat.VERSION),
      "c_current_addr_sk" -> CatalogColumnStat(Some(824389L), Some("1"), Some("1000000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "c_salutation" -> CatalogColumnStat(Some(6L), None, None, Some(69840), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "c_current_hdemo_sk" -> CatalogColumnStat(Some(7083L), Some("1"), Some("7200"), Some(69657), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "c_birth_year" -> CatalogColumnStat(Some(67L), Some("1924"), Some("1992"), Some(69986), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "c_customer_sk" -> CatalogColumnStat(Some(1903054L), Some("1"), Some("2000000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "c_last_review_date" -> CatalogColumnStat(Some(357L), None, None, Some(70102), Some(7), Some(7), None, CatalogColumnStat.VERSION),
      "c_preferred_cust_flag" -> CatalogColumnStat(Some(2L), None, None, Some(69778), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "c_first_sales_date_sk" -> CatalogColumnStat(Some(3758L), Some("2448998"), Some("2452648"), Some(69950), Some(4), Some(4), None, CatalogColumnStat.VERSION)
    )),
    "store_sales" -> CatalogStatistics(42623559552L, Some(287997024L), Map(
      "ss_ext_sales_price" -> CatalogColumnStat(Some(712602L), Some("0.00"), Some("19878.00"), Some(12955462), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ss_item_sk" -> CatalogColumnStat(Some(206807L), Some("1"), Some("204000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ss_coupon_amt" -> CatalogColumnStat(Some(925847L), Some("0.00"), Some("19225.00"), Some(12958053), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ss_store_sk" -> CatalogColumnStat(Some(199L), Some("1"), Some("400"), Some(12950651), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ss_quantity" -> CatalogColumnStat(Some(99L), Some("1"), Some("100"), Some(12953654), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ss_ext_discount_amt" -> CatalogColumnStat(Some(925847L), Some("0.00"), Some("19225.00"), Some(12958053), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ss_hdemo_sk" -> CatalogColumnStat(Some(7083L), Some("1"), Some("7200"), Some(12957139), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ss_ext_tax" -> CatalogColumnStat(Some(135620L), Some("0.00"), Some("1762.38"), Some(12957705), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ss_sold_time_sk" -> CatalogColumnStat(Some(47827L), Some("28800"), Some("75599"), Some(12953300), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ss_promo_sk" -> CatalogColumnStat(Some(1026L), Some("1"), Some("1000"), Some(12954088), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ss_net_paid_inc_tax" -> CatalogColumnStat(Some(1404501L), Some("0.00"), Some("21344.38"), Some(12958941), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ss_wholesale_cost" -> CatalogColumnStat(Some(9503L), Some("1.00"), Some("100.00"), Some(12958327), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ss_cdemo_sk" -> CatalogColumnStat(Some(1847065L), Some("1"), Some("1920800"), Some(12955252), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ss_sold_date_sk" -> CatalogColumnStat(Some(1781L), Some("2450816"), Some("2452642"), Some(12955025), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ss_list_price" -> CatalogColumnStat(Some(19079L), Some("1.00"), Some("200.00"), Some(12952108), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ss_ext_list_price" -> CatalogColumnStat(Some(752016L), Some("1.00"), Some("20000.00"), Some(12955040), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ss_net_profit" -> CatalogColumnStat(Some(1388760L), Some("-10000.00"), Some("9889.00"), Some(12955156), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ss_ticket_number" -> CatalogColumnStat(Some(24596280L), Some("1"), Some("24000000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ss_net_paid" -> CatalogColumnStat(Some(1058635L), Some("0.00"), Some("19878.00"), Some(12954554), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ss_ext_wholesale_cost" -> CatalogColumnStat(Some(382964L), Some("1.00"), Some("10000.00"), Some(12960060), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ss_customer_sk" -> CatalogColumnStat(Some(1903054L), Some("1"), Some("2000000"), Some(12952082), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ss_addr_sk" -> CatalogColumnStat(Some(943039L), Some("1"), Some("1000000"), Some(12956686), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ss_sales_price" -> CatalogColumnStat(Some(19261L), Some("0.00"), Some("200.00"), Some(12958587), Some(8), Some(8), None, CatalogColumnStat.VERSION)
    )),
    "web_sales" -> CatalogStatistics(14688252348L, Some(72001237L), Map(
      "ws_sold_time_sk" -> CatalogColumnStat(Some(83505L), Some("0"), Some("86399"), Some(17931), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_ext_wholesale_cost" -> CatalogColumnStat(Some(382964L), Some("1.00"), Some("10000.00"), Some(17814), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ws_bill_cdemo_sk" -> CatalogColumnStat(Some(1707373L), Some("1"), Some("1920800"), Some(17833), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_net_paid_inc_ship" -> CatalogColumnStat(Some(1629659L), Some("0.00"), Some("43468.92"), Some(0), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ws_sales_price" -> CatalogColumnStat(Some(29143L), Some("0.00"), Some("300.00"), Some(18005), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ws_ship_mode_sk" -> CatalogColumnStat(Some(20L), Some("1"), Some("20"), Some(17823), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_ship_hdemo_sk" -> CatalogColumnStat(Some(7083L), Some("1"), Some("7200"), Some(17833), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_order_number" -> CatalogColumnStat(Some(6073146L), Some("1"), Some("6000000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_sold_date_sk" -> CatalogColumnStat(Some(1781L), Some("2450816"), Some("2452642"), Some(17922), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_web_site_sk" -> CatalogColumnStat(Some(25L), Some("1"), Some("24"), Some(18030), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_bill_customer_sk" -> CatalogColumnStat(Some(1800267L), Some("1"), Some("2000000"), Some(17882), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_coupon_amt" -> CatalogColumnStat(Some(863374L), Some("0.00"), Some("27591.16"), Some(18027), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ws_ship_addr_sk" -> CatalogColumnStat(Some(943039L), Some("1"), Some("1000000"), Some(17931), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_net_paid_inc_tax" -> CatalogColumnStat(Some(1695042L), Some("0.00"), Some("32492.90"), Some(18102), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ws_quantity" -> CatalogColumnStat(Some(99L), Some("1"), Some("100"), Some(18014), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_bill_addr_sk" -> CatalogColumnStat(Some(940457L), Some("1"), Some("1000000"), Some(17801), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_net_paid" -> CatalogColumnStat(Some(1247989L), Some("0.00"), Some("29810.00"), Some(17968), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ws_ext_discount_amt" -> CatalogColumnStat(Some(934889L), Some("0.00"), Some("29982.00"), Some(17890), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ws_item_sk" -> CatalogColumnStat(Some(206807L), Some("1"), Some("204000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_ext_tax" -> CatalogColumnStat(Some(168876L), Some("0.00"), Some("2682.90"), Some(17800), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ws_wholesale_cost" -> CatalogColumnStat(Some(9503L), Some("1.00"), Some("100.00"), Some(17850), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ws_ship_customer_sk" -> CatalogColumnStat(Some(1811873L), Some("1"), Some("2000000"), Some(17886), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_net_paid_inc_ship_tax" -> CatalogColumnStat(Some(2186741L), Some("0.00"), Some("44479.52"), Some(0), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ws_web_page_sk" -> CatalogColumnStat(Some(2108L), Some("1"), Some("2040"), Some(17920), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_ext_sales_price" -> CatalogColumnStat(Some(908147L), Some("0.00"), Some("29810.00"), Some(17843), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ws_ext_ship_cost" -> CatalogColumnStat(Some(482711L), Some("0.00"), Some("14927.00"), Some(17923), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ws_bill_hdemo_sk" -> CatalogColumnStat(Some(7083L), Some("1"), Some("7200"), Some(18011), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_ship_date_sk" -> CatalogColumnStat(Some(1898L), Some("2450817"), Some("2452762"), Some(17883), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_ext_list_price" -> CatalogColumnStat(Some(1071558L), Some("1.02"), Some("29997.00"), Some(18001), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ws_ship_cdemo_sk" -> CatalogColumnStat(Some(1755797L), Some("1"), Some("1920800"), Some(17903), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_warehouse_sk" -> CatalogColumnStat(Some(15L), Some("1"), Some("15"), Some(17812), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_list_price" -> CatalogColumnStat(Some(29447L), Some("1.00"), Some("300.00"), Some(17824), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ws_promo_sk" -> CatalogColumnStat(Some(1026L), Some("1"), Some("1000"), Some(18116), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ws_net_profit" -> CatalogColumnStat(Some(1482074L), Some("-9997.00"), Some("19840.00"), Some(0), Some(8), Some(8), None, CatalogColumnStat.VERSION)
    )),
    "date_dim" -> CatalogStatistics(19284936L, Some(73049L), Map(
      "d_dom" -> CatalogColumnStat(Some(32L), Some("1"), Some("31"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "d_current_quarter" -> CatalogColumnStat(Some(2L), None, None, Some(0), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "d_fy_week_seq" -> CatalogColumnStat(Some(10010L), Some("1"), Some("10436"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "d_holiday" -> CatalogColumnStat(Some(2L), None, None, Some(0), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "d_current_day" -> CatalogColumnStat(Some(1L), None, None, Some(0), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "d_week_seq" -> CatalogColumnStat(Some(10010L), Some("1"), Some("10436"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "d_current_month" -> CatalogColumnStat(Some(2L), None, None, Some(0), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "d_moy" -> CatalogColumnStat(Some(12L), Some("1"), Some("12"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "d_date" -> CatalogColumnStat(Some(73049L), None, None, Some(0), Some(10), Some(10), None, CatalogColumnStat.VERSION),
      "d_same_day_lq" -> CatalogColumnStat(Some(73049L), Some("2414930"), Some("2487978"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "d_weekend" -> CatalogColumnStat(Some(2L), None, None, Some(0), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "d_dow" -> CatalogColumnStat(Some(7L), Some("0"), Some("6"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "d_year" -> CatalogColumnStat(Some(202L), Some("1900"), Some("2100"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "d_current_week" -> CatalogColumnStat(Some(1L), None, None, Some(0), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "d_quarter_name" -> CatalogColumnStat(Some(774L), None, None, Some(0), Some(6), Some(6), None, CatalogColumnStat.VERSION),
      "d_month_seq" -> CatalogColumnStat(Some(2431L), Some("0"), Some("2400"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "d_fy_year" -> CatalogColumnStat(Some(202L), Some("1900"), Some("2100"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "d_following_holiday" -> CatalogColumnStat(Some(2L), None, None, Some(0), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "d_same_day_ly" -> CatalogColumnStat(Some(73049L), Some("2414657"), Some("2487705"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "d_day_name" -> CatalogColumnStat(Some(7L), None, None, Some(0), Some(8), Some(9), None, CatalogColumnStat.VERSION),
      "d_qoy" -> CatalogColumnStat(Some(4L), Some("1"), Some("4"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "d_date_sk" -> CatalogColumnStat(Some(73049L), Some("2415022"), Some("2488070"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "d_fy_quarter_seq" -> CatalogColumnStat(Some(787L), Some("1"), Some("801"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "d_current_year" -> CatalogColumnStat(Some(2L), None, None, Some(0), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "d_date_id" -> CatalogColumnStat(Some(73049L), None, None, Some(0), Some(16), Some(16), None, CatalogColumnStat.VERSION),
      "d_quarter_seq" -> CatalogColumnStat(Some(787L), Some("1"), Some("801"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "d_last_dom" -> CatalogColumnStat(Some(2386L), Some("2415020"), Some("2488372"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "d_first_dom" -> CatalogColumnStat(Some(2329L), Some("2415021"), Some("2488070"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION)
    )),
    "household_demographics" -> CatalogStatistics(316800L, Some(7200L), Map(
      "hd_buy_potential" -> CatalogColumnStat(Some(6L), None, None, Some(0), Some(8), Some(10), None, CatalogColumnStat.VERSION),
      "hd_income_band_sk" -> CatalogColumnStat(Some(20L), Some("1"), Some("20"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "hd_demo_sk" -> CatalogColumnStat(Some(7083L), Some("1"), Some("7200"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "hd_vehicle_count" -> CatalogColumnStat(Some(6L), Some("-1"), Some("4"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "hd_dep_count" -> CatalogColumnStat(Some(10L), Some("0"), Some("9"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION)
    )),
    "call_center" -> CatalogStatistics(16020L, Some(30L), Map(
      "cc_rec_start_date" -> CatalogColumnStat(Some(4L), Some("1998-01-01"), Some("2002-01-01"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cc_mkt_desc" -> CatalogColumnStat(Some(21L), None, None, Some(0), Some(59), Some(93), None, CatalogColumnStat.VERSION),
      "cc_hours" -> CatalogColumnStat(Some(3L), None, None, Some(0), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cc_street_name" -> CatalogColumnStat(Some(14L), None, None, Some(0), Some(8), Some(16), None, CatalogColumnStat.VERSION),
      "cc_manager" -> CatalogColumnStat(Some(22L), None, None, Some(0), Some(13), Some(17), None, CatalogColumnStat.VERSION),
      "cc_city" -> CatalogColumnStat(Some(12L), None, None, Some(0), Some(10), Some(15), None, CatalogColumnStat.VERSION),
      "cc_class" -> CatalogColumnStat(Some(3L), None, None, Some(0), Some(6), Some(6), None, CatalogColumnStat.VERSION),
      "cc_country" -> CatalogColumnStat(Some(1L), None, None, Some(0), Some(13), Some(13), None, CatalogColumnStat.VERSION),
      "cc_open_date_sk" -> CatalogColumnStat(Some(15L), Some("2450794"), Some("2451146"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cc_market_manager" -> CatalogColumnStat(Some(25L), None, None, Some(0), Some(13), Some(17), None, CatalogColumnStat.VERSION),
      "cc_street_number" -> CatalogColumnStat(Some(15L), None, None, Some(0), Some(3), Some(3), None, CatalogColumnStat.VERSION),
      "cc_call_center_sk" -> CatalogColumnStat(Some(30L), Some("1"), Some("30"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cc_name" -> CatalogColumnStat(Some(15L), None, None, Some(0), Some(14), Some(19), None, CatalogColumnStat.VERSION),
      "cc_suite_number" -> CatalogColumnStat(Some(14L), None, None, Some(0), Some(8), Some(9), None, CatalogColumnStat.VERSION),
      "cc_mkt_id" -> CatalogColumnStat(Some(6L), Some("1"), Some("6"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cc_gmt_offset" -> CatalogColumnStat(Some(2L), Some("-6.00"), Some("-5.00"), Some(0), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cc_company_name" -> CatalogColumnStat(Some(6L), None, None, Some(0), Some(4), Some(5), None, CatalogColumnStat.VERSION),
      "cc_division" -> CatalogColumnStat(Some(6L), Some("1"), Some("6"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cc_closed_date_sk" -> CatalogColumnStat(Some(0L), None, None, Some(30), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cc_state" -> CatalogColumnStat(Some(8L), None, None, Some(0), Some(2), Some(2), None, CatalogColumnStat.VERSION),
      "cc_street_type" -> CatalogColumnStat(Some(9L), None, None, Some(0), Some(5), Some(9), None, CatalogColumnStat.VERSION),
      "cc_call_center_id" -> CatalogColumnStat(Some(14L), None, None, Some(0), Some(16), Some(16), None, CatalogColumnStat.VERSION),
      "cc_sq_ft" -> CatalogColumnStat(Some(22L), Some("1670015"), Some("31896816"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cc_mkt_class" -> CatalogColumnStat(Some(26L), None, None, Some(0), Some(35), Some(50), None, CatalogColumnStat.VERSION),
      "cc_tax_percentage" -> CatalogColumnStat(Some(10L), Some("0.00"), Some("0.12"), Some(0), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cc_division_name" -> CatalogColumnStat(Some(6L), None, None, Some(0), Some(5), Some(5), None, CatalogColumnStat.VERSION),
      "cc_zip" -> CatalogColumnStat(Some(14L), None, None, Some(0), Some(5), Some(5), None, CatalogColumnStat.VERSION),
      "cc_rec_end_date" -> CatalogColumnStat(Some(3L), Some("2000-01-01"), Some("2001-12-31"), Some(15), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cc_employees" -> CatalogColumnStat(Some(22L), Some("2935"), Some("69020"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cc_county" -> CatalogColumnStat(Some(8L), None, None, Some(0), Some(15), Some(17), None, CatalogColumnStat.VERSION),
      "cc_company" -> CatalogColumnStat(Some(6L), Some("1"), Some("6"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION)
    )),
    "catalog_page" -> CatalogStatistics(3774000L, Some(20400L), Map(
      "cp_catalog_page_id" -> CatalogColumnStat(Some(20400L), None, None, Some(0), Some(16), Some(16), None, CatalogColumnStat.VERSION),
      "cp_department" -> CatalogColumnStat(Some(1L), None, None, Some(205), Some(10), Some(10), None, CatalogColumnStat.VERSION),
      "cp_description" -> CatalogColumnStat(Some(19304L), None, None, Some(190), Some(75), Some(99), None, CatalogColumnStat.VERSION),
      "cp_start_date_sk" -> CatalogColumnStat(Some(88L), Some("2450815"), Some("2453005"), Some(196), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cp_end_date_sk" -> CatalogColumnStat(Some(101L), Some("2450844"), Some("2453186"), Some(206), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cp_catalog_page_number" -> CatalogColumnStat(Some(186L), Some("1"), Some("188"), Some(208), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cp_type" -> CatalogColumnStat(Some(3L), None, None, Some(197), Some(8), Some(9), None, CatalogColumnStat.VERSION),
      "cp_catalog_page_sk" -> CatalogColumnStat(Some(18915L), Some("1"), Some("20400"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cp_catalog_number" -> CatalogColumnStat(Some(110L), Some("1"), Some("109"), Some(197), Some(4), Some(4), None, CatalogColumnStat.VERSION)
    )),
    "catalog_returns" -> CatalogStatistics(2189464848L, Some(14404374L), Map(
      "cr_return_amount" -> CatalogColumnStat(Some(563788L), Some("0.00"), Some("28778.31"), Some(288408), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cr_returning_hdemo_sk" -> CatalogColumnStat(Some(7083L), Some("1"), Some("7200"), Some(288369), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_refunded_hdemo_sk" -> CatalogColumnStat(Some(7083L), Some("1"), Some("7200"), Some(288053), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_catalog_page_sk" -> CatalogColumnStat(Some(11224L), Some("1"), Some("17108"), Some(288041), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_reason_sk" -> CatalogColumnStat(Some(55L), Some("1"), Some("55"), Some(287890), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_returning_cdemo_sk" -> CatalogColumnStat(Some(1839372L), Some("1"), Some("1920800"), Some(288128), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_fee" -> CatalogColumnStat(Some(9571L), Some("0.50"), Some("100.00"), Some(288038), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cr_refunded_cash" -> CatalogColumnStat(Some(592855L), Some("0.00"), Some("24544.84"), Some(287638), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cr_refunded_cdemo_sk" -> CatalogColumnStat(Some(1842661L), Some("1"), Some("1920800"), Some(287556), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_order_number" -> CatalogColumnStat(Some(8816832L), Some("2"), Some("16000000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_ship_mode_sk" -> CatalogColumnStat(Some(20L), Some("1"), Some("20"), Some(287768), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_refunded_customer_sk" -> CatalogColumnStat(Some(1894309L), Some("1"), Some("2000000"), Some(287207), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_return_amt_inc_tax" -> CatalogColumnStat(Some(855338L), Some("0.00"), Some("29353.87"), Some(288246), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cr_returning_customer_sk" -> CatalogColumnStat(Some(1903054L), Some("1"), Some("2000000"), Some(287581), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_returned_date_sk" -> CatalogColumnStat(Some(2027L), Some("2450821"), Some("2452921"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_return_ship_cost" -> CatalogColumnStat(Some(347391L), Some("0.00"), Some("14130.96"), Some(287952), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cr_returning_addr_sk" -> CatalogColumnStat(Some(943039L), Some("1"), Some("1000000"), Some(288203), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_return_quantity" -> CatalogColumnStat(Some(99L), Some("1"), Some("100"), Some(287844), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_store_credit" -> CatalogColumnStat(Some(415989L), Some("0.00"), Some("22167.49"), Some(288118), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cr_item_sk" -> CatalogColumnStat(Some(206807L), Some("1"), Some("204000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_return_tax" -> CatalogColumnStat(Some(101557L), Some("0.00"), Some("2390.75"), Some(288599), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cr_refunded_addr_sk" -> CatalogColumnStat(Some(943039L), Some("1"), Some("1000000"), Some(287752), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_call_center_sk" -> CatalogColumnStat(Some(31L), Some("1"), Some("30"), Some(288179), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_returned_time_sk" -> CatalogColumnStat(Some(83505L), Some("0"), Some("86399"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cr_net_loss" -> CatalogColumnStat(Some(550908L), Some("0.50"), Some("15781.83"), Some(287954), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cr_reversed_charge" -> CatalogColumnStat(Some(410432L), Some("0.00"), Some("23801.24"), Some(288476), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cr_warehouse_sk" -> CatalogColumnStat(Some(15L), Some("1"), Some("15"), Some(288581), Some(4), Some(4), None, CatalogColumnStat.VERSION)
    )),
    "catalog_sales" -> CatalogStatistics(29375401260L, Some(143997065L), Map(
      "cs_ship_hdemo_sk" -> CatalogColumnStat(Some(7083L), Some("1"), Some("7200"), Some(720450), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_bill_addr_sk" -> CatalogColumnStat(Some(943039L), Some("1"), Some("1000000"), Some(718886), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_net_paid_inc_ship_tax" -> CatalogColumnStat(Some(2570239L), Some("0.00"), Some("45460.80"), Some(0), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cs_ext_sales_price" -> CatalogColumnStat(Some(977146L), Some("0.00"), Some("29808.00"), Some(719228), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cs_sold_date_sk" -> CatalogColumnStat(Some(1772L), Some("2450815"), Some("2452654"), Some(719581), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_ext_tax" -> CatalogColumnStat(Some(189612L), Some("0.00"), Some("2619.36"), Some(719627), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cs_sold_time_sk" -> CatalogColumnStat(Some(83505L), Some("0"), Some("86399"), Some(720917), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_net_paid_inc_ship" -> CatalogColumnStat(Some(1870941L), Some("0.00"), Some("43725.00"), Some(0), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cs_warehouse_sk" -> CatalogColumnStat(Some(15L), Some("1"), Some("15"), Some(719624), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_ext_list_price" -> CatalogColumnStat(Some(1101138L), Some("1.00"), Some("29997.00"), Some(719642), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cs_quantity" -> CatalogColumnStat(Some(99L), Some("1"), Some("100"), Some(720147), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_ext_discount_amt" -> CatalogColumnStat(Some(965247L), Some("0.00"), Some("29765.00"), Some(719820), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cs_net_profit" -> CatalogColumnStat(Some(1640663L), Some("-10000.00"), Some("19840.00"), Some(0), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cs_bill_hdemo_sk" -> CatalogColumnStat(Some(7083L), Some("1"), Some("7200"), Some(719849), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_ext_ship_cost" -> CatalogColumnStat(Some(508914L), Some("0.00"), Some("14896.00"), Some(719848), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cs_item_sk" -> CatalogColumnStat(Some(206807L), Some("1"), Some("204000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_ship_cdemo_sk" -> CatalogColumnStat(Some(1847065L), Some("1"), Some("1920800"), Some(720292), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_wholesale_cost" -> CatalogColumnStat(Some(9503L), Some("1.00"), Some("100.00"), Some(721114), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cs_ship_date_sk" -> CatalogColumnStat(Some(1887L), Some("2450817"), Some("2452744"), Some(719625), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_ext_wholesale_cost" -> CatalogColumnStat(Some(382964L), Some("1.00"), Some("10000.00"), Some(719924), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cs_bill_cdemo_sk" -> CatalogColumnStat(Some(1847065L), Some("1"), Some("1920800"), Some(720208), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_sales_price" -> CatalogColumnStat(Some(29282L), Some("0.00"), Some("300.00"), Some(719781), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cs_net_paid" -> CatalogColumnStat(Some(1330351L), Some("0.00"), Some("29760.00"), Some(719706), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cs_promo_sk" -> CatalogColumnStat(Some(1026L), Some("1"), Some("1000"), Some(720194), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_call_center_sk" -> CatalogColumnStat(Some(31L), Some("1"), Some("30"), Some(719767), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_catalog_page_sk" -> CatalogColumnStat(Some(11224L), Some("1"), Some("17108"), Some(719180), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_bill_customer_sk" -> CatalogColumnStat(Some(1903054L), Some("1"), Some("2000000"), Some(719473), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_list_price" -> CatalogColumnStat(Some(29447L), Some("1.00"), Some("300.00"), Some(720328), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cs_ship_customer_sk" -> CatalogColumnStat(Some(1903054L), Some("1"), Some("2000000"), Some(720582), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_coupon_amt" -> CatalogColumnStat(Some(982009L), Some("0.00"), Some("28422.94"), Some(719631), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cs_ship_addr_sk" -> CatalogColumnStat(Some(943039L), Some("1"), Some("1000000"), Some(718680), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_order_number" -> CatalogColumnStat(Some(15603123L), Some("1"), Some("16000000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cs_net_paid_inc_tax" -> CatalogColumnStat(Some(1807594L), Some("0.00"), Some("31745.52"), Some(719354), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "cs_ship_mode_sk" -> CatalogColumnStat(Some(20L), Some("1"), Some("20"), Some(720146), Some(4), Some(4), None, CatalogColumnStat.VERSION)
    )),
    "customer_address" -> CatalogStatistics(245000000L, Some(1000000L), Map(
      "ca_country" -> CatalogColumnStat(Some(1L), None, None, Some(30097), Some(13), Some(13), None, CatalogColumnStat.VERSION),
      "ca_address_id" -> CatalogColumnStat(Some(1000000L), None, None, Some(0), Some(16), Some(16), None, CatalogColumnStat.VERSION),
      "ca_address_sk" -> CatalogColumnStat(Some(943039L), Some("1"), Some("1000000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ca_county" -> CatalogColumnStat(Some(1957L), None, None, Some(30028), Some(14), Some(28), None, CatalogColumnStat.VERSION),
      "ca_gmt_offset" -> CatalogColumnStat(Some(6L), Some("-10.00"), Some("-5.00"), Some(30131), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "ca_street_type" -> CatalogColumnStat(Some(20L), None, None, Some(30124), Some(5), Some(9), None, CatalogColumnStat.VERSION),
      "ca_street_name" -> CatalogColumnStat(Some(8292L), None, None, Some(30178), Some(9), Some(21), None, CatalogColumnStat.VERSION),
      "ca_city" -> CatalogColumnStat(Some(977L), None, None, Some(30183), Some(9), Some(20), None, CatalogColumnStat.VERSION),
      "ca_location_type" -> CatalogColumnStat(Some(3L), None, None, Some(30172), Some(9), Some(13), None, CatalogColumnStat.VERSION),
      "ca_suite_number" -> CatalogColumnStat(Some(76L), None, None, Some(30047), Some(8), Some(9), None, CatalogColumnStat.VERSION),
      "ca_zip" -> CatalogColumnStat(Some(8311L), None, None, Some(30370), Some(5), Some(5), None, CatalogColumnStat.VERSION),
      "ca_state" -> CatalogColumnStat(Some(54L), None, None, Some(30124), Some(2), Some(2), None, CatalogColumnStat.VERSION),
      "ca_street_number" -> CatalogColumnStat(Some(1034L), None, None, Some(30226), Some(3), Some(4), None, CatalogColumnStat.VERSION)
    )),
    "customer_demographics" -> CatalogStatistics(182476000L, Some(1920800L), Map(
      "cd_dep_employed_count" -> CatalogColumnStat(Some(7L), Some("0"), Some("6"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cd_dep_count" -> CatalogColumnStat(Some(7L), Some("0"), Some("6"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cd_education_status" -> CatalogColumnStat(Some(7L), None, None, Some(0), Some(10), Some(15), None, CatalogColumnStat.VERSION),
      "cd_marital_status" -> CatalogColumnStat(Some(5L), None, None, Some(0), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "cd_gender" -> CatalogColumnStat(Some(2L), None, None, Some(0), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "cd_purchase_estimate" -> CatalogColumnStat(Some(20L), Some("500"), Some("10000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cd_demo_sk" -> CatalogColumnStat(Some(1847065L), Some("1"), Some("1920800"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "cd_credit_rating" -> CatalogColumnStat(Some(4L), None, None, Some(0), Some(7), Some(9), None, CatalogColumnStat.VERSION),
      "cd_dep_college_count" -> CatalogColumnStat(Some(7L), Some("0"), Some("6"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION)
    )),
    "income_band" -> CatalogStatistics(400L, Some(20L), Map(
      "ib_income_band_sk" -> CatalogColumnStat(Some(20L), Some("1"), Some("20"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ib_lower_bound" -> CatalogColumnStat(Some(19L), Some("0"), Some("190001"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "ib_upper_bound" -> CatalogColumnStat(Some(20L), Some("10000"), Some("200000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION)
    )),
    "inventory" -> CatalogStatistics(9583920000L, Some(399330000L), Map(
      "inv_date_sk" -> CatalogColumnStat(Some(267L), Some("2450815"), Some("2452635"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "inv_item_sk" -> CatalogColumnStat(Some(206807L), Some("1"), Some("204000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "inv_warehouse_sk" -> CatalogColumnStat(Some(15L), Some("1"), Some("15"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "inv_quantity_on_hand" -> CatalogColumnStat(Some(1026L), Some("0"), Some("1000"), Some(19969395), Some(4), Some(4), None, CatalogColumnStat.VERSION)
    )),
    "item" -> CatalogStatistics(94248000L, Some(204000L), Map(
      "i_container" -> CatalogColumnStat(Some(1L), None, None, Some(510), Some(7), Some(7), None, CatalogColumnStat.VERSION),
      "i_formulation" -> CatalogColumnStat(Some(158873L), None, None, Some(530), Some(20), Some(20), None, CatalogColumnStat.VERSION),
      "i_brand_id" -> CatalogColumnStat(Some(862L), Some("1001001"), Some("10016017"), Some(516), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "i_manager_id" -> CatalogColumnStat(Some(99L), Some("1"), Some("100"), Some(506), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "i_rec_end_date" -> CatalogColumnStat(Some(3L), None, None, Some(102000), Some(10), Some(10), None, CatalogColumnStat.VERSION),
      "i_class" -> CatalogColumnStat(Some(100L), None, None, Some(499), Some(8), Some(15), None, CatalogColumnStat.VERSION),
      "i_wholesale_cost" -> CatalogColumnStat(Some(6297L), Some("0.02"), Some("88.91"), Some(489), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "i_item_id" -> CatalogColumnStat(Some(104042L), None, None, Some(0), Some(16), Some(16), None, CatalogColumnStat.VERSION),
      "i_manufact_id" -> CatalogColumnStat(Some(1026L), Some("1"), Some("1000"), Some(498), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "i_item_desc" -> CatalogColumnStat(Some(158754L), None, None, Some(508), Some(101), Some(200), None, CatalogColumnStat.VERSION),
      "i_rec_start_date" -> CatalogColumnStat(Some(4L), None, None, Some(522), Some(10), Some(10), None, CatalogColumnStat.VERSION),
      "i_color" -> CatalogColumnStat(Some(88L), None, None, Some(524), Some(6), Some(10), None, CatalogColumnStat.VERSION),
      "i_product_name" -> CatalogColumnStat(Some(203486L), None, None, Some(514), Some(23), Some(30), None, CatalogColumnStat.VERSION),
      "i_category" -> CatalogColumnStat(Some(10L), None, None, Some(482), Some(6), Some(11), None, CatalogColumnStat.VERSION),
      "i_class_id" -> CatalogColumnStat(Some(16L), Some("1"), Some("16"), Some(491), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "i_item_sk" -> CatalogColumnStat(Some(204000L), Some("1"), Some("204000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "i_manufact" -> CatalogColumnStat(Some(997L), None, None, Some(544), Some(12), Some(15), None, CatalogColumnStat.VERSION),
      "i_brand" -> CatalogColumnStat(Some(671L), None, None, Some(510), Some(17), Some(22), None, CatalogColumnStat.VERSION),
      "i_current_price" -> CatalogColumnStat(Some(8736L), Some("0.09"), Some("99.99"), Some(518), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "i_category_id" -> CatalogColumnStat(Some(10L), Some("1"), Some("10"), Some(515), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "i_size" -> CatalogColumnStat(Some(7L), None, None, Some(515), Some(5), Some(11), None, CatalogColumnStat.VERSION),
      "i_units" -> CatalogColumnStat(Some(21L), None, None, Some(503), Some(5), Some(7), None, CatalogColumnStat.VERSION)
    )),
    "promotion" -> CatalogStatistics(268000L, Some(1000L), Map(
      "p_promo_name" -> CatalogColumnStat(Some(10L), None, None, Some(18), Some(4), Some(5), None, CatalogColumnStat.VERSION),
      "p_end_date_sk" -> CatalogColumnStat(Some(564L), Some("2450116"), Some("2450967"), Some(12), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "p_channel_radio" -> CatalogColumnStat(Some(1L), None, None, Some(13), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "p_channel_demo" -> CatalogColumnStat(Some(1L), None, None, Some(16), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "p_item_sk" -> CatalogColumnStat(Some(986L), Some("280"), Some("203966"), Some(14), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "p_channel_dmail" -> CatalogColumnStat(Some(2L), None, None, Some(13), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "p_discount_active" -> CatalogColumnStat(Some(1L), None, None, Some(19), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "p_promo_id" -> CatalogColumnStat(Some(1000L), None, None, Some(0), Some(16), Some(16), None, CatalogColumnStat.VERSION),
      "p_channel_tv" -> CatalogColumnStat(Some(1L), None, None, Some(14), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "p_cost" -> CatalogColumnStat(Some(1L), Some("1000.00"), Some("1000.00"), Some(14), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "p_channel_email" -> CatalogColumnStat(Some(1L), None, None, Some(13), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "p_channel_event" -> CatalogColumnStat(Some(1L), None, None, Some(14), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "p_channel_catalog" -> CatalogColumnStat(Some(1L), None, None, Some(14), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "p_promo_sk" -> CatalogColumnStat(Some(1000L), Some("1"), Some("1000"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "p_purpose" -> CatalogColumnStat(Some(1L), None, None, Some(13), Some(7), Some(7), None, CatalogColumnStat.VERSION),
      "p_start_date_sk" -> CatalogColumnStat(Some(577L), Some("2450100"), Some("2450915"), Some(17), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "p_channel_press" -> CatalogColumnStat(Some(1L), None, None, Some(15), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "p_channel_details" -> CatalogColumnStat(Some(990L), None, None, Some(10), Some(40), Some(60), None, CatalogColumnStat.VERSION),
      "p_response_target" -> CatalogColumnStat(Some(1L), Some("1"), Some("1"), Some(19), Some(4), Some(4), None, CatalogColumnStat.VERSION)
    )),
    "reason" -> CatalogStatistics(3630L, Some(55L), Map(
      "r_reason_sk" -> CatalogColumnStat(Some(55L), Some("1"), Some("55"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "r_reason_id" -> CatalogColumnStat(Some(55L), None, None, Some(0), Some(16), Some(16), None, CatalogColumnStat.VERSION),
      "r_reason_desc" -> CatalogColumnStat(Some(55L), None, None, Some(0), Some(14), Some(43), None, CatalogColumnStat.VERSION)
    )),
    "ship_mode" -> CatalogStatistics(2420L, Some(20L), Map(
      "sm_carrier" -> CatalogColumnStat(Some(19L), None, None, Some(0), Some(7), Some(14), None, CatalogColumnStat.VERSION),
      "sm_ship_mode_sk" -> CatalogColumnStat(Some(20L), Some("1"), Some("20"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "sm_code" -> CatalogColumnStat(Some(4L), None, None, Some(0), Some(5), Some(7), None, CatalogColumnStat.VERSION),
      "sm_type" -> CatalogColumnStat(Some(5L), None, None, Some(0), Some(8), Some(9), None, CatalogColumnStat.VERSION),
      "sm_contract" -> CatalogColumnStat(Some(18L), None, None, Some(0), Some(13), Some(20), None, CatalogColumnStat.VERSION),
      "sm_ship_mode_id" -> CatalogColumnStat(Some(20L), None, None, Some(0), Some(16), Some(16), None, CatalogColumnStat.VERSION)
    )),
    "store" -> CatalogStatistics(207432L, Some(402L), Map(
      "s_rec_end_date" -> CatalogColumnStat(Some(3L), None, None, Some(201), Some(10), Some(10), None, CatalogColumnStat.VERSION),
      "s_state" -> CatalogColumnStat(Some(9L), None, None, Some(2), Some(2), Some(2), None, CatalogColumnStat.VERSION),
      "s_street_type" -> CatalogColumnStat(Some(20L), None, None, Some(6), Some(5), Some(9), None, CatalogColumnStat.VERSION),
      "s_floor_space" -> CatalogColumnStat(Some(300L), Some("5004767"), Some("9997773"), Some(3), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "s_division_name" -> CatalogColumnStat(Some(1L), None, None, Some(5), Some(7), Some(7), None, CatalogColumnStat.VERSION),
      "s_market_desc" -> CatalogColumnStat(Some(318L), None, None, Some(5), Some(59), Some(100), None, CatalogColumnStat.VERSION),
      "s_street_name" -> CatalogColumnStat(Some(255L), None, None, Some(6), Some(9), Some(16), None, CatalogColumnStat.VERSION),
      "s_county" -> CatalogColumnStat(Some(9L), None, None, Some(4), Some(15), Some(17), None, CatalogColumnStat.VERSION),
      "s_rec_start_date" -> CatalogColumnStat(Some(4L), None, None, Some(4), Some(10), Some(10), None, CatalogColumnStat.VERSION),
      "s_company_id" -> CatalogColumnStat(Some(1L), Some("1"), Some("1"), Some(4), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "s_market_manager" -> CatalogColumnStat(Some(275L), None, None, Some(7), Some(13), Some(20), None, CatalogColumnStat.VERSION),
      "s_number_employees" -> CatalogColumnStat(Some(94L), Some("200"), Some("300"), Some(5), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "s_manager" -> CatalogColumnStat(Some(300L), None, None, Some(5), Some(13), Some(20), None, CatalogColumnStat.VERSION),
      "s_country" -> CatalogColumnStat(Some(1L), None, None, Some(4), Some(13), Some(13), None, CatalogColumnStat.VERSION),
      "s_store_name" -> CatalogColumnStat(Some(10L), None, None, Some(2), Some(4), Some(5), None, CatalogColumnStat.VERSION),
      "s_division_id" -> CatalogColumnStat(Some(1L), Some("1"), Some("1"), Some(2), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "s_street_number" -> CatalogColumnStat(Some(274L), None, None, Some(5), Some(3), Some(3), None, CatalogColumnStat.VERSION),
      "s_company_name" -> CatalogColumnStat(Some(1L), None, None, Some(3), Some(7), Some(7), None, CatalogColumnStat.VERSION),
      "s_gmt_offset" -> CatalogColumnStat(Some(2L), Some("-6.00"), Some("-5.00"), Some(4), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "s_store_sk" -> CatalogColumnStat(Some(399L), Some("1"), Some("402"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "s_city" -> CatalogColumnStat(Some(18L), None, None, Some(5), Some(10), Some(15), None, CatalogColumnStat.VERSION),
      "s_zip" -> CatalogColumnStat(Some(99L), None, None, Some(6), Some(5), Some(5), None, CatalogColumnStat.VERSION),
      "s_market_id" -> CatalogColumnStat(Some(10L), Some("1"), Some("10"), Some(6), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "s_hours" -> CatalogColumnStat(Some(3L), None, None, Some(4), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "s_suite_number" -> CatalogColumnStat(Some(75L), None, None, Some(2), Some(8), Some(9), None, CatalogColumnStat.VERSION),
      "s_closed_date_sk" -> CatalogColumnStat(Some(70L), Some("2450823"), Some("2451313"), Some(296), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "s_store_id" -> CatalogColumnStat(Some(210L), None, None, Some(0), Some(16), Some(16), None, CatalogColumnStat.VERSION),
      "s_geography_class" -> CatalogColumnStat(Some(1L), None, None, Some(3), Some(7), Some(7), None, CatalogColumnStat.VERSION),
      "s_tax_percentage" -> CatalogColumnStat(Some(12L), Some("0.00"), Some("0.11"), Some(5), Some(8), Some(8), None, CatalogColumnStat.VERSION)
    )),
    "store_returns" -> CatalogStatistics(4837573440L, Some(28795080L), Map(
      "sr_item_sk" -> CatalogColumnStat(Some(197284L), Some("1"), Some("204000"), Some(0), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_reversed_charge" -> CatalogColumnStat(Some(423824L), Some("0.00"), Some("16099.52"), Some(1009035), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_return_amt_inc_tax" -> CatalogColumnStat(Some(807709L), Some("0.00"), Some("20002.89"), Some(1006919), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_store_sk" -> CatalogColumnStat(Some(199L), Some("1"), Some("400"), Some(1007164), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_return_quantity" -> CatalogColumnStat(Some(103L), Some("1"), Some("100"), Some(1007948), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_fee" -> CatalogColumnStat(Some(9571L), Some("0.50"), Some("100.00"), Some(1008291), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_refunded_cash" -> CatalogColumnStat(Some(559685L), Some("0.00"), Some("17556.95"), Some(1008003), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_return_time_sk" -> CatalogColumnStat(Some(31932L), Some("28799"), Some("61199"), Some(1009330), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_addr_sk" -> CatalogColumnStat(Some(925738L), Some("1"), Some("1000000"), Some(1008253), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_return_amt" -> CatalogColumnStat(Some(492928L), Some("0.00"), Some("18973.20"), Some(1007419), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_returned_date_sk" -> CatalogColumnStat(Some(2010L), Some("2450820"), Some("2452822"), Some(1007464), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_return_tax" -> CatalogColumnStat(Some(86618L), Some("0.00"), Some("1611.71"), Some(1008618), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_return_ship_cost" -> CatalogColumnStat(Some(290195L), Some("0.00"), Some("9578.25"), Some(1007846), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_reason_sk" -> CatalogColumnStat(Some(57L), Some("1"), Some("55"), Some(1008299), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_net_loss" -> CatalogColumnStat(Some(487073L), Some("0.50"), Some("10447.72"), Some(1007153), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_cdemo_sk" -> CatalogColumnStat(Some(1807132L), Some("1"), Some("1920800"), Some(1006835), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_hdemo_sk" -> CatalogColumnStat(Some(6609L), Some("1"), Some("7200"), Some(1008547), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_store_credit" -> CatalogColumnStat(Some(410133L), Some("0.00"), Some("15642.11"), Some(1007102), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_customer_sk" -> CatalogColumnStat(Some(1860981L), Some("1"), Some("2000000"), Some(1008429), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "sr_ticket_number" -> CatalogColumnStat(Some(15853105L), Some("1"), Some("23999996"), Some(0), Some(8), Some(8), None, CatalogColumnStat.VERSION)
    )),
    "time_dim" -> CatalogStatistics(10886400L, Some(86400L), Map(
      "t_sub_shift" -> CatalogColumnStat(Some(4L), None, None, Some(0), Some(7), Some(9), None, CatalogColumnStat.VERSION),
      "t_time" -> CatalogColumnStat(Some(83505L), Some("0"), Some("86399"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "t_second" -> CatalogColumnStat(Some(60L), Some("0"), Some("59"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "t_hour" -> CatalogColumnStat(Some(25L), Some("0"), Some("23"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "t_am_pm" -> CatalogColumnStat(Some(2L), None, None, Some(0), Some(2), Some(2), None, CatalogColumnStat.VERSION),
      "t_minute" -> CatalogColumnStat(Some(60L), Some("0"), Some("59"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "t_shift" -> CatalogColumnStat(Some(3L), None, None, Some(0), Some(6), Some(6), None, CatalogColumnStat.VERSION),
      "t_time_id" -> CatalogColumnStat(Some(80197L), None, None, Some(0), Some(16), Some(16), None, CatalogColumnStat.VERSION),
      "t_time_sk" -> CatalogColumnStat(Some(83505L), Some("0"), Some("86399"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "t_meal_time" -> CatalogColumnStat(Some(3L), None, None, Some(50400), Some(7), Some(9), None, CatalogColumnStat.VERSION)
    )),
    "warehouse" -> CatalogStatistics(3855L, Some(15L), Map(
      "w_state" -> CatalogColumnStat(Some(8L), None, None, Some(0), Some(2), Some(2), None, CatalogColumnStat.VERSION),
      "w_street_name" -> CatalogColumnStat(Some(14L), None, None, Some(1), Some(10), Some(14), None, CatalogColumnStat.VERSION),
      "w_warehouse_name" -> CatalogColumnStat(Some(14L), None, None, Some(1), Some(17), Some(20), None, CatalogColumnStat.VERSION),
      "w_county" -> CatalogColumnStat(Some(8L), None, None, Some(0), Some(14), Some(16), None, CatalogColumnStat.VERSION),
      "w_street_number" -> CatalogColumnStat(Some(14L), None, None, Some(1), Some(3), Some(3), None, CatalogColumnStat.VERSION),
      "w_warehouse_sq_ft" -> CatalogColumnStat(Some(14L), Some("73065"), Some("977787"), Some(1), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "w_city" -> CatalogColumnStat(Some(11L), None, None, Some(0), Some(8), Some(13), None, CatalogColumnStat.VERSION),
      "w_warehouse_sk" -> CatalogColumnStat(Some(15L), Some("1"), Some("15"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "w_suite_number" -> CatalogColumnStat(Some(13L), None, None, Some(1), Some(8), Some(9), None, CatalogColumnStat.VERSION),
      "w_zip" -> CatalogColumnStat(Some(14L), None, None, Some(0), Some(5), Some(5), None, CatalogColumnStat.VERSION),
      "w_gmt_offset" -> CatalogColumnStat(Some(2L), Some("-6.00"), Some("-5.00"), Some(1), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "w_street_type" -> CatalogColumnStat(Some(10L), None, None, Some(1), Some(5), Some(7), None, CatalogColumnStat.VERSION),
      "w_warehouse_id" -> CatalogColumnStat(Some(15L), None, None, Some(0), Some(16), Some(16), None, CatalogColumnStat.VERSION),
      "w_country" -> CatalogColumnStat(Some(1L), None, None, Some(0), Some(13), Some(13), None, CatalogColumnStat.VERSION)
    )),
    "web_page" -> CatalogStatistics(281520L, Some(2040L), Map(
      "wp_type" -> CatalogColumnStat(Some(7L), None, None, Some(19), Some(7), Some(9), None, CatalogColumnStat.VERSION),
      "wp_autogen_flag" -> CatalogColumnStat(Some(2L), None, None, Some(25), Some(1), Some(1), None, CatalogColumnStat.VERSION),
      "wp_url" -> CatalogColumnStat(Some(1L), None, None, Some(25), Some(18), Some(18), None, CatalogColumnStat.VERSION),
      "wp_image_count" -> CatalogColumnStat(Some(7L), Some("1"), Some("7"), Some(20), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "wp_max_ad_count" -> CatalogColumnStat(Some(5L), Some("0"), Some("4"), Some(21), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "wp_customer_sk" -> CatalogColumnStat(Some(486L), Some("711"), Some("1996257"), Some(1471), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "wp_rec_end_date" -> CatalogColumnStat(Some(3L), Some("1999-09-03"), Some("2001-09-02"), Some(1020), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "wp_creation_date_sk" -> CatalogColumnStat(Some(121L), Some("2450672"), Some("2450815"), Some(20), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "wp_link_count" -> CatalogColumnStat(Some(25L), Some("2"), Some("25"), Some(16), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "wp_web_page_id" -> CatalogColumnStat(Some(1004L), None, None, Some(0), Some(16), Some(16), None, CatalogColumnStat.VERSION),
      "wp_web_page_sk" -> CatalogColumnStat(Some(2040L), Some("1"), Some("2040"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "wp_rec_start_date" -> CatalogColumnStat(Some(4L), Some("1997-09-03"), Some("2001-09-03"), Some(21), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "wp_access_date_sk" -> CatalogColumnStat(Some(100L), Some("2452548"), Some("2452648"), Some(19), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "wp_char_count" -> CatalogColumnStat(Some(1493L), Some("303"), Some("8523"), Some(25), Some(4), Some(4), None, CatalogColumnStat.VERSION)
    )),
    "web_returns" -> CatalogStatistics(1439534000L, Some(7197670L), Map(
      "wr_returning_addr_sk" -> CatalogColumnStat(Some(925738L), Some("1"), Some("1000000"), Some(323850), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_reversed_charge" -> CatalogColumnStat(Some(346909L), Some("0.00"), Some("22972.36"), Some(323810), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_returned_date_sk" -> CatalogColumnStat(Some(2189L), Some("2450820"), Some("2453002"), Some(324185), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_order_number" -> CatalogColumnStat(Some(4098425L), Some("1"), Some("5999999"), Some(0), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_fee" -> CatalogColumnStat(Some(9571L), Some("0.50"), Some("100.00"), Some(324065), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_account_credit" -> CatalogColumnStat(Some(334119L), Some("0.00"), Some("23028.27"), Some(324422), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_refunded_customer_sk" -> CatalogColumnStat(Some(1808850L), Some("1"), Some("2000000"), Some(324191), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_returning_customer_sk" -> CatalogColumnStat(Some(1813094L), Some("1"), Some("2000000"), Some(324024), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_return_tax" -> CatalogColumnStat(Some(88469L), Some("0.00"), Some("2551.16"), Some(323621), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_web_page_sk" -> CatalogColumnStat(Some(1994L), Some("1"), Some("2040"), Some(324900), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_item_sk" -> CatalogColumnStat(Some(197284L), Some("1"), Some("204000"), Some(0), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_reason_sk" -> CatalogColumnStat(Some(57L), Some("1"), Some("55"), Some(323666), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_return_amt_inc_tax" -> CatalogColumnStat(Some(683544L), Some("0.00"), Some("29493.38"), Some(323171), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_net_loss" -> CatalogColumnStat(Some(494707L), Some("0.50"), Some("15068.96"), Some(324438), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_refunded_cdemo_sk" -> CatalogColumnStat(Some(1755065L), Some("1"), Some("1920800"), Some(323863), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_returned_time_sk" -> CatalogColumnStat(Some(84232L), Some("0"), Some("86399"), Some(323677), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_return_amt" -> CatalogColumnStat(Some(453015L), Some("0.00"), Some("28346.31"), Some(323473), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_returning_cdemo_sk" -> CatalogColumnStat(Some(1755065L), Some("1"), Some("1920800"), Some(323899), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_returning_hdemo_sk" -> CatalogColumnStat(Some(6609L), Some("1"), Some("7200"), Some(323999), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_refunded_cash" -> CatalogColumnStat(Some(484316L), Some("0.00"), Some("26466.56"), Some(324693), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_refunded_hdemo_sk" -> CatalogColumnStat(Some(6609L), Some("1"), Some("7200"), Some(324230), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_return_quantity" -> CatalogColumnStat(Some(103L), Some("1"), Some("100"), Some(323764), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_return_ship_cost" -> CatalogColumnStat(Some(302038L), Some("0.00"), Some("13602.60"), Some(323341), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "wr_refunded_addr_sk" -> CatalogColumnStat(Some(925738L), Some("1"), Some("1000000"), Some(324482), Some(8), Some(8), None, CatalogColumnStat.VERSION)
    )),
    "web_site" -> CatalogStatistics(11760L, Some(24L), Map(
      "web_rec_end_date" -> CatalogColumnStat(Some(3L), Some("1999-08-16"), Some("2001-08-15"), Some(12), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "web_market_manager" -> CatalogColumnStat(Some(21L), None, None, Some(0), Some(13), Some(15), None, CatalogColumnStat.VERSION),
      "web_country" -> CatalogColumnStat(Some(1L), None, None, Some(0), Some(13), Some(13), None, CatalogColumnStat.VERSION),
      "web_street_name" -> CatalogColumnStat(Some(24L), None, None, Some(0), Some(10), Some(14), None, CatalogColumnStat.VERSION),
      "web_city" -> CatalogColumnStat(Some(11L), None, None, Some(0), Some(10), Some(15), None, CatalogColumnStat.VERSION),
      "web_mkt_id" -> CatalogColumnStat(Some(6L), Some("1"), Some("6"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "web_close_date_sk" -> CatalogColumnStat(Some(8L), Some("2443328"), Some("2447131"), Some(4), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "web_street_number" -> CatalogColumnStat(Some(14L), None, None, Some(0), Some(3), Some(3), None, CatalogColumnStat.VERSION),
      "web_gmt_offset" -> CatalogColumnStat(Some(2L), None, None, Some(0), Some(2), Some(2), None, CatalogColumnStat.VERSION),
      "web_rec_start_date" -> CatalogColumnStat(Some(4L), Some("1997-08-16"), Some("2001-08-16"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "web_mkt_class" -> CatalogColumnStat(Some(17L), None, None, Some(0), Some(32), Some(47), None, CatalogColumnStat.VERSION),
      "web_county" -> CatalogColumnStat(Some(9L), None, None, Some(0), Some(14), Some(17), None, CatalogColumnStat.VERSION),
      "web_class" -> CatalogColumnStat(Some(1L), None, None, Some(0), Some(7), Some(7), None, CatalogColumnStat.VERSION),
      "web_site_sk" -> CatalogColumnStat(Some(24L), Some("1"), Some("24"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "web_manager" -> CatalogColumnStat(Some(19L), None, None, Some(0), Some(13), Some(16), None, CatalogColumnStat.VERSION),
      "web_suite_number" -> CatalogColumnStat(Some(20L), None, None, Some(0), Some(9), Some(9), None, CatalogColumnStat.VERSION),
      "web_site_id" -> CatalogColumnStat(Some(12L), None, None, Some(0), Some(16), Some(16), None, CatalogColumnStat.VERSION),
      "web_company_name" -> CatalogColumnStat(Some(6L), None, None, Some(0), Some(5), Some(5), None, CatalogColumnStat.VERSION),
      "web_state" -> CatalogColumnStat(Some(9L), None, None, Some(0), Some(2), Some(2), None, CatalogColumnStat.VERSION),
      "web_mkt_desc" -> CatalogColumnStat(Some(15L), None, None, Some(0), Some(66), Some(92), None, CatalogColumnStat.VERSION),
      "web_name" -> CatalogColumnStat(Some(4L), None, None, Some(0), Some(6), Some(6), None, CatalogColumnStat.VERSION),
      "web_company_id" -> CatalogColumnStat(Some(6L), Some("1"), Some("6"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "web_street_type" -> CatalogColumnStat(Some(15L), None, None, Some(0), Some(4), Some(9), None, CatalogColumnStat.VERSION),
      "web_open_date_sk" -> CatalogColumnStat(Some(12L), Some("2450628"), Some("2450807"), Some(0), Some(4), Some(4), None, CatalogColumnStat.VERSION),
      "web_tax_percentage" -> CatalogColumnStat(Some(8L), Some("0.00"), Some("0.12"), Some(0), Some(8), Some(8), None, CatalogColumnStat.VERSION),
      "web_zip" -> CatalogColumnStat(Some(14L), None, None, Some(0), Some(5), Some(5), None, CatalogColumnStat.VERSION)
    ))
  )
  // scalastyle:on line.size.limit
}
