/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.util.Arrays;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.MutableRoaringArray;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class CopyOnWriteRoaringBitmap
extends MutableRoaringBitmap {
    private boolean[] needsCopy = new boolean[4];
    private boolean copyOnWrite = true;

    public static CopyOnWriteRoaringBitmap fromImmutable(ImmutableRoaringBitmap immutable) {
        CopyOnWriteRoaringBitmap result = new CopyOnWriteRoaringBitmap();
        MappeableContainerPointer mcp = immutable.highLowContainer.getContainerPointer();
        while (mcp.hasContainer()) {
            result.getMappeableRoaringArray().appendCopyOnWrite(mcp.key(), mcp.getContainer());
            mcp.advance();
        }
        result.needsCopy = new boolean[result.getMappeableRoaringArray().size];
        Arrays.fill(result.needsCopy, true);
        return result;
    }

    private void ensureContainerCopied(int index) {
        if (this.copyOnWrite && index < this.needsCopy.length && this.needsCopy[index]) {
            MutableRoaringArray array = this.getMappeableRoaringArray();
            array.setContainerAtIndex(index, array.getContainerAtIndex(index).clone());
            this.needsCopy[index] = false;
        }
    }

    private void ensureAllContainersCopied() {
        if (this.copyOnWrite) {
            MutableRoaringArray array = this.getMappeableRoaringArray();
            for (int i = 0; i < array.size && i < this.needsCopy.length; ++i) {
                if (!this.needsCopy[i]) continue;
                array.setContainerAtIndex(i, array.getContainerAtIndex(i).clone());
                this.needsCopy[i] = false;
            }
        }
    }

    private void extendNeedsCopyArray(int minSize) {
        if (this.needsCopy.length < minSize) {
            boolean[] newArray = new boolean[Math.max(minSize, this.needsCopy.length * 2)];
            System.arraycopy(this.needsCopy, 0, newArray, 0, this.needsCopy.length);
            this.needsCopy = newArray;
        }
    }

    @Override
    public void add(int x) {
        if (this.copyOnWrite) {
            char hb = (char)(x >>> 16);
            MutableRoaringArray array = this.getMappeableRoaringArray();
            int index = array.getIndex(hb);
            if (index >= 0) {
                this.ensureContainerCopied(index);
            }
        }
        super.add(x);
    }

    @Override
    public void remove(int x) {
        if (this.copyOnWrite) {
            char hb = (char)(x >>> 16);
            MutableRoaringArray array = this.getMappeableRoaringArray();
            int index = array.getIndex(hb);
            if (index >= 0) {
                this.ensureContainerCopied(index);
            }
        }
        super.remove(x);
    }

    @Override
    public void flip(int x) {
        if (this.copyOnWrite) {
            char hb = (char)(x >>> 16);
            MutableRoaringArray array = this.getMappeableRoaringArray();
            int index = array.getIndex(hb);
            if (index >= 0) {
                this.ensureContainerCopied(index);
            }
        }
        super.flip(x);
    }

    @Override
    public void or(ImmutableRoaringBitmap x2) {
        if (this.copyOnWrite) {
            this.ensureAllContainersCopied();
            this.copyOnWrite = false;
        }
        super.or(x2);
    }

    @Override
    public void and(ImmutableRoaringBitmap x2) {
        if (this.copyOnWrite) {
            this.ensureAllContainersCopied();
            this.copyOnWrite = false;
        }
        super.and(x2);
    }

    @Override
    public void xor(ImmutableRoaringBitmap x2) {
        if (this.copyOnWrite) {
            this.ensureAllContainersCopied();
            this.copyOnWrite = false;
        }
        super.xor(x2);
    }

    @Override
    public void andNot(ImmutableRoaringBitmap x2) {
        if (this.copyOnWrite) {
            this.ensureAllContainersCopied();
            this.copyOnWrite = false;
        }
        super.andNot(x2);
    }

    @Override
    public CopyOnWriteRoaringBitmap clone() {
        CopyOnWriteRoaringBitmap result = new CopyOnWriteRoaringBitmap();
        result.copyOnWrite = this.copyOnWrite;
        if (this.copyOnWrite) {
            result.highLowContainer = this.highLowContainer.clone();
            result.needsCopy = (boolean[])this.needsCopy.clone();
        } else {
            result.highLowContainer = this.highLowContainer.clone();
            result.copyOnWrite = false;
        }
        return result;
    }
}

