/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.streampark.common.conf.CommonConfig$;
import org.apache.streampark.common.conf.ConfigConst$;
import org.apache.streampark.common.conf.InternalConfigHolder$;
import org.apache.streampark.common.util.ClassLoaderUtils$;
import org.apache.streampark.common.util.DateUtils$;
import org.apache.streampark.common.util.FileUtils$;
import org.apache.streampark.common.util.HadoopConfigUtils$;
import org.apache.streampark.common.util.HadoopUtils;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Logger$class;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class HadoopUtils$
implements Logger {
    public static final HadoopUtils$ MODULE$;
    private String HADOOP_HOME;
    private String org$apache$streampark$common$util$HadoopUtils$$HADOOP_CONF_DIR;
    private String CONF_SUFFIX;
    private YarnClient reusableYarnClient;
    private UserGroupInformation ugi;
    public Configuration org$apache$streampark$common$util$HadoopUtils$$reusableConf;
    public FileSystem org$apache$streampark$common$util$HadoopUtils$$reusableHdfs;
    private KerberosTicket tgt;
    private Map<String, Configuration> configurationCache;
    private String org$apache$streampark$common$util$HadoopUtils$$hadoopConfDir;
    private long org$apache$streampark$common$util$HadoopUtils$$tgtRefreshTime;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile byte bitmap$0;

    static {
        new HadoopUtils$();
    }

    private String HADOOP_HOME$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.HADOOP_HOME = "HADOOP_HOME";
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.HADOOP_HOME;
        }
    }

    private String org$apache$streampark$common$util$HadoopUtils$$HADOOP_CONF_DIR$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$streampark$common$util$HadoopUtils$$HADOOP_CONF_DIR = "HADOOP_CONF_DIR";
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.org$apache$streampark$common$util$HadoopUtils$$HADOOP_CONF_DIR;
        }
    }

    private String CONF_SUFFIX$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.CONF_SUFFIX = "/etc/hadoop";
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.CONF_SUFFIX;
        }
    }

    private Map configurationCache$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.configurationCache = new ConcurrentHashMap<String, Configuration>();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.configurationCache;
        }
    }

    private String org$apache$streampark$common$util$HadoopUtils$$hadoopConfDir$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                String string;
                Try try_ = Try$.MODULE$.apply((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return FileUtils$.MODULE$.getPathFromEnv(HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$HADOOP_CONF_DIR());
                    }
                });
                if (try_ instanceof Failure) {
                    string = FileUtils$.MODULE$.resolvePath(FileUtils$.MODULE$.getPathFromEnv(this.HADOOP_HOME()), this.CONF_SUFFIX());
                } else {
                    String value;
                    if (!(try_ instanceof Success)) {
                        throw new MatchError((Object)try_);
                    }
                    Success success = (Success)try_;
                    string = value = (String)success.value();
                }
                this.org$apache$streampark$common$util$HadoopUtils$$hadoopConfDir = string;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.org$apache$streampark$common$util$HadoopUtils$$hadoopConfDir;
        }
    }

    private long org$apache$streampark$common$util$HadoopUtils$$tgtRefreshTime$lzycompute() {
        HadoopUtils$ hadoopUtils$ = this;
        synchronized (hadoopUtils$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                long l;
                UserGroupInformation user = UserGroupInformation.getLoginUser();
                Method method = UserGroupInformation.class.getDeclaredMethod("getTGT", new Class[0]);
                method.setAccessible(true);
                this.tgt = (KerberosTicket)method.invoke((Object)user, new Object[0]);
                Option option = Option$.MODULE$.apply((Object)this.tgt);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    KerberosTicket value = (KerberosTicket)some.x();
                    long start = value.getStartTime().getTime();
                    long end = value.getEndTime().getTime();
                    l = (long)((double)(end - start) * (double)0.9f);
                } else {
                    long l2;
                    this.logWarn((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "get kerberos tgtRefreshTime failed, try get kerberos.ttl. ";
                        }
                    });
                    Tuple2<Object, TimeUnit> timeUnit = DateUtils$.MODULE$.getTimeUnit((String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.KERBEROS_TTL()), DateUtils$.MODULE$.getTimeUnit$default$2());
                    TimeUnit timeUnit2 = (TimeUnit)((Object)timeUnit._2());
                    if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit2)) {
                        l2 = timeUnit._1$mcI$sp() * 1000;
                    } else if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit2)) {
                        l2 = timeUnit._1$mcI$sp() * 60 * 1000;
                    } else if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit2)) {
                        l2 = timeUnit._1$mcI$sp() * 60 * 60 * 1000;
                    } else {
                        if (!((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit2)) {
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] parameter:", " invalided, unit options are [s|m|h|d]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CommonConfig$.MODULE$.KERBEROS_TTL().key()})));
                        }
                        l2 = timeUnit._1$mcI$sp() * 60 * 60 * 24 * 1000;
                    }
                    l = l2;
                }
                this.org$apache$streampark$common$util$HadoopUtils$$tgtRefreshTime = l;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            return this.org$apache$streampark$common$util$HadoopUtils$$tgtRefreshTime;
        }
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    @Override
    public String logName() {
        return Logger$class.logName(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger$class.logger(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger$class.logInfo(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger$class.logDebug(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger$class.logTrace(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger$class.logWarn(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger$class.logWarn(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger$class.logError(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger$class.isTraceEnabled(this);
    }

    private String HADOOP_HOME() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.HADOOP_HOME$lzycompute() : this.HADOOP_HOME;
    }

    public String org$apache$streampark$common$util$HadoopUtils$$HADOOP_CONF_DIR() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$streampark$common$util$HadoopUtils$$HADOOP_CONF_DIR$lzycompute() : this.org$apache$streampark$common$util$HadoopUtils$$HADOOP_CONF_DIR;
    }

    private String CONF_SUFFIX() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.CONF_SUFFIX$lzycompute() : this.CONF_SUFFIX;
    }

    private Map<String, Configuration> configurationCache() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.configurationCache$lzycompute() : this.configurationCache;
    }

    public UserGroupInformation getUgi() {
        if (this.ugi == null) {
            this.ugi = HadoopConfigUtils$.MODULE$.kerberosEnable() ? this.getKerberosUGI() : UserGroupInformation.createRemoteUser((String)HadoopConfigUtils$.MODULE$.hadoopUserName());
        }
        return this.ugi;
    }

    public String org$apache$streampark$common$util$HadoopUtils$$hadoopConfDir() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.org$apache$streampark$common$util$HadoopUtils$$hadoopConfDir$lzycompute() : this.org$apache$streampark$common$util$HadoopUtils$$hadoopConfDir;
    }

    public long org$apache$streampark$common$util$HadoopUtils$$tgtRefreshTime() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.org$apache$streampark$common$util$HadoopUtils$$tgtRefreshTime$lzycompute() : this.org$apache$streampark$common$util$HadoopUtils$$tgtRefreshTime;
    }

    public Configuration getConfigurationFromHadoopConfDir(String confDir) {
        BoxedUnit boxedUnit;
        if (this.configurationCache().containsKey(confDir)) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            FileUtils$.MODULE$.exists(confDir);
            File hadoopConfDir = new File(confDir);
            List confName = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs-default.xml", "core-site.xml", "hdfs-site.xml", "yarn-site.xml"}));
            List files = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])hadoopConfDir.listFiles()).filter((Function1)new Serializable(confName){
                public static final long serialVersionUID = 0L;
                private final List confName$1;

                public final boolean apply(File x) {
                    return x.isFile() && this.confName$1.contains((Object)x.getName());
                }
                {
                    this.confName$1 = confName$1;
                }
            })).toList();
            HadoopUtils.HadoopConfiguration conf = new HadoopUtils.HadoopConfiguration();
            if (CollectionUtils.isNotEmpty((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)files))) {
                files.foreach((Function1)new Serializable(conf){
                    public static final long serialVersionUID = 0L;
                    private final HadoopUtils.HadoopConfiguration conf$1;

                    public final void apply(File x) {
                        this.conf$1.addResource(new Path(x.getAbsolutePath()));
                    }
                    {
                        this.conf$1 = conf$1;
                    }
                });
            }
            boxedUnit = this.configurationCache().put(confDir, conf);
        }
        return (Configuration)JavaConversions$.MODULE$.mapAsScalaMap(this.configurationCache()).apply((Object)confDir);
    }

    public String getConfigurationFromHadoopConfDir$default$1() {
        return this.org$apache$streampark$common$util$HadoopUtils$$hadoopConfDir();
    }

    public Configuration hadoopConf() {
        return (Configuration)Option$.MODULE$.apply((Object)this.org$apache$streampark$common$util$HadoopUtils$$reusableConf).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Configuration apply() {
                HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$reusableConf = HadoopUtils$.MODULE$.getConfigurationFromHadoopConfDir(HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$hadoopConfDir());
                ClassLoaderUtils$.MODULE$.loadResource(HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$hadoopConfDir());
                if (StringUtils.isBlank((CharSequence)HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$reusableConf.get("hadoop.tmp.dir"))) {
                    HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$reusableConf.set("hadoop.tmp.dir", "/tmp");
                }
                if (StringUtils.isBlank((CharSequence)HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$reusableConf.get("hbase.fs.tmp.dir"))) {
                    HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$reusableConf.set("hbase.fs.tmp.dir", "/tmp");
                }
                HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$reusableConf.set("yarn.timeline-service.enabled", "false");
                HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$reusableConf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
                HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$reusableConf.set("fs.file.impl", LocalFileSystem.class.getName());
                HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$reusableConf.set("fs.hdfs.impl.disable.cache", "true");
                return HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$reusableConf;
            }
        });
    }

    public void org$apache$streampark$common$util$HadoopUtils$$closeHadoop() {
        if (this.org$apache$streampark$common$util$HadoopUtils$$reusableHdfs != null) {
            this.org$apache$streampark$common$util$HadoopUtils$$reusableHdfs.close();
            this.org$apache$streampark$common$util$HadoopUtils$$reusableHdfs = null;
        }
        if (this.reusableYarnClient != null) {
            this.reusableYarnClient.close();
            this.reusableYarnClient = null;
        }
        if (this.tgt != null && !this.tgt.isDestroyed()) {
            this.tgt.destroy();
            this.tgt = null;
        }
        this.org$apache$streampark$common$util$HadoopUtils$$reusableConf = null;
        this.ugi = null;
    }

    private UserGroupInformation getKerberosUGI() {
        Object object;
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "kerberos login starting....";
            }
        });
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(HadoopConfigUtils$.MODULE$.kerberosPrincipal())).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(HadoopConfigUtils$.MODULE$.kerberosKeytab())).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " and ", " must not be empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_PRINCIPAL(), ConfigConst$.MODULE$.KEY_SECURITY_KERBEROS_KEYTAB()}));
            }
        });
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        if (new StringOps(Predef$.MODULE$.augmentString(HadoopConfigUtils$.MODULE$.kerberosKrb5())).nonEmpty()) {
            System.setProperty("java.security.krb5.conf", HadoopConfigUtils$.MODULE$.kerberosKrb5());
            object = System.setProperty("java.security.krb5.conf.path", HadoopConfigUtils$.MODULE$.kerberosKrb5());
        } else {
            object = BoxedUnit.UNIT;
        }
        System.setProperty("sun.security.spnego.debug", HadoopConfigUtils$.MODULE$.kerberosDebug());
        System.setProperty("sun.security.krb5.debug", HadoopConfigUtils$.MODULE$.kerberosDebug());
        this.hadoopConf().set(ConfigConst$.MODULE$.KEY_HADOOP_SECURITY_AUTHENTICATION(), ConfigConst$.MODULE$.KEY_KERBEROS());
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final UserGroupInformation apply() {
                void var1_1;
                UserGroupInformation.setConfiguration((Configuration)HadoopUtils$.MODULE$.hadoopConf());
                UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)HadoopConfigUtils$.MODULE$.kerberosPrincipal(), (String)HadoopConfigUtils$.MODULE$.kerberosKeytab());
                UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
                HadoopUtils$.MODULE$.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "kerberos authentication successful";
                    }
                });
                return var1_1;
            }
        });
        if (try_ instanceof Success) {
            UserGroupInformation ugi;
            Success success = (Success)try_;
            UserGroupInformation userGroupInformation = ugi = (UserGroupInformation)success.value();
            return userGroupInformation;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public FileSystem hdfs() {
        return (FileSystem)Option$.MODULE$.apply((Object)this.org$apache$streampark$common$util$HadoopUtils$$reusableHdfs).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FileSystem apply() {
                Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FileSystem apply() {
                        return (FileSystem)HadoopUtils$.MODULE$.getUgi().doAs((PrivilegedAction)new PrivilegedAction<FileSystem>(this){

                            public FileSystem run() {
                                return FileSystem.get((Configuration)HadoopUtils$.MODULE$.hadoopConf());
                            }
                        });
                    }
                });
                if (try_ instanceof Success) {
                    FileSystem fileSystem;
                    Success success = (Success)try_;
                    FileSystem fs = (FileSystem)success.value();
                    if (HadoopConfigUtils$.MODULE$.kerberosEnable()) {
                        Timer timer = new Timer();
                        timer.schedule(new TimerTask(this){

                            public void run() {
                                HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$closeHadoop();
                                HadoopUtils$.MODULE$.logInfo((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check Kerberos Tgt And reLogin From Keytab Finish:refresh time: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DateUtils$.MODULE$.format(DateUtils$.MODULE$.format$default$1(), DateUtils$.MODULE$.format$default$2(), DateUtils$.MODULE$.format$default$3())}));
                                    }
                                });
                            }
                        }, HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$tgtRefreshTime(), HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$tgtRefreshTime());
                    }
                    HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$reusableHdfs = fileSystem = fs;
                    return HadoopUtils$.MODULE$.org$apache$streampark$common$util$HadoopUtils$$reusableHdfs;
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] access hdfs error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e})));
                }
                throw new MatchError((Object)try_);
            }
        });
    }

    public YarnClient yarnClient() {
        if (this.reusableYarnClient == null || !this.reusableYarnClient.isInState(Service.STATE.STARTED)) {
            this.reusableYarnClient = YarnClient.createYarnClient();
            YarnConfiguration yarnConf = new YarnConfiguration(this.hadoopConf());
            this.reusableYarnClient.init((Configuration)yarnConf);
            this.reusableYarnClient.start();
        }
        return this.reusableYarnClient;
    }

    public ApplicationId toApplicationId(String appId) {
        Predef$.MODULE$.require(appId != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "[StreamPark] HadoopUtils.toApplicationId: applicationId muse not be null";
            }
        });
        String[] timestampAndId = appId.split("_");
        return ApplicationId.newInstance((long)new StringOps(Predef$.MODULE$.augmentString(timestampAndId[1])).toLong(), (int)new StringOps(Predef$.MODULE$.augmentString((String)Predef$.MODULE$.refArrayOps((Object[])timestampAndId).last())).toInt());
    }

    public String downloadJar(String jarOnHdfs) throws IOException {
        Path sourcePath;
        File tmpDir = FileUtils$.MODULE$.createTempDir();
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        if (fs.exists(sourcePath = fs.makeQualified(new Path(jarOnHdfs)))) {
            Path destPath = new Path(new StringBuilder().append((Object)tmpDir.getAbsolutePath()).append((Object)"/").append((Object)sourcePath.getName()).toString());
            fs.copyToLocalFile(sourcePath, destPath);
            return new File(destPath.toString()).getAbsolutePath();
        }
        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jar file: ", " doesn't exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jarOnHdfs})));
    }

    private HadoopUtils$() {
        MODULE$ = this;
        Logger$class.$init$(this);
    }
}

