// Copyright (c) 2023 Yuki Kimoto
// MIT License

#include "spvm_native.h"

#include <openssl/ssl.h>
#include <openssl/err.h>

static const char* FILE_NAME = "Net/SSLeay/ERR.c";

int32_t SPVM__Net__SSLeay__ERR__error_string_n(SPVM_ENV* env, SPVM_VALUE* stack) {
  
  int32_t error_id = 0;
  
  int64_t e = stack[0].lval;
  
  void* obj_buf = stack[1].oval;
  
  if (!obj_buf) {
    return env->die(env, stack, "The buffer $buf must be defined.", __func__, FILE_NAME, __LINE__);
  }
  
  char* buf = (char*)env->get_chars(env, stack, obj_buf);
  int32_t buf_length = env->length(env, stack, obj_buf);
  
  int32_t len = stack[2].ival;
  
  if (len < 0) {
    len = buf_length;
  }
  
  if (!(len <= buf_length)) {
    return env->die(env, stack, "The length $len must be less than or equal to the length of the buffer $buf.", __func__, FILE_NAME, __LINE__);
  }
  
  ERR_error_string_n(e, buf, len);
  
  return 0;
}

int32_t SPVM__Net__SSLeay__ERR__get_error(SPVM_ENV* env, SPVM_VALUE* stack) {
  
  int64_t error = ERR_get_error();
  
  stack[0].lval = error;
  
  return 0;
}

int32_t SPVM__Net__SSLeay__ERR__peek_error(SPVM_ENV* env, SPVM_VALUE* stack) {
  
  int64_t error = ERR_peek_error();
  
  stack[0].lval = error;
  
  return 0;
}

int32_t SPVM__Net__SSLeay__ERR__peek_last_error(SPVM_ENV* env, SPVM_VALUE* stack) {
  
  int64_t error = ERR_peek_last_error();
  
  stack[0].lval = error;
  
  return 0;
}
