#!/usr/bin/perl

use strict;
use warnings;
no  warnings 'syntax';

use Regexp::Common;
use Test::More;
use t::zip::Zip;

my $r = eval "require Test::Regexp; 1";

unless ($r) {
    print "1..0 # SKIP Test::Regexp not found\n";
    exit;
}


test_zips country         =>  "Norway",
          name            =>  "Norwegian zip codes",
          prefix          => {
              iso         =>  "NO",
              cept        =>  "N",
              invalid     =>  "SE",
          },
          prefix_test_set => [3331, 6996],
;


done_testing;


sub valid_zip_codes {
    map {sprintf "%04d" => $_}  # Add leading 0s

       1,     10,     15,     18,     21,             24 ..   26,
      28,             30 ..   34,     37,     40,     45 ..   48,
      50 ..   51,     55,     60,     80,            101 ..  107,
     109 ..  125,    128 ..  139,    150 ..  155,    157 ..  162,
     164 ..  188,    190 ..  196,    198,            201 ..  204,
     207 ..  208,    211 ..  218,    230,    240,    244,    247,
     250 ..  260,    262 ..  268,    270 ..  284,    286 ..  287,
     301 ..  309,    311,            313 ..  319,    323,    330,
     340,            349 ..  383,    401 ..  406,    408 ..  413,
     415,            421 ..  424,    440 ..  442,    445,
     450 ..  452,    454 ..  465,    467 ..  470,    472 ..  496,
     501 ..  513,    515 ..  518,    520,    540,    550 ..  598,
     601 ..  609,    611 ..  624,    626,            650 ..  694,
     701 ..  702,    705,    710,    712,            750 ..  758,
     760,            763 ..  768,    770 ..  779,    781 ..  791,
     801,            805 ..  807,    840,            850 ..  858,
     860 ..  864,    870 ..  877,    880 ..  884,    890 ..  891,
     901 ..  905,    907 ..  908,    913 ..  915,    950 ..  960,
     962 ..  964,    968 ..  973,    975 ..  988,

    1001,   1003,   1005 .. 1009,   1011,           1051 .. 1056,
    1061 .. 1065,   1067 .. 1069,   1071,   1081,   1083 .. 1084,
    1086 .. 1089,   1101 .. 1102,   1109,   1112,   1150 .. 1158,
    1160 .. 1170,   1172,           1176 .. 1179,   1181 .. 1182,
    1184 .. 1185,   1187 .. 1189,   1201 .. 1205,   1207,
    1214 .. 1215,   1250 .. 1259,   1262 .. 1263,   1266,
    1270 .. 1275,   1278 .. 1279,   1281,           1283 .. 1286,
    1290 .. 1291,   1294 .. 1295,   1300 .. 1307,   1309,
    1311 .. 1314,   1316 .. 1319,   1321 .. 1342,   1344,   1346,
    1348 .. 1354,   1356 .. 1369,   1371 .. 1373,   1375 .. 1381,
    1383 .. 1397,   1399 .. 1421,   1429 .. 1432,   1440 .. 1451,
    1453 .. 1455,   1457 .. 1458,   1468 .. 1488,   1501 .. 1504,
    1506,           1508 .. 1526,   1528 .. 1541,   1545,   1550,
    1555 .. 1556,   1560,   1570,   1580 .. 1581,   1590 .. 1593,
    1596 .. 1599,   1601 .. 1610,   1612 .. 1621,   1624 .. 1626,
    1628 .. 1630,   1632 .. 1634,   1636 .. 1642,   1650 .. 1651,
    1653 .. 1655,   1657 .. 1659,   1661 .. 1667,   1670 .. 1673,
    1675 .. 1676,   1678 .. 1680,   1682 .. 1684,   1690,   1692,
    1701 .. 1715,   1718 .. 1727,   1730,           1733 .. 1735,
    1738 .. 1740,   1742 .. 1743,   1745 .. 1747,   1751 .. 1754,
    1757,           1759 .. 1761,   1763 .. 1769,   1771 .. 1772,
    1776 .. 1779,   1781 .. 1794,   1796,           1798 .. 1799,
    1801 .. 1809,   1811 .. 1816,   1820,   1823,   1825,   1827,
    1830 .. 1833,   1850 .. 1851,   1859 .. 1861,   1866 .. 1867,
    1870 .. 1871,   1875,   1878,   1880,           1890 .. 1893,
    1900 .. 1901,   1903,           1910 .. 1912,   1914,
    1916 .. 1917,   1920 .. 1921,   1923 .. 1931,   1940 .. 1941,
    1950,   1954,   1960 .. 1961,   1963,           1970 .. 1971,

    2000 .. 2001,   2003 .. 2028,   2030 .. 2036,   2040 .. 2041,
    2050 .. 2058,   2060 .. 2062,   2066 .. 2074,   2076,
    2080 .. 2081,   2090 .. 2093,   2100 .. 2101,   2110,   2114,
    2116,   2120,   2123,   2130,   2133 .. 2134,   2150 .. 2151,
    2160 .. 2162,   2164 .. 2166,   2170,           2201 .. 2206,
    2208 .. 2214,   2216 .. 2220,   2223 .. 2226,   2230,
    2232 .. 2233,   2235,   2240,   2256,           2260 .. 2261,
    2264 .. 2266,   2270 .. 2271,   2280,   2283,   2301 .. 2309,
    2312,           2315 .. 2326,   2330,   2332,   2334 .. 2338,
    2340 .. 2341,   2344 .. 2345,   2350,   2353,   2355,   2360,
    2364 .. 2365,   2372,           2380 .. 2391,   2401 .. 2403,
    2405 .. 2412,   2415 .. 2416,   2418,           2420 .. 2423,
    2425,           2427 .. 2430,   2432,           2435 .. 2438,
    2440,   2443,   2446,   2448,   2450 .. 2451,   2460,
    2476 .. 2478,   2480 .. 2481,   2485,           2500 .. 2501,
    2510,   2512,   2540,   2542,   2544,   2550,   2552,   2555,
    2560 .. 2561,   2580 .. 2582,   2584,           2601 .. 2619,
    2624 .. 2626,   2629 .. 2637,   2639 .. 2640,   2642 .. 2643,
    2645 .. 2649,   2651 .. 2653,   2656 .. 2670,   2672 .. 2677,
    2680,           2682 .. 2688,   2690,           2693 .. 2695,
    2711 .. 2718,   2720,   2730,   2740,           2742 .. 2743,
    2750,   2760,   2770,           2801 .. 2811,   2815 .. 2822,
    2825,   2827,   2830 .. 2832,   2836 .. 2840,   2843,
    2846 .. 2851,   2853 .. 2854,   2857 .. 2858,   2860 .. 2862,
    2864,           2866 .. 2867,   2870,           2879 .. 2882,
    2890,   2893,   2900 .. 2901,   2907,   2910,   2917 .. 2918,
    2920,   2923,   2929 .. 2930,   2933,           2936 .. 2937,
    2939 .. 2940,   2943,   2950,   2952 .. 2954,   2959 .. 2960,
    2966 .. 2967,   2973 .. 2975,   2977,   2985,

    3001 .. 3009,   3011 .. 3019,   3021 .. 3048,   3050 .. 3051,
    3053 .. 3058,   3060 .. 3061,   3070 .. 3071,   3075,
    3080 .. 3090,   3092,   3095,   3101,           3103 .. 3128,
    3131 .. 3133,   3135,           3137 .. 3145,   3148,
    3150 .. 3154,   3157 .. 3189,   3191 .. 3196,   3199,
    3201 .. 3246,   3249,           3251 .. 3265,   3267 .. 3271,
    3274 .. 3277,   3280 .. 3282,   3284 .. 3285,   3290 .. 3292,
    3294 .. 3297,   3300 .. 3301,   3320 .. 3322,   3330 .. 3331,
    3340 .. 3342,   3350 .. 3351,   3355,           3358 .. 3361,
    3370 .. 3371,   3401 .. 3414,   3420 .. 3421,   3425 .. 3428,
    3430 .. 3431,   3440 .. 3442,   3470 .. 3472,   3474 .. 3478,
    3480 .. 3484,   3490 .. 3491,   3501 .. 3504,   3507,
    3510 .. 3526,   3528 .. 3531,   3533 .. 3541,   3544,
    3550 .. 3551,   3560 .. 3561,   3570 .. 3571,   3575 .. 3577,
    3579 .. 3581,   3588,   3593,   3595,           3601 .. 3606,
    3608 .. 3624,   3626 .. 3632,   3646 .. 3648,   3650,   3652,
    3656,   3658,   3660 .. 3661,   3665 .. 3666,   3671 .. 3681,
    3683 .. 3684,   3690 .. 3692,   3697,           3701 .. 3705,
    3707 .. 3708,   3710 .. 3744,   3746 .. 3750,   3753,   3760,
    3766,   3770,   3780 .. 3781,   3783,   3785,   3787 .. 3796,
    3798,           3800 .. 3805,   3810 .. 3812,   3820,   3825,
    3830 .. 3836,   3840 .. 3841,   3844,           3848 .. 3850,
    3853 .. 3855,   3864,   3870,   3880,           3882 .. 3888,
    3890 .. 3891,   3893,   3895,   3901 .. 3906,   3910 .. 3922,
    3924 .. 3925,   3928 .. 3931,   3933,           3936 .. 3937,
    3939 .. 3944,   3946 .. 3950,   3960,           3965 .. 3967,
    3970,   3991,   3993 .. 3999,

    4001 .. 4029,   4031 .. 4036,   4041 .. 4059,   4064 .. 4070,
    4076 .. 4079,   4081 .. 4100,   4102,   4110,   4119 .. 4120,
    4123 .. 4124,   4126 .. 4130,   4134,   4137,   4139,   4146,
    4148,   4150,   4152 .. 4154,   4156,           4158 .. 4161,
    4163 .. 4164,   4167 .. 4170,   4173 .. 4174,   4180,   4182,
    4187,   4198,   4200 .. 4201,   4208 .. 4209,   4230,
    4233 .. 4235,   4237,           4239 .. 4240,   4244,   4250,
    4260,   4262,   4264 .. 4265,   4270,   4272,   4274 .. 4276,
    4280,   4291,   4294 .. 4299,   4301 .. 4319,   4321 .. 4330,
    4332 .. 4333,   4335,           4339 .. 4349,   4352 .. 4358,
    4360,           4362 .. 4365,   4367 .. 4376,   4378 .. 4381,
    4387,   4389,   4391 .. 4398,   4400 .. 4403,   4420,   4432,
    4434,   4436,   4438,           4440 .. 4441,   4443,   4460,
    4462 .. 4463,   4465,   4473,   4480,           4484 .. 4485,
    4490 .. 4492,   4501 .. 4506,   4509,           4513 .. 4517,
    4519 .. 4525,   4528 .. 4529,   4532,   4534,   4536,   4540,
    4544,           4550 .. 4554,   4557 .. 4558,   4560,   4563,
    4575 .. 4577,   4579 .. 4580,   4586,   4588,   4590,
    4595 .. 4596,   4604 .. 4606,   4608 .. 4626,   4628 .. 4640,
    4645 .. 4647,   4651,           4656 .. 4659,   4661 .. 4666,
    4670 .. 4679,   4681 .. 4689,   4691,           4693 .. 4703,
    4705,   4715,   4720,   4724,   4730,           4733 .. 4735,
    4737,           4741 .. 4742,   4745,           4747 .. 4748,
    4754 .. 4756,   4760,   4766,   4768,   4770,   4780,
    4790 .. 4795,   4801 .. 4804,   4808 .. 4810,   4812,
    4815 .. 4818,   4820 .. 4821,   4823 .. 4825,   4827 .. 4828,
    4830,   4832,   4834,   4836,   4838 .. 4839,   4841 .. 4844,
    4846 .. 4849,   4851 .. 4859,   4861 .. 4865,   4868 .. 4870,
    4876 .. 4879,   4884 .. 4889,   4891 .. 4894,   4896,   4898,
    4900 .. 4902,   4909 .. 4910,   4912,           4915 .. 4916,
    4920,   4934,   4950 .. 4953,   4955,           4971 .. 4974,
    4980,   4985,   4990,           4993 .. 4994,

    5003 .. 5022,   5031 .. 5039,   5041 .. 5043,   5045,
    5052 .. 5059,   5063,           5067 .. 5068,   5072 .. 5073,
    5075,           5081 .. 5082,   5089,           5093 .. 5094,
    5096 .. 5099,   5101,           5104 .. 5109,   5111,
    5113 .. 5119,   5121 .. 5122,   5124,           5130 .. 5132,
    5134 .. 5137,   5141 .. 5148,   5151 .. 5155,   5160 .. 5165,
    5170 .. 5174,   5176 .. 5179,   5183 .. 5184,   5200 .. 5203,
    5206 .. 5212,   5215 .. 5218,   5221 .. 5232,   5235 .. 5239,
    5243 .. 5244,   5251 .. 5254,   5257 .. 5265,   5267 .. 5268,
    5281 .. 5286,   5291,   5293,   5299 .. 5310,   5314 .. 5315,
    5318 .. 5319,   5321 .. 5323,   5325 .. 5327,   5329,   5331,
    5333 .. 5337,   5341 .. 5343,   5345 .. 5347,   5350,
    5353 .. 5355,   5357 .. 5358,   5360,   5363,   5365 .. 5366,
    5371,   5374,   5378 .. 5382,   5384 .. 5385,   5387 .. 5388,
    5392 .. 5394,   5396 .. 5399,   5401 .. 5404,   5406 .. 5420,
    5423,           5427 .. 5428,   5430,   5437,   5440,
    5443 .. 5445,   5447,           5449 .. 5455,   5457 .. 5460,
    5462 .. 5465,   5470,           5472 .. 5476,   5480,   5484,
    5486,           5498 .. 5499,   5501 .. 5509,   5511 .. 5512,
    5514 .. 5519,   5521 .. 5523,   5525,           5527 .. 5529,
    5531 .. 5538,   5541 .. 5542,   5544 .. 5551,   5554 .. 5555,
    5559 .. 5561,   5563,           5565 .. 5568,   5570,
    5574 .. 5576,   5578,   5580,   5582 .. 5586,   5588 .. 5591,
    5593 .. 5596,   5598,           5600 .. 5602,   5604 .. 5605,
    5610,   5612,   5614,   5620,   5626 .. 5630,   5632,
    5635 .. 5637,   5640 .. 5643,   5645 .. 5647,   5649 .. 5650,
    5652 .. 5653,   5680,   5683,   5685,   5687,   5690,
    5693 .. 5696,   5700 .. 5715,   5718 .. 5719,   5721 .. 5731,
    5733 .. 5734,   5736,           5741 .. 5743,   5745 .. 5752,
    5760,   5763,   5770,   5773,   5776 .. 5788,   5803 .. 5822,
    5824 .. 5825,   5828 .. 5829,   5831,           5835 .. 5836,
    5838,   5841,   5845,           5847 .. 5849,   5851 .. 5854,
    5857 .. 5859,   5861 .. 5864,   5868 .. 5869,   5871 .. 5873,
    5876 .. 5879,   5881 .. 5882,   5884,           5886 .. 5889,
    5892 .. 5893,   5895 .. 5896,   5899,           5902 .. 5904,
    5906 .. 5908,   5911 .. 5918,   5931,           5936 .. 5939,
    5941,   5943,   5947 .. 5948,   5951 .. 5957,   5960 .. 5962,
    5966 .. 5967,   5970,           5977 .. 5979,   5981,
    5983 .. 5984,   5986 .. 5987,   5991,           5993 .. 5994,

    6001 .. 6026,   6028,   6030,   6035 .. 6040,   6043 .. 6048,
    6050 .. 6052,   6055,           6057 .. 6060,   6062 .. 6065,
    6067 .. 6070,   6076,   6080,   6082 .. 6085,   6087,
    6089 .. 6092,   6094 .. 6096,   6098 .. 6106,   6110,   6120,
    6133,           6139 .. 6144,   6146,           6149 .. 6156,
    6160 .. 6161,   6165 .. 6166,   6170,   6174,   6183 .. 6184,
    6190,   6196,   6200 .. 6201,   6210 .. 6216,   6218,   6220,
    6222,   6224,   6230,           6238 .. 6240,   6249 .. 6250,
    6259 .. 6260,   6263 .. 6265,   6270,   6272,   6280 .. 6283,
    6285,   6290,   6292 .. 6294,   6300 .. 6301,   6310,   6315,
    6320,   6330,   6339,   6350,   6360,           6363 .. 6364,
    6386 .. 6387,   6390 .. 6399,   6401 .. 6405,   6407 .. 6416,
    6418 .. 6419,   6421 .. 6423,   6425,           6429 .. 6431,
    6433 .. 6436,   6440,           6443 .. 6445,   6447,   6450,
    6453 .. 6457,   6460 .. 6462,   6470,   6472,   6475 .. 6476,
    6480 .. 6481,   6483 .. 6484,   6486 .. 6488,   6490,
    6493 .. 6494,   6499,           6501 .. 6504,   6506 .. 6512,
    6514 .. 6518,   6520 .. 6525,   6529 .. 6530,   6538 .. 6539,
    6570 .. 6571,   6590,           6600 .. 6601,   6610 .. 6613,
    6620,   6622,   6628 .. 6631,   6633,           6636 .. 6640,
    6642 .. 6645,   6650,           6652 .. 6653,   6655 .. 6659,
    6670,   6674,   6680,   6683,   6686 .. 6690,   6693 .. 6694,
    6697 .. 6704,   6707 .. 6708,   6710 .. 6711,   6713 .. 6719,
    6721,   6723,   6726 .. 6731,   6734,   6737,   6740 .. 6741,
    6750 .. 6751,   6761,   6763,   6770 .. 6772,   6776 .. 6779,
    6781 .. 6784,   6788 .. 6789,   6791 .. 6793,   6795 .. 6815,
    6817 .. 6819,   6821 .. 6823,   6826 .. 6829,   6841,   6843,
    6847 .. 6848,   6851 .. 6856,   6858 .. 6859,   6861,   6863,
    6866,           6868 .. 6873,   6875 .. 6879,   6881 .. 6882,
    6884 .. 6888,   6891,           6893 .. 6896,   6898 .. 6903,
    6909,   6912,   6914 .. 6919,   6921,   6924,   6926 .. 6929,
    6940 .. 6942,   6944,           6946 .. 6947,   6951,   6953,
    6957 .. 6958,   6961,           6963 .. 6964,   6966 .. 6969,
    6971,   6973,   6975,           6977 .. 6978,   6980 .. 6988,
    6991,   6993,   6995 .. 6996,

    7003 .. 7006,   7010 .. 7016,   7018 .. 7034,   7036 .. 7054,
    7056 .. 7059,   7070,   7072,   7074 .. 7075,   7078 .. 7083,
    7088 .. 7089,   7091 .. 7092,   7097 .. 7101,   7105,   7110,
    7112 .. 7114,   7119 .. 7121,   7125 .. 7127,   7129 .. 7130,
    7140,   7142,   7150,           7152 .. 7153,   7156,
    7159 .. 7160,   7165 .. 7170,   7176 .. 7178,   7180,   7190,
    7194,           7200 .. 7201,   7203,   7206,   7211 .. 7213,
    7221,           7223 .. 7224,   7227 .. 7228,   7231 .. 7232,
    7234 .. 7236,   7238 .. 7243,   7246 .. 7247,   7250,   7252,
    7255 .. 7257,   7259 .. 7261,   7263 .. 7264,   7266,   7268,
    7270,   7273,   7280,   7282,   7284 .. 7291,   7295,   7298,
    7300 .. 7302,   7310,           7315 .. 7316,   7318 .. 7321,
    7327,   7329,   7331 .. 7336,   7338,           7340 .. 7343,
    7345,           7350 .. 7351,   7353 .. 7355,   7357 .. 7358,
    7361,   7370,   7372,   7374,   7380,           7383 .. 7384,
    7386 .. 7387,   7391 .. 7393,   7397 .. 7422,   7424 .. 7459,
    7461 .. 7463,   7465 .. 7497,   7500 .. 7510,   7512 .. 7514,
    7517,           7519 .. 7520,   7525,           7529 .. 7531,
    7533,           7540 .. 7541,   7549 .. 7551,   7560,
    7562 .. 7563,   7566,   7570,   7580 .. 7581,   7583 .. 7584,
    7590 .. 7591,   7596,           7600 .. 7610,   7619 .. 7620,
    7622 .. 7624,   7629 .. 7634,   7650 .. 7658,   7660,
    7670 .. 7671,   7690,           7701 .. 7705,   7707 .. 7718,
    7724 .. 7726,   7729 .. 7730,   7732,           7734 .. 7740,
    7742,           7744 .. 7746,   7748,           7750 .. 7751,
    7760 .. 7761,   7770 .. 7771,   7777,           7790 .. 7791,
    7796 .. 7797,   7800 .. 7805,   7808,   7810,   7817 .. 7820,
    7822,   7856,   7860,           7863 .. 7864,   7869 .. 7871,
    7873,   7882,   7884,   7890,   7892 .. 7893,   7896,   7898,
    7900 .. 7901,   7940,   7944,   7950,   7960,   7970 .. 7971,
    7973,           7976 .. 7977,   7980 .. 7982,   7985,   7990,
    7993 .. 7994,

    8001 .. 8016,   8019 .. 8023,   8026 .. 8032,   8037 .. 8038,
    8041,           8047 .. 8050,   8056,   8058,   8063 .. 8064,
    8070 .. 8076,   8079,   8084,   8086 .. 8089,   8091 .. 8098,
    8100,           8102 .. 8103,   8108,   8110,   8114,   8118,
    8120,   8128,   8130,           8135 .. 8136,   8138,   8140,
    8145 .. 8146,   8149 .. 8151,   8157 .. 8161,   8168,   8170,
    8178,           8181 .. 8182,   8184 .. 8190,   8193,
    8195 .. 8198,   8200 .. 8203,   8205 .. 8211,   8214 .. 8215,
    8218 .. 8220,   8226,           8230 .. 8233,   8250 .. 8251,
    8255 .. 8256,   8260 .. 8261,   8264,   8266,   8270 .. 8271,
    8273 .. 8276,   8278,   8281,   8283,           8285 .. 8286,
    8288 .. 8291,   8294,           8297 .. 8298,   8300 .. 8301,
    8305,           8309 .. 8317,   8320,           8322 .. 8326,
    8328,   8340,   8352,   8357,   8360,   8370,   8372 .. 8373,
    8376 .. 8378,   8380,   8382,   8384,           8387 .. 8388,
    8390,           8392 .. 8393,   8398,           8400 .. 8416,
    8426,   8428,   8430,   8432,   8438 .. 8439,   8445,   8447,
    8450,   8455,   8459,   8465,   8469 .. 8470,   8475,
    8480 .. 8481,   8483 .. 8485,   8488 .. 8489,   8493,
    8501 .. 8510,   8512 .. 8518,   8520,           8522 .. 8523,
    8530 .. 8531,   8533 .. 8536,   8539 .. 8540,   8543,   8546,
    8590 .. 8591,   8601 .. 8604,   8607 .. 8608,   8610,
    8613 .. 8618,   8622,   8624,   8626,   8630,   8634,   8638,
    8640 .. 8643,   8646 .. 8648,   8651 .. 8652,   8654 .. 8661,
    8663 .. 8666,   8672,           8680 .. 8681,   8690 .. 8691,
    8700 .. 8701,   8720,           8723 .. 8725,   8730,
    8732 .. 8733,   8735,   8740,   8742 .. 8743,   8750,
    8752 .. 8754,   8761 .. 8762,   8764,           8766 .. 8767,
    8770,           8800 .. 8805,   8809,   8813,   8820,   8827,
    8830,   8842,   8844,           8850 .. 8852,   8854,
    8860 .. 8861,   8865,   8870,   8880,           8890 .. 8892,
    8897,           8900 .. 8902,   8904 .. 8910,   8920 .. 8922,
    8960 .. 8961,   8976,           8980 .. 8981,   8985,

    9006 .. 9020,   9022,   9024,   9027,           9029 .. 9030,
    9034,           9037 .. 9038,   9040,           9042 .. 9043,
    9046,           9049 .. 9050,   9055 .. 9057,   9059 .. 9060,
    9062,   9064,   9068 .. 9069,   9100 .. 9108,   9110,
    9118 .. 9120,   9128,           9130 .. 9132,   9134 .. 9138,
    9140 .. 9144,   9146 .. 9148,   9151 .. 9153,   9156,   9159,
    9161 .. 9163,   9169,           9180 .. 9182,   9184 .. 9187,
    9189 .. 9190,   9192 .. 9195,   9197,   9240,   9251 .. 9263,
    9265 .. 9288,   9290 .. 9294,   9296,           9298 .. 9300,
    9302 .. 9306,   9310 .. 9311,   9315 .. 9316,   9321 .. 9322,
    9325 .. 9326,   9329,           9334 .. 9336,   9350,   9355,
    9357 .. 9358,   9360,   9365,   9370,           9372 .. 9373,
    9376,           9379 .. 9382,   9384 .. 9389,   9391 .. 9393,
    9395,           9402 .. 9409,   9411,           9414 .. 9415,
    9419 .. 9420,   9423 .. 9427,   9430,   9436,   9439 .. 9448,
    9450 .. 9451,   9453 .. 9455,   9470 .. 9471,   9475 .. 9476,
    9479 .. 9489,   9496 .. 9498,   9501 .. 9521,   9525,
    9531 .. 9533,   9536,   9540,   9545,           9550 .. 9551,
    9580,           9582 .. 9587,   9590,   9593,   9595,   9600,
    9609 .. 9610,   9615 .. 9616,   9620 .. 9621,   9624,   9650,
    9657,   9664,   9670,   9672,   9690 .. 9692,   9700,
    9709 .. 9717,   9722,   9730,   9735,   9740,   9742,
    9750 .. 9751,   9760,           9763 .. 9765,   9768,
    9770 .. 9773,   9775,   9782,   9790,   9800,   9802,
    9810 .. 9811,   9815,   9820,   9826,   9840,   9845 .. 9846,
    9900,   9910,   9912,           9914 .. 9917,   9925,   9930,
    9935,           9950 .. 9951,   9960,           9980 .. 9982,
    9990 .. 9991,
}


__END__
