// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1alpha/search_service.proto

package discoveryenginepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The attribute(or function) for which the custom ranking is to be
// applied.
type SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType int32

const (
	// Unspecified AttributeType.
	SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ATTRIBUTE_TYPE_UNSPECIFIED SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType = 0
	// The value of the numerical field will be used to dynamically update
	// the boost amount. In this case, the attribute_value (the x value)
	// of the control point will be the actual value of the numerical
	// field for which the boost_amount is specified.
	SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_NUMERICAL SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType = 1
	// For the freshness use case the attribute value will be the duration
	// between the current time and the date in the datetime field
	// specified. The value must be formatted as an XSD `dayTimeDuration`
	// value (a restricted subset of an ISO 8601 duration value). The
	// pattern for this is: `[nD][T[nH][nM][nS]]`.
	// For example, `5D`, `3DT12H30M`, `T24H`.
	SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_FRESHNESS SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType = 2
)

// Enum value maps for SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType.
var (
	SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType_name = map[int32]string{
		0: "ATTRIBUTE_TYPE_UNSPECIFIED",
		1: "NUMERICAL",
		2: "FRESHNESS",
	}
	SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType_value = map[string]int32{
		"ATTRIBUTE_TYPE_UNSPECIFIED": 0,
		"NUMERICAL":                  1,
		"FRESHNESS":                  2,
	}
)

func (x SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType) Enum() *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType {
	p := new(SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType)
	*p = x
	return p
}

func (x SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_enumTypes[0].Descriptor()
}

func (SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_search_service_proto_enumTypes[0]
}

func (x SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType.Descriptor instead.
func (SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 3, 0, 0, 0}
}

// The interpolation type to be applied. Default will be linear
// (Piecewise Linear).
type SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType int32

const (
	// Interpolation type is unspecified. In this case, it defaults to
	// Linear.
	SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_INTERPOLATION_TYPE_UNSPECIFIED SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType = 0
	// Piecewise linear interpolation will be applied.
	SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_LINEAR SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType = 1
)

// Enum value maps for SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType.
var (
	SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType_name = map[int32]string{
		0: "INTERPOLATION_TYPE_UNSPECIFIED",
		1: "LINEAR",
	}
	SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType_value = map[string]int32{
		"INTERPOLATION_TYPE_UNSPECIFIED": 0,
		"LINEAR":                         1,
	}
)

func (x SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType) Enum() *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType {
	p := new(SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType)
	*p = x
	return p
}

func (x SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_enumTypes[1].Descriptor()
}

func (SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_search_service_proto_enumTypes[1]
}

func (x SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType.Descriptor instead.
func (SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 3, 0, 0, 1}
}

// Enum describing under which condition query expansion should occur.
type SearchRequest_QueryExpansionSpec_Condition int32

const (
	// Unspecified query expansion condition. In this case, server behavior
	// defaults to
	// [Condition.DISABLED][google.cloud.discoveryengine.v1alpha.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
	SearchRequest_QueryExpansionSpec_CONDITION_UNSPECIFIED SearchRequest_QueryExpansionSpec_Condition = 0
	// Disabled query expansion. Only the exact search query is used, even if
	// [SearchResponse.total_size][google.cloud.discoveryengine.v1alpha.SearchResponse.total_size]
	// is zero.
	SearchRequest_QueryExpansionSpec_DISABLED SearchRequest_QueryExpansionSpec_Condition = 1
	// Automatic query expansion built by the Search API.
	SearchRequest_QueryExpansionSpec_AUTO SearchRequest_QueryExpansionSpec_Condition = 2
)

// Enum value maps for SearchRequest_QueryExpansionSpec_Condition.
var (
	SearchRequest_QueryExpansionSpec_Condition_name = map[int32]string{
		0: "CONDITION_UNSPECIFIED",
		1: "DISABLED",
		2: "AUTO",
	}
	SearchRequest_QueryExpansionSpec_Condition_value = map[string]int32{
		"CONDITION_UNSPECIFIED": 0,
		"DISABLED":              1,
		"AUTO":                  2,
	}
)

func (x SearchRequest_QueryExpansionSpec_Condition) Enum() *SearchRequest_QueryExpansionSpec_Condition {
	p := new(SearchRequest_QueryExpansionSpec_Condition)
	*p = x
	return p
}

func (x SearchRequest_QueryExpansionSpec_Condition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchRequest_QueryExpansionSpec_Condition) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_enumTypes[2].Descriptor()
}

func (SearchRequest_QueryExpansionSpec_Condition) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_search_service_proto_enumTypes[2]
}

func (x SearchRequest_QueryExpansionSpec_Condition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchRequest_QueryExpansionSpec_Condition.Descriptor instead.
func (SearchRequest_QueryExpansionSpec_Condition) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 4, 0}
}

// Enum describing under which mode spell correction should occur.
type SearchRequest_SpellCorrectionSpec_Mode int32

const (
	// Unspecified spell correction mode. In this case, server behavior
	// defaults to
	// [Mode.AUTO][google.cloud.discoveryengine.v1alpha.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
	SearchRequest_SpellCorrectionSpec_MODE_UNSPECIFIED SearchRequest_SpellCorrectionSpec_Mode = 0
	// Search API tries to find a spelling suggestion. If a suggestion is
	// found, it is put in the
	// [SearchResponse.corrected_query][google.cloud.discoveryengine.v1alpha.SearchResponse.corrected_query].
	// The spelling suggestion won't be used as the search query.
	SearchRequest_SpellCorrectionSpec_SUGGESTION_ONLY SearchRequest_SpellCorrectionSpec_Mode = 1
	// Automatic spell correction built by the Search API. Search will
	// be based on the corrected query if found.
	SearchRequest_SpellCorrectionSpec_AUTO SearchRequest_SpellCorrectionSpec_Mode = 2
)

// Enum value maps for SearchRequest_SpellCorrectionSpec_Mode.
var (
	SearchRequest_SpellCorrectionSpec_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "SUGGESTION_ONLY",
		2: "AUTO",
	}
	SearchRequest_SpellCorrectionSpec_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"SUGGESTION_ONLY":  1,
		"AUTO":             2,
	}
)

func (x SearchRequest_SpellCorrectionSpec_Mode) Enum() *SearchRequest_SpellCorrectionSpec_Mode {
	p := new(SearchRequest_SpellCorrectionSpec_Mode)
	*p = x
	return p
}

func (x SearchRequest_SpellCorrectionSpec_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchRequest_SpellCorrectionSpec_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_enumTypes[3].Descriptor()
}

func (SearchRequest_SpellCorrectionSpec_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_search_service_proto_enumTypes[3]
}

func (x SearchRequest_SpellCorrectionSpec_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchRequest_SpellCorrectionSpec_Mode.Descriptor instead.
func (SearchRequest_SpellCorrectionSpec_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 5, 0}
}

// Specifies the search result mode. If unspecified, the
// search result mode defaults to `DOCUMENTS`.
type SearchRequest_ContentSearchSpec_SearchResultMode int32

const (
	// Default value.
	SearchRequest_ContentSearchSpec_SEARCH_RESULT_MODE_UNSPECIFIED SearchRequest_ContentSearchSpec_SearchResultMode = 0
	// Returns documents in the search result.
	SearchRequest_ContentSearchSpec_DOCUMENTS SearchRequest_ContentSearchSpec_SearchResultMode = 1
	// Returns chunks in the search result. Only available if the
	// [DataStore.DocumentProcessingConfig.chunking_config][] is specified.
	SearchRequest_ContentSearchSpec_CHUNKS SearchRequest_ContentSearchSpec_SearchResultMode = 2
)

// Enum value maps for SearchRequest_ContentSearchSpec_SearchResultMode.
var (
	SearchRequest_ContentSearchSpec_SearchResultMode_name = map[int32]string{
		0: "SEARCH_RESULT_MODE_UNSPECIFIED",
		1: "DOCUMENTS",
		2: "CHUNKS",
	}
	SearchRequest_ContentSearchSpec_SearchResultMode_value = map[string]int32{
		"SEARCH_RESULT_MODE_UNSPECIFIED": 0,
		"DOCUMENTS":                      1,
		"CHUNKS":                         2,
	}
)

func (x SearchRequest_ContentSearchSpec_SearchResultMode) Enum() *SearchRequest_ContentSearchSpec_SearchResultMode {
	p := new(SearchRequest_ContentSearchSpec_SearchResultMode)
	*p = x
	return p
}

func (x SearchRequest_ContentSearchSpec_SearchResultMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchRequest_ContentSearchSpec_SearchResultMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_enumTypes[4].Descriptor()
}

func (SearchRequest_ContentSearchSpec_SearchResultMode) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_search_service_proto_enumTypes[4]
}

func (x SearchRequest_ContentSearchSpec_SearchResultMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchRequest_ContentSearchSpec_SearchResultMode.Descriptor instead.
func (SearchRequest_ContentSearchSpec_SearchResultMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 6, 0}
}

// An Enum for summary-skipped reasons.
type SearchResponse_Summary_SummarySkippedReason int32

const (
	// Default value. The summary skipped reason is not specified.
	SearchResponse_Summary_SUMMARY_SKIPPED_REASON_UNSPECIFIED SearchResponse_Summary_SummarySkippedReason = 0
	// The adversarial query ignored case.
	//
	// Only populated when
	// [SummarySpec.ignore_adversarial_query][google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SummarySpec.ignore_adversarial_query]
	// is set to `true`.
	SearchResponse_Summary_ADVERSARIAL_QUERY_IGNORED SearchResponse_Summary_SummarySkippedReason = 1
	// The non-summary seeking query ignored case.
	//
	// Only populated when
	// [SummarySpec.ignore_non_summary_seeking_query][google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SummarySpec.ignore_non_summary_seeking_query]
	// is set to `true`.
	SearchResponse_Summary_NON_SUMMARY_SEEKING_QUERY_IGNORED SearchResponse_Summary_SummarySkippedReason = 2
	// The out-of-domain query ignored case.
	//
	// Google skips the summary if there are no high-relevance search results.
	// For example, the data store contains facts about company A but the
	// user query is asking questions about company B.
	SearchResponse_Summary_OUT_OF_DOMAIN_QUERY_IGNORED SearchResponse_Summary_SummarySkippedReason = 3
	// The potential policy violation case.
	//
	// Google skips the summary if there is a potential policy violation
	// detected. This includes content that may be violent or toxic.
	SearchResponse_Summary_POTENTIAL_POLICY_VIOLATION SearchResponse_Summary_SummarySkippedReason = 4
	// The LLM addon not enabled case.
	//
	// Google skips the summary if the LLM addon is not enabled.
	SearchResponse_Summary_LLM_ADDON_NOT_ENABLED SearchResponse_Summary_SummarySkippedReason = 5
)

// Enum value maps for SearchResponse_Summary_SummarySkippedReason.
var (
	SearchResponse_Summary_SummarySkippedReason_name = map[int32]string{
		0: "SUMMARY_SKIPPED_REASON_UNSPECIFIED",
		1: "ADVERSARIAL_QUERY_IGNORED",
		2: "NON_SUMMARY_SEEKING_QUERY_IGNORED",
		3: "OUT_OF_DOMAIN_QUERY_IGNORED",
		4: "POTENTIAL_POLICY_VIOLATION",
		5: "LLM_ADDON_NOT_ENABLED",
	}
	SearchResponse_Summary_SummarySkippedReason_value = map[string]int32{
		"SUMMARY_SKIPPED_REASON_UNSPECIFIED": 0,
		"ADVERSARIAL_QUERY_IGNORED":          1,
		"NON_SUMMARY_SEEKING_QUERY_IGNORED":  2,
		"OUT_OF_DOMAIN_QUERY_IGNORED":        3,
		"POTENTIAL_POLICY_VIOLATION":         4,
		"LLM_ADDON_NOT_ENABLED":              5,
	}
)

func (x SearchResponse_Summary_SummarySkippedReason) Enum() *SearchResponse_Summary_SummarySkippedReason {
	p := new(SearchResponse_Summary_SummarySkippedReason)
	*p = x
	return p
}

func (x SearchResponse_Summary_SummarySkippedReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchResponse_Summary_SummarySkippedReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_enumTypes[5].Descriptor()
}

func (SearchResponse_Summary_SummarySkippedReason) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_search_service_proto_enumTypes[5]
}

func (x SearchResponse_Summary_SummarySkippedReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchResponse_Summary_SummarySkippedReason.Descriptor instead.
func (SearchResponse_Summary_SummarySkippedReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 3, 0}
}

// Request message for
// [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search]
// method.
type SearchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Search serving config, such as
	// `projects/*/locations/global/collections/default_collection/engines/*/servingConfigs/default_serving_config`,
	// or
	// `projects/*/locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`.
	// This field is used to identify the serving configuration name, set
	// of models used to make the search.
	ServingConfig string `protobuf:"bytes,1,opt,name=serving_config,json=servingConfig,proto3" json:"serving_config,omitempty"`
	// The branch resource name, such as
	// `projects/*/locations/global/collections/default_collection/dataStores/default_data_store/branches/0`.
	//
	// Use `default_branch` as the branch ID or leave this field empty, to search
	// documents under the default branch.
	Branch string `protobuf:"bytes,2,opt,name=branch,proto3" json:"branch,omitempty"`
	// Raw search query.
	Query string `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	// Raw image query.
	ImageQuery *SearchRequest_ImageQuery `protobuf:"bytes,19,opt,name=image_query,json=imageQuery,proto3" json:"image_query,omitempty"`
	// Maximum number of
	// [Document][google.cloud.discoveryengine.v1alpha.Document]s to return. The
	// maximum allowed value depends on the data type. Values above the maximum
	// value are coerced to the maximum value.
	//
	// * Websites with basic indexing: Default `10`, Maximum `25`.
	// * Websites with advanced indexing: Default `25`, Maximum `50`.
	// * Other: Default `50`, Maximum `100`.
	//
	// If this field is negative, an  `INVALID_ARGUMENT` is returned.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token received from a previous
	// [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search]
	// must match the call that provided the page token. Otherwise, an
	//
	//	`INVALID_ARGUMENT`  error is returned.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A 0-indexed integer that specifies the current offset (that is, starting
	// result location, amongst the
	// [Document][google.cloud.discoveryengine.v1alpha.Document]s deemed by the
	// API as relevant) in search results. This field is only considered if
	// [page_token][google.cloud.discoveryengine.v1alpha.SearchRequest.page_token]
	// is unset.
	//
	// If this field is negative, an  `INVALID_ARGUMENT`  is returned.
	Offset int32 `protobuf:"varint,6,opt,name=offset,proto3" json:"offset,omitempty"`
	// Specs defining dataStores to filter on in a search call and configurations
	// for those dataStores. This is only considered for engines with multiple
	// dataStores use case. For single dataStore within an engine, they should
	// use the specs at the top level.
	DataStoreSpecs []*SearchRequest_DataStoreSpec `protobuf:"bytes,32,rep,name=data_store_specs,json=dataStoreSpecs,proto3" json:"data_store_specs,omitempty"`
	// The filter syntax consists of an expression language for constructing a
	// predicate from one or more fields of the documents being filtered. Filter
	// expression is case-sensitive.
	//
	// If this field is unrecognizable, an  `INVALID_ARGUMENT`  is returned.
	//
	// Filtering in Vertex AI Search is done by mapping the LHS filter key to a
	// key property defined in the Vertex AI Search backend -- this mapping is
	// defined by the customer in their schema. For example a media customer might
	// have a field 'name' in their schema. In this case the filter would look
	// like this: filter --> name:'ANY("king kong")'
	//
	// For more information about filtering including syntax and filter
	// operators, see
	// [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `protobuf:"bytes,7,opt,name=filter,proto3" json:"filter,omitempty"`
	// The default filter that is applied when a user performs a search without
	// checking any filters on the search page.
	//
	// The filter applied to every search request when quality improvement such as
	// query expansion is needed. In the case a query does not have a sufficient
	// amount of results this filter will be used to determine whether or not to
	// enable the query expansion flow. The original filter will still be used for
	// the query expanded search.
	// This field is strongly recommended to achieve high search quality.
	//
	// For more information about filter syntax, see
	// [SearchRequest.filter][google.cloud.discoveryengine.v1alpha.SearchRequest.filter].
	CanonicalFilter string `protobuf:"bytes,29,opt,name=canonical_filter,json=canonicalFilter,proto3" json:"canonical_filter,omitempty"`
	// The order in which documents are returned. Documents can be ordered by
	// a field in an [Document][google.cloud.discoveryengine.v1alpha.Document]
	// object. Leave it unset if ordered by relevance. `order_by` expression is
	// case-sensitive.
	//
	// For more information on ordering for retail search, see
	// [Ordering](https://cloud.google.com/retail/docs/filter-and-order#order)
	//
	// If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
	OrderBy string `protobuf:"bytes,8,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Information about the end user.
	// Highly recommended for analytics.
	// [UserInfo.user_agent][google.cloud.discoveryengine.v1alpha.UserInfo.user_agent]
	// is used to deduce `device_type` for analytics.
	UserInfo *UserInfo `protobuf:"bytes,21,opt,name=user_info,json=userInfo,proto3" json:"user_info,omitempty"`
	// Facet specifications for faceted search. If empty, no facets are returned.
	//
	// A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
	// error is returned.
	FacetSpecs []*SearchRequest_FacetSpec `protobuf:"bytes,9,rep,name=facet_specs,json=facetSpecs,proto3" json:"facet_specs,omitempty"`
	// Boost specification to boost certain documents.
	// For more information on boosting, see
	// [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
	BoostSpec *SearchRequest_BoostSpec `protobuf:"bytes,10,opt,name=boost_spec,json=boostSpec,proto3" json:"boost_spec,omitempty"`
	// Additional search parameters.
	//
	// For public website search only, supported values are:
	//
	//   - `user_country_code`: string. Default empty. If set to non-empty, results
	//     are restricted or boosted based on the location provided.
	//     For example, `user_country_code: "au"`
	//
	//     For available codes see [Country
	//     Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
	//
	//   - `search_type`: double. Default empty. Enables non-webpage searching
	//     depending on the value. The only valid non-default value is 1,
	//     which enables image searching.
	//     For example, `search_type: 1`
	Params map[string]*structpb.Value `protobuf:"bytes,11,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The query expansion specification that specifies the conditions under which
	// query expansion occurs.
	QueryExpansionSpec *SearchRequest_QueryExpansionSpec `protobuf:"bytes,13,opt,name=query_expansion_spec,json=queryExpansionSpec,proto3" json:"query_expansion_spec,omitempty"`
	// The spell correction specification that specifies the mode under
	// which spell correction takes effect.
	SpellCorrectionSpec *SearchRequest_SpellCorrectionSpec `protobuf:"bytes,14,opt,name=spell_correction_spec,json=spellCorrectionSpec,proto3" json:"spell_correction_spec,omitempty"`
	// A unique identifier for tracking visitors. For example, this could be
	// implemented with an HTTP cookie, which should be able to uniquely identify
	// a visitor on a single device. This unique identifier should not change if
	// the visitor logs in or out of the website.
	//
	// This field should NOT have a fixed value such as `unknown_visitor`.
	//
	// This should be the same identifier as
	// [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1alpha.UserEvent.user_pseudo_id]
	// and
	// [CompleteQueryRequest.user_pseudo_id][google.cloud.discoveryengine.v1alpha.CompleteQueryRequest.user_pseudo_id]
	//
	// The field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an  `INVALID_ARGUMENT`  error is returned.
	UserPseudoId string `protobuf:"bytes,15,opt,name=user_pseudo_id,json=userPseudoId,proto3" json:"user_pseudo_id,omitempty"`
	// A specification for configuring the behavior of content search.
	ContentSearchSpec *SearchRequest_ContentSearchSpec `protobuf:"bytes,24,opt,name=content_search_spec,json=contentSearchSpec,proto3" json:"content_search_spec,omitempty"`
	// Uses the provided embedding to do additional semantic document retrieval.
	// The retrieval is based on the dot product of
	// [SearchRequest.EmbeddingSpec.EmbeddingVector.vector][google.cloud.discoveryengine.v1alpha.SearchRequest.EmbeddingSpec.EmbeddingVector.vector]
	// and the document embedding that is provided in
	// [SearchRequest.EmbeddingSpec.EmbeddingVector.field_path][google.cloud.discoveryengine.v1alpha.SearchRequest.EmbeddingSpec.EmbeddingVector.field_path].
	//
	// If
	// [SearchRequest.EmbeddingSpec.EmbeddingVector.field_path][google.cloud.discoveryengine.v1alpha.SearchRequest.EmbeddingSpec.EmbeddingVector.field_path]
	// is not provided, it will use
	// [ServingConfig.EmbeddingConfig.field_path][google.cloud.discoveryengine.v1alpha.ServingConfig.embedding_config].
	EmbeddingSpec *SearchRequest_EmbeddingSpec `protobuf:"bytes,23,opt,name=embedding_spec,json=embeddingSpec,proto3" json:"embedding_spec,omitempty"`
	// The ranking expression controls the customized ranking on retrieval
	// documents. This overrides
	// [ServingConfig.ranking_expression][google.cloud.discoveryengine.v1alpha.ServingConfig.ranking_expression].
	// The ranking expression is a single function or multiple functions that are
	// joint by "+".
	//   - ranking_expression = function, { " + ", function };
	//
	// Supported functions:
	//   - double * relevance_score
	//   - double * dotProduct(embedding_field_path)
	//
	// Function variables:
	//
	//	 `relevance_score`: pre-defined keywords, used for measure relevance
	//	 between query and document.
	//	 `embedding_field_path`: the document embedding field
	//	 used with query embedding vector.
	//	 `dotProduct`: embedding function between embedding_field_path and query
	//	 embedding vector.
	//
	//	Example ranking expression:
	//	  If document has an embedding field doc_embedding, the ranking expression
	//	  could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
	RankingExpression string `protobuf:"bytes,26,opt,name=ranking_expression,json=rankingExpression,proto3" json:"ranking_expression,omitempty"`
	// Whether to turn on safe search. This is only supported for
	// website search.
	SafeSearch bool `protobuf:"varint,20,opt,name=safe_search,json=safeSearch,proto3" json:"safe_search,omitempty"`
	// The user labels applied to a resource must meet the following requirements:
	//
	//   - Each resource can have multiple labels, up to a maximum of 64.
	//   - Each label must be a key-value pair.
	//   - Keys have a minimum length of 1 character and a maximum length of 63
	//     characters and cannot be empty. Values can be empty and have a maximum
	//     length of 63 characters.
	//   - Keys and values can contain only lowercase letters, numeric characters,
	//     underscores, and dashes. All characters must use UTF-8 encoding, and
	//     international characters are allowed.
	//   - The key portion of a label must be unique. However, you can use the same
	//     key with multiple resources.
	//   - Keys must start with a lowercase letter or international character.
	//
	// See [Google Cloud
	// Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `protobuf:"bytes,22,rep,name=user_labels,json=userLabels,proto3" json:"user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Custom fine tuning configs.
	CustomFineTuningSpec *CustomFineTuningSpec `protobuf:"bytes,34,opt,name=custom_fine_tuning_spec,json=customFineTuningSpec,proto3" json:"custom_fine_tuning_spec,omitempty"`
}

func (x *SearchRequest) Reset() {
	*x = SearchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest) ProtoMessage() {}

func (x *SearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest.ProtoReflect.Descriptor instead.
func (*SearchRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0}
}

func (x *SearchRequest) GetServingConfig() string {
	if x != nil {
		return x.ServingConfig
	}
	return ""
}

func (x *SearchRequest) GetBranch() string {
	if x != nil {
		return x.Branch
	}
	return ""
}

func (x *SearchRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchRequest) GetImageQuery() *SearchRequest_ImageQuery {
	if x != nil {
		return x.ImageQuery
	}
	return nil
}

func (x *SearchRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchRequest) GetOffset() int32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *SearchRequest) GetDataStoreSpecs() []*SearchRequest_DataStoreSpec {
	if x != nil {
		return x.DataStoreSpecs
	}
	return nil
}

func (x *SearchRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *SearchRequest) GetCanonicalFilter() string {
	if x != nil {
		return x.CanonicalFilter
	}
	return ""
}

func (x *SearchRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *SearchRequest) GetUserInfo() *UserInfo {
	if x != nil {
		return x.UserInfo
	}
	return nil
}

func (x *SearchRequest) GetFacetSpecs() []*SearchRequest_FacetSpec {
	if x != nil {
		return x.FacetSpecs
	}
	return nil
}

func (x *SearchRequest) GetBoostSpec() *SearchRequest_BoostSpec {
	if x != nil {
		return x.BoostSpec
	}
	return nil
}

func (x *SearchRequest) GetParams() map[string]*structpb.Value {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *SearchRequest) GetQueryExpansionSpec() *SearchRequest_QueryExpansionSpec {
	if x != nil {
		return x.QueryExpansionSpec
	}
	return nil
}

func (x *SearchRequest) GetSpellCorrectionSpec() *SearchRequest_SpellCorrectionSpec {
	if x != nil {
		return x.SpellCorrectionSpec
	}
	return nil
}

func (x *SearchRequest) GetUserPseudoId() string {
	if x != nil {
		return x.UserPseudoId
	}
	return ""
}

func (x *SearchRequest) GetContentSearchSpec() *SearchRequest_ContentSearchSpec {
	if x != nil {
		return x.ContentSearchSpec
	}
	return nil
}

func (x *SearchRequest) GetEmbeddingSpec() *SearchRequest_EmbeddingSpec {
	if x != nil {
		return x.EmbeddingSpec
	}
	return nil
}

func (x *SearchRequest) GetRankingExpression() string {
	if x != nil {
		return x.RankingExpression
	}
	return ""
}

func (x *SearchRequest) GetSafeSearch() bool {
	if x != nil {
		return x.SafeSearch
	}
	return false
}

func (x *SearchRequest) GetUserLabels() map[string]string {
	if x != nil {
		return x.UserLabels
	}
	return nil
}

func (x *SearchRequest) GetCustomFineTuningSpec() *CustomFineTuningSpec {
	if x != nil {
		return x.CustomFineTuningSpec
	}
	return nil
}

// Response message for
// [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search]
// method.
type SearchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of matched documents. The order represents the ranking.
	Results []*SearchResponse_SearchResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Results of facets requested by user.
	Facets []*SearchResponse_Facet `protobuf:"bytes,2,rep,name=facets,proto3" json:"facets,omitempty"`
	// Guided search result.
	GuidedSearchResult *SearchResponse_GuidedSearchResult `protobuf:"bytes,8,opt,name=guided_search_result,json=guidedSearchResult,proto3" json:"guided_search_result,omitempty"`
	// The estimated total count of matched items irrespective of pagination. The
	// count of
	// [results][google.cloud.discoveryengine.v1alpha.SearchResponse.results]
	// returned by pagination may be less than the
	// [total_size][google.cloud.discoveryengine.v1alpha.SearchResponse.total_size]
	// that matches.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	// A unique search token. This should be included in the
	// [UserEvent][google.cloud.discoveryengine.v1alpha.UserEvent] logs resulting
	// from this search, which enables accurate attribution of search model
	// performance.
	AttributionToken string `protobuf:"bytes,4,opt,name=attribution_token,json=attributionToken,proto3" json:"attribution_token,omitempty"`
	// The URI of a customer-defined redirect page. If redirect action is
	// triggered, no search is performed, and only
	// [redirect_uri][google.cloud.discoveryengine.v1alpha.SearchResponse.redirect_uri]
	// and
	// [attribution_token][google.cloud.discoveryengine.v1alpha.SearchResponse.attribution_token]
	// are set in the response.
	RedirectUri string `protobuf:"bytes,12,opt,name=redirect_uri,json=redirectUri,proto3" json:"redirect_uri,omitempty"`
	// A token that can be sent as
	// [SearchRequest.page_token][google.cloud.discoveryengine.v1alpha.SearchRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,5,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Contains the spell corrected query, if found. If the spell correction type
	// is AUTOMATIC, then the search results are based on corrected_query.
	// Otherwise the original query is used for search.
	CorrectedQuery string `protobuf:"bytes,7,opt,name=corrected_query,json=correctedQuery,proto3" json:"corrected_query,omitempty"`
	// A summary as part of the search results.
	// This field is only returned if
	// [SearchRequest.ContentSearchSpec.summary_spec][google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.summary_spec]
	// is set.
	Summary *SearchResponse_Summary `protobuf:"bytes,9,opt,name=summary,proto3" json:"summary,omitempty"`
	// Controls applied as part of the Control service.
	AppliedControls    []string                             `protobuf:"bytes,10,rep,name=applied_controls,json=appliedControls,proto3" json:"applied_controls,omitempty"`
	GeoSearchDebugInfo []*SearchResponse_GeoSearchDebugInfo `protobuf:"bytes,16,rep,name=geo_search_debug_info,json=geoSearchDebugInfo,proto3" json:"geo_search_debug_info,omitempty"`
	// Query expansion information for the returned results.
	QueryExpansionInfo *SearchResponse_QueryExpansionInfo `protobuf:"bytes,14,opt,name=query_expansion_info,json=queryExpansionInfo,proto3" json:"query_expansion_info,omitempty"`
}

func (x *SearchResponse) Reset() {
	*x = SearchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse) ProtoMessage() {}

func (x *SearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse.ProtoReflect.Descriptor instead.
func (*SearchResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1}
}

func (x *SearchResponse) GetResults() []*SearchResponse_SearchResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchResponse) GetFacets() []*SearchResponse_Facet {
	if x != nil {
		return x.Facets
	}
	return nil
}

func (x *SearchResponse) GetGuidedSearchResult() *SearchResponse_GuidedSearchResult {
	if x != nil {
		return x.GuidedSearchResult
	}
	return nil
}

func (x *SearchResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

func (x *SearchResponse) GetAttributionToken() string {
	if x != nil {
		return x.AttributionToken
	}
	return ""
}

func (x *SearchResponse) GetRedirectUri() string {
	if x != nil {
		return x.RedirectUri
	}
	return ""
}

func (x *SearchResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *SearchResponse) GetCorrectedQuery() string {
	if x != nil {
		return x.CorrectedQuery
	}
	return ""
}

func (x *SearchResponse) GetSummary() *SearchResponse_Summary {
	if x != nil {
		return x.Summary
	}
	return nil
}

func (x *SearchResponse) GetAppliedControls() []string {
	if x != nil {
		return x.AppliedControls
	}
	return nil
}

func (x *SearchResponse) GetGeoSearchDebugInfo() []*SearchResponse_GeoSearchDebugInfo {
	if x != nil {
		return x.GeoSearchDebugInfo
	}
	return nil
}

func (x *SearchResponse) GetQueryExpansionInfo() *SearchResponse_QueryExpansionInfo {
	if x != nil {
		return x.QueryExpansionInfo
	}
	return nil
}

// Specifies the image query input.
type SearchRequest_ImageQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Image:
	//
	//	*SearchRequest_ImageQuery_ImageBytes
	Image isSearchRequest_ImageQuery_Image `protobuf_oneof:"image"`
}

func (x *SearchRequest_ImageQuery) Reset() {
	*x = SearchRequest_ImageQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_ImageQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_ImageQuery) ProtoMessage() {}

func (x *SearchRequest_ImageQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_ImageQuery.ProtoReflect.Descriptor instead.
func (*SearchRequest_ImageQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 0}
}

func (m *SearchRequest_ImageQuery) GetImage() isSearchRequest_ImageQuery_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (x *SearchRequest_ImageQuery) GetImageBytes() string {
	if x, ok := x.GetImage().(*SearchRequest_ImageQuery_ImageBytes); ok {
		return x.ImageBytes
	}
	return ""
}

type isSearchRequest_ImageQuery_Image interface {
	isSearchRequest_ImageQuery_Image()
}

type SearchRequest_ImageQuery_ImageBytes struct {
	// Base64 encoded image bytes. Supported image formats: JPEG, PNG, and
	// BMP.
	ImageBytes string `protobuf:"bytes,1,opt,name=image_bytes,json=imageBytes,proto3,oneof"`
}

func (*SearchRequest_ImageQuery_ImageBytes) isSearchRequest_ImageQuery_Image() {}

// A struct to define data stores to filter on in a search call and
// configurations for those data stores. A maximum of 1 DataStoreSpec per
// data_store is allowed. Otherwise, an `INVALID_ARGUMENT` error is returned.
type SearchRequest_DataStoreSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of
	// [DataStore][google.cloud.discoveryengine.v1alpha.DataStore], such as
	// `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`.
	DataStore string `protobuf:"bytes,1,opt,name=data_store,json=dataStore,proto3" json:"data_store,omitempty"`
}

func (x *SearchRequest_DataStoreSpec) Reset() {
	*x = SearchRequest_DataStoreSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_DataStoreSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_DataStoreSpec) ProtoMessage() {}

func (x *SearchRequest_DataStoreSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_DataStoreSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_DataStoreSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 1}
}

func (x *SearchRequest_DataStoreSpec) GetDataStore() string {
	if x != nil {
		return x.DataStore
	}
	return ""
}

// A facet specification to perform faceted search.
type SearchRequest_FacetSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The facet key specification.
	FacetKey *SearchRequest_FacetSpec_FacetKey `protobuf:"bytes,1,opt,name=facet_key,json=facetKey,proto3" json:"facet_key,omitempty"`
	// Maximum facet values that are returned for this facet. If
	// unspecified, defaults to 20. The maximum allowed value is 300. Values
	// above 300 are coerced to 300.
	//
	// If this field is negative, an  `INVALID_ARGUMENT`  is returned.
	Limit int32 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	// List of keys to exclude when faceting.
	//
	// By default,
	// [FacetKey.key][google.cloud.discoveryengine.v1alpha.SearchRequest.FacetSpec.FacetKey.key]
	// is not excluded from the filter unless it is listed in this field.
	//
	// Listing a facet key in this field allows its values to appear as facet
	// results, even when they are filtered out of search results. Using this
	// field does not affect what search results are returned.
	//
	// For example, suppose there are 100 documents with the color facet "Red"
	// and 200 documents with the color facet "Blue". A query containing the
	// filter "color:ANY("Red")" and having "color" as
	// [FacetKey.key][google.cloud.discoveryengine.v1alpha.SearchRequest.FacetSpec.FacetKey.key]
	// would by default return only "Red" documents in the search results, and
	// also return "Red" with count 100 as the only color facet. Although there
	// are also blue documents available, "Blue" would not be shown as an
	// available facet value.
	//
	// If "color" is listed in "excludedFilterKeys", then the query returns the
	// facet values "Red" with count 100 and "Blue" with count 200, because the
	// "color" key is now excluded from the filter. Because this field doesn't
	// affect search results, the search results are still correctly filtered to
	// return only "Red" documents.
	//
	// A maximum of 100 values are allowed. Otherwise, an  `INVALID_ARGUMENT`
	// error is returned.
	ExcludedFilterKeys []string `protobuf:"bytes,3,rep,name=excluded_filter_keys,json=excludedFilterKeys,proto3" json:"excluded_filter_keys,omitempty"`
	// Enables dynamic position for this facet. If set to true, the position of
	// this facet among all facets in the response is determined automatically.
	// If dynamic facets are enabled, it is ordered together.
	// If set to false, the position of this facet in the
	// response is the same as in the request, and it is ranked before
	// the facets with dynamic position enable and all dynamic facets.
	//
	// For example, you may always want to have rating facet returned in
	// the response, but it's not necessarily to always display the rating facet
	// at the top. In that case, you can set enable_dynamic_position to true so
	// that the position of rating facet in response is determined
	// automatically.
	//
	// Another example, assuming you have the following facets in the request:
	//
	// * "rating", enable_dynamic_position = true
	//
	// * "price", enable_dynamic_position = false
	//
	// * "brands", enable_dynamic_position = false
	//
	// And also you have a dynamic facets enabled, which generates a facet
	// `gender`. Then the final order of the facets in the response can be
	// ("price", "brands", "rating", "gender") or ("price", "brands", "gender",
	// "rating") depends on how API orders "gender" and "rating" facets.
	// However, notice that "price" and "brands" are always
	// ranked at first and second position because their enable_dynamic_position
	// is false.
	EnableDynamicPosition bool `protobuf:"varint,4,opt,name=enable_dynamic_position,json=enableDynamicPosition,proto3" json:"enable_dynamic_position,omitempty"`
}

func (x *SearchRequest_FacetSpec) Reset() {
	*x = SearchRequest_FacetSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_FacetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_FacetSpec) ProtoMessage() {}

func (x *SearchRequest_FacetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_FacetSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_FacetSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 2}
}

func (x *SearchRequest_FacetSpec) GetFacetKey() *SearchRequest_FacetSpec_FacetKey {
	if x != nil {
		return x.FacetKey
	}
	return nil
}

func (x *SearchRequest_FacetSpec) GetLimit() int32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *SearchRequest_FacetSpec) GetExcludedFilterKeys() []string {
	if x != nil {
		return x.ExcludedFilterKeys
	}
	return nil
}

func (x *SearchRequest_FacetSpec) GetEnableDynamicPosition() bool {
	if x != nil {
		return x.EnableDynamicPosition
	}
	return false
}

// Boost specification to boost certain documents.
type SearchRequest_BoostSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Condition boost specifications. If a document matches multiple conditions
	// in the specifictions, boost scores from these specifications are all
	// applied and combined in a non-linear way. Maximum number of
	// specifications is 20.
	ConditionBoostSpecs []*SearchRequest_BoostSpec_ConditionBoostSpec `protobuf:"bytes,1,rep,name=condition_boost_specs,json=conditionBoostSpecs,proto3" json:"condition_boost_specs,omitempty"`
}

func (x *SearchRequest_BoostSpec) Reset() {
	*x = SearchRequest_BoostSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_BoostSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_BoostSpec) ProtoMessage() {}

func (x *SearchRequest_BoostSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_BoostSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_BoostSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 3}
}

func (x *SearchRequest_BoostSpec) GetConditionBoostSpecs() []*SearchRequest_BoostSpec_ConditionBoostSpec {
	if x != nil {
		return x.ConditionBoostSpecs
	}
	return nil
}

// Specification to determine under which conditions query expansion should
// occur.
type SearchRequest_QueryExpansionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The condition under which query expansion should occur. Default to
	// [Condition.DISABLED][google.cloud.discoveryengine.v1alpha.SearchRequest.QueryExpansionSpec.Condition.DISABLED].
	Condition SearchRequest_QueryExpansionSpec_Condition `protobuf:"varint,1,opt,name=condition,proto3,enum=google.cloud.discoveryengine.v1alpha.SearchRequest_QueryExpansionSpec_Condition" json:"condition,omitempty"`
	// Whether to pin unexpanded results. If this field is set to true,
	// unexpanded products are always at the top of the search results, followed
	// by the expanded results.
	PinUnexpandedResults bool `protobuf:"varint,2,opt,name=pin_unexpanded_results,json=pinUnexpandedResults,proto3" json:"pin_unexpanded_results,omitempty"`
}

func (x *SearchRequest_QueryExpansionSpec) Reset() {
	*x = SearchRequest_QueryExpansionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_QueryExpansionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_QueryExpansionSpec) ProtoMessage() {}

func (x *SearchRequest_QueryExpansionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_QueryExpansionSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_QueryExpansionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 4}
}

func (x *SearchRequest_QueryExpansionSpec) GetCondition() SearchRequest_QueryExpansionSpec_Condition {
	if x != nil {
		return x.Condition
	}
	return SearchRequest_QueryExpansionSpec_CONDITION_UNSPECIFIED
}

func (x *SearchRequest_QueryExpansionSpec) GetPinUnexpandedResults() bool {
	if x != nil {
		return x.PinUnexpandedResults
	}
	return false
}

// The specification for query spell correction.
type SearchRequest_SpellCorrectionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mode under which spell correction
	// replaces the original search query. Defaults to
	// [Mode.AUTO][google.cloud.discoveryengine.v1alpha.SearchRequest.SpellCorrectionSpec.Mode.AUTO].
	Mode SearchRequest_SpellCorrectionSpec_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.discoveryengine.v1alpha.SearchRequest_SpellCorrectionSpec_Mode" json:"mode,omitempty"`
}

func (x *SearchRequest_SpellCorrectionSpec) Reset() {
	*x = SearchRequest_SpellCorrectionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_SpellCorrectionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_SpellCorrectionSpec) ProtoMessage() {}

func (x *SearchRequest_SpellCorrectionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_SpellCorrectionSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_SpellCorrectionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 5}
}

func (x *SearchRequest_SpellCorrectionSpec) GetMode() SearchRequest_SpellCorrectionSpec_Mode {
	if x != nil {
		return x.Mode
	}
	return SearchRequest_SpellCorrectionSpec_MODE_UNSPECIFIED
}

// A specification for configuring the behavior of content search.
type SearchRequest_ContentSearchSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If `snippetSpec` is not specified, snippets are not included in the
	// search response.
	SnippetSpec *SearchRequest_ContentSearchSpec_SnippetSpec `protobuf:"bytes,1,opt,name=snippet_spec,json=snippetSpec,proto3" json:"snippet_spec,omitempty"`
	// If `summarySpec` is not specified, summaries are not included in the
	// search response.
	SummarySpec *SearchRequest_ContentSearchSpec_SummarySpec `protobuf:"bytes,2,opt,name=summary_spec,json=summarySpec,proto3" json:"summary_spec,omitempty"`
	// If there is no extractive_content_spec provided, there will be no
	// extractive answer in the search response.
	ExtractiveContentSpec *SearchRequest_ContentSearchSpec_ExtractiveContentSpec `protobuf:"bytes,3,opt,name=extractive_content_spec,json=extractiveContentSpec,proto3" json:"extractive_content_spec,omitempty"`
	// Specifies the search result mode. If unspecified, the
	// search result mode defaults to `DOCUMENTS`.
	SearchResultMode SearchRequest_ContentSearchSpec_SearchResultMode `protobuf:"varint,4,opt,name=search_result_mode,json=searchResultMode,proto3,enum=google.cloud.discoveryengine.v1alpha.SearchRequest_ContentSearchSpec_SearchResultMode" json:"search_result_mode,omitempty"`
	// Specifies the chunk spec to be returned from the search response.
	// Only available if the
	// [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.search_result_mode]
	// is set to
	// [CHUNKS][google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS]
	ChunkSpec *SearchRequest_ContentSearchSpec_ChunkSpec `protobuf:"bytes,5,opt,name=chunk_spec,json=chunkSpec,proto3" json:"chunk_spec,omitempty"`
}

func (x *SearchRequest_ContentSearchSpec) Reset() {
	*x = SearchRequest_ContentSearchSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_ContentSearchSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_ContentSearchSpec) ProtoMessage() {}

func (x *SearchRequest_ContentSearchSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_ContentSearchSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_ContentSearchSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 6}
}

func (x *SearchRequest_ContentSearchSpec) GetSnippetSpec() *SearchRequest_ContentSearchSpec_SnippetSpec {
	if x != nil {
		return x.SnippetSpec
	}
	return nil
}

func (x *SearchRequest_ContentSearchSpec) GetSummarySpec() *SearchRequest_ContentSearchSpec_SummarySpec {
	if x != nil {
		return x.SummarySpec
	}
	return nil
}

func (x *SearchRequest_ContentSearchSpec) GetExtractiveContentSpec() *SearchRequest_ContentSearchSpec_ExtractiveContentSpec {
	if x != nil {
		return x.ExtractiveContentSpec
	}
	return nil
}

func (x *SearchRequest_ContentSearchSpec) GetSearchResultMode() SearchRequest_ContentSearchSpec_SearchResultMode {
	if x != nil {
		return x.SearchResultMode
	}
	return SearchRequest_ContentSearchSpec_SEARCH_RESULT_MODE_UNSPECIFIED
}

func (x *SearchRequest_ContentSearchSpec) GetChunkSpec() *SearchRequest_ContentSearchSpec_ChunkSpec {
	if x != nil {
		return x.ChunkSpec
	}
	return nil
}

// The specification that uses customized query embedding vector to do
// semantic document retrieval.
type SearchRequest_EmbeddingSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The embedding vector used for retrieval. Limit to 1.
	EmbeddingVectors []*SearchRequest_EmbeddingSpec_EmbeddingVector `protobuf:"bytes,1,rep,name=embedding_vectors,json=embeddingVectors,proto3" json:"embedding_vectors,omitempty"`
}

func (x *SearchRequest_EmbeddingSpec) Reset() {
	*x = SearchRequest_EmbeddingSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_EmbeddingSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_EmbeddingSpec) ProtoMessage() {}

func (x *SearchRequest_EmbeddingSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_EmbeddingSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_EmbeddingSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 7}
}

func (x *SearchRequest_EmbeddingSpec) GetEmbeddingVectors() []*SearchRequest_EmbeddingSpec_EmbeddingVector {
	if x != nil {
		return x.EmbeddingVectors
	}
	return nil
}

// Specifies how a facet is computed.
type SearchRequest_FacetSpec_FacetKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Supported textual and numerical facet keys in
	// [Document][google.cloud.discoveryengine.v1alpha.Document] object, over
	// which the facet values are computed. Facet key is case-sensitive.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Set only if values should be bucketed into intervals. Must be set
	// for facets with numerical values. Must not be set for facet with text
	// values. Maximum number of intervals is 30.
	Intervals []*Interval `protobuf:"bytes,2,rep,name=intervals,proto3" json:"intervals,omitempty"`
	// Only get facet for the given restricted values. Only supported on
	// textual fields. For example, suppose "category" has three values
	// "Action > 2022", "Action > 2021" and "Sci-Fi > 2022". If set
	// "restricted_values" to "Action > 2022", the "category" facet only
	// contains "Action > 2022". Only supported on textual fields. Maximum
	// is 10.
	RestrictedValues []string `protobuf:"bytes,3,rep,name=restricted_values,json=restrictedValues,proto3" json:"restricted_values,omitempty"`
	// Only get facet values that start with the given string prefix. For
	// example, suppose "category" has three values "Action > 2022",
	// "Action > 2021" and "Sci-Fi > 2022". If set "prefixes" to "Action", the
	// "category" facet only contains "Action > 2022" and "Action > 2021".
	// Only supported on textual fields. Maximum is 10.
	Prefixes []string `protobuf:"bytes,4,rep,name=prefixes,proto3" json:"prefixes,omitempty"`
	// Only get facet values that contain the given strings. For example,
	// suppose "category" has three values "Action > 2022",
	// "Action > 2021" and "Sci-Fi > 2022". If set "contains" to "2022", the
	// "category" facet only contains "Action > 2022" and "Sci-Fi > 2022".
	// Only supported on textual fields. Maximum is 10.
	Contains []string `protobuf:"bytes,5,rep,name=contains,proto3" json:"contains,omitempty"`
	// True to make facet keys case insensitive when getting faceting
	// values with prefixes or contains; false otherwise.
	CaseInsensitive bool `protobuf:"varint,6,opt,name=case_insensitive,json=caseInsensitive,proto3" json:"case_insensitive,omitempty"`
	// The order in which documents are returned.
	//
	// Allowed values are:
	//
	// * "count desc", which means order by
	// [SearchResponse.Facet.values.count][google.cloud.discoveryengine.v1alpha.SearchResponse.Facet.FacetValue.count]
	// descending.
	//
	// * "value desc", which means order by
	// [SearchResponse.Facet.values.value][google.cloud.discoveryengine.v1alpha.SearchResponse.Facet.FacetValue.value]
	// descending.
	//
	//	Only applies to textual facets.
	//
	// If not set, textual values are sorted in [natural
	// order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
	// intervals are sorted in the order given by
	// [FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1alpha.SearchRequest.FacetSpec.FacetKey.intervals].
	OrderBy string `protobuf:"bytes,7,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *SearchRequest_FacetSpec_FacetKey) Reset() {
	*x = SearchRequest_FacetSpec_FacetKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_FacetSpec_FacetKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_FacetSpec_FacetKey) ProtoMessage() {}

func (x *SearchRequest_FacetSpec_FacetKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_FacetSpec_FacetKey.ProtoReflect.Descriptor instead.
func (*SearchRequest_FacetSpec_FacetKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *SearchRequest_FacetSpec_FacetKey) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SearchRequest_FacetSpec_FacetKey) GetIntervals() []*Interval {
	if x != nil {
		return x.Intervals
	}
	return nil
}

func (x *SearchRequest_FacetSpec_FacetKey) GetRestrictedValues() []string {
	if x != nil {
		return x.RestrictedValues
	}
	return nil
}

func (x *SearchRequest_FacetSpec_FacetKey) GetPrefixes() []string {
	if x != nil {
		return x.Prefixes
	}
	return nil
}

func (x *SearchRequest_FacetSpec_FacetKey) GetContains() []string {
	if x != nil {
		return x.Contains
	}
	return nil
}

func (x *SearchRequest_FacetSpec_FacetKey) GetCaseInsensitive() bool {
	if x != nil {
		return x.CaseInsensitive
	}
	return false
}

func (x *SearchRequest_FacetSpec_FacetKey) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Boost applies to documents which match a condition.
type SearchRequest_BoostSpec_ConditionBoostSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An expression which specifies a boost condition. The syntax and
	// supported fields are the same as a filter expression. See
	// [SearchRequest.filter][google.cloud.discoveryengine.v1alpha.SearchRequest.filter]
	// for detail syntax and limitations.
	//
	// Examples:
	//
	// * To boost documents with document ID "doc_1" or "doc_2", and
	// color "Red" or "Blue":
	// `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
	Condition string `protobuf:"bytes,1,opt,name=condition,proto3" json:"condition,omitempty"`
	// Strength of the condition boost, which should be in [-1, 1]. Negative
	// boost means demotion. Default is 0.0.
	//
	// Setting to 1.0 gives the document a big promotion. However, it does
	// not necessarily mean that the boosted document will be the top result
	// at all times, nor that other documents will be excluded. Results
	// could still be shown even when none of them matches the condition.
	// And results that are significantly more relevant to the search query
	// can still trump your heavily favored but irrelevant documents.
	//
	// Setting to -1.0 gives the document a big demotion. However, results
	// that are deeply relevant might still be shown. The document will have
	// an upstream battle to get a fairly high ranking, but it is not
	// blocked out completely.
	//
	// Setting to 0.0 means no boost applied. The boosting condition is
	// ignored. Only one of the (condition, boost) combination or the
	// boost_control_spec below are set. If both are set then the global boost
	// is ignored and the more fine-grained boost_control_spec is applied.
	Boost float32 `protobuf:"fixed32,2,opt,name=boost,proto3" json:"boost,omitempty"`
	// Complex specification for custom ranking based on customer defined
	// attribute value.
	BoostControlSpec *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec `protobuf:"bytes,3,opt,name=boost_control_spec,json=boostControlSpec,proto3" json:"boost_control_spec,omitempty"`
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) Reset() {
	*x = SearchRequest_BoostSpec_ConditionBoostSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_BoostSpec_ConditionBoostSpec) ProtoMessage() {}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_BoostSpec_ConditionBoostSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_BoostSpec_ConditionBoostSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 3, 0}
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) GetBoost() float32 {
	if x != nil {
		return x.Boost
	}
	return 0
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec) GetBoostControlSpec() *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec {
	if x != nil {
		return x.BoostControlSpec
	}
	return nil
}

// Specification for custom ranking based on customer specified attribute
// value. It provides more controls for customized ranking than the simple
// (condition, boost) combination above.
type SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the field whose value will be used to determine the
	// boost amount.
	FieldName string `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// The attribute type to be used to determine the boost amount. The
	// attribute value can be derived from the field value of the specified
	// field_name. In the case of numerical it is straightforward i.e.
	// attribute_value = numerical_field_value. In the case of freshness
	// however, attribute_value = (time.now() - datetime_field_value).
	AttributeType SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType `protobuf:"varint,2,opt,name=attribute_type,json=attributeType,proto3,enum=google.cloud.discoveryengine.v1alpha.SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType" json:"attribute_type,omitempty"`
	// The interpolation type to be applied to connect the control points
	// listed below.
	InterpolationType SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType `protobuf:"varint,3,opt,name=interpolation_type,json=interpolationType,proto3,enum=google.cloud.discoveryengine.v1alpha.SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType" json:"interpolation_type,omitempty"`
	// The control points used to define the curve. The monotonic function
	// (defined through the interpolation_type above) passes through the
	// control points listed here.
	ControlPoints []*SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint `protobuf:"bytes,4,rep,name=control_points,json=controlPoints,proto3" json:"control_points,omitempty"`
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec) Reset() {
	*x = SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec) ProtoMessage() {}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 3, 0, 0}
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec) GetAttributeType() SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType {
	if x != nil {
		return x.AttributeType
	}
	return SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ATTRIBUTE_TYPE_UNSPECIFIED
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec) GetInterpolationType() SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType {
	if x != nil {
		return x.InterpolationType
	}
	return SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_INTERPOLATION_TYPE_UNSPECIFIED
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec) GetControlPoints() []*SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint {
	if x != nil {
		return x.ControlPoints
	}
	return nil
}

// The control points used to define the curve. The curve defined
// through these control points can only be monotonically increasing
// or decreasing(constant values are acceptable).
type SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Can be one of:
	// 1. The numerical field value.
	// 2. The duration spec for freshness:
	// The value must be formatted as an XSD `dayTimeDuration` value (a
	// restricted subset of an ISO 8601 duration value). The pattern for
	// this is: `[nD][T[nH][nM][nS]]`.
	AttributeValue string `protobuf:"bytes,1,opt,name=attribute_value,json=attributeValue,proto3" json:"attribute_value,omitempty"`
	// The value between -1 to 1 by which to boost the score if the
	// attribute_value evaluates to the value specified above.
	BoostAmount float32 `protobuf:"fixed32,2,opt,name=boost_amount,json=boostAmount,proto3" json:"boost_amount,omitempty"`
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint) Reset() {
	*x = SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint) ProtoMessage() {}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint.ProtoReflect.Descriptor instead.
func (*SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 3, 0, 0, 0}
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint) GetAttributeValue() string {
	if x != nil {
		return x.AttributeValue
	}
	return ""
}

func (x *SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint) GetBoostAmount() float32 {
	if x != nil {
		return x.BoostAmount
	}
	return 0
}

// A specification for configuring snippets in a search response.
type SearchRequest_ContentSearchSpec_SnippetSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [DEPRECATED] This field is deprecated. To control snippet return, use
	// `return_snippet` field. For backwards compatibility, we will return
	// snippet if max_snippet_count > 0.
	//
	// Deprecated: Marked as deprecated in google/cloud/discoveryengine/v1alpha/search_service.proto.
	MaxSnippetCount int32 `protobuf:"varint,1,opt,name=max_snippet_count,json=maxSnippetCount,proto3" json:"max_snippet_count,omitempty"`
	// [DEPRECATED] This field is deprecated and will have no affect on the
	// snippet.
	//
	// Deprecated: Marked as deprecated in google/cloud/discoveryengine/v1alpha/search_service.proto.
	ReferenceOnly bool `protobuf:"varint,2,opt,name=reference_only,json=referenceOnly,proto3" json:"reference_only,omitempty"`
	// If `true`, then return snippet. If no snippet can be generated, we
	// return "No snippet is available for this page." A `snippet_status` with
	// `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also be returned.
	ReturnSnippet bool `protobuf:"varint,3,opt,name=return_snippet,json=returnSnippet,proto3" json:"return_snippet,omitempty"`
}

func (x *SearchRequest_ContentSearchSpec_SnippetSpec) Reset() {
	*x = SearchRequest_ContentSearchSpec_SnippetSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_ContentSearchSpec_SnippetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_ContentSearchSpec_SnippetSpec) ProtoMessage() {}

func (x *SearchRequest_ContentSearchSpec_SnippetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_ContentSearchSpec_SnippetSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_ContentSearchSpec_SnippetSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 6, 0}
}

// Deprecated: Marked as deprecated in google/cloud/discoveryengine/v1alpha/search_service.proto.
func (x *SearchRequest_ContentSearchSpec_SnippetSpec) GetMaxSnippetCount() int32 {
	if x != nil {
		return x.MaxSnippetCount
	}
	return 0
}

// Deprecated: Marked as deprecated in google/cloud/discoveryengine/v1alpha/search_service.proto.
func (x *SearchRequest_ContentSearchSpec_SnippetSpec) GetReferenceOnly() bool {
	if x != nil {
		return x.ReferenceOnly
	}
	return false
}

func (x *SearchRequest_ContentSearchSpec_SnippetSpec) GetReturnSnippet() bool {
	if x != nil {
		return x.ReturnSnippet
	}
	return false
}

// A specification for configuring a summary returned in a search
// response.
type SearchRequest_ContentSearchSpec_SummarySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of top results to generate the summary from. If the number
	// of results returned is less than `summaryResultCount`, the summary is
	// generated from all of the results.
	//
	// At most 10 results for documents mode, or 50 for chunks mode, can be
	// used to generate a summary. The chunks mode is used when
	// [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.search_result_mode]
	// is set to
	// [CHUNKS][google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
	SummaryResultCount int32 `protobuf:"varint,1,opt,name=summary_result_count,json=summaryResultCount,proto3" json:"summary_result_count,omitempty"`
	// Specifies whether to include citations in the summary. The default
	// value is `false`.
	//
	// When this field is set to `true`, summaries include in-line citation
	// numbers.
	//
	// Example summary including citations:
	//
	// BigQuery is Google Cloud's fully managed and completely serverless
	// enterprise data warehouse [1]. BigQuery supports all data types, works
	// across clouds, and has built-in machine learning and business
	// intelligence, all within a unified platform [2, 3].
	//
	// The citation numbers refer to the returned search results and are
	// 1-indexed. For example, [1] means that the sentence is attributed to
	// the first search result. [2, 3] means that the sentence is attributed
	// to both the second and third search results.
	IncludeCitations bool `protobuf:"varint,2,opt,name=include_citations,json=includeCitations,proto3" json:"include_citations,omitempty"`
	// Specifies whether to filter out adversarial queries. The default value
	// is `false`.
	//
	// Google employs search-query classification to detect adversarial
	// queries. No summary is returned if the search query is classified as an
	// adversarial query. For example, a user might ask a question regarding
	// negative comments about the company or submit a query designed to
	// generate unsafe, policy-violating output. If this field is set to
	// `true`, we skip generating summaries for adversarial queries and return
	// fallback messages instead.
	IgnoreAdversarialQuery bool `protobuf:"varint,3,opt,name=ignore_adversarial_query,json=ignoreAdversarialQuery,proto3" json:"ignore_adversarial_query,omitempty"`
	// Specifies whether to filter out queries that are not summary-seeking.
	// The default value is `false`.
	//
	// Google employs search-query classification to detect summary-seeking
	// queries. No summary is returned if the search query is classified as a
	// non-summary seeking query. For example, `why is the sky blue` and `Who
	// is the best soccer player in the world?` are summary-seeking queries,
	// but `SFO airport` and `world cup 2026` are not. They are most likely
	// navigational queries. If this field is set to `true`, we skip
	// generating summaries for non-summary seeking queries and return
	// fallback messages instead.
	IgnoreNonSummarySeekingQuery bool `protobuf:"varint,4,opt,name=ignore_non_summary_seeking_query,json=ignoreNonSummarySeekingQuery,proto3" json:"ignore_non_summary_seeking_query,omitempty"`
	// If specified, the spec will be used to modify the prompt provided to
	// the LLM.
	ModelPromptSpec *SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec `protobuf:"bytes,5,opt,name=model_prompt_spec,json=modelPromptSpec,proto3" json:"model_prompt_spec,omitempty"`
	// Language code for Summary. Use language tags defined by
	// [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
	// Note: This is an experimental feature.
	LanguageCode string `protobuf:"bytes,6,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// If specified, the spec will be used to modify the model specification
	// provided to the LLM.
	ModelSpec *SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec `protobuf:"bytes,7,opt,name=model_spec,json=modelSpec,proto3" json:"model_spec,omitempty"`
	// If true, answer will be generated from most relevant chunks from top
	// search results. This feature will improve summary quality.
	// Note that with this feature enabled, not all top search results
	// will be referenced and included in the reference list, so the citation
	// source index only points to the search results listed in the reference
	// list.
	UseSemanticChunks bool `protobuf:"varint,8,opt,name=use_semantic_chunks,json=useSemanticChunks,proto3" json:"use_semantic_chunks,omitempty"`
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec) Reset() {
	*x = SearchRequest_ContentSearchSpec_SummarySpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_ContentSearchSpec_SummarySpec) ProtoMessage() {}

func (x *SearchRequest_ContentSearchSpec_SummarySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_ContentSearchSpec_SummarySpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_ContentSearchSpec_SummarySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 6, 1}
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec) GetSummaryResultCount() int32 {
	if x != nil {
		return x.SummaryResultCount
	}
	return 0
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec) GetIncludeCitations() bool {
	if x != nil {
		return x.IncludeCitations
	}
	return false
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec) GetIgnoreAdversarialQuery() bool {
	if x != nil {
		return x.IgnoreAdversarialQuery
	}
	return false
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec) GetIgnoreNonSummarySeekingQuery() bool {
	if x != nil {
		return x.IgnoreNonSummarySeekingQuery
	}
	return false
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec) GetModelPromptSpec() *SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec {
	if x != nil {
		return x.ModelPromptSpec
	}
	return nil
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec) GetModelSpec() *SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec {
	if x != nil {
		return x.ModelSpec
	}
	return nil
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec) GetUseSemanticChunks() bool {
	if x != nil {
		return x.UseSemanticChunks
	}
	return false
}

// A specification for configuring the extractive content in a search
// response.
type SearchRequest_ContentSearchSpec_ExtractiveContentSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of extractive answers returned in each search
	// result.
	//
	// An extractive answer is a verbatim answer extracted from the original
	// document, which provides a precise and contextually relevant answer to
	// the search query.
	//
	// If the number of matching answers is less than the
	// `max_extractive_answer_count`, return all of the answers. Otherwise,
	// return the `max_extractive_answer_count`.
	//
	// At most five answers are returned for each
	// [SearchResult][google.cloud.discoveryengine.v1alpha.SearchResponse.SearchResult].
	MaxExtractiveAnswerCount int32 `protobuf:"varint,1,opt,name=max_extractive_answer_count,json=maxExtractiveAnswerCount,proto3" json:"max_extractive_answer_count,omitempty"`
	// The max number of extractive segments returned in each search result.
	// Only applied if the
	// [DataStore][google.cloud.discoveryengine.v1alpha.DataStore] is set to
	// [DataStore.ContentConfig.CONTENT_REQUIRED][google.cloud.discoveryengine.v1alpha.DataStore.ContentConfig.CONTENT_REQUIRED]
	// or
	// [DataStore.solution_types][google.cloud.discoveryengine.v1alpha.DataStore.solution_types]
	// is
	// [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_CHAT].
	//
	// An extractive segment is a text segment extracted from the original
	// document that is relevant to the search query, and, in general, more
	// verbose than an extractive answer. The segment could then be used as
	// input for LLMs to generate summaries and answers.
	//
	// If the number of matching segments is less than
	// `max_extractive_segment_count`, return all of the segments. Otherwise,
	// return the `max_extractive_segment_count`.
	MaxExtractiveSegmentCount int32 `protobuf:"varint,2,opt,name=max_extractive_segment_count,json=maxExtractiveSegmentCount,proto3" json:"max_extractive_segment_count,omitempty"`
	// Specifies whether to return the confidence score from the extractive
	// segments in each search result. This feature is available only for new
	// or allowlisted data stores. To allowlist your data store,
	// contact your Customer Engineer. The default value is `false`.
	ReturnExtractiveSegmentScore bool `protobuf:"varint,3,opt,name=return_extractive_segment_score,json=returnExtractiveSegmentScore,proto3" json:"return_extractive_segment_score,omitempty"`
	// Specifies whether to also include the adjacent from each selected
	// segments.
	// Return at most `num_previous_segments` segments before each selected
	// segments.
	NumPreviousSegments int32 `protobuf:"varint,4,opt,name=num_previous_segments,json=numPreviousSegments,proto3" json:"num_previous_segments,omitempty"`
	// Return at most `num_next_segments` segments after each selected
	// segments.
	NumNextSegments int32 `protobuf:"varint,5,opt,name=num_next_segments,json=numNextSegments,proto3" json:"num_next_segments,omitempty"`
}

func (x *SearchRequest_ContentSearchSpec_ExtractiveContentSpec) Reset() {
	*x = SearchRequest_ContentSearchSpec_ExtractiveContentSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_ContentSearchSpec_ExtractiveContentSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_ContentSearchSpec_ExtractiveContentSpec) ProtoMessage() {}

func (x *SearchRequest_ContentSearchSpec_ExtractiveContentSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_ContentSearchSpec_ExtractiveContentSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_ContentSearchSpec_ExtractiveContentSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 6, 2}
}

func (x *SearchRequest_ContentSearchSpec_ExtractiveContentSpec) GetMaxExtractiveAnswerCount() int32 {
	if x != nil {
		return x.MaxExtractiveAnswerCount
	}
	return 0
}

func (x *SearchRequest_ContentSearchSpec_ExtractiveContentSpec) GetMaxExtractiveSegmentCount() int32 {
	if x != nil {
		return x.MaxExtractiveSegmentCount
	}
	return 0
}

func (x *SearchRequest_ContentSearchSpec_ExtractiveContentSpec) GetReturnExtractiveSegmentScore() bool {
	if x != nil {
		return x.ReturnExtractiveSegmentScore
	}
	return false
}

func (x *SearchRequest_ContentSearchSpec_ExtractiveContentSpec) GetNumPreviousSegments() int32 {
	if x != nil {
		return x.NumPreviousSegments
	}
	return 0
}

func (x *SearchRequest_ContentSearchSpec_ExtractiveContentSpec) GetNumNextSegments() int32 {
	if x != nil {
		return x.NumNextSegments
	}
	return 0
}

// Specifies the chunk spec to be returned from the search response.
// Only available if the
// [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.search_result_mode]
// is set to
// [CHUNKS][google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS]
type SearchRequest_ContentSearchSpec_ChunkSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of previous chunks to be returned of the current chunk. The
	// maximum allowed value is 3.
	// If not specified, no previous chunks will be returned.
	NumPreviousChunks int32 `protobuf:"varint,1,opt,name=num_previous_chunks,json=numPreviousChunks,proto3" json:"num_previous_chunks,omitempty"`
	// The number of next chunks to be returned of the current chunk. The
	// maximum allowed value is 3.
	// If not specified, no next chunks will be returned.
	NumNextChunks int32 `protobuf:"varint,2,opt,name=num_next_chunks,json=numNextChunks,proto3" json:"num_next_chunks,omitempty"`
}

func (x *SearchRequest_ContentSearchSpec_ChunkSpec) Reset() {
	*x = SearchRequest_ContentSearchSpec_ChunkSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_ContentSearchSpec_ChunkSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_ContentSearchSpec_ChunkSpec) ProtoMessage() {}

func (x *SearchRequest_ContentSearchSpec_ChunkSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_ContentSearchSpec_ChunkSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_ContentSearchSpec_ChunkSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 6, 3}
}

func (x *SearchRequest_ContentSearchSpec_ChunkSpec) GetNumPreviousChunks() int32 {
	if x != nil {
		return x.NumPreviousChunks
	}
	return 0
}

func (x *SearchRequest_ContentSearchSpec_ChunkSpec) GetNumNextChunks() int32 {
	if x != nil {
		return x.NumNextChunks
	}
	return 0
}

// Specification of the prompt to use with the model.
type SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Text at the beginning of the prompt that instructs the assistant.
	// Examples are available in the user guide.
	Preamble string `protobuf:"bytes,1,opt,name=preamble,proto3" json:"preamble,omitempty"`
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec) Reset() {
	*x = SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec) ProtoMessage() {}

func (x *SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 6, 1, 0}
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec) GetPreamble() string {
	if x != nil {
		return x.Preamble
	}
	return ""
}

// Specification of the model.
type SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The model version used to generate the summary.
	//
	// Supported values are:
	//
	//   - `stable`: string. Default value when no value is specified. Uses a
	//     generally available, fine-tuned model. For more information, see
	//     [Answer generation model versions and
	//     lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
	//   - `preview`: string. (Public preview) Uses a preview model. For more
	//     information, see
	//     [Answer generation model versions and
	//     lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec) Reset() {
	*x = SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec) ProtoMessage() {}

func (x *SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec.ProtoReflect.Descriptor instead.
func (*SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 6, 1, 1}
}

func (x *SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// Embedding vector.
type SearchRequest_EmbeddingSpec_EmbeddingVector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Embedding field path in schema.
	FieldPath string `protobuf:"bytes,1,opt,name=field_path,json=fieldPath,proto3" json:"field_path,omitempty"`
	// Query embedding vector.
	Vector []float32 `protobuf:"fixed32,2,rep,packed,name=vector,proto3" json:"vector,omitempty"`
}

func (x *SearchRequest_EmbeddingSpec_EmbeddingVector) Reset() {
	*x = SearchRequest_EmbeddingSpec_EmbeddingVector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchRequest_EmbeddingSpec_EmbeddingVector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest_EmbeddingSpec_EmbeddingVector) ProtoMessage() {}

func (x *SearchRequest_EmbeddingSpec_EmbeddingVector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest_EmbeddingSpec_EmbeddingVector.ProtoReflect.Descriptor instead.
func (*SearchRequest_EmbeddingSpec_EmbeddingVector) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{0, 7, 0}
}

func (x *SearchRequest_EmbeddingSpec_EmbeddingVector) GetFieldPath() string {
	if x != nil {
		return x.FieldPath
	}
	return ""
}

func (x *SearchRequest_EmbeddingSpec_EmbeddingVector) GetVector() []float32 {
	if x != nil {
		return x.Vector
	}
	return nil
}

// Represents the search results.
type SearchResponse_SearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Document.id][google.cloud.discoveryengine.v1alpha.Document.id] of the
	// searched [Document][google.cloud.discoveryengine.v1alpha.Document].
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The document data snippet in the search response. Only fields that are
	// marked as `retrievable` are populated.
	Document *Document `protobuf:"bytes,2,opt,name=document,proto3" json:"document,omitempty"`
	// The chunk data in the search response if the
	// [SearchRequest.ContentSearchSpec.search_result_mode][google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.search_result_mode]
	// is set to
	// [CHUNKS][google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SearchResultMode.CHUNKS].
	Chunk *Chunk `protobuf:"bytes,18,opt,name=chunk,proto3" json:"chunk,omitempty"`
	// Google provided available scores.
	ModelScores map[string]*DoubleList `protobuf:"bytes,4,rep,name=model_scores,json=modelScores,proto3" json:"model_scores,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *SearchResponse_SearchResult) Reset() {
	*x = SearchResponse_SearchResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_SearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_SearchResult) ProtoMessage() {}

func (x *SearchResponse_SearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_SearchResult.ProtoReflect.Descriptor instead.
func (*SearchResponse_SearchResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 0}
}

func (x *SearchResponse_SearchResult) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *SearchResponse_SearchResult) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *SearchResponse_SearchResult) GetChunk() *Chunk {
	if x != nil {
		return x.Chunk
	}
	return nil
}

func (x *SearchResponse_SearchResult) GetModelScores() map[string]*DoubleList {
	if x != nil {
		return x.ModelScores
	}
	return nil
}

// A facet result.
type SearchResponse_Facet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key for this facet. For example, `"colors"` or `"price"`. It matches
	// [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1alpha.SearchRequest.FacetSpec.FacetKey.key].
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The facet values for this field.
	Values []*SearchResponse_Facet_FacetValue `protobuf:"bytes,2,rep,name=values,proto3" json:"values,omitempty"`
	// Whether the facet is dynamically generated.
	DynamicFacet bool `protobuf:"varint,3,opt,name=dynamic_facet,json=dynamicFacet,proto3" json:"dynamic_facet,omitempty"`
}

func (x *SearchResponse_Facet) Reset() {
	*x = SearchResponse_Facet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_Facet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_Facet) ProtoMessage() {}

func (x *SearchResponse_Facet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_Facet.ProtoReflect.Descriptor instead.
func (*SearchResponse_Facet) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 1}
}

func (x *SearchResponse_Facet) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SearchResponse_Facet) GetValues() []*SearchResponse_Facet_FacetValue {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *SearchResponse_Facet) GetDynamicFacet() bool {
	if x != nil {
		return x.DynamicFacet
	}
	return false
}

// Guided search result. The guided search helps user to refine the search
// results and narrow down to the real needs from a broaded search results.
type SearchResponse_GuidedSearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of ranked refinement attributes.
	RefinementAttributes []*SearchResponse_GuidedSearchResult_RefinementAttribute `protobuf:"bytes,1,rep,name=refinement_attributes,json=refinementAttributes,proto3" json:"refinement_attributes,omitempty"`
	// Suggested follow-up questions.
	FollowUpQuestions []string `protobuf:"bytes,2,rep,name=follow_up_questions,json=followUpQuestions,proto3" json:"follow_up_questions,omitempty"`
}

func (x *SearchResponse_GuidedSearchResult) Reset() {
	*x = SearchResponse_GuidedSearchResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_GuidedSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_GuidedSearchResult) ProtoMessage() {}

func (x *SearchResponse_GuidedSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_GuidedSearchResult.ProtoReflect.Descriptor instead.
func (*SearchResponse_GuidedSearchResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 2}
}

func (x *SearchResponse_GuidedSearchResult) GetRefinementAttributes() []*SearchResponse_GuidedSearchResult_RefinementAttribute {
	if x != nil {
		return x.RefinementAttributes
	}
	return nil
}

func (x *SearchResponse_GuidedSearchResult) GetFollowUpQuestions() []string {
	if x != nil {
		return x.FollowUpQuestions
	}
	return nil
}

// Summary of the top N search results specified by the summary spec.
type SearchResponse_Summary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The summary content.
	SummaryText string `protobuf:"bytes,1,opt,name=summary_text,json=summaryText,proto3" json:"summary_text,omitempty"`
	// Additional summary-skipped reasons. This provides the reason for ignored
	// cases. If nothing is skipped, this field is not set.
	SummarySkippedReasons []SearchResponse_Summary_SummarySkippedReason `protobuf:"varint,2,rep,packed,name=summary_skipped_reasons,json=summarySkippedReasons,proto3,enum=google.cloud.discoveryengine.v1alpha.SearchResponse_Summary_SummarySkippedReason" json:"summary_skipped_reasons,omitempty"`
	// A collection of Safety Attribute categories and their associated
	// confidence scores.
	SafetyAttributes *SearchResponse_Summary_SafetyAttributes `protobuf:"bytes,3,opt,name=safety_attributes,json=safetyAttributes,proto3" json:"safety_attributes,omitempty"`
	// Summary with metadata information.
	SummaryWithMetadata *SearchResponse_Summary_SummaryWithMetadata `protobuf:"bytes,4,opt,name=summary_with_metadata,json=summaryWithMetadata,proto3" json:"summary_with_metadata,omitempty"`
}

func (x *SearchResponse_Summary) Reset() {
	*x = SearchResponse_Summary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_Summary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_Summary) ProtoMessage() {}

func (x *SearchResponse_Summary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_Summary.ProtoReflect.Descriptor instead.
func (*SearchResponse_Summary) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 3}
}

func (x *SearchResponse_Summary) GetSummaryText() string {
	if x != nil {
		return x.SummaryText
	}
	return ""
}

func (x *SearchResponse_Summary) GetSummarySkippedReasons() []SearchResponse_Summary_SummarySkippedReason {
	if x != nil {
		return x.SummarySkippedReasons
	}
	return nil
}

func (x *SearchResponse_Summary) GetSafetyAttributes() *SearchResponse_Summary_SafetyAttributes {
	if x != nil {
		return x.SafetyAttributes
	}
	return nil
}

func (x *SearchResponse_Summary) GetSummaryWithMetadata() *SearchResponse_Summary_SummaryWithMetadata {
	if x != nil {
		return x.SummaryWithMetadata
	}
	return nil
}

// Debug information specifically related to forward geocoding issues arising
// from Geolocation Search.
type SearchResponse_GeoSearchDebugInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The address from which forward geocoding ingestion produced issues.
	OriginalAddressQuery string `protobuf:"bytes,1,opt,name=original_address_query,json=originalAddressQuery,proto3" json:"original_address_query,omitempty"`
	// The error produced.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *SearchResponse_GeoSearchDebugInfo) Reset() {
	*x = SearchResponse_GeoSearchDebugInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_GeoSearchDebugInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_GeoSearchDebugInfo) ProtoMessage() {}

func (x *SearchResponse_GeoSearchDebugInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_GeoSearchDebugInfo.ProtoReflect.Descriptor instead.
func (*SearchResponse_GeoSearchDebugInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 4}
}

func (x *SearchResponse_GeoSearchDebugInfo) GetOriginalAddressQuery() string {
	if x != nil {
		return x.OriginalAddressQuery
	}
	return ""
}

func (x *SearchResponse_GeoSearchDebugInfo) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

// Information describing query expansion including whether expansion has
// occurred.
type SearchResponse_QueryExpansionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bool describing whether query expansion has occurred.
	ExpandedQuery bool `protobuf:"varint,1,opt,name=expanded_query,json=expandedQuery,proto3" json:"expanded_query,omitempty"`
	// Number of pinned results. This field will only be set when expansion
	// happens and
	// [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.discoveryengine.v1alpha.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
	// is set to true.
	PinnedResultCount int64 `protobuf:"varint,2,opt,name=pinned_result_count,json=pinnedResultCount,proto3" json:"pinned_result_count,omitempty"`
}

func (x *SearchResponse_QueryExpansionInfo) Reset() {
	*x = SearchResponse_QueryExpansionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_QueryExpansionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_QueryExpansionInfo) ProtoMessage() {}

func (x *SearchResponse_QueryExpansionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_QueryExpansionInfo.ProtoReflect.Descriptor instead.
func (*SearchResponse_QueryExpansionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 5}
}

func (x *SearchResponse_QueryExpansionInfo) GetExpandedQuery() bool {
	if x != nil {
		return x.ExpandedQuery
	}
	return false
}

func (x *SearchResponse_QueryExpansionInfo) GetPinnedResultCount() int64 {
	if x != nil {
		return x.PinnedResultCount
	}
	return 0
}

// A facet value which contains value names and their count.
type SearchResponse_Facet_FacetValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A facet value which contains values.
	//
	// Types that are assignable to FacetValue:
	//
	//	*SearchResponse_Facet_FacetValue_Value
	//	*SearchResponse_Facet_FacetValue_Interval
	FacetValue isSearchResponse_Facet_FacetValue_FacetValue `protobuf_oneof:"facet_value"`
	// Number of items that have this facet value.
	Count int64 `protobuf:"varint,3,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *SearchResponse_Facet_FacetValue) Reset() {
	*x = SearchResponse_Facet_FacetValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_Facet_FacetValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_Facet_FacetValue) ProtoMessage() {}

func (x *SearchResponse_Facet_FacetValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_Facet_FacetValue.ProtoReflect.Descriptor instead.
func (*SearchResponse_Facet_FacetValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 1, 0}
}

func (m *SearchResponse_Facet_FacetValue) GetFacetValue() isSearchResponse_Facet_FacetValue_FacetValue {
	if m != nil {
		return m.FacetValue
	}
	return nil
}

func (x *SearchResponse_Facet_FacetValue) GetValue() string {
	if x, ok := x.GetFacetValue().(*SearchResponse_Facet_FacetValue_Value); ok {
		return x.Value
	}
	return ""
}

func (x *SearchResponse_Facet_FacetValue) GetInterval() *Interval {
	if x, ok := x.GetFacetValue().(*SearchResponse_Facet_FacetValue_Interval); ok {
		return x.Interval
	}
	return nil
}

func (x *SearchResponse_Facet_FacetValue) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

type isSearchResponse_Facet_FacetValue_FacetValue interface {
	isSearchResponse_Facet_FacetValue_FacetValue()
}

type SearchResponse_Facet_FacetValue_Value struct {
	// Text value of a facet, such as "Black" for facet "colors".
	Value string `protobuf:"bytes,1,opt,name=value,proto3,oneof"`
}

type SearchResponse_Facet_FacetValue_Interval struct {
	// Interval value for a facet, such as [10, 20) for facet "price". It
	// matches
	// [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1alpha.SearchRequest.FacetSpec.FacetKey.intervals].
	Interval *Interval `protobuf:"bytes,2,opt,name=interval,proto3,oneof"`
}

func (*SearchResponse_Facet_FacetValue_Value) isSearchResponse_Facet_FacetValue_FacetValue() {}

func (*SearchResponse_Facet_FacetValue_Interval) isSearchResponse_Facet_FacetValue_FacetValue() {}

// Useful attribute for search result refinements.
type SearchResponse_GuidedSearchResult_RefinementAttribute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Attribute key used to refine the results. For example, `"movie_type"`.
	AttributeKey string `protobuf:"bytes,1,opt,name=attribute_key,json=attributeKey,proto3" json:"attribute_key,omitempty"`
	// Attribute value used to refine the results. For example, `"drama"`.
	AttributeValue string `protobuf:"bytes,2,opt,name=attribute_value,json=attributeValue,proto3" json:"attribute_value,omitempty"`
}

func (x *SearchResponse_GuidedSearchResult_RefinementAttribute) Reset() {
	*x = SearchResponse_GuidedSearchResult_RefinementAttribute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_GuidedSearchResult_RefinementAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_GuidedSearchResult_RefinementAttribute) ProtoMessage() {}

func (x *SearchResponse_GuidedSearchResult_RefinementAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_GuidedSearchResult_RefinementAttribute.ProtoReflect.Descriptor instead.
func (*SearchResponse_GuidedSearchResult_RefinementAttribute) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 2, 0}
}

func (x *SearchResponse_GuidedSearchResult_RefinementAttribute) GetAttributeKey() string {
	if x != nil {
		return x.AttributeKey
	}
	return ""
}

func (x *SearchResponse_GuidedSearchResult_RefinementAttribute) GetAttributeValue() string {
	if x != nil {
		return x.AttributeValue
	}
	return ""
}

// Safety Attribute categories and their associated confidence scores.
type SearchResponse_Summary_SafetyAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The display names of Safety Attribute categories associated with the
	// generated content. Order matches the Scores.
	Categories []string `protobuf:"bytes,1,rep,name=categories,proto3" json:"categories,omitempty"`
	// The confidence scores of the each category, higher
	// value means higher confidence. Order matches the Categories.
	Scores []float32 `protobuf:"fixed32,2,rep,packed,name=scores,proto3" json:"scores,omitempty"`
}

func (x *SearchResponse_Summary_SafetyAttributes) Reset() {
	*x = SearchResponse_Summary_SafetyAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_Summary_SafetyAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_Summary_SafetyAttributes) ProtoMessage() {}

func (x *SearchResponse_Summary_SafetyAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_Summary_SafetyAttributes.ProtoReflect.Descriptor instead.
func (*SearchResponse_Summary_SafetyAttributes) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 3, 0}
}

func (x *SearchResponse_Summary_SafetyAttributes) GetCategories() []string {
	if x != nil {
		return x.Categories
	}
	return nil
}

func (x *SearchResponse_Summary_SafetyAttributes) GetScores() []float32 {
	if x != nil {
		return x.Scores
	}
	return nil
}

// Citation metadata.
type SearchResponse_Summary_CitationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Citations for segments.
	Citations []*SearchResponse_Summary_Citation `protobuf:"bytes,1,rep,name=citations,proto3" json:"citations,omitempty"`
}

func (x *SearchResponse_Summary_CitationMetadata) Reset() {
	*x = SearchResponse_Summary_CitationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_Summary_CitationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_Summary_CitationMetadata) ProtoMessage() {}

func (x *SearchResponse_Summary_CitationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_Summary_CitationMetadata.ProtoReflect.Descriptor instead.
func (*SearchResponse_Summary_CitationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 3, 1}
}

func (x *SearchResponse_Summary_CitationMetadata) GetCitations() []*SearchResponse_Summary_Citation {
	if x != nil {
		return x.Citations
	}
	return nil
}

// Citation info for a segment.
type SearchResponse_Summary_Citation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index indicates the start of the segment, measured in bytes/unicode.
	StartIndex int64 `protobuf:"varint,1,opt,name=start_index,json=startIndex,proto3" json:"start_index,omitempty"`
	// End of the attributed segment, exclusive.
	EndIndex int64 `protobuf:"varint,2,opt,name=end_index,json=endIndex,proto3" json:"end_index,omitempty"`
	// Citation sources for the attributed segment.
	Sources []*SearchResponse_Summary_CitationSource `protobuf:"bytes,3,rep,name=sources,proto3" json:"sources,omitempty"`
}

func (x *SearchResponse_Summary_Citation) Reset() {
	*x = SearchResponse_Summary_Citation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_Summary_Citation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_Summary_Citation) ProtoMessage() {}

func (x *SearchResponse_Summary_Citation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_Summary_Citation.ProtoReflect.Descriptor instead.
func (*SearchResponse_Summary_Citation) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 3, 2}
}

func (x *SearchResponse_Summary_Citation) GetStartIndex() int64 {
	if x != nil {
		return x.StartIndex
	}
	return 0
}

func (x *SearchResponse_Summary_Citation) GetEndIndex() int64 {
	if x != nil {
		return x.EndIndex
	}
	return 0
}

func (x *SearchResponse_Summary_Citation) GetSources() []*SearchResponse_Summary_CitationSource {
	if x != nil {
		return x.Sources
	}
	return nil
}

// Citation source.
type SearchResponse_Summary_CitationSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Document reference index from SummaryWithMetadata.references.
	// It is 0-indexed and the value will be zero if the reference_index is
	// not set explicitly.
	ReferenceIndex int64 `protobuf:"varint,4,opt,name=reference_index,json=referenceIndex,proto3" json:"reference_index,omitempty"`
}

func (x *SearchResponse_Summary_CitationSource) Reset() {
	*x = SearchResponse_Summary_CitationSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_Summary_CitationSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_Summary_CitationSource) ProtoMessage() {}

func (x *SearchResponse_Summary_CitationSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_Summary_CitationSource.ProtoReflect.Descriptor instead.
func (*SearchResponse_Summary_CitationSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 3, 3}
}

func (x *SearchResponse_Summary_CitationSource) GetReferenceIndex() int64 {
	if x != nil {
		return x.ReferenceIndex
	}
	return 0
}

// Document reference.
type SearchResponse_Summary_Reference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Title of the document.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Required.
	// [Document.name][google.cloud.discoveryengine.v1alpha.Document.name] of
	// the document. Full resource name of the referenced document, in the
	// format
	// `projects/*/locations/*/collections/*/dataStores/*/branches/*/documents/*`.
	Document string `protobuf:"bytes,2,opt,name=document,proto3" json:"document,omitempty"`
	// Cloud Storage or HTTP uri for the document.
	Uri string `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	// List of cited chunk contents derived from document content.
	ChunkContents []*SearchResponse_Summary_Reference_ChunkContent `protobuf:"bytes,4,rep,name=chunk_contents,json=chunkContents,proto3" json:"chunk_contents,omitempty"`
}

func (x *SearchResponse_Summary_Reference) Reset() {
	*x = SearchResponse_Summary_Reference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_Summary_Reference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_Summary_Reference) ProtoMessage() {}

func (x *SearchResponse_Summary_Reference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_Summary_Reference.ProtoReflect.Descriptor instead.
func (*SearchResponse_Summary_Reference) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 3, 4}
}

func (x *SearchResponse_Summary_Reference) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *SearchResponse_Summary_Reference) GetDocument() string {
	if x != nil {
		return x.Document
	}
	return ""
}

func (x *SearchResponse_Summary_Reference) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *SearchResponse_Summary_Reference) GetChunkContents() []*SearchResponse_Summary_Reference_ChunkContent {
	if x != nil {
		return x.ChunkContents
	}
	return nil
}

// Summary with metadata information.
type SearchResponse_Summary_SummaryWithMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Summary text with no citation information.
	Summary string `protobuf:"bytes,1,opt,name=summary,proto3" json:"summary,omitempty"`
	// Citation metadata for given summary.
	CitationMetadata *SearchResponse_Summary_CitationMetadata `protobuf:"bytes,2,opt,name=citation_metadata,json=citationMetadata,proto3" json:"citation_metadata,omitempty"`
	// Document References.
	References []*SearchResponse_Summary_Reference `protobuf:"bytes,3,rep,name=references,proto3" json:"references,omitempty"`
}

func (x *SearchResponse_Summary_SummaryWithMetadata) Reset() {
	*x = SearchResponse_Summary_SummaryWithMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_Summary_SummaryWithMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_Summary_SummaryWithMetadata) ProtoMessage() {}

func (x *SearchResponse_Summary_SummaryWithMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_Summary_SummaryWithMetadata.ProtoReflect.Descriptor instead.
func (*SearchResponse_Summary_SummaryWithMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 3, 5}
}

func (x *SearchResponse_Summary_SummaryWithMetadata) GetSummary() string {
	if x != nil {
		return x.Summary
	}
	return ""
}

func (x *SearchResponse_Summary_SummaryWithMetadata) GetCitationMetadata() *SearchResponse_Summary_CitationMetadata {
	if x != nil {
		return x.CitationMetadata
	}
	return nil
}

func (x *SearchResponse_Summary_SummaryWithMetadata) GetReferences() []*SearchResponse_Summary_Reference {
	if x != nil {
		return x.References
	}
	return nil
}

// Chunk content.
type SearchResponse_Summary_Reference_ChunkContent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Chunk textual content.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Page identifier.
	PageIdentifier string `protobuf:"bytes,2,opt,name=page_identifier,json=pageIdentifier,proto3" json:"page_identifier,omitempty"`
}

func (x *SearchResponse_Summary_Reference_ChunkContent) Reset() {
	*x = SearchResponse_Summary_Reference_ChunkContent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResponse_Summary_Reference_ChunkContent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse_Summary_Reference_ChunkContent) ProtoMessage() {}

func (x *SearchResponse_Summary_Reference_ChunkContent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse_Summary_Reference_ChunkContent.ProtoReflect.Descriptor instead.
func (*SearchResponse_Summary_Reference_ChunkContent) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP(), []int{1, 3, 4, 0}
}

func (x *SearchResponse_Summary_Reference_ChunkContent) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *SearchResponse_Summary_Reference_ChunkContent) GetPageIdentifier() string {
	if x != nil {
		return x.PageIdentifier
	}
	return ""
}

var File_google_cloud_discoveryengine_v1alpha_search_service_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x63, 0x68, 0x75, 0x6e, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd2, 0x31, 0x0a,
	0x0d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b,
	0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x0a, 0x06, 0x62,
	0x72, 0x61, 0x6e, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x41, 0x27,
	0x0a, 0x25, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12,
	0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x5f, 0x0a, 0x0b, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x0a, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x6b, 0x0a, 0x10, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x20,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x29, 0x0a, 0x10, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x61, 0x6e, 0x6f, 0x6e,
	0x69, 0x63, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x4b, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x5e, 0x0a, 0x0b, 0x66, 0x61, 0x63, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x61, 0x63,
	0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0a, 0x66, 0x61, 0x63, 0x65, 0x74, 0x53, 0x70, 0x65,
	0x63, 0x73, 0x12, 0x5c, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x6f, 0x6f, 0x73,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x57, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x78, 0x0a, 0x14, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x12, 0x71, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x7b, 0x0a, 0x15, 0x73, 0x70, 0x65, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x72,
	0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x70, 0x65, 0x6c, 0x6c, 0x43, 0x6f, 0x72,
	0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x13, 0x73, 0x70, 0x65,
	0x6c, 0x6c, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x24, 0x0a, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x70, 0x73, 0x65, 0x75, 0x64, 0x6f, 0x5f,
	0x69, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x50, 0x73,
	0x65, 0x75, 0x64, 0x6f, 0x49, 0x64, 0x12, 0x75, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x18, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x12, 0x68, 0x0a,
	0x0e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x6d, 0x62, 0x65, 0x64,
	0x64, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0d, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x61, 0x6e, 0x6b, 0x69,
	0x6e, 0x67, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x1a, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x11, 0x72, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x61, 0x66, 0x65, 0x5f, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x73, 0x61, 0x66,
	0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x64, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x71, 0x0a,
	0x17, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x75, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x69, 0x6e, 0x65,
	0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x52, 0x14, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x46, 0x69, 0x6e, 0x65, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63,
	0x1a, 0x38, 0x0a, 0x0a, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x21,
	0x0a, 0x0b, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x42, 0x07, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x1a, 0x60, 0x0a, 0x0d, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4f, 0x0a, 0x0a, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x1a, 0x92, 0x04, 0x0a,
	0x09, 0x46, 0x61, 0x63, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x68, 0x0a, 0x09, 0x66, 0x61,
	0x63, 0x65, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x46, 0x61, 0x63,
	0x65, 0x74, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x66, 0x61, 0x63, 0x65,
	0x74, 0x4b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x6b, 0x65,
	0x79, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x64, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x36, 0x0a, 0x17,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x50, 0x6f, 0x73, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x9a, 0x02, 0x0a, 0x08, 0x46, 0x61, 0x63, 0x65, 0x74, 0x4b, 0x65,
	0x79, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4c, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52, 0x09, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69,
	0x63, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x10, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x12,
	0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x63,
	0x61, 0x73, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x63, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x65, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x1a, 0xe9, 0x08, 0x0a, 0x09, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x84, 0x01, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x6f,
	0x6f, 0x73, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65,
	0x63, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x1a, 0xd4, 0x07, 0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1c, 0x0a,
	0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x62,
	0x6f, 0x6f, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x62, 0x6f, 0x6f, 0x73,
	0x74, 0x12, 0x8f, 0x01, 0x0a, 0x12, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x61,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x53, 0x70, 0x65,
	0x63, 0x52, 0x10, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x53,
	0x70, 0x65, 0x63, 0x1a, 0xf7, 0x05, 0x0a, 0x10, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x96, 0x01, 0x0a, 0x0e, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x6f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70,
	0x65, 0x63, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0xa2, 0x01, 0x0a, 0x12, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x6f, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x42, 0x6f, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x53, 0x70, 0x65, 0x63,
	0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x95, 0x01, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x53, 0x70, 0x65,
	0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0d,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x1a, 0x5a, 0x0a,
	0x0c, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x27, 0x0a,
	0x0f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x5f,
	0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0b, 0x62, 0x6f,
	0x6f, 0x73, 0x74, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x4d, 0x0a, 0x0d, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x54,
	0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x55,
	0x4d, 0x45, 0x52, 0x49, 0x43, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x46, 0x52, 0x45,
	0x53, 0x48, 0x4e, 0x45, 0x53, 0x53, 0x10, 0x02, 0x22, 0x43, 0x0a, 0x11, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a,
	0x1e, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x4f, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x49, 0x4e, 0x45, 0x41, 0x52, 0x10, 0x01, 0x1a, 0xfa, 0x01,
	0x0a, 0x12, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x6e, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x16, 0x70, 0x69, 0x6e, 0x5f, 0x75, 0x6e, 0x65, 0x78,
	0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x70, 0x69, 0x6e, 0x55, 0x6e, 0x65, 0x78, 0x70, 0x61, 0x6e,
	0x64, 0x65, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x3e, 0x0a, 0x09, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x4f, 0x4e, 0x44, 0x49,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x08, 0x0a, 0x04, 0x41, 0x55, 0x54, 0x4f, 0x10, 0x02, 0x1a, 0xb4, 0x01, 0x0a, 0x13, 0x53,
	0x70, 0x65, 0x6c, 0x6c, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x60, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x70, 0x65, 0x6c, 0x6c, 0x43, 0x6f, 0x72, 0x72, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04,
	0x6d, 0x6f, 0x64, 0x65, 0x22, 0x3b, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10,
	0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x55, 0x47, 0x47, 0x45, 0x53, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x55, 0x54, 0x4f, 0x10,
	0x02, 0x1a, 0xbf, 0x0f, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x12, 0x74, 0x0a, 0x0c, 0x73, 0x6e, 0x69, 0x70, 0x70,
	0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x52, 0x0b, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x74, 0x0a,
	0x0c, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0b, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x93, 0x01, 0x0a, 0x17, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x45, 0x78, 0x74,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x70,
	0x65, 0x63, 0x52, 0x15, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x84, 0x01, 0x0a, 0x12, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x10,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x6e, 0x0a, 0x0a, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x68, 0x75, 0x6e,
	0x6b, 0x53, 0x70, 0x65, 0x63, 0x52, 0x09, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x53, 0x70, 0x65, 0x63,
	0x1a, 0x8f, 0x01, 0x0a, 0x0b, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x2e, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x0f, 0x6d, 0x61, 0x78, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x29, 0x0a, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0d, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x72,
	0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0d, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x53, 0x6e, 0x69, 0x70, 0x70,
	0x65, 0x74, 0x1a, 0xa5, 0x05, 0x0a, 0x0b, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x12, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f,
	0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x10, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x38, 0x0a, 0x18, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x61, 0x64, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x16, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x41, 0x64, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x72, 0x69, 0x61, 0x6c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x46, 0x0a, 0x20, 0x69,
	0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x5f, 0x73, 0x65, 0x65, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1c, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x4e, 0x6f, 0x6e,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x65, 0x65, 0x6b, 0x69, 0x6e, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x12, 0x8d, 0x01, 0x0a, 0x11, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x70, 0x72,
	0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x70,
	0x65, 0x63, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x53, 0x70,
	0x65, 0x63, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x7a, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x2e, 0x0a, 0x13, 0x75, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x6d, 0x61,
	0x6e, 0x74, 0x69, 0x63, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x11, 0x75, 0x73, 0x65, 0x53, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63, 0x43, 0x68,
	0x75, 0x6e, 0x6b, 0x73, 0x1a, 0x2d, 0x0a, 0x0f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x50, 0x72, 0x6f,
	0x6d, 0x70, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d,
	0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d,
	0x62, 0x6c, 0x65, 0x1a, 0x25, 0x0a, 0x09, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0xbe, 0x02, 0x0a, 0x15, 0x45,
	0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x3d, 0x0a, 0x1b, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x78, 0x74, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x18, 0x6d, 0x61, 0x78, 0x45, 0x78,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x1c, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x19, 0x6d, 0x61, 0x78, 0x45, 0x78,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x1f, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x65,
	0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1c, 0x72,
	0x65, 0x74, 0x75, 0x72, 0x6e, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x6e,
	0x75, 0x6d, 0x5f, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x6e, 0x75, 0x6d, 0x50,
	0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x2a, 0x0a, 0x11, 0x6e, 0x75, 0x6d, 0x5f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x6e, 0x75, 0x6d, 0x4e,
	0x65, 0x78, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x63, 0x0a, 0x09, 0x43,
	0x68, 0x75, 0x6e, 0x6b, 0x53, 0x70, 0x65, 0x63, 0x12, 0x2e, 0x0a, 0x13, 0x6e, 0x75, 0x6d, 0x5f,
	0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x6e, 0x75, 0x6d, 0x50, 0x72, 0x65, 0x76, 0x69, 0x6f,
	0x75, 0x73, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x75, 0x6d, 0x5f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0d, 0x6e, 0x75, 0x6d, 0x4e, 0x65, 0x78, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73,
	0x22, 0x51, 0x0a, 0x10, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x52,
	0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x4f, 0x43, 0x55,
	0x4d, 0x45, 0x4e, 0x54, 0x53, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x48, 0x55, 0x4e, 0x4b,
	0x53, 0x10, 0x02, 0x1a, 0xd9, 0x01, 0x0a, 0x0d, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x7e, 0x0a, 0x11, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x56, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x52, 0x10, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x56, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x73, 0x1a, 0x48, 0x0a, 0x0f, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69,
	0x6e, 0x67, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x50, 0x61, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x18, 0x02, 0x20, 0x03, 0x28, 0x02, 0x52, 0x06, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x1a,
	0x51, 0x0a, 0x0b, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x3d, 0x0a, 0x0f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xa1, 0x1e, 0x0a, 0x0e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x12, 0x52, 0x0a, 0x06, 0x66, 0x61, 0x63, 0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x52, 0x06, 0x66,
	0x61, 0x63, 0x65, 0x74, 0x73, 0x12, 0x79, 0x0a, 0x14, 0x67, 0x75, 0x69, 0x64, 0x65, 0x64, 0x5f,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x47, 0x75, 0x69, 0x64, 0x65, 0x64,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x12, 0x67, 0x75,
	0x69, 0x64, 0x65, 0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x2b, 0x0a, 0x11, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c,
	0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x55, 0x72, 0x69, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x72, 0x72, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x56, 0x0a, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52,
	0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x73, 0x12, 0x7a, 0x0a, 0x15, 0x67, 0x65, 0x6f, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x64, 0x65, 0x62, 0x75, 0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x10, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x47, 0x65, 0x6f, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x44, 0x65, 0x62, 0x75, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x12, 0x67, 0x65, 0x6f,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x65, 0x62, 0x75, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x79, 0x0a, 0x14, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x12, 0x71, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70,
	0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0x96, 0x03, 0x0a, 0x0c, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x4a, 0x0a, 0x08, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x68,
	0x75, 0x6e, 0x6b, 0x52, 0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x75, 0x0a, 0x0c, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x73, 0x1a, 0x70, 0x0a, 0x10, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x46, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x1a, 0xb7, 0x02, 0x0a, 0x05, 0x46, 0x61, 0x63, 0x65, 0x74, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x5d, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x2e, 0x46, 0x61, 0x63, 0x65,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x66, 0x61, 0x63, 0x65, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x46, 0x61,
	0x63, 0x65, 0x74, 0x1a, 0x97, 0x01, 0x0a, 0x0a, 0x46, 0x61, 0x63, 0x65, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x16, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4c, 0x0a, 0x08, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x48, 0x00, 0x52, 0x08,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x0d,
	0x0a, 0x0b, 0x66, 0x61, 0x63, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0xbc, 0x02,
	0x0a, 0x12, 0x47, 0x75, 0x69, 0x64, 0x65, 0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x90, 0x01, 0x0a, 0x15, 0x72, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x47, 0x75, 0x69, 0x64, 0x65,
	0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x52, 0x65,
	0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x52, 0x14, 0x72, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x66, 0x6f, 0x6c, 0x6c, 0x6f,
	0x77, 0x5f, 0x75, 0x70, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x55, 0x70, 0x51, 0x75,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x63, 0x0a, 0x13, 0x52, 0x65, 0x66, 0x69, 0x6e,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x4b, 0x65, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0xb8, 0x0d, 0x0a,
	0x07, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x54, 0x65, 0x78, 0x74, 0x12, 0x89, 0x01, 0x0a, 0x17,
	0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x51, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x53, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x53, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x52, 0x15, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x12, 0x7a, 0x0a, 0x11, 0x73, 0x61, 0x66, 0x65, 0x74,
	0x79, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x52, 0x10, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x12, 0x84, 0x01, 0x0a, 0x15, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f,
	0x77, 0x69, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x57, 0x69, 0x74, 0x68, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x13, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x57, 0x69,
	0x74, 0x68, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x4a, 0x0a, 0x10, 0x53, 0x61,
	0x66, 0x65, 0x74, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x1e,
	0x0a, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x02, 0x52, 0x06,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x1a, 0x77, 0x0a, 0x10, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x63, 0x0a, 0x09, 0x63, 0x69,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x43, 0x69, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a,
	0xaf, 0x01, 0x0a, 0x08, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1b, 0x0a,
	0x09, 0x65, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x08, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x65, 0x0a, 0x07, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x1a, 0x39, 0x0a, 0x0e, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x1a, 0xcf, 0x02, 0x0a,
	0x09, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x12, 0x4b, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x10, 0x0a,
	0x03, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12,
	0x7a, 0x0a, 0x0e, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e,
	0x43, 0x68, 0x75, 0x6e, 0x6b, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x0d, 0x63, 0x68,
	0x75, 0x6e, 0x6b, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x51, 0x0a, 0x0c, 0x43,
	0x68, 0x75, 0x6e, 0x6b, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x70, 0x61, 0x67, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x1a, 0x93,
	0x02, 0x0a, 0x13, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x57, 0x69, 0x74, 0x68, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x12, 0x7a, 0x0a, 0x11, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x10, 0x63, 0x69, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x66, 0x0a, 0x0a,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0a, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x22, 0xe0, 0x01, 0x0a, 0x14, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x53, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x26, 0x0a,
	0x22, 0x53, 0x55, 0x4d, 0x4d, 0x41, 0x52, 0x59, 0x5f, 0x53, 0x4b, 0x49, 0x50, 0x50, 0x45, 0x44,
	0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x41, 0x44, 0x56, 0x45, 0x52, 0x53, 0x41,
	0x52, 0x49, 0x41, 0x4c, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x49, 0x47, 0x4e, 0x4f, 0x52,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x25, 0x0a, 0x21, 0x4e, 0x4f, 0x4e, 0x5f, 0x53, 0x55, 0x4d, 0x4d,
	0x41, 0x52, 0x59, 0x5f, 0x53, 0x45, 0x45, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x51, 0x55, 0x45, 0x52,
	0x59, 0x5f, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x44, 0x10, 0x02, 0x12, 0x1f, 0x0a, 0x1b, 0x4f,
	0x55, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x44, 0x4f, 0x4d, 0x41, 0x49, 0x4e, 0x5f, 0x51, 0x55, 0x45,
	0x52, 0x59, 0x5f, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x44, 0x10, 0x03, 0x12, 0x1e, 0x0a, 0x1a,
	0x50, 0x4f, 0x54, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59,
	0x5f, 0x56, 0x49, 0x4f, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15,
	0x4c, 0x4c, 0x4d, 0x5f, 0x41, 0x44, 0x44, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x45, 0x4e,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x1a, 0x6f, 0x0a, 0x12, 0x47, 0x65, 0x6f, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x44, 0x65, 0x62, 0x75, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x34, 0x0a,
	0x16, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x6b, 0x0a, 0x12, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x25,
	0x0a, 0x0e, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2e, 0x0a, 0x13, 0x70, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x11, 0x70, 0x69, 0x6e, 0x6e, 0x65, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x32, 0x8e, 0x04, 0x0a, 0x0d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xa8, 0x03, 0x0a, 0x06, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb2, 0x02,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xab, 0x02, 0x3a, 0x01, 0x2a, 0x5a, 0x68, 0x3a, 0x01, 0x2a, 0x22,
	0x63, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5a, 0x65, 0x3a, 0x01, 0x2a, 0x22, 0x60, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x22, 0x55, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x1a, 0x52, 0xca, 0x41, 0x1e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x9e, 0x02, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x42, 0x12, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x52, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f,
	0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa,
	0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56,
	0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0xea, 0x02, 0x27,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a,
	0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescData = file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1alpha_search_service_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes = make([]protoimpl.MessageInfo, 39)
var file_google_cloud_discoveryengine_v1alpha_search_service_proto_goTypes = []interface{}{
	(SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_AttributeType)(0),     // 0: google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType
	(SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_InterpolationType)(0), // 1: google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType
	(SearchRequest_QueryExpansionSpec_Condition)(0),                                    // 2: google.cloud.discoveryengine.v1alpha.SearchRequest.QueryExpansionSpec.Condition
	(SearchRequest_SpellCorrectionSpec_Mode)(0),                                        // 3: google.cloud.discoveryengine.v1alpha.SearchRequest.SpellCorrectionSpec.Mode
	(SearchRequest_ContentSearchSpec_SearchResultMode)(0),                              // 4: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SearchResultMode
	(SearchResponse_Summary_SummarySkippedReason)(0),                                   // 5: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.SummarySkippedReason
	(*SearchRequest)(nil),                              // 6: google.cloud.discoveryengine.v1alpha.SearchRequest
	(*SearchResponse)(nil),                             // 7: google.cloud.discoveryengine.v1alpha.SearchResponse
	(*SearchRequest_ImageQuery)(nil),                   // 8: google.cloud.discoveryengine.v1alpha.SearchRequest.ImageQuery
	(*SearchRequest_DataStoreSpec)(nil),                // 9: google.cloud.discoveryengine.v1alpha.SearchRequest.DataStoreSpec
	(*SearchRequest_FacetSpec)(nil),                    // 10: google.cloud.discoveryengine.v1alpha.SearchRequest.FacetSpec
	(*SearchRequest_BoostSpec)(nil),                    // 11: google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec
	(*SearchRequest_QueryExpansionSpec)(nil),           // 12: google.cloud.discoveryengine.v1alpha.SearchRequest.QueryExpansionSpec
	(*SearchRequest_SpellCorrectionSpec)(nil),          // 13: google.cloud.discoveryengine.v1alpha.SearchRequest.SpellCorrectionSpec
	(*SearchRequest_ContentSearchSpec)(nil),            // 14: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec
	(*SearchRequest_EmbeddingSpec)(nil),                // 15: google.cloud.discoveryengine.v1alpha.SearchRequest.EmbeddingSpec
	nil,                                                // 16: google.cloud.discoveryengine.v1alpha.SearchRequest.ParamsEntry
	nil,                                                // 17: google.cloud.discoveryengine.v1alpha.SearchRequest.UserLabelsEntry
	(*SearchRequest_FacetSpec_FacetKey)(nil),           // 18: google.cloud.discoveryengine.v1alpha.SearchRequest.FacetSpec.FacetKey
	(*SearchRequest_BoostSpec_ConditionBoostSpec)(nil), // 19: google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec.ConditionBoostSpec
	(*SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec)(nil),              // 20: google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec
	(*SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint)(nil), // 21: google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint
	(*SearchRequest_ContentSearchSpec_SnippetSpec)(nil),                              // 22: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SnippetSpec
	(*SearchRequest_ContentSearchSpec_SummarySpec)(nil),                              // 23: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SummarySpec
	(*SearchRequest_ContentSearchSpec_ExtractiveContentSpec)(nil),                    // 24: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.ExtractiveContentSpec
	(*SearchRequest_ContentSearchSpec_ChunkSpec)(nil),                                // 25: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.ChunkSpec
	(*SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec)(nil),              // 26: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec
	(*SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec)(nil),                    // 27: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec
	(*SearchRequest_EmbeddingSpec_EmbeddingVector)(nil),                              // 28: google.cloud.discoveryengine.v1alpha.SearchRequest.EmbeddingSpec.EmbeddingVector
	(*SearchResponse_SearchResult)(nil),                                              // 29: google.cloud.discoveryengine.v1alpha.SearchResponse.SearchResult
	(*SearchResponse_Facet)(nil),                                                     // 30: google.cloud.discoveryengine.v1alpha.SearchResponse.Facet
	(*SearchResponse_GuidedSearchResult)(nil),                                        // 31: google.cloud.discoveryengine.v1alpha.SearchResponse.GuidedSearchResult
	(*SearchResponse_Summary)(nil),                                                   // 32: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary
	(*SearchResponse_GeoSearchDebugInfo)(nil),                                        // 33: google.cloud.discoveryengine.v1alpha.SearchResponse.GeoSearchDebugInfo
	(*SearchResponse_QueryExpansionInfo)(nil),                                        // 34: google.cloud.discoveryengine.v1alpha.SearchResponse.QueryExpansionInfo
	nil,                                     // 35: google.cloud.discoveryengine.v1alpha.SearchResponse.SearchResult.ModelScoresEntry
	(*SearchResponse_Facet_FacetValue)(nil), // 36: google.cloud.discoveryengine.v1alpha.SearchResponse.Facet.FacetValue
	(*SearchResponse_GuidedSearchResult_RefinementAttribute)(nil), // 37: google.cloud.discoveryengine.v1alpha.SearchResponse.GuidedSearchResult.RefinementAttribute
	(*SearchResponse_Summary_SafetyAttributes)(nil),               // 38: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.SafetyAttributes
	(*SearchResponse_Summary_CitationMetadata)(nil),               // 39: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.CitationMetadata
	(*SearchResponse_Summary_Citation)(nil),                       // 40: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.Citation
	(*SearchResponse_Summary_CitationSource)(nil),                 // 41: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.CitationSource
	(*SearchResponse_Summary_Reference)(nil),                      // 42: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.Reference
	(*SearchResponse_Summary_SummaryWithMetadata)(nil),            // 43: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.SummaryWithMetadata
	(*SearchResponse_Summary_Reference_ChunkContent)(nil),         // 44: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.Reference.ChunkContent
	(*UserInfo)(nil),             // 45: google.cloud.discoveryengine.v1alpha.UserInfo
	(*CustomFineTuningSpec)(nil), // 46: google.cloud.discoveryengine.v1alpha.CustomFineTuningSpec
	(*structpb.Value)(nil),       // 47: google.protobuf.Value
	(*Interval)(nil),             // 48: google.cloud.discoveryengine.v1alpha.Interval
	(*Document)(nil),             // 49: google.cloud.discoveryengine.v1alpha.Document
	(*Chunk)(nil),                // 50: google.cloud.discoveryengine.v1alpha.Chunk
	(*DoubleList)(nil),           // 51: google.cloud.discoveryengine.v1alpha.DoubleList
}
var file_google_cloud_discoveryengine_v1alpha_search_service_proto_depIdxs = []int32{
	8,  // 0: google.cloud.discoveryengine.v1alpha.SearchRequest.image_query:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.ImageQuery
	9,  // 1: google.cloud.discoveryengine.v1alpha.SearchRequest.data_store_specs:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.DataStoreSpec
	45, // 2: google.cloud.discoveryengine.v1alpha.SearchRequest.user_info:type_name -> google.cloud.discoveryengine.v1alpha.UserInfo
	10, // 3: google.cloud.discoveryengine.v1alpha.SearchRequest.facet_specs:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.FacetSpec
	11, // 4: google.cloud.discoveryengine.v1alpha.SearchRequest.boost_spec:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec
	16, // 5: google.cloud.discoveryengine.v1alpha.SearchRequest.params:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.ParamsEntry
	12, // 6: google.cloud.discoveryengine.v1alpha.SearchRequest.query_expansion_spec:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.QueryExpansionSpec
	13, // 7: google.cloud.discoveryengine.v1alpha.SearchRequest.spell_correction_spec:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.SpellCorrectionSpec
	14, // 8: google.cloud.discoveryengine.v1alpha.SearchRequest.content_search_spec:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec
	15, // 9: google.cloud.discoveryengine.v1alpha.SearchRequest.embedding_spec:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.EmbeddingSpec
	17, // 10: google.cloud.discoveryengine.v1alpha.SearchRequest.user_labels:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.UserLabelsEntry
	46, // 11: google.cloud.discoveryengine.v1alpha.SearchRequest.custom_fine_tuning_spec:type_name -> google.cloud.discoveryengine.v1alpha.CustomFineTuningSpec
	29, // 12: google.cloud.discoveryengine.v1alpha.SearchResponse.results:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.SearchResult
	30, // 13: google.cloud.discoveryengine.v1alpha.SearchResponse.facets:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.Facet
	31, // 14: google.cloud.discoveryengine.v1alpha.SearchResponse.guided_search_result:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.GuidedSearchResult
	32, // 15: google.cloud.discoveryengine.v1alpha.SearchResponse.summary:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.Summary
	33, // 16: google.cloud.discoveryengine.v1alpha.SearchResponse.geo_search_debug_info:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.GeoSearchDebugInfo
	34, // 17: google.cloud.discoveryengine.v1alpha.SearchResponse.query_expansion_info:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.QueryExpansionInfo
	18, // 18: google.cloud.discoveryengine.v1alpha.SearchRequest.FacetSpec.facet_key:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.FacetSpec.FacetKey
	19, // 19: google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec.condition_boost_specs:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec.ConditionBoostSpec
	2,  // 20: google.cloud.discoveryengine.v1alpha.SearchRequest.QueryExpansionSpec.condition:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.QueryExpansionSpec.Condition
	3,  // 21: google.cloud.discoveryengine.v1alpha.SearchRequest.SpellCorrectionSpec.mode:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.SpellCorrectionSpec.Mode
	22, // 22: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.snippet_spec:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SnippetSpec
	23, // 23: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.summary_spec:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SummarySpec
	24, // 24: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.extractive_content_spec:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.ExtractiveContentSpec
	4,  // 25: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.search_result_mode:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SearchResultMode
	25, // 26: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.chunk_spec:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.ChunkSpec
	28, // 27: google.cloud.discoveryengine.v1alpha.SearchRequest.EmbeddingSpec.embedding_vectors:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.EmbeddingSpec.EmbeddingVector
	47, // 28: google.cloud.discoveryengine.v1alpha.SearchRequest.ParamsEntry.value:type_name -> google.protobuf.Value
	48, // 29: google.cloud.discoveryengine.v1alpha.SearchRequest.FacetSpec.FacetKey.intervals:type_name -> google.cloud.discoveryengine.v1alpha.Interval
	20, // 30: google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec.ConditionBoostSpec.boost_control_spec:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec
	0,  // 31: google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.attribute_type:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.AttributeType
	1,  // 32: google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.interpolation_type:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.InterpolationType
	21, // 33: google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.control_points:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.BoostSpec.ConditionBoostSpec.BoostControlSpec.ControlPoint
	26, // 34: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SummarySpec.model_prompt_spec:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SummarySpec.ModelPromptSpec
	27, // 35: google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SummarySpec.model_spec:type_name -> google.cloud.discoveryengine.v1alpha.SearchRequest.ContentSearchSpec.SummarySpec.ModelSpec
	49, // 36: google.cloud.discoveryengine.v1alpha.SearchResponse.SearchResult.document:type_name -> google.cloud.discoveryengine.v1alpha.Document
	50, // 37: google.cloud.discoveryengine.v1alpha.SearchResponse.SearchResult.chunk:type_name -> google.cloud.discoveryengine.v1alpha.Chunk
	35, // 38: google.cloud.discoveryengine.v1alpha.SearchResponse.SearchResult.model_scores:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.SearchResult.ModelScoresEntry
	36, // 39: google.cloud.discoveryengine.v1alpha.SearchResponse.Facet.values:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.Facet.FacetValue
	37, // 40: google.cloud.discoveryengine.v1alpha.SearchResponse.GuidedSearchResult.refinement_attributes:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.GuidedSearchResult.RefinementAttribute
	5,  // 41: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.summary_skipped_reasons:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.SummarySkippedReason
	38, // 42: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.safety_attributes:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.SafetyAttributes
	43, // 43: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.summary_with_metadata:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.SummaryWithMetadata
	51, // 44: google.cloud.discoveryengine.v1alpha.SearchResponse.SearchResult.ModelScoresEntry.value:type_name -> google.cloud.discoveryengine.v1alpha.DoubleList
	48, // 45: google.cloud.discoveryengine.v1alpha.SearchResponse.Facet.FacetValue.interval:type_name -> google.cloud.discoveryengine.v1alpha.Interval
	40, // 46: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.CitationMetadata.citations:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.Citation
	41, // 47: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.Citation.sources:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.CitationSource
	44, // 48: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.Reference.chunk_contents:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.Reference.ChunkContent
	39, // 49: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.SummaryWithMetadata.citation_metadata:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.CitationMetadata
	42, // 50: google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.SummaryWithMetadata.references:type_name -> google.cloud.discoveryengine.v1alpha.SearchResponse.Summary.Reference
	6,  // 51: google.cloud.discoveryengine.v1alpha.SearchService.Search:input_type -> google.cloud.discoveryengine.v1alpha.SearchRequest
	7,  // 52: google.cloud.discoveryengine.v1alpha.SearchService.Search:output_type -> google.cloud.discoveryengine.v1alpha.SearchResponse
	52, // [52:53] is the sub-list for method output_type
	51, // [51:52] is the sub-list for method input_type
	51, // [51:51] is the sub-list for extension type_name
	51, // [51:51] is the sub-list for extension extendee
	0,  // [0:51] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1alpha_search_service_proto_init() }
func file_google_cloud_discoveryengine_v1alpha_search_service_proto_init() {
	if File_google_cloud_discoveryengine_v1alpha_search_service_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1alpha_chunk_proto_init()
	file_google_cloud_discoveryengine_v1alpha_common_proto_init()
	file_google_cloud_discoveryengine_v1alpha_document_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_ImageQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_DataStoreSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_FacetSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_BoostSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_QueryExpansionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_SpellCorrectionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_ContentSearchSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_EmbeddingSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_FacetSpec_FacetKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_BoostSpec_ConditionBoostSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_BoostSpec_ConditionBoostSpec_BoostControlSpec_ControlPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_ContentSearchSpec_SnippetSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_ContentSearchSpec_SummarySpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_ContentSearchSpec_ExtractiveContentSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_ContentSearchSpec_ChunkSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_ContentSearchSpec_SummarySpec_ModelPromptSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_ContentSearchSpec_SummarySpec_ModelSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchRequest_EmbeddingSpec_EmbeddingVector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_SearchResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_Facet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_GuidedSearchResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_Summary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_GeoSearchDebugInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_QueryExpansionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_Facet_FacetValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_GuidedSearchResult_RefinementAttribute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_Summary_SafetyAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_Summary_CitationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_Summary_Citation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_Summary_CitationSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_Summary_Reference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_Summary_SummaryWithMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResponse_Summary_Reference_ChunkContent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*SearchRequest_ImageQuery_ImageBytes)(nil),
	}
	file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes[30].OneofWrappers = []interface{}{
		(*SearchResponse_Facet_FacetValue_Value)(nil),
		(*SearchResponse_Facet_FacetValue_Interval)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   39,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1alpha_search_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1alpha_search_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1alpha_search_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1alpha_search_service_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1alpha_search_service_proto = out.File
	file_google_cloud_discoveryengine_v1alpha_search_service_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1alpha_search_service_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1alpha_search_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SearchServiceClient is the client API for SearchService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SearchServiceClient interface {
	// Performs a search.
	Search(ctx context.Context, in *SearchRequest, opts ...grpc.CallOption) (*SearchResponse, error)
}

type searchServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSearchServiceClient(cc grpc.ClientConnInterface) SearchServiceClient {
	return &searchServiceClient{cc}
}

func (c *searchServiceClient) Search(ctx context.Context, in *SearchRequest, opts ...grpc.CallOption) (*SearchResponse, error) {
	out := new(SearchResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1alpha.SearchService/Search", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SearchServiceServer is the server API for SearchService service.
type SearchServiceServer interface {
	// Performs a search.
	Search(context.Context, *SearchRequest) (*SearchResponse, error)
}

// UnimplementedSearchServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSearchServiceServer struct {
}

func (*UnimplementedSearchServiceServer) Search(context.Context, *SearchRequest) (*SearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Search not implemented")
}

func RegisterSearchServiceServer(s *grpc.Server, srv SearchServiceServer) {
	s.RegisterService(&_SearchService_serviceDesc, srv)
}

func _SearchService_Search_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchServiceServer).Search(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1alpha.SearchService/Search",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchServiceServer).Search(ctx, req.(*SearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SearchService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.discoveryengine.v1alpha.SearchService",
	HandlerType: (*SearchServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Search",
			Handler:    _SearchService_Search_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/discoveryengine/v1alpha/search_service.proto",
}
