# This file should be included if the command line reads like this:
# x86_64-w64-mingw32.shared-cmake -DCMAKE_BUILD_TYPE=Release -DMXE=1 ..

MESSAGE("MXE (M cross environment) https://mxe.cc/")
message("Please run the configuration like this:")
message("x86_64-w64-mingw32.shared-cmake -G \"Unix Makefiles\" -DCMAKE_BUILD_TYPE=Release ../../development")

set(SHIPPED_DLLS_DIR "${HOME_DEVEL_DIR}/mxe/dll-set-for-packages")

set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES ${HOME_DEVEL_DIR}/mxe/usr/x86_64-w64-mingw32.shared/include)
set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES ${HOME_DEVEL_DIR}/mxe/usr/x86_64-w64-mingw32.shared/include)

# This is used throughout all the build system files
set(TARGET ${CMAKE_PROJECT_NAME})

# Now that we have the TARGET variable contents, let's configure InnoSetup
configure_file(${CMAKE_SOURCE_DIR}/CMakeStuff/${LOWCASE_PROJECT_NAME}-mxe.iss.in
  ${CMAKE_SOURCE_DIR}/winInstaller/${LOWCASE_PROJECT_NAME}-mxe.iss @ONLY)

# Now that we have the TARGET variable contents, let's configure NSIS
configure_file(${CMAKE_SOURCE_DIR}/CMakeStuff/${LOWCASE_PROJECT_NAME}-mxe.nsis.in
  ${CMAKE_SOURCE_DIR}/winInstaller/${LOWCASE_PROJECT_NAME}-mxe.nsis @ONLY)


find_package(
    Qt6 REQUIRED
    COMPONENTS Widgets
               Xml
               Svg
               SvgWidgets
               PrintSupport
               Network
               Qml
               Sql
               Concurrent
               Core5Compat
               GLOBAL
)


set(IsoSpec++_FOUND 1)
set(IsoSpec++_INCLUDE_DIRS "${HOME_DEVEL_DIR}/isospec/development")
set(IsoSpec++_LIBRARIES "${SHIPPED_DLLS_DIR}/libIsoSpec++.dll")
if(NOT TARGET IsoSpec++::IsoSpec++)
  add_library(IsoSpec++::IsoSpec++ UNKNOWN IMPORTED)
  set_target_properties(IsoSpec++::IsoSpec++ PROPERTIES
    IMPORTED_LOCATION             "${IsoSpec++_LIBRARIES}"
    INTERFACE_INCLUDE_DIRECTORIES "${IsoSpec++_INCLUDE_DIRS}")
endif()


set(PwizLite_FOUND 1)
set(PwizLite_INCLUDE_DIRS "${HOME_DEVEL_DIR}/pwizlite/development/src")
set(PwizLite_LIBRARIES "${HOME_DEVEL_DIR}/pwizlite/build-area/mxe/src/libpwizlite.dll")
if(NOT TARGET PwizLite::PwizLite)
    add_library(PwizLite::PwizLite UNKNOWN IMPORTED)
    set_target_properties(
        PwizLite::PwizLite PROPERTIES IMPORTED_LOCATION "${PwizLite_LIBRARIES}" INTERFACE_INCLUDE_DIRECTORIES
                                                                                "${PwizLite_INCLUDE_DIRS}"
    )
endif()

find_package(
    Boost
    COMPONENTS chrono
               container
               filesystem
               iostreams
               thread
    REQUIRED
)


find_package(SQLite3 REQUIRED)


set(QCustomPlotQt6_FOUND 1)
set(QCustomPlotQt6_INCLUDE_DIR "${HOME_DEVEL_DIR}/qcustomplot/development")
set(QCustomPlotQt6_LIBRARIES "${HOME_DEVEL_DIR}/qcustomplot/build-area/mxe/libQCustomPlotQt6.dll")
if(NOT TARGET QCustomPlotQt6::QCustomPlotQt6)
    add_library(QCustomPlotQt6::QCustomPlotQt6 UNKNOWN IMPORTED)
    set_target_properties(
        QCustomPlotQt6::QCustomPlotQt6
        PROPERTIES IMPORTED_LOCATION "${QCustomPlotQt6_LIBRARIES}"
                   INTERFACE_INCLUDE_DIRECTORIES "${QCustomPlotQt6_INCLUDE_DIR}"
                   INTERFACE_COMPILE_DEFINITIONS QCUSTOMPLOT_USE_LIBRARY
    )
endif()


find_package(ZLIB REQUIRED)


set(liblzf_FOUND 1)
set(liblzf_INCLUDE_DIRS "${HOME_DEVEL_DIR}/lzf/development")

set(liblzf_LIBRARIES "${HOME_DEVEL_DIR}/lzf/build-area/mxe/liblzf.dll")
if(NOT TARGET liblzf::liblzf)
    add_library(liblzf::liblzf UNKNOWN IMPORTED)
    set_target_properties(
        liblzf::liblzf
        PROPERTIES IMPORTED_LOCATION "${liblzf_LIBRARIES}"
                   INTERFACE_INCLUDE_DIRECTORIES "${liblzf_INCLUDE_DIRS}"
                   INTERFACE_COMPILE_DEFINITIONS LIBLZF_USE_LIBRARY
    )
endif()


set(OdsStream_FOUND 1)
set(OdsStream_INCLUDE_DIR "${HOME_DEVEL_DIR}/odsstream/development/src")
set(OdsStream_LIBRARIES "${HOME_DEVEL_DIR}/odsstream/build-area/mxe/src/libodsstream.dll")
if(NOT TARGET OdsStream::Core)
    add_library(OdsStream::Core UNKNOWN IMPORTED)
    set_target_properties(
        OdsStream::Core PROPERTIES IMPORTED_LOCATION "${OdsStream_LIBRARIES}" INTERFACE_INCLUDE_DIRECTORIES
                                                                              "${OdsStream_INCLUDE_DIR}"
    )
endif()


set(QUAZIP_FOUND 1)
set(QUAZIP_INCLUDE_DIR "${HOME_DEVEL_DIR}/quazip/development/quazip")
set(QUAZIP_LIBRARIES "${HOME_DEVEL_DIR}/quazip/build-area/mxe/quazip/libquazip1-qt6.dll")
set(QUAZIP_ZLIB_INCLUDE_DIR ${ZLIB_INCLUDE_DIRS})
set(QUAZIP_INCLUDE_DIRS ${QUAZIP_INCLUDE_DIR} ${QUAZIP_ZLIB_INCLUDE_DIR})

message(STATUS "QUAZIP_INCLUDE_DIR :${QUAZIP_INCLUDE_DIR}")

if(NOT TARGET QuaZip::QuaZip)
    add_library(QuaZip::QuaZip UNKNOWN IMPORTED)
    set_target_properties(
        QuaZip::QuaZip PROPERTIES IMPORTED_LOCATION ${QUAZIP_LIBRARIES} INTERFACE_INCLUDE_DIRECTORIES
                                                                        ${QUAZIP_INCLUDE_DIR}
    )
endif()


set(QScintilla_FOUND 1)
set(QScintilla_INCLUDE_DIRS "${HOME_DEVEL_DIR}/qscintilla2/development/src")
set(QScintilla_LIBRARIES "${HOME_DEVEL_DIR}/qscintilla2/build-area/mxe/src/libqscintilla2_qt6.dll")
if(NOT TARGET QScintilla::QScintilla)
  add_library(QScintilla::QScintilla UNKNOWN IMPORTED)
  set_target_properties(QScintilla::QScintilla PROPERTIES
    IMPORTED_LOCATION             "${QScintilla_LIBRARIES}"
    INTERFACE_INCLUDE_DIRECTORIES "${QScintilla_INCLUDE_DIRS}")
endif()


set(PappsoMSpp_FOUND 1)
set(PappsoMSpp_INCLUDE_DIRS "${HOME_DEVEL_DIR}/pappsomspp/development/src")
set(PappsoMSpp_LIBRARIES
  "${SHIPPED_DLLS_DIR}/libpappsomspp-core.dll")
if(NOT TARGET PappsoMSpp::Core)

  add_library(PappsoMSpp::Core UNKNOWN IMPORTED GLOBAL)
  set_target_properties(PappsoMSpp::Core PROPERTIES
    IMPORTED_LOCATION ${PappsoMSpp_LIBRARIES}
    INTERFACE_INCLUDE_DIRECTORIES ${PappsoMSpp_INCLUDE_DIRS})

endif()

set(PappsoMSppGui_FOUND 1)
set(PappsoMSppGui_LIBRARIES
  "${SHIPPED_DLLS_DIR}/libpappsomspp-gui.dll")
if(NOT TARGET PappsoMSpp::Gui)

  add_library(PappsoMSpp::Gui UNKNOWN IMPORTED GLOBAL)
  set_target_properties(PappsoMSpp::Gui PROPERTIES
    IMPORTED_LOCATION ${PappsoMSppGui_LIBRARIES}
    INTERFACE_INCLUDE_DIRECTORIES ${PappsoMSpp_INCLUDE_DIRS})

endif()

include_directories(${include_directories} ${PappsoMSpp_INCLUDE_DIRS} ${PappsoMSpp_INCLUDE_DIRS})


set(XpertMass_FOUND 1)
set(XpertMass_INCLUDE_DIRS "${HOME_DEVEL_DIR}/xpertmass/development/source/XpertMassCore/includes")
set(XpertMass_LIBRARIES "${SHIPPED_DLLS_DIR}/libXpertMassCore.dll")
if(NOT TARGET XpertMass::Core)

  add_library(XpertMass::Core UNKNOWN IMPORTED GLOBAL)
  set_target_properties(XpertMass::Core PROPERTIES
    IMPORTED_LOCATION ${XpertMass_LIBRARIES}
    INTERFACE_INCLUDE_DIRECTORIES ${XpertMass_INCLUDE_DIRS})

endif()

set(XpertMassGui_INCLUDE_DIRS "${HOME_DEVEL_DIR}/xpertmass/development/source/XpertMassGui/includes")
set(XpertMassGui_LIBRARIES "${SHIPPED_DLLS_DIR}/libXpertMassGui.dll")
if(NOT TARGET XpertMass::Gui)

  add_library(XpertMass::Gui UNKNOWN IMPORTED GLOBAL)
  set_target_properties(XpertMass::Gui PROPERTIES
    IMPORTED_LOCATION ${XpertMassGui_LIBRARIES}
    INTERFACE_INCLUDE_DIRECTORIES ${XpertMassGui_INCLUDE_DIRS})

endif()

include_directories(${include_directories} ${XpertMass_INCLUDE_DIRS} ${XpertMassGui_INCLUDE_DIRS})


# Build the WindRes resource file for the icon into an object file
# that will then be added to the target_link_libaries.
if(NOT CMAKE_RC_COMPILER)
set(CMAKE_RC_COMPILER ${HOME_DEVEL_DIR}/mxe/usr/bin/x86_64-w64-mingw32.shared-windres)
endif()

message("CMAKE_RC_COMPILER: ${CMAKE_RC_COMPILER}")

execute_process(COMMAND ${CMAKE_RC_COMPILER}
  -D GCC_WINDRES
  -I "${CMAKE_SOURCE_DIR}"
  -i "${CMAKE_SOURCE_DIR}/${PROJECT_NAME}.rc"
  -o "${CMAKE_BINARY_DIR}/${PROJECT_NAME}.obj"
  WORKING_DIRECTORY	${CMAKE_CURRENT_SOURCE_DIR})

# We add this to the target_link_libraries()
set(PLATFORM_SPECIFIC_LIB_FILES "${CMAKE_BINARY_DIR}/${PROJECT_NAME}.obj" ${PLATFORM_SPECIFIC_LIB_FILES})


################## MS WINDOWS package creation ###################
################## MS WINDOWS package creation ###################
################## MS WINDOWS package creation ###################

# There are two solutions:
# 1. NSIS, used from Debian on Linux and from MS Windows
# 2. InnoSetup, used from wine on Linux and from MS Windows

######################### NSIS ############################
######################### NSIS ############################

add_custom_target(winpackage
      COMMAND "makensis" "-V4"
      "${CMAKE_SOURCE_DIR}/winInstaller/${LOWCASE_PROJECT_NAME}-mxe.nsis"
      WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}/winInstaller
      COMMENT "Build of the Windows Package Setup executable"
      DEPENDS ${TARGET}
      VERBATIM)

######################### InnoSetup ############################
######################### InnoSetup ############################

add_custom_target(winpackage_innosetup
      COMMAND wine "$ENV{HOME}/.wine/drive_c/Program\ Files\ \(x86\)/Inno\ Setup\ 6/ISCC.exe"
      "z:/devel/${LOWCASE_PROJECT_NAME_NO_VER}/development/winInstaller/${LOWCASE_PROJECT_NAME}-mxe.iss"
      WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}/winInstaller
      COMMENT "Build of the Windows Package Setup executable"
      DEPENDS ${TARGET}
      VERBATIM)


# We want to move the locally created MS-Windows package to an out-of-source directory

set(WIN_PACKAGE_STORE_PATH "${HOME_DEVEL_DIR}/msxpertsuite-store/win-packages/${LOWCASE_PROJECT_NAME_NO_VER}")

add_custom_command(
    TARGET winpackage
    POST_BUILD

    # Create destination directory first
    COMMAND ${CMAKE_COMMAND} -E make_directory ${WIN_PACKAGE_STORE_PATH}

    COMMAND mv ${CMAKE_SOURCE_DIR}/winInstaller/*-setup.exe ${WIN_PACKAGE_STORE_PATH}

    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}

    COMMENT "Copy the MS-Windows package files to ${WIN_PACKAGE_STORE_PATH}"
)


################# INSTALL directories #################
################# INSTALL directories #################
################# INSTALL directories #################

# This is the default on windows, but set it nonetheless.
set(CMAKE_INSTALL_PREFIX "C:/Program Files")
set(PROJECT_INSTALL_PREFIX ${CMAKE_INSTALL_PREFIX})
message("The project install prefix: ${PROJECT_INSTALL_PREFIX}")

#### These directories do not include the CMAKE_INSTALL_PREFIX path.
#### In the install actions of this CMake-based configuration, only use
#### PROJECT_INSTALL_<VARIABLE>

### The directory where the binary is to be installed
set(PROJECT_INSTALL_BIN_DIR ${CMAKE_PROJECT_NAME})
message(STATUS "The project install bin dir: ${PROJECT_INSTALL_BIN_DIR}")

set(PROJECT_INSTALL_LIB_DIR ${CMAKE_PROJECT_NAME})
message(STATUS "The project install lib dir: ${PROJECT_INSTALL_LIB_DIR}")

set(PROJECT_INSTALL_DATA_DIR ${CMAKE_PROJECT_NAME})
message(STATUS "The project install data dir: ${PROJECT_INSTALL_DATA_DIR}")

set(PROJECT_INSTALL_CHEMDATA_DIR "${PROJECT_INSTALL_DATA_DIR}/data")
message(STATUS "The project install chemdata dir: ${PROJECT_INSTALL_CHEMDATA_DIR}")

set(PROJECT_INSTALL_DOC_DIR "${PROJECT_INSTALL_DATA_DIR}/doc")
message(STATUS "The project install doc dir: ${PROJECT_INSTALL_DOC_DIR}")

# On Win10 all the code is relocatable.
remove_definitions(-fPIC)

