var errno = require('errno');

Object.keys(errno.code).forEach(function(code) {
	var e = errno.code[code];

	exports[code] = function(path) {
		var err = new Error(code+', '+e.description+(path ? ' \''+path+'\'' : ''));
		err.errno = e.errno;
		err.code = code;
		err.path = path;
		return err;
	};
});