---
name: Bug report
about: Report a problem with rest-server to help us resolve it and improve
---

<!--

Welcome! - We kindly ask that you:

  1. Fill out the issue template below - not doing so needs a good reason.
  2. Use the forum if you have a question rather than a bug or feature request.

The forum is at: https://forum.restic.net

NOTE: Not filling out the issue template needs a good reason, as otherwise it
may take a lot longer to find the problem, not to mention it can take up a lot
more time which can otherwise be spent on development. Please also take the
time to help us debug the issue by collecting relevant information, even if
it doesn't seem to be relevant to you. Thanks!

The forum is a better place for questions about rest-server or general suggestions
and topics, e.g. usage or documentation questions! This issue tracker is mainly
for tracking bugs and feature requests directly relating to the development of
the software itself, rather than the project.

Thanks for understanding, and for contributing to the project!

-->


Output of `rest-server --version` <!-- If using docker, output of `docker images restic/rest-server:latest -q` -->
---------------------------------



Problem description / Steps to reproduce
----------------------------------------

<!--
This section should include at least:

 * A description of the problem you are having with rest-server.

 * The complete command line and any environment variables you used to
   configure rest-server. Make sure to replace sensitive values!

 * The output of the commands, what rest-server prints gives may give us much
   information to diagnose the problem!

 * The more time you spend describing an easy way to reproduce the behavior (if
   this is possible), the easier it is for the project developers to fix it!
-->


Expected behavior
-----------------

<!--
Describe what you'd like rest-server to do differently.
-->

Actual behavior
---------------

<!--
In this section, please try to concentrate on observations, so only describe
what you observed directly.
-->

Do you have any idea what may have caused this?
-----------------------------------------------

<!--
Did something noteworthy happen on your system, Internet connection, backend services, etc?
-->


Did rest-server help you today? Did it make you happy in any way?
-----------------------------------------------------------------

<!--
Answering this question is not required, but if you have anything positive to share, please do so here!
Sometimes we get tired of reading bug reports all day and a little positive end note does wonders.
Idea by Joey Hess, https://joeyh.name/blog/entry/two_holiday_stories/
-->
