/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util;

import ancestris.util.Utilities;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyCreate;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyForeignXRef;
import genj.gedcom.PropertyMultilineValue;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class GedcomUtilities {
    private static final Logger LOG = Logger.getLogger(GedcomUtilities.class.getName(), null);
    public static final int MERGE_MODE_KEEP = 0;
    public static final int MERGE_MODE_REPLACE = 1;
    public static final int MERGE_MODE_ENRICH = 2;
    public static final int MERGE_MODE_ADD = 3;
    private static final Set<String> EXCLUDED_PATH = new HashSet<String>(Arrays.asList("INDI:NAME:SURN", "INDI:NAME:GIVN", "INDI:NAME:NICK", "INDI:NAME:SPFX", "INDI:NAME:NSFX", "INDI:NAME:NPFX"));
    public static final Set<String> QUASI_SINGLETON = new HashSet<String>(Arrays.asList("INDI:NAME", "INDI:BIRT", "INDI:DEAT", "INDI:BURI"));
    private static SimilarityBag bag = null;
    private static final int MIN_THRESHOLD = 50;
    private static final Map<String, Set<String>> allows = new HashMap<String, Set<String>>();

    public static <T> List<T> searchProperties(Gedcom gedcom, Class<T> type, String entityTag) {
        LOG.log(Level.FINER, "Searching for property {0}", type.getClass());
        Collection<Entity> entities = entityTag == null || entityTag.isEmpty() ? gedcom.getEntities() : gedcom.getEntities(entityTag);
        ArrayList<T> foundProperties = new ArrayList<T>();
        for (Entity entity : entities) {
            foundProperties.addAll(GedcomUtilities.searchPropertiesRecursively(entity, type));
        }
        LOG.log(Level.FINER, "found  {0}", foundProperties.size());
        return foundProperties;
    }

    private static <T> List<T> searchPropertiesRecursively(Property parent, Class<T> type) {
        ArrayList<Property> foundProperties = new ArrayList<Property>();
        for (Property child : parent.getProperties()) {
            if (type.isAssignableFrom(child.getClass())) {
                foundProperties.add(child);
            }
            foundProperties.addAll(GedcomUtilities.searchPropertiesRecursively(child, type));
        }
        return foundProperties;
    }

    public static int deleteTags(Gedcom gedcom, String tagToRemove, String entityTag, boolean allValues, boolean emptyTag, boolean asserted, String value, boolean exact) {
        LOG.log(Level.FINER, "deleting_tag {0}", tagToRemove);
        if (tagToRemove.trim().isEmpty()) {
            return 0;
        }
        int iCounter = 0;
        Collection<Entity> entities = entityTag == null || entityTag.isEmpty() ? gedcom.getEntities() : gedcom.getEntities(entityTag);
        for (Entity entity : entities) {
            List<Property> propsToDelete = entity.getAllProperties(tagToRemove);
            for (Property prop : propsToDelete) {
                boolean isEmpty;
                if (allValues) {
                    iCounter = GedcomUtilities.deleteTag(prop, tagToRemove, iCounter, entity);
                    continue;
                }
                boolean bl = isEmpty = prop.getValue().length() == 0 && prop.getNoOfProperties() == 0;
                if (emptyTag && isEmpty) {
                    iCounter = GedcomUtilities.deleteTag(prop, tagToRemove, iCounter, entity);
                    continue;
                }
                if (asserted && "Y".equals(prop.getValue()) && prop.getNoOfProperties() == 0) {
                    iCounter = GedcomUtilities.deleteTag(prop, tagToRemove, iCounter, entity);
                    continue;
                }
                if (exact) {
                    if (value == null || value.isEmpty() || !prop.toString().equals(value)) continue;
                    iCounter = GedcomUtilities.deleteTag(prop, tagToRemove, iCounter, entity);
                    continue;
                }
                if (value == null || value.isEmpty() || !prop.toString().contains(value)) continue;
                iCounter = GedcomUtilities.deleteTag(prop, tagToRemove, iCounter, entity);
            }
        }
        LOG.log(Level.FINER, "DeletedNb {0}", iCounter);
        return iCounter;
    }

    private static int deleteTag(Property prop, String tagToRemove, int iCounter, Entity entity) {
        Property parent = prop.getParent();
        if (parent != null) {
            String propText = parent.getTag() + " " + tagToRemove + " '" + prop.toString() + "'";
            parent.delProperty(prop);
            try {
                int n = parent.getPropertyPosition(prop);
            }
            catch (Exception e) {
                ++iCounter;
            }
            LOG.log(Level.FINER, "deleting_tag {0} {1} {2}", new Object[]{entity.getTag(), entity.toString(), propText});
        }
        return iCounter;
    }

    public static void MergeEntities(Entity dest, Entity src, int mergeMode, Map<Property, Boolean> sourceProperties) throws GedcomException {
        GedcomUtilities.initSimilarityBag();
        if (sourceProperties == null) {
            sourceProperties = GedcomUtilities.list2map(Arrays.asList(src.getProperties()));
        }
        ArrayList<Property> props = new ArrayList<Property>(sourceProperties.keySet());
        Collections.sort(props, (o1, o2) -> {
            Property p1 = (Property)o1;
            Property p2 = (Property)o2;
            return p1.getPath().compareTo(p2.getPath());
        });
        for (Property property : props) {
            TagPath tagPath = property.getParent().getPath();
            String[] pathArray = tagPath.toArray();
            pathArray[0] = dest.getTag();
            TagPath destTagPath = new TagPath(pathArray, null);
            Property propDest = dest.getProperty(destTagPath);
            if (propDest == null) {
                dest.setValue(tagPath, "");
                propDest = dest.getProperty(tagPath);
            }
            int specificMergeMode = sourceProperties.get(property) != false ? 3 : mergeMode;
            GedcomUtilities.mergePropertiesRecursively(property, propDest, specificMergeMode, new HashSet<Property>());
        }
        for (Property property : src.getProperties(PropertyXRef.class)) {
            PropertyXRef targetProperty;
            if (property instanceof PropertyFamilyChild) {
                Indi child;
                PropertyFamilyChild famc = (PropertyFamilyChild)property;
                if (dest instanceof Indi && (child = (Indi)dest).isChildIn(famc.getFamily())) continue;
            }
            if (property instanceof PropertyFamilySpouse) {
                Indi spouse;
                PropertyFamilySpouse fams = (PropertyFamilySpouse)property;
                if (dest instanceof Indi && (spouse = (Indi)dest).isSpouseIn(fams.getFamily())) continue;
            }
            if ((targetProperty = ((PropertyXRef)property).getTarget()) == null || targetProperty instanceof PropertyForeignXRef || targetProperty instanceof PropertyFamilyChild || targetProperty instanceof PropertyFamilySpouse || targetProperty instanceof PropertyAssociation && !targetProperty.isGrammar7()) continue;
            targetProperty.unlink();
            targetProperty.setValue("@" + dest.getEntity().getId() + "@");
            targetProperty.link();
        }
        dest.getGedcom().deleteEntity(src);
        bag.clear();
    }

    public static Map<Property, Boolean> list2map(List<Property> list) {
        HashMap<Property, Boolean> ret = new HashMap<Property, Boolean>();
        for (Property key : list) {
            ret.put(key, Boolean.FALSE);
        }
        return ret;
    }

    private static void copyPropertiesRecursively(Property srcProperty, Property destParentProperty) {
        Property addedProperty = null;
        int n = srcProperty.getParent().getPropertyPosition(srcProperty);
        try {
            if (srcProperty instanceof PropertyForeignXRef) {
                PropertyForeignXRef pfxref = (PropertyForeignXRef)srcProperty;
                PropertyXRef pxref = pfxref.getTarget();
                if (pxref != null) {
                    pxref.unlink();
                    pxref.setValue(destParentProperty.getEntity().getId());
                    pxref.link();
                }
            } else if (srcProperty instanceof PropertyXRef) {
                addedProperty = destParentProperty.addProperty(srcProperty.getTag(), srcProperty.getValue(), n);
                ((PropertyXRef)addedProperty).link();
            } else {
                addedProperty = srcProperty instanceof PropertyName ? destParentProperty.addProperty(srcProperty.getTag(), "", n) : destParentProperty.addProperty(srcProperty.getTag(), srcProperty.getValue(), n);
            }
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        for (int i = 0; i < srcProperty.getNoOfProperties(); ++i) {
            Property child = srcProperty.getProperty(i);
            GedcomUtilities.copyPropertiesRecursively(child, addedProperty);
        }
    }

    public static void initSimilarityBag() {
        if (bag == null) {
            bag = new SimilarityBag();
        }
    }

    public static void clearSimilarityBag() {
        if (bag != null) {
            bag.clear();
        }
    }

    private static void mergePropertiesRecursively(Property srcProperty, Property dest, int mergeMode, Set<Property> mergedProperties) {
        String tag = srcProperty.getTag();
        String tagPathValue = srcProperty.getPath().toString();
        if (srcProperty instanceof PropertyForeignXRef || srcProperty instanceof PropertyFamilySpouse || srcProperty instanceof PropertyFamilyChild || tag.equals("CHAN")) {
            return;
        }
        if (EXCLUDED_PATH.contains(tagPathValue)) {
            return;
        }
        Property destProperty = dest.getProperty(tag);
        if (mergeMode != 3 && destProperty != null && !destProperty.getMetaProperty().isSingleton()) {
            boolean isUnique;
            boolean isQuasiSingleton = QUASI_SINGLETON.contains(tagPathValue);
            Property[] destSiblings = dest.getProperties(tag);
            Property[] srcSiblings = srcProperty.getParent().getProperties(tag);
            boolean bl = isUnique = destSiblings.length == 1 && srcSiblings.length == 1;
            if (!isUnique || !isQuasiSingleton) {
                destProperty = GedcomUtilities.getSimilarProperty(srcProperty, srcSiblings, destSiblings, mergedProperties);
            }
        }
        if (mergeMode == 3 || destProperty == null) {
            PropertyEvent destEvent;
            GedcomUtilities.copyPropertiesRecursively(srcProperty, dest);
            if (dest instanceof PropertyEvent && (destEvent = (PropertyEvent)dest).isKnownToHaveHappened() != null && destEvent.isKnownToHaveHappened().booleanValue() && destEvent.getNoOfProperties() > 0) {
                destEvent.setKnownToHaveHappened(false);
            }
        } else {
            switch (mergeMode) {
                case 0: {
                    break;
                }
                case 1: {
                    if (destProperty instanceof PropertyXRef) {
                        PropertyXRef pxref = (PropertyXRef)destProperty;
                        try {
                            pxref.unlink();
                            pxref.setValue(srcProperty.getValue());
                            pxref.link();
                        }
                        catch (GedcomException ex) {
                            LOG.log(Level.INFO, "", ex);
                        }
                        break;
                    }
                    destProperty.setValue(srcProperty.getValue());
                    break;
                }
                case 2: {
                    GedcomUtilities.enrichValue(srcProperty, destProperty, tag);
                    break;
                }
            }
            mergedProperties.add(destProperty);
            for (int i = 0; i < srcProperty.getNoOfProperties(); ++i) {
                GedcomUtilities.mergePropertiesRecursively(srcProperty.getProperty(i), destProperty, mergeMode, mergedProperties);
            }
        }
    }

    private static Property getSimilarProperty(Property srcProperty, Property[] srcSiblings, Property[] destSiblings, Set<Property> mergedProperties) {
        Property ret;
        String tagPath = srcProperty.getPath().toString();
        if (!bag.isCalculated(tagPath)) {
            Map<Property, Property> map = GedcomUtilities.getPropertiesMapping(srcSiblings, destSiblings);
            ret = map.get(srcProperty);
            GedcomUtilities.bag.tagpathMaps.put(tagPath, map);
        } else {
            ret = GedcomUtilities.bag.tagpathMaps.get(tagPath).get(srcProperty);
        }
        return ret == null || mergedProperties.contains(ret) ? null : ret;
    }

    public static Map<Property, Property> getPropertiesMapping(Property[] srcSiblings, Property[] destSiblings) {
        HashMap<Property, Property> map = new HashMap<Property, Property>();
        int[][] scores = new int[srcSiblings.length][destSiblings.length];
        for (int i = 0; i < srcSiblings.length; ++i) {
            for (int j = 0; j < destSiblings.length; ++j) {
                scores[i][j] = GedcomUtilities.getScore(srcSiblings[i], destSiblings[j]);
            }
        }
        while (true) {
            int maxSimilarity = 50;
            int s = -1;
            int d = -1;
            for (int j = 0; j < destSiblings.length; ++j) {
                for (int i = 0; i < srcSiblings.length; ++i) {
                    if (scores[i][j] <= maxSimilarity) continue;
                    maxSimilarity = scores[i][j];
                    s = i;
                    d = j;
                }
            }
            if (s == -1) break;
            scores[s][d] = 0;
            if (map.keySet().contains(srcSiblings[s]) || map.values().contains(destSiblings[d])) continue;
            map.put(srcSiblings[s], destSiblings[d]);
        }
        return map;
    }

    private static int getScore(Property srcSibling, Property destSibling) {
        boolean xref = false;
        String srcValue = GedcomUtilities.normalizeString(srcSibling.getValue()).toLowerCase();
        String destValue = GedcomUtilities.normalizeString(destSibling.getValue()).toLowerCase();
        if (srcSibling instanceof PropertyXRef) {
            PropertyXRef srcXref = (PropertyXRef)srcSibling;
            if (destSibling instanceof PropertyXRef) {
                PropertyXRef destXref = (PropertyXRef)destSibling;
                if (srcXref.isValid() && srcXref.getTargetEntity().isPresent() && destXref.isValid() && destXref.getTargetEntity().isPresent()) {
                    srcValue = GedcomUtilities.normalizeString(srcXref.getTargetEntity().get().getDisplayTitle(false)).toLowerCase();
                    destValue = GedcomUtilities.normalizeString(destXref.getTargetEntity().get().getDisplayTitle(false)).toLowerCase();
                    xref = true;
                } else {
                    return 0;
                }
            }
        }
        int score = 0;
        if (!srcValue.isBlank() && !destValue.isBlank()) {
            score = GedcomUtilities.similarity(srcValue, destValue, 3);
        }
        if (!xref) {
            score += GedcomUtilities.calcCosine(GedcomUtilities.getMapFromChildren(srcSibling), GedcomUtilities.getMapFromChildren(destSibling));
        }
        return score;
    }

    private static Map<String, Integer> getMapFromChildren(Property parent) {
        Map<String, Integer> ret = GedcomUtilities.bag.wordMaps.get(parent);
        if (ret != null) {
            return ret;
        }
        ArrayList<String> listOfElements = new ArrayList<String>();
        listOfElements.addAll(Arrays.asList(GedcomUtilities.normalizeAndReduce(parent.getValue().split(" "), false)));
        for (Property child : parent.getProperties()) {
            if (child.getValue().isBlank()) {
                listOfElements.addAll(GedcomUtilities.getMapFromChildren(child).keySet());
            }
            listOfElements.addAll(Arrays.asList(GedcomUtilities.normalizeAndReduce(child.getValue().split(" "), false)));
        }
        ret = GedcomUtilities.buildMap(listOfElements);
        GedcomUtilities.bag.wordMaps.put(parent, ret);
        return ret;
    }

    private static void enrichValue(Property srcProperty, Property destProperty, String tag) {
        String destValue;
        String srcValue = srcProperty.getValue();
        if (srcValue.equals(destValue = destProperty.getValue())) {
            return;
        }
        if (tag.equals("SEX") && (srcValue.equals("M") || srcValue.equals("F")) && !destValue.equals("M") && !destValue.equals("F")) {
            destProperty.setValue(srcValue);
            return;
        }
        if (srcProperty instanceof PropertyName) {
            PropertyName srcName = (PropertyName)srcProperty;
            if (destProperty instanceof PropertyName) {
                PropertyName destName = (PropertyName)destProperty;
                String srcLast = srcName.getLastName().trim();
                String srcFirst = srcName.getFirstName().trim();
                String srcNPFX = srcName.getNamePrefix().trim();
                String srcSPFX = srcName.getSurnamePrefix().trim();
                String srcNSFX = srcName.getSuffix().trim();
                String srcNick = srcName.getNick().trim();
                String destLast = destName.getLastName().trim();
                String destFirst = destName.getFirstName().trim();
                String destNPFX = destName.getNamePrefix().trim();
                String destSPFX = destName.getSurnamePrefix().trim();
                String destNSFX = destName.getSuffix().trim();
                String destNick = destName.getNick().trim();
                boolean modified = false;
                if (!srcLast.isBlank() && (destLast.isBlank() || destLast.length() < 3)) {
                    destLast = srcLast;
                    modified = true;
                }
                if (srcFirst.length() > destFirst.length()) {
                    destFirst = srcFirst;
                    modified = true;
                }
                if (srcNPFX.length() > destNPFX.length()) {
                    destNPFX = srcNPFX;
                    modified = true;
                }
                if (srcSPFX.length() > destSPFX.length()) {
                    destSPFX = srcSPFX;
                    modified = true;
                }
                if (srcNSFX.length() > destNSFX.length()) {
                    destNSFX = srcNSFX;
                    modified = true;
                }
                if (modified) {
                    destName.setName(destNPFX, destFirst, destSPFX, destLast, destNSFX);
                }
                if (srcNick.length() > destNick.length()) {
                    destName.setNick(srcNick);
                }
                return;
            }
        }
        if (srcProperty instanceof PropertyDate) {
            PropertyDate srcDate = (PropertyDate)srcProperty;
            if (destProperty instanceof PropertyDate) {
                PropertyDate destDate = (PropertyDate)destProperty;
                if (srcDate.isValid()) {
                    if (!srcDate.isRange() && destDate.isRange()) {
                        destDate.setValue(srcDate.getValue());
                    } else if (!srcDate.isRange() && !destDate.isRange()) {
                        if (srcDate.getFormat().equals(PropertyDate.DATE) && !destDate.getFormat().equals(PropertyDate.DATE)) {
                            destDate.setValue(srcDate.getValue());
                        } else {
                            PointInTime srcStart = srcDate.getStart();
                            PointInTime destStart = destDate.getStart();
                            if (srcStart.isComplete() && !destStart.isComplete()) {
                                destDate.setValue(srcDate.getValue());
                            }
                        }
                    }
                    return;
                }
            }
        }
        if (srcProperty instanceof PropertyPlace) {
            PropertyPlace srcPlace = (PropertyPlace)srcProperty;
            if (destProperty instanceof PropertyPlace) {
                PropertyPlace destPlace = (PropertyPlace)destProperty;
                if (srcPlace.isValid()) {
                    if (!srcPlace.getDisplayValue().isBlank() && !destPlace.getDisplayValue().isBlank()) {
                        String[] format = destPlace.getFormat();
                        String[] newValue = destPlace.getJurisdictions();
                        boolean modified = false;
                        for (int j = 0; j < format.length; ++j) {
                            if (srcPlace.getJurisdiction(j).isBlank() || !destPlace.getJurisdiction(j).isBlank()) continue;
                            newValue[j] = srcPlace.getJurisdiction(j);
                            modified = true;
                        }
                        if (modified) {
                            destPlace.setValue(PropertyPlace.arrayToString(newValue));
                        }
                    }
                    return;
                }
            }
        }
        if (srcProperty instanceof PropertyMultilineValue) {
            PropertyMultilineValue srcMultiline = (PropertyMultilineValue)srcProperty;
            if (destProperty instanceof PropertyMultilineValue) {
                PropertyMultilineValue destMultiline = (PropertyMultilineValue)destProperty;
                String srcLines = srcMultiline.getValue();
                Object destLines = destMultiline.getValue();
                if (!srcLines.toLowerCase().contains(((String)destLines).toLowerCase()) && !((String)destLines).toLowerCase().contains(srcLines.toLowerCase())) {
                    destLines = (String)destLines + "\n\n" + srcLines;
                    destMultiline.setValue((String)destLines);
                }
                return;
            }
        }
        if (GedcomConstants.TAG_YES_EVENTS.contains(tag) || GedcomConstants.TAG_ATTR_EVENTS_MAP.get(Grammar.V70).contains(tag)) {
            if (srcValue.length() > destValue.length() && (!srcValue.equals("Y") || srcValue.equals("Y") && srcProperty.getNoOfProperties() + destProperty.getNoOfProperties() == 0)) {
                destProperty.setValue(srcValue);
            }
            return;
        }
        if (srcProperty instanceof PropertyAge) {
            PropertyAge srcAge = (PropertyAge)srcProperty;
            if (destProperty instanceof PropertyAge) {
                PropertyAge destAge = (PropertyAge)destProperty;
                if (srcAge.isValid() && !destAge.isValid()) {
                    destAge.setValue(srcAge.getValue());
                }
                if (srcAge.isValid() && destAge.isValid() && !srcAge.getAge().isZero() && destAge.getAge().isZero()) {
                    destAge.setValue(srcAge.getValue());
                }
                return;
            }
        }
        if (srcProperty instanceof PropertyCreate) {
            PropertyCreate srcCreate = (PropertyCreate)srcProperty;
            if (destProperty instanceof PropertyCreate) {
                PropertyCreate destCreate = (PropertyCreate)destProperty;
                if (srcCreate.compareTo(destProperty) < 0) {
                    destCreate.setValue(srcCreate.getValue());
                }
                return;
            }
        }
        if (srcProperty instanceof PropertyXRef) {
            PropertyXRef srcXref = (PropertyXRef)srcProperty;
            if (destProperty instanceof PropertyXRef) {
                PropertyXRef destXref = (PropertyXRef)destProperty;
                if (srcXref.isValid() && srcXref.getTargetEntity().isPresent() && destXref.isValid() && destXref.getTargetEntity().isPresent()) {
                    String srcEntityValue = srcXref.getTargetEntity().get().getDisplayTitle(false);
                    String destEntityValue = destXref.getTargetEntity().get().getDisplayTitle(false);
                    if (srcEntityValue.length() > destEntityValue.length()) {
                        destXref.unlink();
                        destXref.setValue(srcValue);
                        try {
                            destXref.link();
                        }
                        catch (GedcomException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        }
    }

    public static String normalizeAndReduce(String str) {
        String ret = GedcomUtilities.normalizeString(str).toLowerCase();
        return ret.length() > 2 ? ret : "";
    }

    public static String[] normalizeAndReduce(String[] str, boolean split) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String str1 : str) {
            if (split) {
                String[] bits;
                for (String bit : bits = GedcomUtilities.normalizeAndReduce(str1).split(" ")) {
                    if (bit.isBlank()) continue;
                    ret.add(bit);
                }
                continue;
            }
            String bit = GedcomUtilities.normalizeAndReduce(str1);
            if (bit.isBlank()) continue;
            ret.add(bit);
        }
        return (String[])ret.toArray(String[]::new);
    }

    private static List<String> ngrams(int n, String str) {
        ArrayList<String> ngrams = new ArrayList<String>();
        for (int i = 0; i < str.length() - n + 1; ++i) {
            ngrams.add(str.substring(i, i + n));
        }
        return ngrams;
    }

    public static boolean isSimilar(String str1, String str2) {
        int min = Math.min(str1.length(), str2.length());
        int n = min <= 6 ? 2 : 3;
        int threshold = 60;
        return GedcomUtilities.similarity(str1, str2, n) >= threshold;
    }

    public static int similarity(String left, String right, int n) {
        if (left == null || right == null || left.isBlank() || right.isBlank()) {
            return 0;
        }
        if (left.equals(right)) {
            return 100;
        }
        List<String> ngrams1 = GedcomUtilities.ngrams(n, left);
        List<String> ngrams2 = GedcomUtilities.ngrams(n, right);
        return GedcomUtilities.calcCosine(GedcomUtilities.buildMap(ngrams1), GedcomUtilities.buildMap(ngrams2));
    }

    public static Map<String, Integer> buildMap(List<String> ngrams) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ngrams.forEach(word -> map.put((String)word, map.getOrDefault(word, 0) + 1));
        return map;
    }

    public static int calcCosine(Map<String, Integer> map1, Map<String, Integer> map2) {
        if (map1.isEmpty() || map2.isEmpty()) {
            return 0;
        }
        HashSet<String> uniqueKeySet = new HashSet<String>();
        for (String word : map1.keySet()) {
            uniqueKeySet.add(word);
        }
        for (String word : map2.keySet()) {
            uniqueKeySet.add(word);
        }
        int sumProduct = 0;
        int sumAs = 0;
        int sumBs = 0;
        for (String word : uniqueKeySet) {
            Integer b;
            Integer a = map1.get(word);
            if (a == null) {
                a = 0;
            }
            if ((b = map2.get(word)) == null) {
                b = 0;
            }
            sumProduct += a * b;
            sumAs += a * a;
            sumBs += b * b;
        }
        double cosine = (double)sumProduct / (Math.sqrt(sumAs) * Math.sqrt(sumBs)) + 1.0E-7;
        return (int)(100.0 * cosine);
    }

    public static boolean isSameValue(Property propertySrc, Property propertyDest) {
        PropertyXRef xref;
        if (propertySrc == null || propertyDest == null) {
            return false;
        }
        if (propertySrc instanceof Entity) {
            Entity entSrc = (Entity)propertySrc;
            if (propertyDest instanceof Entity) {
                Entity entDest = (Entity)propertyDest;
                return GedcomUtilities.isSameNames(entSrc, entDest);
            }
        }
        String valueSrc = "";
        String valueDest = "";
        Entity entSrc = null;
        Entity entDest = null;
        if (propertySrc instanceof PropertyXRef && (xref = (PropertyXRef)propertySrc).isValid() && xref.getTargetEntity().isPresent()) {
            entSrc = xref.getTargetEntity().get();
        } else {
            valueSrc = propertySrc.getValue();
        }
        if (propertyDest instanceof PropertyXRef && (xref = (PropertyXRef)propertyDest).isValid() && xref.getTargetEntity().isPresent()) {
            entDest = xref.getTargetEntity().get();
        } else {
            valueDest = propertyDest.getValue();
        }
        return entSrc == null || entDest == null ? valueSrc.equals(valueDest) : GedcomUtilities.isSameNames(entSrc, entDest);
    }

    public static boolean isSameNames(Entity entA, Entity entB) {
        if (GedcomUtilities.normalizeString(entA.toString(false)).equals(GedcomUtilities.normalizeString(entB.toString(false)))) {
            return true;
        }
        if (entA instanceof Indi) {
            Indi indiA = (Indi)entA;
            if (entB instanceof Indi) {
                Indi indiB = (Indi)entB;
                if (GedcomUtilities.normalizeString(indiA.getFullSurname()).equals(GedcomUtilities.normalizeString(indiB.getFullSurname()))) {
                    return true;
                }
            }
        }
        if (entA instanceof Fam) {
            Fam famA = (Fam)entA;
            if (entB instanceof Fam) {
                Fam famB = (Fam)entB;
                Indi husbA = famA.getHusband();
                Indi husbB = famB.getHusband();
                Indi wifeA = famA.getWife();
                Indi wifeB = famB.getWife();
                if (husbA != null && husbB != null && wifeA != null && wifeB != null && GedcomUtilities.normalizeString(husbA.getFullSurname()).equals(GedcomUtilities.normalizeString(husbB.getFullSurname())) && GedcomUtilities.normalizeString(wifeA.getFullSurname()).equals(GedcomUtilities.normalizeString(wifeB.getFullSurname()))) {
                    return true;
                }
            }
        }
        return false;
    }

    public static String normalizeString(String str) {
        String normalized = Utilities.removeDiacritics(str);
        normalized = normalized.replaceAll("[^A-Za-z0-9]", " ").replaceAll(" +", " ").trim();
        return normalized;
    }

    public static Entity copyEntity(Entity sourceEntity, Gedcom targetGedcom, boolean richCopy) {
        Entity newEntity = null;
        try {
            newEntity = targetGedcom.createEntity(sourceEntity.getTag());
        }
        catch (GedcomException ex) {
            LOG.log(Level.INFO, "", ex);
        }
        if (newEntity == null) {
            return newEntity;
        }
        GedcomUtilities.copyPropertiesRecursively(sourceEntity, newEntity, richCopy);
        return newEntity;
    }

    public static void copyPropertiesRecursively(Property srcProperty, Property destProperty, boolean richCopy) {
        if (srcProperty == null || destProperty == null) {
            return;
        }
        for (int i = 0; i < srcProperty.getNoOfProperties(); ++i) {
            Property addedProperty;
            Property child = srcProperty.getProperty(i);
            if (child.getTag().equals("CHAN") || child instanceof PropertyForeignXRef) continue;
            if (child instanceof PropertyXRef) {
                String tag;
                Entity entityToCopy;
                Set<String> allowed;
                PropertyXRef propertyXRef = (PropertyXRef)child;
                try {
                    addedProperty = destProperty.addProperty(child.getTag(), child.getValue(), i);
                    ((PropertyXRef)addedProperty).link();
                    GedcomUtilities.copyPropertiesRecursively(child, addedProperty, richCopy);
                }
                catch (GedcomException ex) {
                    LOG.log(Level.INFO, "", ex);
                }
                if (!richCopy || (allowed = allows.get(srcProperty.getEntity().getTag())) == null || (entityToCopy = (Entity)propertyXRef.getTargetEntity().orElse(null)) == null || !allowed.contains(tag = entityToCopy.getTag())) continue;
                Entity ent = GedcomUtilities.copyEntity(entityToCopy, destProperty.getGedcom(), richCopy);
                try {
                    Property addedProperty2 = destProperty.addProperty(child.getTag(), child.getValue(), i);
                    ((PropertyXRef)addedProperty2).setValue(ent.getId());
                    ((PropertyXRef)addedProperty2).link();
                    GedcomUtilities.copyPropertiesRecursively(child, addedProperty2, richCopy);
                }
                catch (GedcomException ex) {
                    LOG.log(Level.INFO, "", ex);
                }
                continue;
            }
            if (child instanceof PropertyName) {
                try {
                    addedProperty = destProperty.addProperty(child.getTag(), "", i);
                    GedcomUtilities.copyPropertiesRecursively(child, addedProperty, richCopy);
                }
                catch (GedcomException ex) {
                    LOG.log(Level.INFO, "", ex);
                }
                continue;
            }
            try {
                addedProperty = destProperty.addProperty(child.getTag(), child.getValue(), i);
                GedcomUtilities.copyPropertiesRecursively(child, addedProperty, richCopy);
                continue;
            }
            catch (GedcomException ex) {
                LOG.log(Level.INFO, "", ex);
            }
        }
    }

    public static Entity attach(Entity importedEntity, Property targetProperty) {
        Gedcom gedcom = targetProperty.getGedcom();
        Entity attachedEntity = importedEntity;
        if (gedcom.compareTo(importedEntity.getGedcom()) != 0) {
            attachedEntity = GedcomUtilities.copyEntity(importedEntity, gedcom, true);
        }
        try {
            Property xref = targetProperty.addProperty(attachedEntity.getTag(), "@" + attachedEntity.getId() + "@", targetProperty.getNoOfProperties());
            if (xref != null && xref instanceof PropertyXRef) {
                ((PropertyXRef)xref).link();
            }
        }
        catch (GedcomException ex) {
            LOG.log(Level.INFO, "", ex);
        }
        return targetProperty.getEntity();
    }

    public static Entity createParent(boolean isHusband, Indi indi, Fam fam, Gedcom gedcom) {
        Fam targetEntity = fam;
        Indi targetIndi = indi;
        if (fam.getGedcom().compareTo(gedcom) != 0) {
            targetEntity = (Fam)GedcomUtilities.copyEntity(fam, gedcom, true);
        }
        if (indi.getGedcom().compareTo(gedcom) != 0) {
            targetIndi = (Indi)GedcomUtilities.copyEntity(indi, gedcom, true);
        }
        PropertyXRef xref = null;
        try {
            xref = isHusband ? targetEntity.setHusband(targetIndi) : targetEntity.setWife(targetIndi);
        }
        catch (GedcomException ex) {
            LOG.log(Level.INFO, "", ex);
        }
        return xref != null ? xref.getEntity() : null;
    }

    public static Entity createChild(Indi child, Fam fam, Gedcom gedcom) {
        Fam targetEntity = fam;
        Indi targetIndi = child;
        if (fam.getGedcom().compareTo(gedcom) != 0) {
            targetEntity = (Fam)GedcomUtilities.copyEntity(fam, gedcom, true);
        }
        if (child.getGedcom().compareTo(gedcom) != 0) {
            targetIndi = (Indi)GedcomUtilities.copyEntity(child, gedcom, true);
        }
        PropertyXRef xref = null;
        try {
            xref = targetEntity.addChild(targetIndi);
        }
        catch (GedcomException ex) {
            LOG.log(Level.INFO, "", ex);
        }
        return xref != null ? xref.getEntity() : null;
    }

    public static Fam createFamily(Gedcom gedcom, Indi husb, Indi wife, Indi child) {
        Fam fam;
        try {
            fam = (Fam)gedcom.createEntity("FAM");
        }
        catch (GedcomException ex) {
            LOG.log(Level.INFO, "", ex);
            return null;
        }
        if (husb != null) {
            try {
                fam.setHusband(husb);
            }
            catch (GedcomException ex) {
                LOG.log(Level.INFO, "", ex);
            }
        }
        if (wife != null) {
            try {
                fam.setWife(wife);
            }
            catch (GedcomException ex) {
                LOG.log(Level.INFO, "", ex);
            }
        }
        if (child != null) {
            try {
                fam.addChild(child);
            }
            catch (GedcomException ex) {
                LOG.log(Level.INFO, "", ex);
            }
        }
        return fam;
    }

    static {
        allows.put("FAM", new HashSet<String>(Arrays.asList("INDI", "SOUR", "OBJE", "NOTE", "SOTE")));
        allows.put("INDI", new HashSet<String>(Arrays.asList("SOUR", "OBJE", "NOTE", "SOTE")));
        allows.put("SOUR", new HashSet<String>(Arrays.asList("OBJE", "NOTE", "SOTE", "REPO")));
        allows.put("OBJE", new HashSet<String>(Arrays.asList("NOTE", "SOTE")));
    }

    private static class SimilarityBag {
        public Map<String, Map<Property, Property>> tagpathMaps = new HashMap<String, Map<Property, Property>>();
        public Map<Property, Map<String, Integer>> wordMaps = new HashMap<Property, Map<String, Integer>>();

        public void clear() {
            this.tagpathMaps.clear();
            this.wordMaps.clear();
        }

        private boolean isCalculated(String tagPath) {
            return this.tagpathMaps.get(tagPath) != null;
        }
    }
}

