/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import ancestris.api.search.SearchCommunicator;
import ancestris.reports.ScopeOptions;
import ancestris.reports.relatives.ReportRelatives;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.report.Report;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openide.util.NbBundle;

public class ScopeFamOptions
extends ScopeOptions {
    public int scopeType = 0;
    public String[] scopeTypes = this.getScopes();
    public int chosenIndi = 0;
    public String[] chosenIndis = this.getReferences();
    public int nbgen = 0;
    public int livingInYear = 0;

    @Override
    public List<String[]> getMessages() {
        List<String[]> ret = super.getMessages();
        if (this.scopeType == 2 || this.scopeType == 3 || this.scopeType == 4) {
            ret.add(new String[]{NbBundle.getMessage(ScopeOptions.class, (String)"nbgen"), this.nbgen == 0 ? NbBundle.getMessage(ScopeOptions.class, (String)"nbgenAll") : String.valueOf(this.nbgen)});
        }
        return ret;
    }

    public List<Fam> getScope(Object context, Report report) {
        Object fam2;
        Object o = this.setRootEntity(context, "FAM", report, this.chosenIndi, this.scopeType, this.livingInYear);
        if (o == null) {
            return null;
        }
        if (o instanceof ArrayList) {
            ArrayList list = (ArrayList)o;
            return list;
        }
        Entity entity = this.getRootEntity();
        HashSet<Object> fams = new HashSet<Object>();
        Indi selectedHusb = null;
        Indi selectedWife = null;
        if (entity instanceof Indi) {
            Indi indi;
            selectedHusb = indi = (Indi)entity;
            selectedWife = indi;
            entity = indi.getPreferredFamily();
        } else if (entity instanceof Fam) {
            fam2 = (Fam)entity;
            Indi husb = fam2.getHusband();
            Indi wife = fam2.getWife();
            if (husb != null) {
                selectedHusb = husb;
            }
            if (wife != null) {
                selectedWife = wife;
            }
        }
        if (selectedHusb == null && selectedWife != null) {
            selectedHusb = selectedWife;
        }
        if (selectedHusb != null && selectedWife == null) {
            selectedWife = selectedHusb;
        }
        if (selectedHusb == null && selectedWife == null) {
            selectedWife = selectedHusb = this.gedcom.getDeCujusIndi();
        }
        if (selectedHusb == null && selectedWife == null) {
            selectedWife = selectedHusb = (Indi)this.gedcom.getFirstEntity("INDI");
        }
        this.gedcom = selectedHusb.getGedcom();
        if (this.hasReference() && entity instanceof Fam) {
            fams.addAll(Arrays.asList(selectedHusb.getFamiliesWhereSpouse()));
            fams.addAll(Arrays.asList(selectedWife.getFamiliesWhereSpouse()));
        }
        if (this.scopeType == 5) {
            HashSet<Indi> indis = new HashSet<Indi>();
            indis.addAll(new ReportRelatives().getRelatives(selectedHusb));
            indis.addAll(new ReportRelatives().getRelatives(selectedWife));
            for (Indi indi : indis) {
                fams.addAll(Arrays.asList(indi.getFamiliesWhereSpouse()));
            }
        } else if (this.scopeType != 1) {
            if (this.scopeType == 7) {
                List ents = SearchCommunicator.getResultEntities((Gedcom)this.gedcom);
                fam2 = ents.iterator();
                while (fam2.hasNext()) {
                    Entity ent = (Entity)fam2.next();
                    if (!(ent instanceof Fam)) continue;
                    Fam resultFam = (Fam)ent;
                    fams.add(resultFam);
                }
            } else if (!this.hasReference()) {
                for (Object fam2 : this.gedcom.getFamilies()) {
                    if (this.scopeType == 6 && this.areContemporaries((Entity)fam2, selectedHusb) && selectedWife != selectedHusb && this.areContemporaries((Entity)fam2, selectedWife)) {
                        fams.add(fam2);
                    }
                    if (this.scopeType != 8 || !this.isAliveIn((Entity)fam2, this.livingInYear)) continue;
                    fams.add(fam2);
                }
            } else if (this.scopeType == 2) {
                fams.addAll(this.getDescendantFams(selectedHusb, selectedWife, this.nbgen));
            } else if (this.scopeType == 3) {
                ancestors = new HashSet<Fam>();
                ancestors.addAll(this.getAncestorFams(selectedHusb, this.nbgen));
                if (selectedWife == selectedHusb) {
                    ancestors.addAll(this.getAncestorFams(selectedWife, this.nbgen));
                }
                fams.addAll(ancestors);
            } else if (this.scopeType == 4) {
                fams.addAll(this.getDescendantFams(selectedHusb, selectedWife, this.nbgen));
                ancestors = new HashSet();
                ancestors.addAll(this.getAncestorFams(selectedHusb, this.nbgen));
                if (selectedWife != selectedHusb) {
                    ancestors.addAll(this.getAncestorFams(selectedWife, this.nbgen));
                }
                fams.addAll(ancestors);
            }
        }
        return new ArrayList<Fam>(fams);
    }

    private Set<Fam> getAncestorFams(Indi selectedHusb, int nbgen) {
        HashSet<Fam> ancestors = new HashSet<Fam>();
        this.addParents(selectedHusb.getFamilyWhereBiologicalChild(), ancestors, 1, nbgen);
        return ancestors;
    }

    private void addParents(Fam fam, Set<Fam> ancestors, int i, int nbgen) {
        Indi mother;
        if (fam == null || nbgen != 0 && i > nbgen) {
            return;
        }
        ancestors.add(fam);
        Indi father = fam.getHusband();
        if (father != null) {
            this.addParents(father.getFamilyWhereBiologicalChild(), ancestors, i + 1, nbgen);
        }
        if ((mother = fam.getWife()) != null) {
            this.addParents(mother.getFamilyWhereBiologicalChild(), ancestors, i + 1, nbgen);
        }
    }

    private Set<Fam> getDescendantFams(Indi selectedHusb, Indi selectedWife, int nbgen) {
        HashSet<Fam> descendants = new HashSet<Fam>();
        for (Fam fam : selectedHusb.getFamiliesWhereSpouse()) {
            if (selectedHusb != selectedWife && !selectedWife.isSpouseIn(fam)) continue;
            this.addChildren(fam, descendants, 1, nbgen);
        }
        return descendants;
    }

    private void addChildren(Fam fam, Set<Fam> descendants, int i, int nbgen) {
        if (nbgen != 0 && i > nbgen) {
            return;
        }
        for (Indi child : fam.getChildren()) {
            for (Fam childfam : child.getFamiliesWhereSpouse()) {
                descendants.add(childfam);
                this.addChildren(childfam, descendants, i + 1, nbgen);
            }
        }
    }
}

