/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.samevalues;

import ancestris.gedcom.GedcomDirectory;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.report.Report;
import genj.view.ViewContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ReportSameValues
extends Report {
    public String accepts(Object context) {
        Property property;
        Context selected = GedcomDirectory.getDefault().getDefaultContext();
        if (selected != null && (property = selected.getProperty()) != null) {
            return property.getValue().isBlank() ? null : this.translate("xname", new Object[]{property.getPropertyName(), property.getValue()});
        }
        return null;
    }

    public List<ViewContext> start(Gedcom gedcom) {
        Property property;
        Context selected = GedcomDirectory.getDefault().getDefaultContext();
        if (selected != null && (property = selected.getProperty()) != null) {
            return this.find(property);
        }
        this.println(this.translate("warning.property"));
        return null;
    }

    public List<ViewContext> start(Property property) {
        if (property == null) {
            return null;
        }
        if (property instanceof Entity) {
            return this.start(property.getGedcom());
        }
        return this.find(property);
    }

    private List<ViewContext> find(Property property) {
        Gedcom gedcom = property.getGedcom();
        String val = property.getValue();
        if (!val.isBlank()) {
            Set set = gedcom.getReferenceSet(property.getTag()).getReferences((Object)val);
            if (set.isEmpty()) {
                Class<?> clazz = property.getClass();
                List list = gedcom.getPropertiesByClass(clazz);
                for (Property prop : list) {
                    if (!prop.getValue().equals(val)) continue;
                    set.add(prop);
                }
            }
            if (!set.isEmpty()) {
                ArrayList<ViewContext> result = new ArrayList<ViewContext>();
                for (Property prop : set) {
                    Property parent = prop.getParent();
                    StringBuilder sb = new StringBuilder();
                    if (parent != null) {
                        sb.append(parent.getPropertyName());
                        sb.append(" | ");
                    }
                    sb.append(prop.getPropertyName());
                    sb.append(" | ");
                    sb.append(prop.getDisplayValue());
                    sb.append(" | ");
                    sb.append(prop.getEntity().toString());
                    result.add(new ViewContext(prop).setText(sb.toString()));
                }
                Collections.sort(result);
                return result;
            }
        }
        this.println(this.translate("warning.property.value"));
        return null;
    }
}

