/*
 * Decompiled with CFR 0.152.
 */
package genj.timeline;

import ancestris.core.TextOptions;
import ancestris.util.TimingUtility;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.gedcom.time.GregorianCalendar;
import genj.gedcom.time.PointInTime;
import genj.timeline.TimelineView;
import genj.util.swing.ImageIcon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

class Model {
    private static final Logger LOG = Logger.getLogger("ancestris.chronology");
    private Context context;
    private Gedcom gedcom;
    public double max = Double.NaN;
    public double min = Double.NaN;
    public double now = Model.today();
    private final Set<TagPath> paths = new HashSet<TagPath>();
    private final Set<String> tags = new HashSet<String>();
    private static final String[] DEFAULT_PATHS = new String[]{"INDI:BIRT", "INDI:BAPM", "FAM:MARR", "FAM:DIV", "INDI:DEAT"};
    private final Map<Double, Event> eventMap = new TreeMap<Double, Event>();
    private final Map<Indi, EventSerie> indiSeries = new HashMap<Indi, EventSerie>();
    private static final Double INCREMENT_D = 1.0E-8;
    public List<List<Event>> eventLayers = new ArrayList<List<Event>>();
    public List<List<EventSerie>> indiLayers = new ArrayList<List<EventSerie>>();
    double timeBeforeEvent = 0.5;
    double timeAfterEvent = 2.0;
    double cmPerYear = 0.0;
    static int EST_SPAN = 9;
    static int EST_LIVING = 100;
    boolean isPackIndi = false;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final Callback callback = new Callback();
    private RequestProcessor.Task layoutAllLayersThread;
    private RequestProcessor.Task layoutEventLayersThread;
    private RequestProcessor.Task layoutIndiLayersThread;
    private final Object lock = new Object();
    private boolean isRebuilding = false;
    private boolean isRedrawing = false;
    private static RequestProcessor RP = null;
    private int progressCounter = 0;
    private boolean isGedcomChanging = false;
    private final TimelineView view;

    public Model(TimelineView view) {
        this.view = view;
    }

    public void setPaths(Collection<TagPath> set, boolean rebuild) {
        if (set == null) {
            set = Arrays.asList(TagPath.toArray((String[])DEFAULT_PATHS));
        }
        this.paths.clear();
        this.tags.clear();
        for (TagPath path : set) {
            this.paths.add(path);
            this.tags.add(path.getLast());
        }
        if (rebuild) {
            this.createAndLayoutAllLayers();
        }
    }

    Gedcom getGedcom() {
        return this.gedcom;
    }

    public void setGedcom(Context context) {
        if (context == null) {
            return;
        }
        Gedcom newGedcom = context.getGedcom();
        if (this.gedcom == newGedcom) {
            if (this.context != context) {
                this.context = context;
                this.view.update();
            }
            return;
        }
        this.context = context;
        if (this.gedcom != null) {
            this.gedcom.removeGedcomListener((GedcomListener)this.callback);
        }
        this.gedcom = newGedcom;
        if (this.gedcom != null) {
            this.gedcom.addGedcomListener((GedcomListener)this.callback);
        }
        this.createAndLayoutAllLayers();
    }

    private void updateView() {
        this.view.update();
    }

    void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    void removeListener(Listener listener) {
        this.listeners.remove(listener);
        if (this.gedcom != null && this.callback != null) {
            this.gedcom.removeGedcomListener((GedcomListener)this.callback);
        }
    }

    void setTimePerEvent(double before, double after, double cm, boolean redraw) {
        if (this.timeBeforeEvent == before && this.timeAfterEvent == after) {
            return;
        }
        if (this.eventMap == null || this.indiSeries == null) {
            return;
        }
        this.timeBeforeEvent = before;
        this.timeAfterEvent = after;
        this.cmPerYear = cm;
        if (redraw) {
            this.layoutLayers(false);
        }
    }

    public void setPackIndi(boolean set, boolean redraw) {
        this.isPackIndi = set;
        if (redraw) {
            this.layoutLayers(true);
        }
    }

    public void layoutLayers(boolean indiOnly) {
        this.setMinMax();
        if (this.isRebuilding || this.isRedrawing) {
            return;
        }
        if (!indiOnly) {
            this.layoutEventLayers();
        }
        this.layoutIndiLayers();
    }

    private void setMinMax() {
        if (!this.eventMap.isEmpty()) {
            ArrayList<Double> tmpList = new ArrayList<Double>(this.eventMap.keySet());
            this.min = (Double)tmpList.get(0) - 2.0 * this.timeBeforeEvent;
            this.max = Math.max((Double)tmpList.get(this.eventMap.size() - 1), this.now + 1.0) + 2.0 * this.timeAfterEvent;
        }
    }

    public boolean isReady() {
        return !this.isRebuilding && !this.isRedrawing;
    }

    public double getCmPerYear() {
        return this.cmPerYear;
    }

    private static double today() {
        Calendar cal = Calendar.getInstance();
        PointInTime pit = new PointInTime(cal);
        try {
            return Model.toDouble(pit, false);
        }
        catch (GedcomException gedcomException) {
            return 0.0;
        }
    }

    public static double toDouble(PointInTime pit, boolean roundUp) throws GedcomException {
        GregorianCalendar calendar = PointInTime.GREGORIAN;
        if (pit.getCalendar() != calendar) {
            pit = pit.getPointInTime((genj.gedcom.time.Calendar)calendar);
        }
        int year = pit.getYear();
        double result = year;
        int month = pit.getMonth();
        if (month == Integer.MAX_VALUE) {
            return roundUp ? result + 1.0 : result;
        }
        double months = calendar.getMonths();
        result += (double)month / months;
        int day = pit.getDay();
        if (day == Integer.MAX_VALUE) {
            return roundUp ? result + 1.0 / months : result;
        }
        double days = calendar.getDays(month, year);
        return result += (double)day / months / days;
    }

    static PointInTime toPointInTime(double year) {
        GregorianCalendar calendar = PointInTime.GREGORIAN;
        int months = calendar.getMonths();
        int y = (int)Math.floor(year);
        if ((year %= 1.0) < 0.0) {
            year = 1.0 + year;
        }
        int m = (int)Math.floor(year * (double)months);
        int days = calendar.getDays(m, y);
        int d = (int)Math.floor(year * (double)months % 1.0 * (double)days);
        return new PointInTime(d, m, y);
    }

    protected Event getEvent(double year, int layer) {
        if (layer >= this.eventLayers.size()) {
            return null;
        }
        for (Event event : this.eventLayers.get(layer)) {
            if (!(event.from - this.timeBeforeEvent < year) || !(year < event.to + this.timeAfterEvent)) continue;
            return event;
        }
        return null;
    }

    protected EventSerie getEventSerie(double year, int layer) {
        if (layer >= this.indiLayers.size()) {
            return null;
        }
        for (EventSerie eventSerie : this.indiLayers.get(layer)) {
            if (!(eventSerie.from - this.timeBeforeEvent < year) || !(year < eventSerie.to + this.timeAfterEvent)) continue;
            return eventSerie;
        }
        return null;
    }

    public int getLayerFromEvent(Event event) {
        if (event == null) {
            return 0;
        }
        int layer = 0;
        for (List<Event> layers : this.eventLayers) {
            for (Event e : layers) {
                if (e != event) continue;
                return layer;
            }
            ++layer;
        }
        return 0;
    }

    public int getLayerFromEventSerie(EventSerie eventSerie) {
        if (eventSerie == null) {
            return 0;
        }
        int layer = 0;
        for (List<EventSerie> layers : this.indiLayers) {
            for (EventSerie es : layers) {
                if (es != eventSerie) continue;
                return layer;
            }
            ++layer;
        }
        return 0;
    }

    public List<Entity> getAllContextEntities(Context context) {
        ArrayList<Entity> ents = new ArrayList<Entity>();
        for (Entity ent : context.getEntities()) {
            Indi indi;
            ents.add(ent);
            if (ent instanceof Indi) {
                indi = (Indi)ent;
                Fam[] fams = indi.getFamiliesWhereSpouse();
                ents.addAll(Arrays.asList(fams));
            }
            if (ent instanceof Fam) {
                Indi wife;
                Fam fam = (Fam)ent;
                Indi husb = fam.getHusband();
                if (husb != null) {
                    ents.add((Entity)husb);
                }
                if ((wife = fam.getWife()) != null) {
                    ents.add((Entity)wife);
                }
                ents.addAll(Arrays.asList(fam.getChildren()));
            }
            if ((indi = this.getIndiFromEntity(ent)) == null) continue;
            ents.add((Entity)indi);
        }
        return ents;
    }

    private Indi getIndiFromEntity(Entity entity) {
        Entity target;
        if (entity == null) {
            return null;
        }
        if (entity instanceof Indi) {
            return (Indi)entity;
        }
        if (entity instanceof Fam) {
            Fam fam = (Fam)entity;
            Indi husb = fam.getHusband();
            Indi wife = fam.getWife();
            if (husb == null && wife == null) {
                Indi[] children = fam.getChildren(true);
                if (children.length == 0) {
                    return null;
                }
                return children[0];
            }
            if (husb != null && wife == null) {
                return husb;
            }
            if (wife != null && husb == null) {
                return wife;
            }
            Indi ancestorHusb = this.getOldestAgnaticAncestor(husb, new HashSet<Indi>());
            Indi ancestorWife = this.getOldestAgnaticAncestor(wife, new HashSet<Indi>());
            PropertyDate ahbd = ancestorHusb.getBirthDate();
            PropertyDate awbd = ancestorWife.getBirthDate();
            if (ahbd != null && awbd != null && ahbd.isValid() && awbd.isValid()) {
                if (awbd.compareTo((Property)ahbd) > 0) {
                    return husb;
                }
                return wife;
            }
            if ((ahbd == null || !ahbd.isValid()) && awbd != null && awbd.isValid()) {
                return wife;
            }
            if (ahbd != null && ahbd.isValid() && (awbd == null || !awbd.isValid())) {
                return husb;
            }
            return husb;
        }
        for (PropertyXRef xref : entity.getProperties(PropertyXRef.class)) {
            target = xref.getTargetEntity().orElse(null);
            if (!(target instanceof Indi)) continue;
            return (Indi)target;
        }
        for (PropertyXRef xref : entity.getProperties(PropertyXRef.class)) {
            target = xref.getTargetEntity().orElse(null);
            if (!(target instanceof Fam)) continue;
            return this.getIndiFromEntity(target);
        }
        return (Indi)entity.getGedcom().getFirstEntity("INDI");
    }

    public Set<TagPath> getPaths() {
        return Collections.unmodifiableSet(this.paths);
    }

    private void fireStructureChanged() {
        for (int l = this.listeners.size() - 1; l >= 0; --l) {
            this.listeners.get(l).structureChanged();
        }
    }

    public int getMaxLayersNumber() {
        return Math.max(this.indiLayers == null ? 0 : this.indiLayers.size(), this.eventLayers == null ? 0 : this.eventLayers.size());
    }

    public int getLayersNumber(int mode) {
        if (mode == TimelineView.INDI_MODE) {
            return this.indiLayers == null ? 0 : this.indiLayers.size();
        }
        return this.eventLayers == null ? 0 : this.eventLayers.size();
    }

    private void createAndLayoutAllLayers() {
        if (this.gedcom == null || this.isRebuilding) {
            return;
        }
        TimingUtility tu = new TimingUtility();
        LOG.log(Level.FINER, "{0} - Launch tasks to create all events, individuals and then lay out the layers", tu.getTime());
        ProgressHandle ph = ProgressHandle.createHandle((String)"", () -> {
            if (null == this.layoutAllLayersThread) {
                return false;
            }
            return this.layoutAllLayersThread.cancel();
        });
        Runnable runnable = () -> {
            Object object = this.lock;
            synchronized (object) {
                while (this.isRebuilding || this.isRedrawing) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                this.isRebuilding = true;
                LOG.log(Level.FINER, "{0} - Executing tasks to create all events, individuals and then lay out the layers...Start.", tu.getTime());
                this.min = Double.MAX_VALUE;
                this.max = -1.7976931348623157E308;
                this.eventMap.clear();
                this.indiSeries.clear();
                try {
                    ph.setDisplayName(NbBundle.getMessage(this.getClass(), (String)"TXT_CreateLayers_Msg1"));
                    ph.start();
                    ph.switchToDeterminate(this.gedcom.getIndis().size() + this.gedcom.getFamilies().size());
                    this.progressCounter = 0;
                    this.createEventsFromEntities(this.gedcom.getEntities("INDI"), ph);
                    this.createEventsFromEntities(this.gedcom.getEntities("FAM"), ph);
                    this.isRebuilding = false;
                    this.setMinMax();
                    this.layoutEventLayers();
                    this.layoutIndiLayers();
                    this.lock.notifyAll();
                }
                catch (MissingResourceException t) {
                    LOG.log(Level.SEVERE, "Error in calculating events", t);
                }
                LOG.log(Level.FINER, "{0} - Executing tasks to create all events, individuals and then lay out the layers...End.", tu.getTime());
            }
        };
        if (RP == null) {
            RP = new RequestProcessor("Chrono Model View", 1, true);
        }
        this.layoutAllLayersThread = RP.create(runnable);
        this.layoutAllLayersThread.addTaskListener(task -> {
            ph.finish();
            this.isRebuilding = false;
        });
        this.layoutAllLayersThread.schedule(0);
    }

    private void layoutEventLayers() {
        if (this.gedcom == null) {
            return;
        }
        TimingUtility tu = new TimingUtility();
        LOG.log(Level.FINER, tu.getTime() + " - Launch task to lay out EVENT layers");
        ProgressHandle ph = ProgressHandle.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"TXT_CreateLayers_Msg2"), () -> {
            if (null == this.layoutEventLayersThread) {
                return false;
            }
            return this.layoutEventLayersThread.cancel();
        });
        Runnable runnable = () -> {
            Object object = this.lock;
            synchronized (object) {
                while (this.isRebuilding || this.isRedrawing) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                this.isRedrawing = true;
                LOG.log(Level.FINER, tu.getTime() + " - Executing tasks to lay out EVENT layers...Start.");
                try {
                    ph.start();
                    ph.switchToDeterminate(this.eventMap.size());
                    this.progressCounter = 0;
                    this.createEventLayers(ph);
                    this.lock.notifyAll();
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Error in calculating events", t);
                }
                LOG.log(Level.FINER, tu.getTime() + " - Executing tasks to lay out EVENT layers...End.");
            }
        };
        if (RP == null) {
            RP = new RequestProcessor("Chrono Model View", 1, true);
        }
        this.layoutEventLayersThread = RP.create(runnable);
        this.layoutEventLayersThread.addTaskListener(task -> {
            ph.finish();
            this.fireStructureChanged();
            this.isRedrawing = false;
        });
        this.layoutEventLayersThread.schedule(0);
    }

    private void layoutIndiLayers() {
        if (this.gedcom == null) {
            return;
        }
        TimingUtility tu = new TimingUtility();
        LOG.log(Level.FINER, tu.getTime() + " - Launch task to lay out INDI layers");
        ProgressHandle ph = ProgressHandle.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"TXT_CreateLayers_Msg2"), () -> {
            if (null == this.layoutIndiLayersThread) {
                return false;
            }
            return this.layoutIndiLayersThread.cancel();
        });
        Runnable runnable = () -> {
            Object object = this.lock;
            synchronized (object) {
                while (this.isRebuilding || this.isRedrawing) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                this.isRedrawing = true;
                LOG.log(Level.FINER, tu.getTime() + " - Executing tasks to lay out INDI layers...Start.");
                try {
                    ph.start();
                    ph.switchToDeterminate(this.gedcom.getIndis().size());
                    this.progressCounter = 0;
                    this.createIndiLayers(ph);
                    this.lock.notifyAll();
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Error in calculating events", t);
                }
                LOG.log(Level.FINER, tu.getTime() + " - Executing tasks to lay out INDI layers...End.");
            }
        };
        if (RP == null) {
            RP = new RequestProcessor("Chrono Model View", 1, true);
        }
        this.layoutIndiLayersThread = RP.create(runnable);
        this.layoutIndiLayersThread.addTaskListener(task -> {
            ph.finish();
            this.fireStructureChanged();
            this.isRedrawing = false;
            this.updateView();
        });
        this.layoutIndiLayersThread.schedule(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedList<Event> getEvents() {
        LinkedList<Event> propertyHits = new LinkedList<Event>();
        LinkedList<Event> entityHits = new LinkedList<Event>();
        if (this.eventLayers == null || this.eventLayers.isEmpty()) {
            return entityHits;
        }
        List props = this.context.getProperties();
        List<Entity> ents = this.getAllContextEntities(this.context);
        Object object = this.lock;
        synchronized (object) {
            while (this.isRebuilding || this.isRedrawing) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            for (List<Event> eventLayer : this.eventLayers) {
                for (Event event : eventLayer) {
                    for (Entity ent : ents) {
                        if (ent != event.getEntity()) continue;
                        entityHits.add(event);
                    }
                    for (Property prop : props) {
                        if (event.getProperty() != prop && !event.getProperty().contains(prop)) continue;
                        propertyHits.add(event);
                    }
                }
            }
            this.lock.notifyAll();
        }
        return propertyHits.isEmpty() ? entityHits : propertyHits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<EventSerie> getIndis() {
        LinkedList<EventSerie> propertyHits = new LinkedList<EventSerie>();
        LinkedList<EventSerie> entityHits = new LinkedList<EventSerie>();
        if (this.indiLayers == null || this.indiLayers.isEmpty()) {
            return entityHits;
        }
        Object object = this.lock;
        synchronized (object) {
            List props = this.context.getProperties();
            List<Entity> ents = this.getAllContextEntities(this.context);
            for (List<EventSerie> indiLayer : this.indiLayers) {
                for (EventSerie eventSerie : indiLayer) {
                    for (Entity ent : ents) {
                        if (ent != eventSerie.getEntity()) continue;
                        entityHits.add(eventSerie);
                    }
                    for (Property prop : props) {
                        if (eventSerie.getProperty() != prop && !eventSerie.contains(prop)) continue;
                        propertyHits.add(eventSerie);
                    }
                }
            }
            this.lock.notifyAll();
        }
        return propertyHits.isEmpty() ? entityHits : propertyHits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Indi> getIndisFromLayers() {
        ArrayList<Indi> ret = new ArrayList<Indi>();
        if (this.indiLayers == null || this.indiLayers.isEmpty()) {
            return ret;
        }
        Object object = this.lock;
        synchronized (object) {
            for (List<EventSerie> indiLayer : this.indiLayers) {
                for (EventSerie eventSerie : indiLayer) {
                    ret.add(eventSerie.indi);
                }
            }
            this.lock.notifyAll();
        }
        return ret;
    }

    public void eraseAll() {
        Runnable runnable = () -> {
            Iterator<Object> it2;
            Iterator<Object> it = this.eventLayers.iterator();
            while (it.hasNext()) {
                it2 = it.next().iterator();
                while (it2.hasNext()) {
                    it2.next();
                    it2.remove();
                }
                it.remove();
            }
            it = this.indiLayers.iterator();
            while (it.hasNext()) {
                it2 = it.next().iterator();
                while (it2.hasNext()) {
                    it2.next();
                    it2.remove();
                }
                it.remove();
            }
            it = this.eventMap.entrySet().iterator();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            it = this.indiSeries.entrySet().iterator();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        };
        new RequestProcessor("interruptible tasks", 1, true).create(runnable).schedule(0);
    }

    private void createEventsFromEntities(Collection<? extends Entity> es, ProgressHandle ph) {
        for (Entity entity : es) {
            Property[] props;
            ph.progress(this.progressCounter++);
            for (Property p : props = entity.getProperties()) {
                if (!this.tags.contains(p.getTag())) continue;
                try {
                    this.createEventFromEntityEvent(entity, p);
                }
                catch (ClassCastException e) {
                    LOG.log(Level.INFO, "Unable to convert property : " + p.toString() + " entity :" + entity.getId(), e);
                }
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            return;
        }
    }

    private void createEventFromEntityEvent(Entity ent, Property pe) {
        PropertyDate pd = pe.getWhen();
        if (pd == null || !pd.isValid() || !pd.isComparable()) {
            return;
        }
        try {
            Event e = new Event(pe, pd);
            Double key = e.from;
            while (this.eventMap.containsKey(key)) {
                key = key + INCREMENT_D;
            }
            this.eventMap.put(key, e);
            if (ent instanceof Indi) {
                Indi indi = (Indi)ent;
                this.updateEventSeriesWithIndi(indi, e);
            } else if (ent instanceof Fam) {
                Indi wife;
                Fam fam = (Fam)ent;
                Indi husb = fam.getHusband();
                if (husb != null) {
                    this.updateEventSeriesWithIndi(husb, e);
                }
                if ((wife = fam.getWife()) != null) {
                    this.updateEventSeriesWithIndi(wife, e);
                }
            }
        }
        catch (GedcomException gedcomException) {
            // empty catch block
        }
    }

    private void updateEventSeriesWithIndi(Indi indi, Event e) {
        EventSerie es = this.indiSeries.get(indi);
        if (es == null) {
            es = new EventSerie(indi);
            this.indiSeries.put(indi, es);
        }
        es.addEvent(e);
    }

    private void createEventLayers(ProgressHandle ph) {
        this.eventLayers.clear();
        Double gap = Math.max(this.timeBeforeEvent, this.timeAfterEvent);
        TreeMap<Double, Integer> endLimits = new TreeMap<Double, Integer>();
        Iterator<Double> iterator = this.eventMap.keySet().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        Double key = iterator.next();
        Event event = this.eventMap.get(key);
        List<Object> layer = new LinkedList<Event>();
        layer.add(event);
        endLimits.put(key - event.from + event.to + gap, this.eventLayers.size());
        this.eventLayers.add(layer);
        ph.progress(this.progressCounter++);
        while (iterator.hasNext()) {
            key = iterator.next();
            event = this.eventMap.get(key);
            Double firstKey = (Double)endLimits.firstKey();
            if (key > firstKey) {
                int l = (Integer)endLimits.get(firstKey);
                layer = this.eventLayers.get(l);
                layer.add(event);
                endLimits.remove(firstKey);
                lKey = key - event.from + event.to + gap;
                while (endLimits.containsKey(lKey)) {
                    lKey = lKey + INCREMENT_D;
                }
                endLimits.put(lKey, l);
            } else {
                layer = new LinkedList();
                layer.add(event);
                lKey = key - event.from + event.to + gap;
                while (endLimits.containsKey(lKey)) {
                    lKey = lKey + INCREMENT_D;
                }
                endLimits.put(lKey, this.eventLayers.size());
                this.eventLayers.add(layer);
            }
            ph.progress(this.progressCounter++);
        }
    }

    private void createIndiPackedLayers(ProgressHandle ph) {
        TreeMap<Double, EventSerie> indiMap = new TreeMap<Double, EventSerie>();
        for (EventSerie es : this.indiSeries.values()) {
            Double tKey = es.from;
            while (indiMap.containsKey(tKey)) {
                tKey = tKey + INCREMENT_D;
            }
            indiMap.put(tKey, es);
        }
        Double gap = Math.max(this.timeBeforeEvent, this.timeAfterEvent);
        TreeMap<Double, Integer> endLimits = new TreeMap<Double, Integer>();
        Iterator iterator = indiMap.keySet().iterator();
        Double key = (Double)iterator.next();
        EventSerie event = (EventSerie)indiMap.get(key);
        List<Object> layer = new LinkedList<EventSerie>();
        layer.add(event);
        endLimits.put(key - event.from + event.to + gap, this.indiLayers.size());
        this.indiLayers.add(layer);
        ph.progress(this.progressCounter++);
        while (iterator.hasNext()) {
            key = (Double)iterator.next();
            event = (EventSerie)indiMap.get(key);
            Double firstKey = (Double)endLimits.firstKey();
            if (key > firstKey) {
                int l = (Integer)endLimits.get(firstKey);
                layer = this.indiLayers.get(l);
                layer.add(event);
                endLimits.remove(firstKey);
                lKey = key - event.from + event.to + gap;
                endLimits.put(lKey, l);
            } else {
                layer = new LinkedList();
                layer.add(event);
                lKey = key - event.from + event.to + gap;
                endLimits.put(lKey, this.indiLayers.size());
                this.indiLayers.add(layer);
            }
            ph.progress(this.progressCounter++);
        }
    }

    public void createIndiLayers(ProgressHandle ph) {
        if (this.context == null) {
            return;
        }
        this.indiLayers.clear();
        if (this.isPackIndi) {
            this.createIndiPackedLayers(ph);
            return;
        }
        HashSet<Indi> tmpTraversedIndi = new HashSet<Indi>();
        this.indiSeries.values().forEach(es -> {
            es.layered = false;
        });
        LinkedList<EventSerie> layer = new LinkedList<EventSerie>();
        this.indiLayers.add(layer);
        layer.add(new EventSerie(null));
        Entity entity = this.context.getEntity();
        Indi rootIndi = this.getIndiFromEntity(entity);
        if (rootIndi == null) {
            return;
        }
        this.traverseTreeFromIndi(rootIndi, tmpTraversedIndi, ph);
        LinkedList<EventSerie> values = new LinkedList<EventSerie>(this.indiSeries.values());
        Collections.sort(values, (o1, o2) -> {
            double d1 = ((EventSerie)o1).from;
            double d2 = ((EventSerie)o2).from;
            if (d1 == d2) {
                return 0;
            }
            if (d1 < d2) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        });
        for (EventSerie es2 : values) {
            if (es2.layered) continue;
            if (this.indiLayers.size() > 1 && !this.isPackIndi) {
                layer = new LinkedList();
                this.indiLayers.add(layer);
                layer.add(new EventSerie(null));
            }
            this.traverseTreeFromIndi(es2.indi, tmpTraversedIndi, ph);
        }
        layer = new LinkedList();
        this.indiLayers.add(layer);
        layer.add(new EventSerie(null));
        this.view.setRootTitle(rootIndi.toString(true));
    }

    private void traverseTreeFromIndi(Indi rootIndi, Set<Indi> set, ProgressHandle ph) {
        if (rootIndi == null) {
            return;
        }
        Stack<Indi> indiStack = new Stack<Indi>();
        Indi indi = this.getOldestAgnaticAncestor(rootIndi, new HashSet<Indi>());
        while (indi != null) {
            if (!set.contains(indi)) {
                set.add(indi);
                EventSerie es = this.indiSeries.get(indi);
                if (es != null && !es.layered) {
                    es.layered = true;
                    LinkedList<EventSerie> layer = new LinkedList<EventSerie>();
                    layer.add(es);
                    this.indiLayers.add(layer);
                }
                ph.progress(this.progressCounter++);
            }
            indi = this.getNextIndiInTree(indi, set, indiStack);
        }
    }

    private Indi getOldestAgnaticAncestor(Indi indi, Set<Indi> visited) {
        if (visited.contains(indi)) {
            return null;
        }
        visited.add(indi);
        Fam fam = indi.getFamilyWhereBiologicalChild();
        if (fam != null) {
            Indi father = fam.getHusband();
            if (father != null) {
                return this.getOldestAgnaticAncestor(father, visited);
            }
            Indi mother = fam.getWife();
            if (mother != null) {
                return this.getOldestAgnaticAncestor(mother, visited);
            }
        }
        return indi;
    }

    public Indi getNextIndiInTree(Indi indi, Set<Indi> set, Stack<Indi> stack) {
        Fam[] fams;
        for (Fam fam : fams = indi.getFamiliesWhereSpouse()) {
            Indi[] children;
            Indi spouse = fam.getOtherSpouse(indi);
            if (spouse != null && !set.contains(spouse)) {
                Indi ancestor = this.getOldestAgnaticAncestor(spouse, new HashSet<Indi>());
                stack.push(indi);
                if (ancestor != null && !set.contains(ancestor)) {
                    return ancestor;
                }
                return spouse;
            }
            for (Indi child : children = fam.getChildren(true)) {
                if (set.contains(child)) continue;
                stack.push(child);
                return child;
            }
        }
        Fam fam = indi.getFamilyWhereBiologicalChild();
        if (fam != null) {
            Indi[] children;
            for (Indi child : children = fam.getChildren(true)) {
                if (set.contains(child)) continue;
                stack.push(child);
                return child;
            }
        }
        if (!stack.empty()) {
            return stack.pop();
        }
        return null;
    }

    public Set<Indi> getVisibleInviduals() {
        return this.indiSeries.keySet();
    }

    private class Callback
    extends GedcomListenerAdapter {
        private Callback() {
        }

        public void gedcomWriteLockReleased(Gedcom gedcom) {
            if (!Model.this.isGedcomChanging) {
                WindowManager.getDefault().invokeWhenUIReady(() -> {
                    Model.this.isGedcomChanging = true;
                    Model.this.createAndLayoutAllLayers();
                    Model.this.isGedcomChanging = false;
                });
            }
        }
    }

    class Event
    implements Comparable<Event> {
        double from;
        double to;
        Property pe;
        PropertyDate pd;
        String content;

        Event(Property propEvent, PropertyDate propDate) throws GedcomException {
            this.pe = propEvent;
            this.pd = propDate;
            this.from = Model.toDouble(propDate.getStart(), propDate.getFormat() == PropertyDate.AFTER);
            double d = this.to = propDate.isRange() ? Model.toDouble(propDate.getEnd(), false) : this.from;
            if (this.from > this.to) {
                throw new GedcomException("");
            }
            this.content();
        }

        private void content() {
            Entity e = this.pe.getEntity();
            this.content = e.toString();
        }

        public String toString() {
            return this.content;
        }

        Entity getEntity() {
            return this.pe.getEntity();
        }

        int getSex() {
            Entity entity = this.pe.getEntity();
            if (entity instanceof Indi) {
                Indi indi = (Indi)entity;
                return indi.getSex();
            }
            return 0;
        }

        Property getProperty() {
            return this.pe;
        }

        @Override
        public int compareTo(Event o) {
            double other = o.from;
            return this.from > other ? 1 : (this.from < other ? -1 : 0);
        }
    }

    class EventSerie {
        Indi indi;
        double from;
        double to;
        SortedSet<Event> events;
        String content;
        boolean layered;

        EventSerie(Indi indi) {
            this.indi = indi;
            this.events = new TreeSet<Event>();
            this.from = Double.MAX_VALUE;
            this.to = Double.MIN_VALUE;
            this.content();
            this.layered = false;
        }

        private void content() {
            this.content = this.indi == null ? "" : this.indi.toString();
        }

        public String toString() {
            return this.content;
        }

        Entity getEntity() {
            return this.indi;
        }

        int getSex() {
            return this.indi.getSex();
        }

        Property getProperty() {
            if (this.events.isEmpty()) {
                return null;
            }
            return this.events.first().getProperty();
        }

        public void addEvent(Event e) {
            this.events.add(e);
            this.from = Math.min(this.getFrom(), e.from);
            this.to = Math.max(this.getTo(), e.to);
        }

        public double getFrom() {
            double minDate = this.getFirstEvent().from;
            if (this.contains("BIRT")) {
                return minDate;
            }
            return minDate - (double)EST_SPAN;
        }

        public double getTo() {
            double maxDate = this.getLastEvent().to;
            if (this.contains("DEAT")) {
                return maxDate;
            }
            if (maxDate < Model.this.now - (double)EST_LIVING) {
                return Math.min(maxDate + (double)EST_SPAN, Model.this.now);
            }
            return Model.this.now;
        }

        public double[] getDates() {
            double[] ret = new double[this.events.size()];
            int i = 0;
            for (Event e : this.events) {
                ret[i] = e.from;
                ++i;
            }
            return ret;
        }

        public ImageIcon getImage() {
            return this.indi.getImage();
        }

        public String getTag() {
            return this.indi.getTag();
        }

        public String getDisplayDates() {
            String birth = this.indi.getBirthAsString();
            String death = this.indi.getDeathAsString();
            return TextOptions.getInstance().getBirthSymbol() + (birth.isEmpty() ? "-" : birth) + " " + TextOptions.getInstance().getDeathSymbol() + (death.isEmpty() ? "-" : death);
        }

        public Event getFirstEvent() {
            return this.events.first();
        }

        public Event getLastEvent() {
            return this.events.last();
        }

        private boolean contains(String tag) {
            for (Event e : this.events) {
                if (!e.pe.getTag().equals(tag)) continue;
                return true;
            }
            return false;
        }

        private boolean contains(Property prop) {
            for (Event e : this.events) {
                if (!e.pe.equals(prop)) continue;
                return true;
            }
            return false;
        }
    }

    static interface Listener {
        public void dataChanged();

        public void structureChanged();
    }
}

