#ifndef __YACREADER_GLOBAL_GUI_H
#define __YACREADER_GLOBAL_GUI_H

#include "yacreader_global.h"

#include <QWidget>
#include <QMimeData>

#define PATH "PATH"
#define MAG_GLASS_SIZE "MAG_GLASS_SIZE"
#define MAG_GLASS_ZOOM "MAG_GLASS_ZOOM"
#define ZOOM_LEVEL "ZOOM_LEVEL"
#define SLIDE_SIZE "SLIDE_SIZE"
#define GO_TO_FLOW_SIZE "GO_TO_FLOW_SIZE"
#define FLOW_TYPE_SW "FLOW_TYPE_SW"
#define FITMODE "FITMODE"
#define FLOW_TYPE "FLOW_TYPE"
#define FULLSCREEN "FULLSCREEN"
#define Y_WINDOW_GEOMETRY "GEOMETRY"
#define MAXIMIZED "MAXIMIZED"
#define CLOSE_TO_TRAY "CLOSE_TO_TRAY"
#define CLOSE_TO_TRAY_NOTIFIED "CLOSE_TO_TRAY_NOTIFIED"
#define START_TO_TRAY "START_TO_TRAY"
#define DOUBLE_PAGE "DOUBLE_PAGE"
#define DOUBLE_MANGA_PAGE "DOUBLE_MANGA_PAGE"
#define COVER_IS_SP "COVER_IS_SP"
#define BACKGROUND_COLOR "BACKGROUND_COLOR"
#define SHOW_TOOLBARS "SHOW_TOOLBARS"
#define BRIGHTNESS "BRIGHTNESS"
#define CONTRAST "CONTRAST"
#define GAMMA "GAMMA"
#define SHOW_INFO "SHOW_INFO"
#define SHOW_TIME_IN_INFO "SHOW_TIME_IN_INFO"
#define QUICK_NAVI_MODE "QUICK_NAVI_MODE"
#define DISABLE_MOUSE_OVER_GOTO_FLOW "DISABLE_MOUSE_OVER_GOTO_FLOW"
#define ENLARGE_IMAGES "ENLARGE_IMAGES"
#define DO_NOT_TURN_PAGE_ON_SCROLL "DO_NOT_TURN_PAGE_ON_SCROLL"
#define USE_SINGLE_SCROLL_STEP_TO_TURN_PAGE "USE_SINGLE_SCROLL_STEP_TO_TURN_PAGE"
#define DISABLE_SCROLL_ANIMATION "DISABLE_SCROLL_ANIMATION"
#define MOUSE_MODE "MOUSE_MODE"

#define FLOW_TYPE_GL "FLOW_TYPE_GL"
#define Y_POSITION "Y_POSITION"
#define COVER_DISTANCE "COVER_DISTANCE"
#define CENTRAL_DISTANCE "CENTRAL_DISTANCE"
#define Z_COVER_OFFSET "Z_COVER_OFFSET"
#define COVER_ROTATION "COVER_ROTATION"
#define FADE_OUT_DIST "FADE_OUT_DIST"
#define LIGHT_STRENGTH "LIGHT_STRENGTH"
#define MAX_ANGLE "MAX_ANGLE"
#define PERFORMANCE "PERFORMANCE"
#define USE_OPEN_GL "USE_OPEN_GL"
#define X_ROTATION "X_ROTATION"
#define Y_COVER_OFFSET "Y_COVER_OFFSET"
#define V_SYNC "V_SYNC"
#define SERVER_ON "SERVER_ON"

#define MAIN_WINDOW_GEOMETRY "MAIN_WINDOW_GEOMETRY"
#define MAIN_WINDOW_STATE "MAIN_WINDOW_STATE"
#define COMICS_VIEW_HEADERS "COMICS_VIEW_HEADERS_9.16.3" // VALUE CHANGED IN 9.16.3 to avoid issues with previous versions
#define COMICS_VIEW_HEADERS_GEOMETRY "COMICS_VIEW_HEADERS_GEOMETRY"
#define COMICS_VIEW_STATUS "COMICS_VIEW_STATUS"
#define COMICS_VIEW_FLOW_SPLITTER_STATUS "COMICS_VIEW_FLOW_SPLITTER_STATUS"
#define SIDEBAR_SPLITTER_STATUS "SIDEBAR_SPLITTER_STATUS"
#define COMICS_GRID_COVER_SIZES "COMICS_GRID_COVER_SIZES"
#define COMICS_GRID_SHOW_INFO "COMICS_GRID_SHOW_INFO"
#define COMICS_GRID_INFO_WIDTH "COMICS_GRID_INFO_WIDTH"

#define COMIC_VINE_API_KEY "COMIC_VINE_API_KEY"
#define COMIC_VINE_BASE_URL "COMIC_VINE_BASE_URL"
#define COMIC_VINE_USER_AGENT "COMIC_VINE_USER_AGENT"

#define USE_BACKGROUND_IMAGE_IN_GRID_VIEW "USE_BACKGROUND_IMAGE_IN_GRID_VIEW"
#define OPACITY_BACKGROUND_IMAGE_IN_GRID_VIEW "OPACITY_BACKGROUND_IMAGE_IN_GRID_VIEW"
#define BLUR_RADIUS_BACKGROUND_IMAGE_IN_GRID_VIEW "BLUR_RADIUS_BACKGROUND_IMAGE_IN_GRID_VIEW"
#define USE_SELECTED_COMIC_COVER_AS_BACKGROUND_IMAGE_IN_GRID_VIEW "USE_SELECTED_COMIC_COVER_AS_BACKGROUND_IMAGE_IN_GRID_VIEW"
#define DISPLAY_GLOBAL_CONTINUE_READING_IN_GRID_VIEW "DISPLAY_GLOBAL_CONTINUE_READING_IN_GRID_VIEW"
#define DISPLAY_CONTINUE_READING_IN_GRID_VIEW "DISPLAY_CONTINUE_READING_IN_GRID_VIEW"
#define DISPLAY_RECENTLY_INDICATOR "DISPLAY_RECENTLY_INDICATOR"
#define NUM_DAYS_TO_CONSIDER_RECENT "NUM_DAYS_TO_CONSIDER_RECENT"
#define THIRD_PARTY_READER_COMMAND "THIRD_PARTY_READER_COMMAND"

namespace YACReader {

static const QString YACReaderLibrarComiscSelectionMimeDataFormat = "application/yacreaderlibrary-comics-ids";
static const QString YACReaderLibrarSubReadingListMimeDataFormat = "application/yacreaderlibrary-sublist-rows";

enum FlowType {
    CoverFlowLike = 0,
    Strip,
    StripOverlapped,
    Modern,
    Roulette,
    Custom
};

enum ComicsViewStatus {
    Flow,
    Grid,
    Info
};

enum LibraryUITheme {
    Light,
    Dark
};

void addSperator(QWidget *w);
QAction *createSeparator();
QIcon noHighlightedIcon(const QString &path);
void colorize(QImage &img, QColor &col);
QList<qulonglong> mimeDataToComicsIds(const QMimeData *data);
QString addExtensionToIconPath(const QString &path);
QString addExtensionToIconPathInToolbar(const QString &path);
QAction *actionWithCustomIcon(const QIcon &icon, QAction *action);
QPixmap hdpiPixmap(const QString &file, QSize size);
QString imageFileLoader(QWidget *parent);
QString imagePathFromMimeData(const QMimeData *mimeData);
}
#endif
