/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef ITKTEMPLATES_DEFAULTPIXELACCESSOR_H_
#define ITKTEMPLATES_DEFAULTPIXELACCESSOR_H_

#include <ItkTemplatesAPI.h>
#include <itkDefaultPixelAccessor.h>
#include <itkCovariantVector.h>
#include <itkOffset.h>

extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<bool>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<char>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<double>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<float>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<int>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<itk::CovariantVector<double, 2u>>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<itk::CovariantVector<double, 3u>>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<itk::CovariantVector<float, 2u>>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<itk::CovariantVector<float, 3u>>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<itk::Offset<2u>>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<itk::Offset<3u>>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<itk::Vector<double, 1u>>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<itk::Vector<double, 2u>>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<itk::Vector<double, 3u>>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<itk::Vector<float, 1u>>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<itk::Vector<float, 2u>>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<itk::Vector<float, 3u>>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<long>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<long long>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<short>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<signed char>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<std::complex<double>>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<std::complex<float>>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<unsigned char>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<unsigned int>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<unsigned long>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<unsigned long long>;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessor<unsigned short>;

#include <itkDefaultPixelAccessorFunctor.h>
#include <itkImage.h>

extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<bool, 2u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<bool, 3u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<char, 2u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<char, 3u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<double, 2u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<double, 3u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<float, 2u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<float, 3u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<int, 2u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<int, 3u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<long, 2u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<long, 3u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<short, 2u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<short, 3u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<signed char, 2u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<signed char, 3u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<unsigned char, 2u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<unsigned char, 3u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<unsigned int, 2u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<unsigned int, 3u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<unsigned long, 2u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<unsigned long, 3u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<unsigned short, 2u> >;
extern template class ITKTEMPLATES_API itk::DefaultPixelAccessorFunctor<itk::Image<unsigned short, 3u> >;

#endif // ITKTEMPLATES_DEFAULTPIXELACCESSOR_H_