import { BinaryView, Frag } from "@ot-builder/bin-util";
import { OtGlyph } from "@ot-builder/ot-glyphs";
import { Data } from "@ot-builder/prelude";
import { ReadTimeIVS, WriteTimeIVS } from "@ot-builder/var-store";
import { LookupWriteTrick } from "../cfg";
import { OtlStat } from "../stat";
export interface SubtableReadingContext<L> {
    crossReferences: Data.Order<L>;
    gOrd: Data.Order<OtGlyph>;
    ivs: Data.Maybe<ReadTimeIVS>;
}
export interface SubtableWriteContext<L> {
    trick: LookupWriteTrick;
    crossReferences: Data.Order<L>;
    gOrd: Data.Order<OtGlyph>;
    ivs: Data.Maybe<WriteTimeIVS>;
    stat: OtlStat;
}
export interface LookupReader<L, C extends L> {
    createLookup(): C;
    parseSubtable(view: BinaryView, lookup: C, context: SubtableReadingContext<L>): void;
}
export interface LookupWriter<L, C extends L> {
    canBeUsed(lookup: L): lookup is L & C;
    getLookupType(lookup: C, context: SubtableWriteContext<L>): number;
    getLookupTypeSymbol(lookup: C): symbol;
    createSubtableFragments(lookup: C, context: SubtableWriteContext<L>): Frag[];
}
export interface LookupReaderFactory<L> {
    createReader(format: number): LookupReader<L, any>;
    isExtendedFormat(format: number): boolean;
}
export interface LookupWriterFactory<L> {
    readonly extendedFormat: number;
    writers(): Iterable<LookupWriter<L, any>>;
    queryDependencies(lookup: L): ReadonlyArray<L>;
}
export declare const SubtableSizeLimit = 61440;
export declare enum LookupFlag {
    RightToLeft = 1,
    IgnoreBaseGlyphs = 2,
    IgnoreLigatures = 4,
    IgnoreMarks = 8,
    UseMarkFilteringSet = 16,
    MarkAttachmentType = 65280
}
//# sourceMappingURL=general.d.ts.map