% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalityTest.R
\name{normalityTest}
\alias{normalityTest}
\alias{normalityTest.default}
\alias{normalityTest.formula}
\title{Normality Tests}
\usage{
normalityTest(x, ...)

\method{normalityTest}{formula}(formula, test, data, ...)

\method{normalityTest}{default}(
  x,
  test = c("shapiro.test", "ad.test", "cvm.test", "lillie.test", "pearson.test",
    "sf.test"),
  groups,
  vname,
  gname,
  ...
)
}
\arguments{
\item{x}{numeric vector or formula.}

\item{\dots}{any arguments to be passed down; the only useful such arguments are for the \code{\link[nortest]{pearson.test}} function in the \pkg{nortest} package.}

\item{formula}{one-sided formula of the form \code{~x} or two-sided formula of the form \code{x ~ groups}, where \code{x} is a numeric variable and \code{groups} is a factor.}

\item{test}{quoted name of the function to perform the test.}

\item{data}{a data frame containing the data for the test.}

\item{groups}{optional factor to divide the data into groups.}

\item{vname}{optional name for the variable; if absent, taken from \code{x}.}

\item{gname}{optional name for the grouping factor; if absent, taken from \code{groups}.}
}
\value{
If testing by groups, the function invisibly returns \code{NULL}; otherwise it returns an object of class \code{"htest"}, which normally would be printed.
}
\description{
Normality Tests
}
\details{
Perform one of several tests of normality, either for a variable or for a variable by groups.
The \code{normalityTest} function uses the \code{\link[stats]{shapiro.test}} function or one of several functions in the \pkg{nortest} package.
If tests are done by groups, then adjusted p-values, computed by the Holm method, are also reported (see \code{\link[stats]{p.adjust}}).
}
\examples{
data(Prestige, package="car")
with(Prestige, normalityTest(income))
normalityTest(income ~ type, data=Prestige, test="ad.test")
normalityTest(~income, data=Prestige, test="pearson.test", n.classes=5)

}
\seealso{
\code{\link[stats]{shapiro.test}}, \code{\link[nortest]{ad.test}}, \code{\link[nortest]{cvm.test}}, \code{\link[nortest]{lillie.test}}, \code{\link[nortest]{pearson.test}}, \code{\link[nortest]{sf.test}}.
}
\author{
John Fox
}
\keyword{htest}
