# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rbi` gem.
# Please instead update this file by running `bin/tapioca gem rbi`.

# source://rbi//lib/rbi.rb#7
module RBI; end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/parser.rb#129
class RBI::ASTVisitor
  abstract!

  # source://sorbet-runtime/0.5.10598/lib/types/private/abstract/declare.rb#37
  def initialize(*args, **_arg1, &blk); end

  # @abstract
  #
  # source://rbi//lib/rbi/parser.rb#141
  sig { abstract.params(node: T.nilable(::AST::Node)).void }
  def visit(node); end

  # source://rbi//lib/rbi/parser.rb#136
  sig { params(nodes: T::Array[::AST::Node]).void }
  def visit_all(nodes); end

  private

  # source://rbi//lib/rbi/parser.rb#151
  sig { params(node: ::AST::Node).returns(::String) }
  def parse_expr(node); end

  # source://rbi//lib/rbi/parser.rb#146
  sig { params(node: ::AST::Node).returns(::String) }
  def parse_name(node); end
end

# source://rbi//lib/rbi/model.rb#960
class RBI::Arg < ::RBI::Node
  # source://rbi//lib/rbi/model.rb#972
  sig { params(value: ::String, loc: T.nilable(::RBI::Loc)).void }
  def initialize(value, loc: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#978
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#611
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#983
  sig { returns(::String) }
  def to_s; end

  # source://rbi//lib/rbi/model.rb#964
  sig { returns(::String) }
  def value; end
end

# Attributes
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#341
class RBI::Attr < ::RBI::NodeWithComments
  include ::RBI::Indexable

  abstract!

  # source://rbi//lib/rbi/model.rb#366
  sig do
    params(
      name: ::Symbol,
      names: T::Array[::Symbol],
      visibility: ::RBI::Visibility,
      sigs: T::Array[::RBI::Sig],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment]
    ).void
  end
  def initialize(name, names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#346
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#406
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # @abstract
  #
  # source://rbi//lib/rbi/model.rb#374
  sig { abstract.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/index.rb#109
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#413
  sig { override.params(other: ::RBI::Node).void }
  def merge_with(other); end

  # source://rbi//lib/rbi/model.rb#348
  sig { returns(T::Array[::Symbol]) }
  def names; end

  # @return [Array<Symbol>]
  #
  # source://rbi//lib/rbi/model.rb#348
  def names=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#373
  sig { override.returns(T::Boolean) }
  def oneline?; end

  # source://rbi//lib/rbi/model.rb#354
  sig { returns(T::Array[::RBI::Sig]) }
  def sigs; end

  # source://rbi//lib/rbi/model.rb#351
  sig { returns(::RBI::Visibility) }
  def visibility; end

  # @return [Visibility]
  #
  # source://rbi//lib/rbi/model.rb#351
  def visibility=(_arg0); end
end

# source://rbi//lib/rbi/model.rb#377
class RBI::AttrAccessor < ::RBI::Attr
  # source://rbi//lib/rbi/model.rb#391
  sig do
    params(
      name: ::Symbol,
      names: ::Symbol,
      visibility: ::RBI::Visibility,
      sigs: T::Array[::RBI::Sig],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::AttrAccessor).void)
    ).void
  end
  def initialize(name, *names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#444
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#397
  sig { override.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/model.rb#403
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#409
class RBI::AttrReader < ::RBI::Attr
  # source://rbi//lib/rbi/model.rb#423
  sig do
    params(
      name: ::Symbol,
      names: ::Symbol,
      visibility: ::RBI::Visibility,
      sigs: T::Array[::RBI::Sig],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::AttrReader).void)
    ).void
  end
  def initialize(name, *names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#426
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#429
  sig { override.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/model.rb#435
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#441
class RBI::AttrWriter < ::RBI::Attr
  # source://rbi//lib/rbi/model.rb#455
  sig do
    params(
      name: ::Symbol,
      names: ::Symbol,
      visibility: ::RBI::Visibility,
      sigs: T::Array[::RBI::Sig],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::AttrWriter).void)
    ).void
  end
  def initialize(name, *names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#435
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#461
  sig { override.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/model.rb#467
  sig { override.returns(::String) }
  def to_s; end
end

# An arbitrary blank line that can be added both in trees and comments
#
# source://rbi//lib/rbi/model.rb#70
class RBI::BlankLine < ::RBI::Comment
  # source://rbi//lib/rbi/model.rb#74
  sig { params(loc: T.nilable(::RBI::Loc)).void }
  def initialize(loc: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#215
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end
end

# source://rbi//lib/rbi/model.rb#733
class RBI::BlockParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#744
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::BlockParam).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#755
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#541
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#546
  sig { override.params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # source://rbi//lib/rbi/model.rb#750
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#213
class RBI::Class < ::RBI::Scope
  # source://rbi//lib/rbi/model.rb#231
  sig do
    params(
      name: ::String,
      superclass_name: T.nilable(::String),
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Class).void)
    ).void
  end
  def initialize(name, superclass_name: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#370
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#239
  sig { override.returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/model.rb#217
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#217
  def name=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#282
  sig { override.params(v: ::RBI::Printer).void }
  def print_header(v); end

  # source://rbi//lib/rbi/model.rb#220
  sig { returns(T.nilable(::String)) }
  def superclass_name; end

  # @return [String, nil]
  #
  # source://rbi//lib/rbi/model.rb#220
  def superclass_name=(_arg0); end
end

# source://rbi//lib/rbi/model.rb#50
class RBI::Comment < ::RBI::Node
  # source://rbi//lib/rbi/model.rb#57
  sig { params(text: ::String, loc: T.nilable(::RBI::Loc)).void }
  def initialize(text, loc: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#63
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#195
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#54
  sig { returns(::String) }
  def text; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#54
  def text=(_arg0); end
end

# A tree showing incompatibles nodes
#
# Is rendered as a merge conflict between `left` and` right`:
# ~~~rb
# class Foo
#   <<<<<<< left
#   def m1; end
#   def m2(a); end
#   =======
#   def m1(a); end
#   def m2; end
#   >>>>>>> right
# end
# ~~~
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#578
class RBI::ConflictTree < ::RBI::Tree
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#585
  sig { params(left_name: ::String, right_name: ::String).void }
  def initialize(left_name: T.unsafe(nil), right_name: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#596
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#582
  sig { returns(::RBI::Tree) }
  def left; end

  # @return [Tree]
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#582
  def right; end
end

# Consts
#
# source://rbi//lib/rbi/model.rb#305
class RBI::Const < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#320
  sig do
    params(
      name: ::String,
      value: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Const).void)
    ).void
  end
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/printer.rb#333
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#397
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#328
  sig { returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/index.rb#99
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#309
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/model.rb#334
  sig { override.returns(::String) }
  def to_s; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#309
  def value; end
end

# source://rbi//lib/rbi/parser.rb#600
class RBI::ConstBuilder < ::RBI::ASTVisitor
  # source://rbi//lib/rbi/parser.rb#615
  sig { void }
  def initialize; end

  # source://rbi//lib/rbi/parser.rb#612
  sig { returns(T::Array[::String]) }
  def names; end

  # @return [Array<String>]
  #
  # source://rbi//lib/rbi/parser.rb#612
  def names=(_arg0); end

  # source://rbi//lib/rbi/parser.rb#621
  sig { override.params(node: T.nilable(::AST::Node)).void }
  def visit(node); end

  class << self
    # source://rbi//lib/rbi/parser.rb#604
    sig { params(node: T.nilable(::AST::Node)).returns(T.nilable(::String)) }
    def visit(node); end
  end
end

# source://rbi//lib/rbi.rb#8
class RBI::Error < ::StandardError; end

# source://rbi//lib/rbi/model.rb#808
class RBI::Extend < ::RBI::Mixin
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#820
  sig do
    params(
      name: ::String,
      names: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Extend).void)
    ).void
  end
  def initialize(name, *names, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#492
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/index.rb#139
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#826
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#133
class RBI::File
  # source://rbi//lib/rbi/model.rb#152
  sig do
    params(
      strictness: T.nilable(::String),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(file: ::RBI::File).void)
    ).void
  end
  def initialize(strictness: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#160
  sig { params(node: ::RBI::Node).void }
  def <<(node); end

  # source://rbi//lib/rbi/printer.rb#104
  sig { params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#143
  sig { returns(T::Array[::RBI::Comment]) }
  def comments; end

  # @return [Array<Comment>]
  #
  # source://rbi//lib/rbi/model.rb#143
  def comments=(_arg0); end

  # source://rbi//lib/rbi/model.rb#165
  sig { returns(T::Boolean) }
  def empty?; end

  # source://rbi//lib/rbi/printer.rb#128
  sig do
    params(
      out: T.any(::IO, ::StringIO),
      indent: ::Integer,
      print_locs: T::Boolean,
      max_line_length: T.nilable(::Integer)
    ).void
  end
  def print(out: T.unsafe(nil), indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#137
  sig { returns(::RBI::Tree) }
  def root; end

  # @return [Tree]
  #
  # source://rbi//lib/rbi/model.rb#137
  def root=(_arg0); end

  # source://rbi//lib/rbi/model.rb#140
  sig { returns(T.nilable(::String)) }
  def strictness; end

  # @return [String, nil]
  #
  # source://rbi//lib/rbi/model.rb#140
  def strictness=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#134
  sig { params(indent: ::Integer, print_locs: T::Boolean, max_line_length: T.nilable(::Integer)).returns(::String) }
  def string(indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end
end

# source://rbi//lib/rbi/formatter.rb#5
class RBI::Formatter
  # source://rbi//lib/rbi/formatter.rb#24
  sig do
    params(
      add_sig_templates: T::Boolean,
      group_nodes: T::Boolean,
      max_line_length: T.nilable(::Integer),
      nest_singleton_methods: T::Boolean,
      nest_non_public_methods: T::Boolean,
      sort_nodes: T::Boolean
    ).void
  end
  def initialize(add_sig_templates: T.unsafe(nil), group_nodes: T.unsafe(nil), max_line_length: T.unsafe(nil), nest_singleton_methods: T.unsafe(nil), nest_non_public_methods: T.unsafe(nil), sort_nodes: T.unsafe(nil)); end

  # source://rbi//lib/rbi/formatter.rb#9
  sig { returns(T::Boolean) }
  def add_sig_templates; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/formatter.rb#9
  def add_sig_templates=(_arg0); end

  # source://rbi//lib/rbi/formatter.rb#53
  sig { params(file: ::RBI::File).void }
  def format_file(file); end

  # source://rbi//lib/rbi/formatter.rb#58
  sig { params(tree: ::RBI::Tree).void }
  def format_tree(tree); end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/formatter.rb#9
  def group_nodes; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/formatter.rb#9
  def group_nodes=(_arg0); end

  # source://rbi//lib/rbi/formatter.rb#12
  sig { returns(T.nilable(::Integer)) }
  def max_line_length; end

  # @return [Integer, nil]
  #
  # source://rbi//lib/rbi/formatter.rb#12
  def max_line_length=(_arg0); end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/formatter.rb#9
  def nest_non_public_methods; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/formatter.rb#9
  def nest_non_public_methods=(_arg0); end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/formatter.rb#9
  def nest_singleton_methods; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/formatter.rb#9
  def nest_singleton_methods=(_arg0); end

  # source://rbi//lib/rbi/formatter.rb#41
  sig { params(file: ::RBI::File).returns(::String) }
  def print_file(file); end

  # source://rbi//lib/rbi/formatter.rb#47
  sig { params(tree: ::RBI::Tree).returns(::String) }
  def print_tree(tree); end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/formatter.rb#9
  def sort_nodes; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/formatter.rb#9
  def sort_nodes=(_arg0); end
end

# source://rbi//lib/rbi/rewriters/group_nodes.rb#88
class RBI::Group < ::RBI::Tree
  # source://rbi//lib/rbi/rewriters/group_nodes.rb#95
  sig { params(kind: ::RBI::Group::Kind).void }
  def initialize(kind); end

  # source://rbi//lib/rbi/printer.rb#836
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/group_nodes.rb#92
  sig { returns(::RBI::Group::Kind) }
  def kind; end
end

# source://rbi//lib/rbi/rewriters/group_nodes.rb#100
class RBI::Group::Kind < ::T::Enum
  enums do
    Mixins = new
    RequiredAncestors = new
    Helpers = new
    TypeMembers = new
    MixesInClassMethods = new
    Sends = new
    Attrs = new
    TStructFields = new
    TEnums = new
    Inits = new
    Methods = new
    SingletonClasses = new
    Consts = new
  end
end

# Sorbet's misc.
#
# source://rbi//lib/rbi/model.rb#1285
class RBI::Helper < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1299
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Helper).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/printer.rb#823
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#510
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/index.rb#169
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1289
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/model.rb#1306
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#785
class RBI::Include < ::RBI::Mixin
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#797
  sig do
    params(
      name: ::String,
      names: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Include).void)
    ).void
  end
  def initialize(name, *names, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#483
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/index.rb#129
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#803
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/index.rb#5
class RBI::Index < ::RBI::Visitor
  # source://rbi//lib/rbi/index.rb#17
  sig { void }
  def initialize; end

  # source://rbi//lib/rbi/index.rb#28
  sig { params(id: ::String).returns(T::Array[::RBI::Node]) }
  def [](id); end

  # source://rbi//lib/rbi/index.rb#33
  sig { params(nodes: ::RBI::Node).void }
  def index(*nodes); end

  # source://rbi//lib/rbi/index.rb#23
  sig { returns(T::Array[::String]) }
  def keys; end

  # source://rbi//lib/rbi/index.rb#38
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/index.rb#55
  sig { params(node: T.all(::RBI::Indexable, ::RBI::Node)).void }
  def index_node(node); end

  class << self
    # source://rbi//lib/rbi/index.rb#10
    sig { params(node: ::RBI::Node).returns(::RBI::Index) }
    def index(*node); end
  end
end

# A Node that can be refered to by a unique ID inside an index
#
# @abstract Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/index.rb#70
module RBI::Indexable
  interface!

  # Unique IDs that refer to this node.
  #
  # Some nodes can have multiple ids, for example an attribute accessor matches the ID of the
  # getter and the setter.
  #
  # @abstract
  #
  # source://rbi//lib/rbi/index.rb#81
  sig { abstract.returns(T::Array[::String]) }
  def index_ids; end
end

# source://rbi//lib/rbi/model.rb#988
class RBI::KwArg < ::RBI::Arg
  # source://rbi//lib/rbi/model.rb#1001
  sig { params(keyword: ::String, value: ::String, loc: T.nilable(::RBI::Loc)).void }
  def initialize(keyword, value, loc: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#1007
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#620
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#992
  sig { returns(::String) }
  def keyword; end

  # source://rbi//lib/rbi/model.rb#1012
  sig { returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#674
class RBI::KwOptParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#689
  sig do
    params(
      name: ::String,
      value: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::KwOptParam).void)
    ).void
  end
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#701
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#511
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#516
  sig { override.params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # source://rbi//lib/rbi/model.rb#696
  sig { override.returns(::String) }
  def to_s; end

  # source://rbi//lib/rbi/model.rb#678
  sig { returns(::String) }
  def value; end
end

# source://rbi//lib/rbi/model.rb#647
class RBI::KwParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#658
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::KwParam).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#669
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#496
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#501
  sig { override.params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # source://rbi//lib/rbi/model.rb#664
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#706
class RBI::KwRestParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#717
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::KwRestParam).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#728
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#526
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#531
  sig { override.params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # source://rbi//lib/rbi/model.rb#723
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/loc.rb#5
class RBI::Loc
  # source://rbi//lib/rbi/loc.rb#23
  sig do
    params(
      file: T.nilable(::String),
      begin_line: T.nilable(::Integer),
      end_line: T.nilable(::Integer),
      begin_column: T.nilable(::Integer),
      end_column: T.nilable(::Integer)
    ).void
  end
  def initialize(file: T.unsafe(nil), begin_line: T.unsafe(nil), end_line: T.unsafe(nil), begin_column: T.unsafe(nil), end_column: T.unsafe(nil)); end

  # @return [Integer, nil]
  #
  # source://rbi//lib/rbi/loc.rb#12
  def begin_column; end

  # source://rbi//lib/rbi/loc.rb#12
  sig { returns(T.nilable(::Integer)) }
  def begin_line; end

  # @return [Integer, nil]
  #
  # source://rbi//lib/rbi/loc.rb#12
  def end_column; end

  # @return [Integer, nil]
  #
  # source://rbi//lib/rbi/loc.rb#12
  def end_line; end

  # source://rbi//lib/rbi/loc.rb#9
  sig { returns(T.nilable(::String)) }
  def file; end

  # source://rbi//lib/rbi/loc.rb#37
  sig { returns(T.nilable(::String)) }
  def source; end

  # source://rbi//lib/rbi/loc.rb#32
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://rbi//lib/rbi/parser.rb#707
    sig { params(file: ::String, ast_loc: T.any(::Parser::Source::Map, ::Parser::Source::Range)).returns(::RBI::Loc) }
    def from_ast_loc(file, ast_loc); end
  end
end

# A tree that _might_ contain conflicts
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#324
class RBI::MergeTree < ::RBI::Tree
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#338
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      conflicts: T::Array[::RBI::Rewriters::Merge::Conflict],
      block: T.nilable(T.proc.params(node: ::RBI::Tree).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), conflicts: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#328
  sig { returns(T::Array[::RBI::Rewriters::Merge::Conflict]) }
  def conflicts; end
end

# Methods and args
#
# source://rbi//lib/rbi/model.rb#475
class RBI::Method < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#505
  sig do
    params(
      name: ::String,
      params: T::Array[::RBI::Param],
      is_singleton: T::Boolean,
      visibility: ::RBI::Visibility,
      sigs: T::Array[::RBI::Sig],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Method).void)
    ).void
  end
  def initialize(name, params: T.unsafe(nil), is_singleton: T.unsafe(nil), visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#525
  sig { params(param: ::RBI::Param).void }
  def <<(param); end

  # source://rbi//lib/rbi/printer.rb#382
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#453
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#530
  sig { returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/index.rb#119
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/printer.rb#435
  sig { returns(T::Boolean) }
  def inline_params?; end

  # source://rbi//lib/rbi/model.rb#485
  sig { returns(T::Boolean) }
  def is_singleton; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#485
  def is_singleton=(_arg0); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#461
  sig { override.params(other: ::RBI::Node).void }
  def merge_with(other); end

  # source://rbi//lib/rbi/model.rb#479
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#479
  def name=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#430
  sig { override.returns(T::Boolean) }
  def oneline?; end

  # source://rbi//lib/rbi/model.rb#482
  sig { returns(T::Array[::RBI::Param]) }
  def params; end

  # source://rbi//lib/rbi/model.rb#491
  sig { returns(T::Array[::RBI::Sig]) }
  def sigs; end

  # @return [Array<Sig>]
  #
  # source://rbi//lib/rbi/model.rb#491
  def sigs=(_arg0); end

  # source://rbi//lib/rbi/model.rb#539
  sig { override.returns(::String) }
  def to_s; end

  # source://rbi//lib/rbi/model.rb#488
  sig { returns(::RBI::Visibility) }
  def visibility; end

  # @return [Visibility]
  #
  # source://rbi//lib/rbi/model.rb#488
  def visibility=(_arg0); end
end

# source://rbi//lib/rbi/model.rb#1345
class RBI::MixesInClassMethods < ::RBI::Mixin
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1357
  sig do
    params(
      name: ::String,
      names: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::MixesInClassMethods).void)
    ).void
  end
  def initialize(name, *names, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#501
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/index.rb#149
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1363
  sig { override.returns(::String) }
  def to_s; end
end

# Mixins
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#762
class RBI::Mixin < ::RBI::NodeWithComments
  abstract!

  # source://rbi//lib/rbi/model.rb#779
  sig do
    params(
      name: ::String,
      names: T::Array[::String],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment]
    ).void
  end
  def initialize(name, names, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#556
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#474
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#769
  sig { returns(T::Array[::String]) }
  def names; end

  # @return [Array<String>]
  #
  # source://rbi//lib/rbi/model.rb#769
  def names=(_arg0); end
end

# source://rbi//lib/rbi/model.rb#186
class RBI::Module < ::RBI::Scope
  # source://rbi//lib/rbi/model.rb#200
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Module).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#379
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#207
  sig { override.returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/model.rb#190
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#190
  def name=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#268
  sig { override.params(v: ::RBI::Printer).void }
  def print_header(v); end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#5
class RBI::Node
  abstract!

  # source://rbi//lib/rbi/model.rb#18
  sig { params(loc: T.nilable(::RBI::Loc)).void }
  def initialize(loc: T.unsafe(nil)); end

  # @abstract
  #
  # source://rbi//lib/rbi/printer.rb#145
  sig { abstract.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # Can `self` and `_other` be merged into a single definition?
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#283
  sig { params(_other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(_other); end

  # source://rbi//lib/rbi/model.rb#24
  sig { void }
  def detach; end

  # source://rbi//lib/rbi/rewriters/group_nodes.rb#48
  sig { returns(::RBI::Group::Kind) }
  def group_kind; end

  # source://rbi//lib/rbi/model.rb#15
  sig { returns(T.nilable(::RBI::Loc)) }
  def loc; end

  # @return [Loc, nil]
  #
  # source://rbi//lib/rbi/model.rb#15
  def loc=(_arg0); end

  # Merge `self` and `other` into a single definition
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#289
  sig { params(other: ::RBI::Node).void }
  def merge_with(other); end

  # source://rbi//lib/rbi/printer.rb#177
  sig { returns(T::Boolean) }
  def oneline?; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#292
  sig { returns(T.nilable(::RBI::ConflictTree)) }
  def parent_conflict_tree; end

  # source://rbi//lib/rbi/model.rb#43
  sig { returns(T.nilable(::RBI::Scope)) }
  def parent_scope; end

  # source://rbi//lib/rbi/model.rb#12
  sig { returns(T.nilable(::RBI::Tree)) }
  def parent_tree; end

  # @return [Tree, nil]
  #
  # source://rbi//lib/rbi/model.rb#12
  def parent_tree=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#155
  sig do
    params(
      out: T.any(::IO, ::StringIO),
      indent: ::Integer,
      print_locs: T::Boolean,
      max_line_length: T.nilable(::Integer)
    ).void
  end
  def print(out: T.unsafe(nil), indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#168
  sig { params(v: ::RBI::Printer).void }
  def print_blank_line_before(v); end

  # source://rbi//lib/rbi/model.rb#32
  sig { params(node: ::RBI::Node).void }
  def replace(node); end

  # source://rbi//lib/rbi/printer.rb#161
  sig { params(indent: ::Integer, print_locs: T::Boolean, max_line_length: T.nilable(::Integer)).returns(::String) }
  def string(indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#79
class RBI::NodeWithComments < ::RBI::Node
  abstract!

  # source://rbi//lib/rbi/model.rb#89
  sig { params(loc: T.nilable(::RBI::Loc), comments: T::Array[::RBI::Comment]).void }
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#95
  sig { returns(T::Array[::String]) }
  def annotations; end

  # source://rbi//lib/rbi/model.rb#86
  sig { returns(T::Array[::RBI::Comment]) }
  def comments; end

  # @return [Array<Comment>]
  #
  # source://rbi//lib/rbi/model.rb#86
  def comments=(_arg0); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#306
  sig { override.params(other: ::RBI::Node).void }
  def merge_with(other); end

  # source://rbi//lib/rbi/printer.rb#186
  sig { override.returns(T::Boolean) }
  def oneline?; end
end

# source://rbi//lib/rbi/model.rb#593
class RBI::OptParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#608
  sig do
    params(
      name: ::String,
      value: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::OptParam).void)
    ).void
  end
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#615
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#466
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#471
  sig { override.params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # source://rbi//lib/rbi/model.rb#597
  sig { returns(::String) }
  def value; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#544
class RBI::Param < ::RBI::NodeWithComments
  abstract!

  # source://rbi//lib/rbi/model.rb#560
  sig { params(name: ::String, loc: T.nilable(::RBI::Loc), comments: T::Array[::RBI::Comment]).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#444
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#457
  sig { returns(T::Array[::String]) }
  def comments_lines; end

  # source://rbi//lib/rbi/model.rb#551
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/printer.rb#449
  sig { params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # source://rbi//lib/rbi/model.rb#566
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/parser.rb#7
class RBI::ParseError < ::StandardError
  # source://rbi//lib/rbi/parser.rb#14
  sig { params(message: ::String, location: ::RBI::Loc).void }
  def initialize(message, location); end

  # source://rbi//lib/rbi/parser.rb#11
  sig { returns(::RBI::Loc) }
  def location; end
end

# source://rbi//lib/rbi/parser.rb#53
class RBI::Parser
  # source://rbi//lib/rbi/parser.rb#64
  sig { void }
  def initialize; end

  # source://rbi//lib/rbi/parser.rb#97
  sig { params(path: ::String).returns(::RBI::Tree) }
  def parse_file(path); end

  # source://rbi//lib/rbi/parser.rb#86
  sig { params(string: ::String).returns(::RBI::Tree) }
  def parse_string(string); end

  private

  # source://rbi//lib/rbi/parser.rb#104
  sig { params(content: ::String, file: ::String).returns(::RBI::Tree) }
  def parse(content, file:); end

  class << self
    # source://rbi//lib/rbi/parser.rb#75
    sig { params(path: ::String).returns(::RBI::Tree) }
    def parse_file(path); end

    # source://rbi//lib/rbi/parser.rb#80
    sig { params(paths: T::Array[::String]).returns(T::Array[::RBI::Tree]) }
    def parse_files(paths); end

    # source://rbi//lib/rbi/parser.rb#70
    sig { params(string: ::String).returns(::RBI::Tree) }
    def parse_string(string); end

    # source://rbi//lib/rbi/parser.rb#91
    sig { params(strings: T::Array[::String]).returns(T::Array[::RBI::Tree]) }
    def parse_strings(strings); end
  end
end

# source://rbi//lib/rbi/printer.rb#5
class RBI::Printer < ::RBI::Visitor
  # source://rbi//lib/rbi/printer.rb#28
  sig do
    params(
      out: T.any(::IO, ::StringIO),
      indent: ::Integer,
      print_locs: T::Boolean,
      max_line_length: T.nilable(::Integer)
    ).void
  end
  def initialize(out: T.unsafe(nil), indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#15
  sig { returns(::Integer) }
  def current_indent; end

  # source://rbi//lib/rbi/printer.rb#46
  sig { void }
  def dedent; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/printer.rb#9
  def in_visibility_group; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/printer.rb#9
  def in_visibility_group=(_arg0); end

  # Printing
  #
  # source://rbi//lib/rbi/printer.rb#41
  sig { void }
  def indent; end

  # source://rbi//lib/rbi/printer.rb#18
  sig { returns(T.nilable(::Integer)) }
  def max_line_length; end

  # source://rbi//lib/rbi/printer.rb#12
  sig { returns(T.nilable(::RBI::Node)) }
  def previous_node; end

  # Print a string without indentation nor `\n` at the end.
  #
  # source://rbi//lib/rbi/printer.rb#52
  sig { params(string: ::String).void }
  def print(string); end

  # source://rbi//lib/rbi/printer.rb#9
  sig { returns(T::Boolean) }
  def print_locs; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/printer.rb#9
  def print_locs=(_arg0); end

  # Print a string with indentation and `\n` at the end.
  #
  # source://rbi//lib/rbi/printer.rb#72
  sig { params(string: ::String).void }
  def printl(string); end

  # Print a string without indentation but with a `\n` at the end.
  #
  # source://rbi//lib/rbi/printer.rb#58
  sig { params(string: T.nilable(::String)).void }
  def printn(string = T.unsafe(nil)); end

  # Print a string with indentation but without a `\n` at the end.
  #
  # source://rbi//lib/rbi/printer.rb#65
  sig { params(string: T.nilable(::String)).void }
  def printt(string = T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#83
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  # source://rbi//lib/rbi/printer.rb#89
  sig { override.params(nodes: T::Array[::RBI::Node]).void }
  def visit_all(nodes); end

  # source://rbi//lib/rbi/printer.rb#78
  sig { params(file: ::RBI::File).void }
  def visit_file(file); end
end

# source://rbi//lib/rbi/model.rb#901
class RBI::Private < ::RBI::Visibility
  # source://rbi//lib/rbi/model.rb#911
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Private).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

# source://rbi//lib/rbi/model.rb#885
class RBI::Protected < ::RBI::Visibility
  # source://rbi//lib/rbi/model.rb#895
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Protected).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

# source://rbi//lib/rbi/model.rb#869
class RBI::Public < ::RBI::Visibility
  # source://rbi//lib/rbi/model.rb#879
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Public).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

# source://rbi//lib/rbi/model.rb#571
class RBI::ReqParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#582
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::ReqParam).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#588
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end
end

# source://rbi//lib/rbi/model.rb#1368
class RBI::RequiresAncestor < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1381
  sig { params(name: ::String, loc: T.nilable(::RBI::Loc), comments: T::Array[::RBI::Comment]).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#868
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/index.rb#159
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1372
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/model.rb#1387
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#620
class RBI::RestParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#631
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::RestParam).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#642
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#481
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#486
  sig { override.params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # source://rbi//lib/rbi/model.rb#637
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/rewriters/add_sig_templates.rb#5
module RBI::Rewriters; end

# source://rbi//lib/rbi/rewriters/add_sig_templates.rb#6
class RBI::Rewriters::AddSigTemplates < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#10
  sig { params(with_todo_comment: T::Boolean).void }
  def initialize(with_todo_comment: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#16
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#30
  sig { params(attr: ::RBI::Attr).void }
  def add_attr_sig(attr); end

  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#45
  sig { params(method: ::RBI::Method).void }
  def add_method_sig(method); end

  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#56
  sig { params(node: ::RBI::NodeWithComments).void }
  def add_todo_comment(node); end
end

# source://rbi//lib/rbi/rewriters/annotate.rb#6
class RBI::Rewriters::Annotate < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/annotate.rb#10
  sig { params(annotation: ::String, annotate_scopes: T::Boolean, annotate_properties: T::Boolean).void }
  def initialize(annotation, annotate_scopes: T.unsafe(nil), annotate_properties: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/annotate.rb#18
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/annotate.rb#31
  sig { params(node: ::RBI::NodeWithComments).void }
  def annotate_node(node); end

  # source://rbi//lib/rbi/rewriters/annotate.rb#37
  sig { params(node: ::RBI::Node).returns(T::Boolean) }
  def root?(node); end
end

# source://rbi//lib/rbi/rewriters/deannotate.rb#6
class RBI::Rewriters::Deannotate < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/deannotate.rb#10
  sig { params(annotation: ::String).void }
  def initialize(annotation); end

  # source://rbi//lib/rbi/rewriters/deannotate.rb#16
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/deannotate.rb#27
  sig { params(node: ::RBI::NodeWithComments).void }
  def deannotate_node(node); end
end

# source://rbi//lib/rbi/rewriters/group_nodes.rb#6
class RBI::Rewriters::GroupNodes < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/group_nodes.rb#10
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end
end

# Merge two RBI trees together
#
# Be this `Tree`:
# ~~~rb
# class Foo
#   attr_accessor :a
#   def m; end
#   C = 10
# end
# ~~~
#
# Merged with this one:
# ~~~rb
# class Foo
#   attr_reader :a
#   def m(x); end
#   C = 10
# end
# ~~~
#
# Compatible definitions are merged together while incompatible definitions are moved into a `ConflictTree`:
# ~~~rb
# class Foo
#   <<<<<<< left
#   attr_accessor :a
#   def m; end
#   =======
#   attr_reader :a
#   def m(x); end
#   >>>>>>> right
#   C = 10
# end
# ~~~
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#39
class RBI::Rewriters::Merge
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#66
  sig { params(left_name: ::String, right_name: ::String, keep: ::RBI::Rewriters::Merge::Keep).void }
  def initialize(left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#75
  sig { params(tree: ::RBI::Tree).void }
  def merge(tree); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#63
  sig { returns(::RBI::MergeTree) }
  def tree; end

  class << self
    # source://rbi//lib/rbi/rewriters/merge_trees.rb#51
    sig do
      params(
        left: ::RBI::Tree,
        right: ::RBI::Tree,
        left_name: ::String,
        right_name: ::String,
        keep: ::RBI::Rewriters::Merge::Keep
      ).returns(::RBI::MergeTree)
    end
    def merge_trees(left, right, left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end
  end
end

# Used for logging / error displaying purpose
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#82
class RBI::Rewriters::Merge::Conflict < ::T::Struct
  const :left, ::RBI::Node
  const :right, ::RBI::Node
  const :left_name, ::String
  const :right_name, ::String

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#91
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://sorbet-runtime/0.5.10598/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# Merge adjacent conflict trees
#
# Transform this:
# ~~~rb
# class Foo
#   <<<<<<< left
#   def m1; end
#   =======
#   def m1(a); end
#   >>>>>>> right
#   <<<<<<< left
#   def m2(a); end
#   =======
#   def m2; end
#   >>>>>>> right
# end
# ~~~
#
# Into this:
# ~~~rb
# class Foo
#   <<<<<<< left
#   def m1; end
#   def m2(a); end
#   =======
#   def m1(a); end
#   def m2; end
#   >>>>>>> right
# end
# ~~~
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#241
class RBI::Rewriters::Merge::ConflictTreeMerger < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#243
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#248
  sig { override.params(nodes: T::Array[::RBI::Node]).void }
  def visit_all(nodes); end

  private

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#269
  sig { params(left: ::RBI::Tree, right: ::RBI::Tree).void }
  def merge_conflict_trees(left, right); end
end

# source://rbi//lib/rbi/rewriters/merge_trees.rb#42
class RBI::Rewriters::Merge::Keep < ::T::Enum
  enums do
    NONE = new
    LEFT = new
    RIGHT = new
  end
end

# source://rbi//lib/rbi/rewriters/merge_trees.rb#96
class RBI::Rewriters::Merge::TreeMerger < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#103
  sig do
    params(
      output: ::RBI::Tree,
      left_name: ::String,
      right_name: ::String,
      keep: ::RBI::Rewriters::Merge::Keep
    ).void
  end
  def initialize(output, left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#100
  sig { returns(T::Array[::RBI::Rewriters::Merge::Conflict]) }
  def conflicts; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#115
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#164
  sig { returns(::RBI::Tree) }
  def current_scope; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#181
  sig { params(left: ::RBI::Scope, right: ::RBI::Scope).void }
  def make_conflict_scope(left, right); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#188
  sig { params(left: ::RBI::Node, right: ::RBI::Node).void }
  def make_conflict_tree(left, right); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#169
  sig { params(node: ::RBI::Node).returns(T.nilable(::RBI::Node)) }
  def previous_definition(node); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#200
  sig { params(left: ::RBI::Scope, right: ::RBI::Scope).returns(::RBI::Scope) }
  def replace_scope_header(left, right); end
end

# source://rbi//lib/rbi/rewriters/nest_non_public_methods.rb#6
class RBI::Rewriters::NestNonPublicMethods < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/nest_non_public_methods.rb#10
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end
end

# source://rbi//lib/rbi/rewriters/nest_singleton_methods.rb#6
class RBI::Rewriters::NestSingletonMethods < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/nest_singleton_methods.rb#10
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end
end

# Remove all definitions existing in the index from the current tree
#
# Let's create an `Index` from two different `Tree`s:
# ~~~rb
# tree1 = Parse.parse_string(<<~RBI)
#   class Foo
#     def foo; end
#   end
# RBI
#
# tree2 = Parse.parse_string(<<~RBI)
#   FOO = 10
# RBI
#
# index = Index.index(tree1, tree2)
# ~~~
#
# We can use `RemoveKnownDefinitions` to remove the definitions found in the `index` from the `Tree` to clean:
# ~~~rb
# tree_to_clean = Parser.parse_string(<<~RBI)
#   class Foo
#     def foo; end
#     def bar; end
#   end
#   FOO = 10
#   BAR = 42
# RBI
#
# cleaned_tree, operations = RemoveKnownDefinitions.remove(tree_to_clean, index)
#
# assert_equal(<<~RBI, cleaned_tree)
#   class Foo
#     def bar; end
#   end
#   BAR = 42
# RBI
#
# assert_equal(<<~OPERATIONS, operations.join("\n"))
#   Deleted ::Foo#foo at -:2:2-2-16 (duplicate from -:2:2-2:16)
#   Deleted ::FOO at -:5:0-5:8 (duplicate from -:1:0-1:8)
# OPERATIONS
# ~~~
#
# source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#48
class RBI::Rewriters::RemoveKnownDefinitions < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#67
  sig { params(index: ::RBI::Index).void }
  def initialize(index); end

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#64
  sig { returns(T::Array[::RBI::Rewriters::RemoveKnownDefinitions::Operation]) }
  def operations; end

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#79
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#74
  sig { params(nodes: T::Array[::RBI::Node]).void }
  def visit_all(nodes); end

  private

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#107
  sig { params(node: ::RBI::Node, previous: ::RBI::Node).returns(T::Boolean) }
  def can_delete_node?(node, previous); end

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#125
  sig { params(node: ::RBI::Node, previous: ::RBI::Node).void }
  def delete_node(node, previous); end

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#98
  sig { params(node: ::RBI::Indexable).returns(T.nilable(::RBI::Node)) }
  def previous_definition_for(node); end

  class << self
    # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#57
    sig do
      params(
        tree: ::RBI::Tree,
        index: ::RBI::Index
      ).returns([::RBI::Tree, T::Array[::RBI::Rewriters::RemoveKnownDefinitions::Operation]])
    end
    def remove(tree, index); end
  end
end

# source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#130
class RBI::Rewriters::RemoveKnownDefinitions::Operation < ::T::Struct
  const :deleted_node, ::RBI::Node
  const :duplicate_of, ::RBI::Node

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#137
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://sorbet-runtime/0.5.10598/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# source://rbi//lib/rbi/rewriters/sort_nodes.rb#6
class RBI::Rewriters::SortNodes < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#10
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#61
  sig { params(kind: ::RBI::Group::Kind).returns(::Integer) }
  def group_rank(kind); end

  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#82
  sig { params(node: ::RBI::Node).returns(T.nilable(::String)) }
  def node_name(node); end

  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#33
  sig { params(node: ::RBI::Node).returns(::Integer) }
  def node_rank(node); end

  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#94
  sig { params(node: ::RBI::Node).void }
  def sort_node_names!(node); end
end

# Scopes
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#172
class RBI::Scope < ::RBI::Tree
  include ::RBI::Indexable

  abstract!

  # source://sorbet-runtime/0.5.10598/lib/types/private/abstract/declare.rb#37
  def initialize(*args, **_arg1, &blk); end

  # source://rbi//lib/rbi/printer.rb#240
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # Duplicate `self` scope without its body
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#350
  sig { returns(T.self_type) }
  def dup_empty; end

  # @abstract
  #
  # source://rbi//lib/rbi/model.rb#178
  sig { abstract.returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/index.rb#89
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/printer.rb#254
  sig { params(v: ::RBI::Printer).void }
  def print_body(v); end

  # @abstract
  #
  # source://rbi//lib/rbi/printer.rb#251
  sig { abstract.params(v: ::RBI::Printer).void }
  def print_header(v); end

  # source://rbi//lib/rbi/model.rb#181
  sig { override.returns(::String) }
  def to_s; end
end

# A conflict between two scope headers
#
# Is rendered as a merge conflict between `left` and` right` for scope definitions:
# ~~~rb
# <<<<<<< left
# class Foo
# =======
# module Foo
# >>>>>>> right
#   def m1; end
# end
# ~~~
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#617
class RBI::ScopeConflict < ::RBI::Tree
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#631
  sig { params(left: ::RBI::Scope, right: ::RBI::Scope, left_name: ::String, right_name: ::String).void }
  def initialize(left:, right:, left_name: T.unsafe(nil), right_name: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#640
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#621
  sig { returns(::RBI::Scope) }
  def left; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#656
  sig { override.returns(T::Boolean) }
  def oneline?; end

  # @return [Scope]
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#621
  def right; end
end

# Sends
#
# source://rbi//lib/rbi/model.rb#919
class RBI::Send < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#937
  sig do
    params(
      method: ::String,
      args: T::Array[::RBI::Arg],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Send).void)
    ).void
  end
  def initialize(method, args = T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#945
  sig { params(arg: ::RBI::Arg).void }
  def <<(arg); end

  # source://rbi//lib/rbi/model.rb#950
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#590
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#926
  sig { returns(T::Array[::RBI::Arg]) }
  def args; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#519
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/index.rb#179
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#923
  sig { returns(::String) }
  def method; end

  # source://rbi//lib/rbi/model.rb#955
  sig { returns(::String) }
  def to_s; end
end

# Sorbet's sigs
#
# source://rbi//lib/rbi/model.rb#1019
class RBI::Sig < ::RBI::Node
  # source://rbi//lib/rbi/model.rb#1051
  sig do
    params(
      params: T::Array[::RBI::SigParam],
      return_type: T.nilable(::String),
      is_abstract: T::Boolean,
      is_override: T::Boolean,
      is_overridable: T::Boolean,
      is_final: T::Boolean,
      type_params: T::Array[::String],
      checked: T.nilable(::Symbol),
      loc: T.nilable(::RBI::Loc),
      block: T.nilable(T.proc.params(node: ::RBI::Sig).void)
    ).void
  end
  def initialize(params: T.unsafe(nil), return_type: T.unsafe(nil), is_abstract: T.unsafe(nil), is_override: T.unsafe(nil), is_overridable: T.unsafe(nil), is_final: T.unsafe(nil), type_params: T.unsafe(nil), checked: T.unsafe(nil), loc: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#1076
  sig { params(param: ::RBI::SigParam).void }
  def <<(param); end

  # source://rbi//lib/rbi/model.rb#1081
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#631
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#1035
  sig { returns(T.nilable(::Symbol)) }
  def checked; end

  # @return [Symbol, nil]
  #
  # source://rbi//lib/rbi/model.rb#1035
  def checked=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#654
  sig { returns(T::Boolean) }
  def inline_params?; end

  # source://rbi//lib/rbi/model.rb#1029
  sig { returns(T::Boolean) }
  def is_abstract; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1029
  def is_abstract=(_arg0); end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1029
  def is_final; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1029
  def is_final=(_arg0); end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1029
  def is_overridable; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1029
  def is_overridable=(_arg0); end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1029
  def is_override; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1029
  def is_override=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#649
  sig { override.returns(T::Boolean) }
  def oneline?; end

  # source://rbi//lib/rbi/model.rb#1023
  sig { returns(T::Array[::RBI::SigParam]) }
  def params; end

  # source://rbi//lib/rbi/model.rb#1026
  sig { returns(T.nilable(::String)) }
  def return_type; end

  # @return [String, nil]
  #
  # source://rbi//lib/rbi/model.rb#1026
  def return_type=(_arg0); end

  # source://rbi//lib/rbi/model.rb#1032
  sig { returns(T::Array[::String]) }
  def type_params; end

  private

  # source://rbi//lib/rbi/printer.rb#696
  sig { params(v: ::RBI::Printer).void }
  def print_as_block(v); end

  # source://rbi//lib/rbi/printer.rb#672
  sig { params(v: ::RBI::Printer).void }
  def print_as_line(v); end

  # source://rbi//lib/rbi/printer.rb#661
  sig { returns(T::Array[::String]) }
  def sig_modifiers; end
end

# source://rbi//lib/rbi/parser.rb#635
class RBI::SigBuilder < ::RBI::ASTVisitor
  # source://rbi//lib/rbi/parser.rb#649
  sig { void }
  def initialize; end

  # source://rbi//lib/rbi/parser.rb#646
  sig { returns(::RBI::Sig) }
  def current; end

  # @return [Sig]
  #
  # source://rbi//lib/rbi/parser.rb#646
  def current=(_arg0); end

  # source://rbi//lib/rbi/parser.rb#655
  sig { override.params(node: T.nilable(::AST::Node)).void }
  def visit(node); end

  # source://rbi//lib/rbi/parser.rb#664
  sig { params(node: ::AST::Node).void }
  def visit_send(node); end

  class << self
    # source://rbi//lib/rbi/parser.rb#639
    sig { params(node: ::AST::Node).returns(::RBI::Sig) }
    def build(node); end
  end
end

# source://rbi//lib/rbi/model.rb#1089
class RBI::SigParam < ::RBI::NodeWithComments
  # source://rbi//lib/rbi/model.rb#1104
  sig do
    params(
      name: ::String,
      type: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::SigParam).void)
    ).void
  end
  def initialize(name, type, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#1112
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#749
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#762
  sig { returns(T::Array[::String]) }
  def comments_lines; end

  # source://rbi//lib/rbi/model.rb#1093
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/printer.rb#754
  sig { params(v: ::RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#1093
  def type; end
end

# source://rbi//lib/rbi/model.rb#245
class RBI::SingletonClass < ::RBI::Scope
  # source://rbi//lib/rbi/model.rb#255
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::SingletonClass).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#261
  sig { override.returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/printer.rb#319
  sig { override.params(v: ::RBI::Printer).void }
  def print_header(v); end
end

# source://rbi//lib/rbi/model.rb#266
class RBI::Struct < ::RBI::Scope
  # source://rbi//lib/rbi/model.rb#288
  sig do
    params(
      name: ::String,
      members: T::Array[::Symbol],
      keyword_init: T::Boolean,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(struct: ::RBI::Struct).void)
    ).void
  end
  def initialize(name, members: T.unsafe(nil), keyword_init: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#388
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#297
  sig { override.returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/model.rb#276
  sig { returns(T::Boolean) }
  def keyword_init; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#276
  def keyword_init=(_arg0); end

  # source://rbi//lib/rbi/model.rb#273
  sig { returns(T::Array[::Symbol]) }
  def members; end

  # @return [Array<Symbol>]
  #
  # source://rbi//lib/rbi/model.rb#273
  def members=(_arg0); end

  # source://rbi//lib/rbi/model.rb#270
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#270
  def name=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#298
  sig { override.params(v: ::RBI::Printer).void }
  def print_header(v); end
end

# Sorbet's T::Enum
#
# source://rbi//lib/rbi/model.rb#1230
class RBI::TEnum < ::RBI::Class
  # source://rbi//lib/rbi/model.rb#1241
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(klass: ::RBI::TEnum).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

# source://rbi//lib/rbi/model.rb#1247
class RBI::TEnumBlock < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1261
  sig do
    params(
      names: T::Array[::String],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::TEnumBlock).void)
    ).void
  end
  def initialize(names = T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#1273
  sig { params(name: ::String).void }
  def <<(name); end

  # source://rbi//lib/rbi/printer.rb#793
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#1268
  sig { returns(T::Boolean) }
  def empty?; end

  # source://rbi//lib/rbi/index.rb#209
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#546
  sig { override.params(other: ::RBI::Node).void }
  def merge_with(other); end

  # source://rbi//lib/rbi/model.rb#1251
  sig { returns(T::Array[::String]) }
  def names; end

  # source://rbi//lib/rbi/model.rb#1278
  sig { override.returns(::String) }
  def to_s; end
end

# Sorbet's T::Struct
#
# source://rbi//lib/rbi/model.rb#1119
class RBI::TStruct < ::RBI::Class
  # source://rbi//lib/rbi/model.rb#1130
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(klass: ::RBI::TStruct).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

# source://rbi//lib/rbi/model.rb#1168
class RBI::TStructConst < ::RBI::TStructField
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1181
  sig do
    params(
      name: ::String,
      type: ::String,
      default: T.nilable(::String),
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::TStructConst).void)
    ).void
  end
  def initialize(name, type, default: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#537
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#1187
  sig { override.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/index.rb#189
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1193
  sig { override.returns(::String) }
  def to_s; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#1136
class RBI::TStructField < ::RBI::NodeWithComments
  abstract!

  # source://rbi//lib/rbi/model.rb#1157
  sig do
    params(
      name: ::String,
      type: ::String,
      default: T.nilable(::String),
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment]
    ).void
  end
  def initialize(name, type, default: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#771
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#528
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#1146
  sig { returns(T.nilable(::String)) }
  def default; end

  # @return [String, nil]
  #
  # source://rbi//lib/rbi/model.rb#1146
  def default=(_arg0); end

  # @abstract
  #
  # source://rbi//lib/rbi/model.rb#1165
  sig { abstract.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/model.rb#1143
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#1143
  def name=(_arg0); end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#1143
  def type; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#1143
  def type=(_arg0); end
end

# source://rbi//lib/rbi/model.rb#1198
class RBI::TStructProp < ::RBI::TStructField
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1211
  sig do
    params(
      name: ::String,
      type: ::String,
      default: T.nilable(::String),
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::TStructProp).void)
    ).void
  end
  def initialize(name, type, default: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#559
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#1217
  sig { override.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/index.rb#199
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1223
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#102
class RBI::Tree < ::RBI::NodeWithComments
  # source://rbi//lib/rbi/model.rb#115
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Tree).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#122
  sig { params(node: ::RBI::Node).void }
  def <<(node); end

  # source://rbi//lib/rbi/printer.rb#224
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#66
  sig { params(with_todo_comment: T::Boolean).void }
  def add_sig_templates!(with_todo_comment: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/annotate.rb#48
  sig { params(annotation: ::String, annotate_scopes: T::Boolean, annotate_properties: T::Boolean).void }
  def annotate!(annotation, annotate_scopes: T.unsafe(nil), annotate_properties: T.unsafe(nil)); end

  # source://tapioca/0.11.6/lib/tapioca/rbi_ext/model.rb#38
  sig do
    params(
      name: ::String,
      superclass_name: T.nilable(::String),
      block: T.nilable(T.proc.params(scope: ::RBI::Scope).void)
    ).returns(::RBI::Scope)
  end
  def create_class(name, superclass_name: T.unsafe(nil), &block); end

  # source://tapioca/0.11.6/lib/tapioca/rbi_ext/model.rb#45
  sig { params(name: ::String, value: ::String).void }
  def create_constant(name, value:); end

  # source://tapioca/0.11.6/lib/tapioca/rbi_ext/model.rb#55
  sig { params(name: ::String).void }
  def create_extend(name); end

  # source://tapioca/0.11.6/lib/tapioca/rbi_ext/model.rb#50
  sig { params(name: ::String).void }
  def create_include(name); end

  # source://tapioca/0.11.6/lib/tapioca/rbi_ext/model.rb#89
  sig do
    params(
      name: ::String,
      parameters: T::Array[::RBI::TypedParam],
      return_type: ::String,
      class_method: T::Boolean,
      visibility: ::RBI::Visibility,
      comments: T::Array[::RBI::Comment]
    ).void
  end
  def create_method(name, parameters: T.unsafe(nil), return_type: T.unsafe(nil), class_method: T.unsafe(nil), visibility: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://tapioca/0.11.6/lib/tapioca/rbi_ext/model.rb#60
  sig { params(name: ::String).void }
  def create_mixes_in_class_methods(name); end

  # source://tapioca/0.11.6/lib/tapioca/rbi_ext/model.rb#25
  sig { params(name: ::String, block: T.nilable(T.proc.params(scope: ::RBI::Scope).void)).returns(::RBI::Scope) }
  def create_module(name, &block); end

  # source://tapioca/0.11.6/lib/tapioca/rbi_ext/model.rb#9
  sig { params(constant: ::Module, block: T.nilable(T.proc.params(scope: ::RBI::Scope).void)).returns(::RBI::Scope) }
  def create_path(constant, &block); end

  # source://tapioca/0.11.6/lib/tapioca/rbi_ext/model.rb#74
  sig do
    params(
      name: ::String,
      type: ::String,
      variance: ::Symbol,
      fixed: T.nilable(::String),
      upper: T.nilable(::String),
      lower: T.nilable(::String)
    ).void
  end
  def create_type_variable(name, type:, variance: T.unsafe(nil), fixed: T.unsafe(nil), upper: T.unsafe(nil), lower: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/deannotate.rb#40
  sig { params(annotation: ::String).void }
  def deannotate!(annotation); end

  # source://rbi//lib/rbi/model.rb#128
  sig { returns(T::Boolean) }
  def empty?; end

  # source://rbi//lib/rbi/rewriters/group_nodes.rb#38
  sig { void }
  def group_nodes!; end

  # source://rbi//lib/rbi/index.rb#64
  sig { returns(::RBI::Index) }
  def index; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#318
  sig do
    params(
      other: ::RBI::Tree,
      left_name: ::String,
      right_name: ::String,
      keep: ::RBI::Rewriters::Merge::Keep
    ).returns(::RBI::MergeTree)
  end
  def merge(other, left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/nest_non_public_methods.rb#45
  sig { void }
  def nest_non_public_methods!; end

  # source://rbi//lib/rbi/rewriters/nest_singleton_methods.rb#35
  sig { void }
  def nest_singleton_methods!; end

  # source://rbi//lib/rbi/model.rb#106
  sig { returns(T::Array[::RBI::Node]) }
  def nodes; end

  # source://rbi//lib/rbi/printer.rb#231
  sig { override.returns(T::Boolean) }
  def oneline?; end

  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#107
  sig { void }
  def sort_nodes!; end

  private

  # source://tapioca/0.11.6/lib/tapioca/rbi_ext/model.rb#116
  sig { params(node: ::RBI::Node).returns(::RBI::Node) }
  def create_node(node); end

  # source://tapioca/0.11.6/lib/tapioca/rbi_ext/model.rb#111
  sig { returns(T::Hash[::String, ::RBI::Node]) }
  def nodes_cache; end
end

# source://rbi//lib/rbi/parser.rb#156
class RBI::TreeBuilder < ::RBI::ASTVisitor
  # source://rbi//lib/rbi/parser.rb#172
  sig do
    params(
      file: ::String,
      comments: T::Array[::Parser::Source::Comment],
      nodes_comments_assoc: T::Hash[::Parser::Source::Map, T::Array[::Parser::Source::Comment]]
    ).void
  end
  def initialize(file:, comments: T.unsafe(nil), nodes_comments_assoc: T.unsafe(nil)); end

  # source://rbi//lib/rbi/parser.rb#163
  sig { returns(T.nilable(::AST::Node)) }
  def last_node; end

  # source://rbi//lib/rbi/parser.rb#187
  sig { void }
  def post_process; end

  # source://rbi//lib/rbi/parser.rb#160
  sig { returns(::RBI::Tree) }
  def tree; end

  # source://rbi//lib/rbi/parser.rb#193
  sig { override.params(node: T.nilable(::Object)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/parser.rb#546
  sig { void }
  def assoc_dangling_comments; end

  # source://rbi//lib/rbi/parser.rb#527
  sig { returns(::RBI::Tree) }
  def current_scope; end

  # source://rbi//lib/rbi/parser.rb#532
  sig { returns(T::Array[::RBI::Sig]) }
  def current_sigs; end

  # source://rbi//lib/rbi/parser.rb#539
  sig { returns(T::Array[::RBI::Comment]) }
  def current_sigs_comments; end

  # source://rbi//lib/rbi/parser.rb#516
  sig { params(node: ::AST::Node).returns(T::Array[::RBI::Comment]) }
  def node_comments(node); end

  # source://rbi//lib/rbi/parser.rb#511
  sig { params(node: ::AST::Node).returns(::RBI::Loc) }
  def node_loc(node); end

  # source://rbi//lib/rbi/parser.rb#402
  sig { params(node: ::AST::Node).returns(T.nilable(::RBI::Node)) }
  def parse_block(node); end

  # source://rbi//lib/rbi/parser.rb#249
  sig { params(node: ::AST::Node).returns(::RBI::Node) }
  def parse_const_assign(node); end

  # source://rbi//lib/rbi/parser.rb#263
  sig { params(node: ::AST::Node).returns(::RBI::Method) }
  def parse_def(node); end

  # source://rbi//lib/rbi/parser.rb#486
  sig { params(node: ::AST::Node).returns(::RBI::TEnumBlock) }
  def parse_enum(node); end

  # source://rbi//lib/rbi/parser.rb#290
  sig { params(node: ::AST::Node).returns(::RBI::Param) }
  def parse_param(node); end

  # source://rbi//lib/rbi/parser.rb#503
  sig { params(node: ::AST::Node).returns(::RBI::RequiresAncestor) }
  def parse_requires_ancestor(node); end

  # source://rbi//lib/rbi/parser.rb#229
  sig { params(node: ::AST::Node).returns(::RBI::Scope) }
  def parse_scope(node); end

  # source://rbi//lib/rbi/parser.rb#318
  sig { params(node: ::AST::Node).returns(T.nilable(::RBI::Node)) }
  def parse_send(node); end

  # source://rbi//lib/rbi/parser.rb#385
  sig { params(node: ::AST::Node).returns(T::Array[::RBI::Arg]) }
  def parse_send_args(node); end

  # source://rbi//lib/rbi/parser.rb#479
  sig { params(node: ::AST::Node).returns(::RBI::Sig) }
  def parse_sig(node); end

  # source://rbi//lib/rbi/parser.rb#424
  sig { params(node: ::AST::Node).returns(::RBI::Struct) }
  def parse_struct(node); end

  # source://rbi//lib/rbi/parser.rb#463
  sig { params(node: ::AST::Node).returns([::String, ::String, T.nilable(::String)]) }
  def parse_tstruct_prop(node); end

  # source://rbi//lib/rbi/parser.rb#564
  sig { void }
  def separate_header_comments; end

  # source://rbi//lib/rbi/parser.rb#586
  sig { void }
  def set_root_tree_loc; end

  # source://rbi//lib/rbi/parser.rb#418
  sig { params(node: ::AST::Node).returns(T::Boolean) }
  def struct_definition?(node); end
end

# source://rbi//lib/rbi/model.rb#1311
class RBI::TypeMember < ::RBI::NodeWithComments
  # source://rbi//lib/rbi/model.rb#1326
  sig do
    params(
      name: ::String,
      value: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::TypeMember).void)
    ).void
  end
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/printer.rb#810
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#1334
  sig { returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/model.rb#1315
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/model.rb#1340
  sig { override.returns(::String) }
  def to_s; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#1315
  def value; end
end

# source://rbi//lib/rbi/parser.rb#20
class RBI::UnexpectedParserError < ::StandardError
  # source://rbi//lib/rbi/parser.rb#27
  sig { params(parent_exception: ::Exception, last_location: ::RBI::Loc).void }
  def initialize(parent_exception, last_location); end

  # source://rbi//lib/rbi/parser.rb#24
  sig { returns(::RBI::Loc) }
  def last_location; end

  # source://rbi//lib/rbi/parser.rb#34
  sig { params(io: T.any(::IO, ::StringIO)).void }
  def print_debug(io: T.unsafe(nil)); end
end

# source://rbi//lib/rbi/version.rb#5
RBI::VERSION = T.let(T.unsafe(nil), String)

# Visibility
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#833
class RBI::Visibility < ::RBI::NodeWithComments
  abstract!

  # source://rbi//lib/rbi/model.rb#843
  sig { params(visibility: ::Symbol, loc: T.nilable(::RBI::Loc), comments: T::Array[::RBI::Comment]).void }
  def initialize(visibility, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#849
  sig { params(other: ::RBI::Visibility).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/printer.rb#577
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/model.rb#864
  sig { returns(T::Boolean) }
  def private?; end

  # source://rbi//lib/rbi/model.rb#859
  sig { returns(T::Boolean) }
  def protected?; end

  # source://rbi//lib/rbi/model.rb#854
  sig { returns(T::Boolean) }
  def public?; end

  # source://rbi//lib/rbi/model.rb#840
  sig { returns(::Symbol) }
  def visibility; end
end

# source://rbi//lib/rbi/rewriters/nest_non_public_methods.rb#51
class RBI::VisibilityGroup < ::RBI::Tree
  # source://rbi//lib/rbi/rewriters/nest_non_public_methods.rb#58
  sig { params(visibility: ::RBI::Visibility).void }
  def initialize(visibility); end

  # source://rbi//lib/rbi/printer.rb#846
  sig { override.params(v: ::RBI::Printer).void }
  def accept_printer(v); end

  # source://rbi//lib/rbi/printer.rb#859
  sig { override.returns(T::Boolean) }
  def oneline?; end

  # source://rbi//lib/rbi/rewriters/nest_non_public_methods.rb#55
  sig { returns(::RBI::Visibility) }
  def visibility; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/visitor.rb#5
class RBI::Visitor
  abstract!

  # source://sorbet-runtime/0.5.10598/lib/types/private/abstract/declare.rb#37
  def initialize(*args, **_arg1, &blk); end

  # @abstract
  #
  # source://rbi//lib/rbi/visitor.rb#12
  sig { abstract.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  # source://rbi//lib/rbi/visitor.rb#15
  sig { params(nodes: T::Array[::RBI::Node]).void }
  def visit_all(nodes); end
end
