--TEST--
BcMath\Number compare() with scale
--EXTENSIONS--
bcmath
--FILE--
<?php

$values1 = [
    new BcMath\Number('0.001'),
    new BcMath\Number('-0.001'),
];

$values2 = [
    0,
    -0,
    '0.0011',
    '-0.0011',
];

$value1 = new BcMath\Number('0.001');

$scales = [0, 2, 3, 4];

foreach ($scales as $scale) {
    echo "========== scale is {$scale} ==========\n";
    foreach ($values1 as $value1) {
        foreach ($values2 as $value2) {
            $output = str_pad("{$value1} <=> {$value2}: ", 20, ' ', STR_PAD_LEFT);
            $output .= str_pad((string) $value1->compare($value2, $scale), 2, ' ', STR_PAD_LEFT);
            echo "{$output}\n";
        }
    }
}
?>
--EXPECT--
========== scale is 0 ==========
       0.001 <=> 0:  0
       0.001 <=> 0:  0
  0.001 <=> 0.0011:  0
 0.001 <=> -0.0011:  0
      -0.001 <=> 0:  0
      -0.001 <=> 0:  0
 -0.001 <=> 0.0011:  0
-0.001 <=> -0.0011:  0
========== scale is 2 ==========
       0.001 <=> 0:  0
       0.001 <=> 0:  0
  0.001 <=> 0.0011:  0
 0.001 <=> -0.0011:  0
      -0.001 <=> 0:  0
      -0.001 <=> 0:  0
 -0.001 <=> 0.0011:  0
-0.001 <=> -0.0011:  0
========== scale is 3 ==========
       0.001 <=> 0:  1
       0.001 <=> 0:  1
  0.001 <=> 0.0011:  0
 0.001 <=> -0.0011:  1
      -0.001 <=> 0: -1
      -0.001 <=> 0: -1
 -0.001 <=> 0.0011: -1
-0.001 <=> -0.0011:  0
========== scale is 4 ==========
       0.001 <=> 0:  1
       0.001 <=> 0:  1
  0.001 <=> 0.0011: -1
 0.001 <=> -0.0011:  1
      -0.001 <=> 0: -1
      -0.001 <=> 0: -1
 -0.001 <=> 0.0011: -1
-0.001 <=> -0.0011:  1
